.OH "'CooL Language Reference Manual''Statements'"
.EH "'Statements''CooL Language Reference Manual'"
.bp
.NX 1 "Statements"
.LP
A statement denotes a computation.
.LP
A statement list has the form
.Ss
S1
\&...
Sn
.Se
where the
.Si Si
are statements.
.LP
The statements are executed in the given order.
.\"===========================================================================
.NX 2 "Assignment Statement"
.LP
An assignment statement has the form
.Ss
Target := Source;
.Se
where 
.Si Target
is a variable and
.Si Source
is an expression.
.LP
The value of 
.Si Target
becomes the value of
.Si Source.
.LP
The type of 
.Si Source
must be compatible to the type of
.Si Target
or both types must be numeric (i.e. of integer type or floating point
type). In the latter case
.Si Source
is converted into a value of the type of
.Si Target.
.LP
If the type of 
.Si Target
is
.Si "ARRAY [Lwb .. Upb] OF CHAR,"
.Si "REF ARRAY [Lwb .. Upb] OF CHAR,"
or
.Si "REF ARRAY OF CHAR,"
a string literal may be supplied as 
.Si Source.
The string literal is interpreted as an array of characters or (in the
latter two cases) as the address of an array containing the characters
of the string.
.LP
The type of 
.Si Target
cannot be an open array.
.\"===========================================================================
.NX 2 "Call Statement"
.LP
A call statement is a call of a proper procedure or method
(see section 
.Ii "2.5. Procedure Declaration"
and
.Ii "3.13. Object Types)."
.\"===========================================================================
.NX 2 "Return Statement"
.LP
The statement part of a proper procedure may contain a return
statement of the form
.Ss
RETURN;
.Se
The execution of the statement causes a return to the caller.
.LP
The statement part of a function returning a value of type
.Si T
must contain a statement of the form
.Ss
RETURN E;
.Se
where
.Si E
is an expression.
The type of 
.Si E
must be compatible to 
.Si T.
.LP
The execution of the statement causes a return to the caller.  The
value of
.Si E
determines the result of the procedure call.
.\"===========================================================================
.KS
.NX 2 "If Statement"
.LP
An if statement has the form
.Ss
IF C1 THEN S1
ELSIF C2 THEN S2
\&...
ELSIF Cn THEN Sn
ELSE S0
END IF;
.Se
where the
.Si Ci
are expressions of type 
.Si BOOL
and the
.Si Si
are statement lists.
.KE
.LP
The clauses
.Si "ELSIF Ci THEN Si"
and the clause
.Si "ELSE S0"
are optional.
.LP
The expressions
.Si Ci
are evaluated one after the other until one yields true.  Then the
corresponding
.Si Si
is executed which concludes the execution of the if statement.  If
none of the
.Si Ci
yields true, the statement list
.Si S0,
if present, is executed.
.\"===========================================================================
.NX 2 "Select Statement"
.LP
A select statement has the form
.Ss
SELECT E OF
CASE L1 : S1
\&...
CASE Ln : Sn
OTHERWISE S0
END SELECT;
.Se
where
.Si E
is an expression of type 
.Si T, 
where 
.Si T 
is
.Si BOOL,
.Si CHAR,
an integer type, or an enumeration type, the
.Si Li
are lists of constant expressions delivering a value of type
.Si T
separated by commas,
and the
.Si Si
are statement lists. The notation
.Ss
Lwb .. Upb
.Se
where 
.Si Lwb
and
.Si Upb
are constant expressions of type 
.Si CHAR
an integer type, or an enumeration type, is a shorthand for the list
of all values in the range from
.Si Lwb 
to
.Si Upb.
.LP
The clause
.Si "OTHERWISE S0" 
may be omitted.
.LP
The expression
.Si E
is evaluated yielding a value 
.Ii "x."
If a list
.Si Li
contains 
.Ii "x,"
the statement
.Si Si
is executed which concludes the execution of the Select statement.
If none of the
.Si Li
contains 
.Ii "x,"
the Statement 
.Si S0,
if present, is executed and the execution of the Select statement is
concluded.
.\"===========================================================================
.NX 2 "Typeselect Statement"
.LP
A typeselect statement has the form
.Ss
TYPESELECT D := E OF
CASE T1 : S1
\&...
CASE Tn : Sn
OTHERWISE S0
END TYPESELECT;
.Se
where
.Si E
is an expression whose type is an object type,
.Si D
is an identifier
(which is implicitly declared as visible in 
.Si "S0, ... , Sn"
\&),
.Si Ti
subtypes of the type of
.Si E
or the type of
.Si E
itself, and the
.Si Si
are statement lists.  The clause
.Si "OTHERWISE S0"
may be omitted.
.LP
The statement evaluates
.Si E
and assigns the result
to
.Si D.
Then it is checked for each
.Si Ti
in the order of their appearance whether the type of
.Si D
is equal to or is a subtype of
.Si Ti.
If this is true,
.Si Si
is executed which concludes the execution of the typeselect statement.
If it is not true for any
.Si Ti,
the statement list
.Si S0,
if present, is executed and the execution of the typeselect statement
is concluded.
.LP
Inside 
.Si Si,
the static type of
.Si D
is
.Si Ti.
Inside
.Si S0,
the static type of
.Si D
is the type of
.Si E.
.Si D
may not be used as target of an assignment or as an actual parameter
with mode
.Si OUT
or
.Si INOUT.
.\"===========================================================================
.NX 2 "Loop Statement"
.LP
A loop statement has the form 
.Ss
LOOP
   S
END LOOP;
.Se
where 
.Si S
is a statement list.
.LP
.Si S
is repeatedly executed.  An exit statement may be used to terminate
the loop.
.\"===========================================================================
.NX 2 "While Statement"
.LP
A while statement has the form
.Ss
WHILE C LOOP
   S
END LOOP;
.Se
where 
.Si C
is an expression of type
.Si BOOL
and
.Si S
is a statement list.
.LP
It is equivalent to
.Ss
LOOP
   IF NOT C THEN EXIT; END IF;
   S
END LOOP;
.Se
.\"===========================================================================
.NX 2 "For Statement"
.LP
A for statement has the form
.Ss
FOR I IN Domain LOOP
   S
END LOOP;
.Se
.Si I
is an identifier implicitly declared of type
.Si INT
as visible in 
.Si S.
.LP
.Si Domain
has the form
.Ss
E1 .. E2 Step
.Se
where
.Si Ei
are expressions of an integer type.
.Si Domain
represents a range of values from 
.Si E1
through
.Si E2.
.LP
.Si Step
has the form
.Ss
INCR E3
.Se
or 
.Ss
DECR E3
.Se
where 
.Si E3
is an expression which yields a positive value of an integer type.
If
.Si Step
is omitted, this is equivalent to
.Si "INCR 1."
.LP
In the first form
.Si I
represents the values from
.Si E1
through
.Si E2
in ascending order and
.Si E3
denotes the incrementing value. In the second form
.Si I
represents the values from
.Si E1
through
.Si E2
in descending order and
.Si E3
denotes the decrementing value.
.LP
The expressions
.Si Ei
are evaluated once before the execution of the for statement and the
range does not change during the execution.
.LP
.Si S
is a statement list, which is executed once for each element of
.Si Domain.
During execution of
.Si S,
.Si I
denotes the current element.  It may not be used as target of an
assignment or as an actual parameter with mode
.Si OUT
or
.Si INOUT.
.\"===========================================================================
.NX 2 "Exit Statement"
.LP
An exit Statement has the form
.Ss
EXIT;
.Se
It terminates the execution of the innermost loop, while, or for
statement.
.\"===========================================================================
.NX 2 "Raise Statement"
.LP
A raise statement has the form
.Ss
RAISE I (A1, ... , An);
.Se
where
.Si I
is an identifier declared as an exception and 
.Si Ai
are actual parameters. There must be as many actual parameters as
there are formal parameters in the declaration of the exception
.Si I. 
The type of an actual parameter must be compatible to the type of the
formal parameter.
.LP
All statements dynamically enclosing the raise statement are
terminated until a try statement is encountered that handles the
exception.
.\"===========================================================================
.NX 2 "Try Statement"
.LP
A try statement is used to handle exceptions. It has the form
.Ss
TRY S0 EXCEPT
Cases
OTHERWISE S1
END TRY;
.Se
where
.Si S0
and
.Si S1
are statement lists.
.LP
.Si Cases
is a list of case clauses. A case clause has the form
.Ss
CASE I (P1, ... , Pn) : S
.Se
where 
.Si I
is an identifier declared as exception of the form
.Ss
EXCEPTION I (P1, ... , Pn)
.Se
.Si Pi 
are formal parameters of the form
.Ss
IN Ii : Ti
.Se
and
.Si S 
is a statement list, called 
.Ii handler
of the exception.
.LP
The identifier
.Si Ii
is implicitly declared of type
.Si Ti,
visible in 
.Si S 
and denotes the value of the actual parameter (corresponding to 
.Si Pi)
given in a raise statement of 
.Si I.
.LP
The notation
.Ss
CASE I1, ... , Im (P1, ... , Pn) : S
.Se
.KS
is a shorthand for
.Ss
CASE I1 (P1, ... , Pn) : S
\&...
CASE Im (P1, ... , Pn) : S
.Se
.KE
.LP
The clause
.Si "OTHERWISE S1"
may be omitted.
.LP
The statement list 
.Si S0 
is executed. If it does not lead to an unhandled exception, the
execution of the try statement is concluded.  If it leads to an
unhandled exception
.Ii "X"
then there are three cases.
.IP (1) 
.Ii "X"
is equal to the exception
.Si I
of one of the case clauses. Then the statement list
.Si S
of this case clause is executed which concludes the execution of the
try statement.
.IP (2)
.Ii "X"
is not equal to the exception
.Si I
of any case clause and there is a clause
.br
.Si "OTHERWISE S1."
Then 
.Si S1 
is executed which concludes the execution of the try statement.
.LP
In cases (1) and (2) the exception is said to be 
.Ii "handled."
.IP (3) 
If 
.Ii "X"
is not equal to the exception
.Si I
of any case clause and there is no
.Si OTHERWISE
clause, the exception is not handled in this try statement.
.LP
NOTE: A raise statement executed within an exception handler is not
handled by the try statement which defines that handler.
.\"===========================================================================
.NX 2 "Retry Statement"
.LP
A retry statement has the form
.Ss
RETRY;
.Se
It may be used inside an exception handler to reexecute the try
statement which defines that handler.
.\"===========================================================================
.NX 2 "Reraise Statement"
.LP
A reraise statement has the form
.Ss
RERAISE;
.Se
It may be used inside an exception handler to raise that exception
.Si I,
which caused the execution of that handler. The actual parameters of
.Si I
are not changed.
.Si I
is not handled by the try statement which defines that handler.
.\"===========================================================================
.NX 2 "Delete Statement"
.LP
A delete Statement has the form
.Ss
DELETE Expr;
.Se
as described in section 
.Ii "3.12 Object Types."
.\"===========================================================================
.NX 2 "Null Statement"
.LP
A null statement has the form
.Ss
;
.Se
It denotes no action.
.\"================================================================ The End ==
