.OH "'CooL Language Reference Manual''Modules'"
.EH "'Modules''CooL Language Reference Manual'"
.bp
.NX 1 "Modules"
.LP
A program may be separated into different modules that can be compiled
separately.
.LP
Each module consists of two parts: a specification part and an
implementation part.
.br
The specification part contains all identifiers, which can be made
visible outside the defining module using an import statement. An
identifier only declared in the implementation part of a module is not
visible in any other module.
.LP
CooL provides a seperate namespace for modules names.
.\"===========================================================================
.NX 2 "Specification"
.LP
The specification part of a module has the form
.Ss
SPECIFICATION I
   Imports
   Decls
END SPECIFICATION;
.Se
where 
.Si I
is an identifier,
.Si Imports
is a list of imports and 
.Si Decls
is a list of declarations.
.LP
There are two special forms of declarations in a specification part of
a module.
.LP
A procedure specification has the form
.Ss
PROCEDURE P Sig;
.Se
where 
.Si P
is an identifier and
.Si Sig
is a signature. The declaration of
.Si P
contains no body.
.LP
An exported object type is written in the form
.Ss
SuperType ABSTRACT OBJECT Params
PUBLIC
   PublicMethods
PROTECTED
   ProtectedMethods
STATE
   State
END OBJECT;
.Se
where 
.Si SuperType
is the supertype of the object type (which is omitted in the case of
no supertype),
.Si Params
are the object parameters,
.Si PublicMethods
and 
.Si ProtectedMethods
are a lists of method specifications and
.Si State
is a list of field declarations. The keyword
.Si ABSTRACT
is omitted in the case of a non-abstract object type.
.LP
.\"===========================================================================
.NX 2 "Implementation"
.LP
The implementation part of a module has the form
.Ss
IMPLEMENTATION I
   Imports
   Decls
END IMPLEMENTATION;
.Se
where 
.Si I
is an identifier (that has to be the same as in the specification part
of the module),
.Si Imports
is a list of imports and 
.Si Decls
is a list of declarations.
.LP
A declaration from the specification part of the module defining an
exception, a constant, a variable or a non-object type is not repeated
in the implementation part. These identifiers are automatically
visible in the implementation part.
.LP
The specification of an exported procedure is repeated in the
implementation part and completed with its body.
.LP
An exported object type is written in the form
.Ss
ABSTRACT OBJECT
BODY
   Body
END OBJECT
.Se
where
.Si Body
is a list of method implementations. The keyword
.Si ABSTRACT
is omitted in the case of a non-abstract object type.
.LP
Any local declarations in the implementation part of a module have the
form as described in chapter
.Ii "2. Declarations."
.\"===========================================================================
.NX 2 "Imports"
.LP
An import clause may have one of two forms.
.LP
The form
.Ss
IMPORT S1, .. , Sn;
.Se
imports the specification parts of the modules 
.Si "S1, .. , Sn."
An identifier 
.Si I 
exported by a specification part of a module
.Si Si 
may be used with an modul qualifier in the form
.Ss
Si :: I
.Se
The identifier
.Si I
is not visible without module qualification.
.LP
The form
.Ss
IMPORT I1, .. , In FROM S;
.Se
imports the identifiers
.Si "I1, .. , In"
from the specification part of a module
.Si S.
This form makes an identifier 
.Si Ii
visible in the current module. The identifier has to be used in the
form
.Si Ii
; a module qualification is not allowed in this case.
.LP
.\"===========================================================================
.NX 2 "Export Foreign"
.LP
A CooL variable or procedure that should be used in a module written
in a language other than CooL must be declared with a prefix 
.Si "EXPORT FOREIGN" 
in the specification part of a module. The declaration has the form
.Ss
EXPORT FOREIGN D;
.Se
where
.Si D
is a variable declaration or a procedure specification.
.LP
If 
.Si D
is a procedure specification the prefix
.Si "EXPORT FOREIGN"
is omitted in the procedure implementation in the implementation part
of the module.
.LP
Inside a program all identifiers declared as foreign export must be
unique. 
.LP
CooL follows the C parameter passing conventions.
.\"===========================================================================
.NX 2 "Program start"
.LP
A program must contain one root declaration. A root declaration has
the form
.Ss
ROOT P;
.Se
where
.Si P
is a procedure specification. 
.LP
This procedure is the designated start of the program. The name of the
procedure must satisfy the requirements of the operating system and
the signature must satisfy the argument passing mechanism of the
calling environment. 
