(*---------------------------------------------------------------------
-- Dialog Interface Objects
-----------------------------------------------------------------------
-- Copyright: (c) Sietec GmbH & Co oHG
--            All rights reserved 1993
-----------------------------------------------------------------------
-- Modul    : WindowObj.cs
-- Author   : Gold, Herbert
-- angelegt : 1993-12-01
---------------------------------------------------------------------*)
SPECIFICATION WindowObj

IMPORT DialogInterface FROM DialogIF;
IMPORT Control         FROM Control;
IMPORT ToggleButton    FROM Toggle;
IMPORT RadioButton     FROM Radio;
IMPORT ComboBox        FROM ComboBox;
IMPORT Bcdfield        FROM Bcdfield;
IMPORT Datefield       FROM Datefield;
IMPORT Doublefield     FROM Doublefield;
IMPORT Intfield        FROM Intfield;
IMPORT Stringfield     FROM Stringfield;
IMPORT Label	       FROM Label;
IMPORT Table           FROM Table;
IMPORT Textfield       FROM Textfield;
IMPORT ListBox         FROM SelectBox;
IMPORT Application     FROM Applic;
IMPORT PushButton      FROM Push;

IMPORT List            FROM List;
IMPORT Date            FROM Date;
IMPORT BCD             FROM Bcd;

IMPORT DoiService, WIDGET FROM DoiServ;

EXCEPTION NoResourceInitialized;   -- method initialize not yet applied
EXCEPTION NotKnownInResource;      -- an element name can not be mapped


TYPE WindowObject = DialogInterface ABSTRACT OBJECT

PUBLIC

  METHOD AddPushButton( IN name : STRING, 
                        IN action : METHOD ) : PushButton;
  METHOD AddToggleButton( IN name : STRING,
                          IN getV : METHOD() : BOOL,
                          IN putV : METHOD( IN BOOL ),
                          IN exep : METHOD( IN METHOD ) : BOOL 
                        ) : ToggleButton;
  METHOD AddRadioButton(  IN name : STRING,
                          IN getV : METHOD() : BOOL,
                          IN putV : METHOD( IN BOOL ),
                          IN exep : METHOD( IN METHOD ) : BOOL 
                       ) : RadioButton;

  METHOD AddComboBox( IN name : STRING,
                      IN getV : METHOD() : STRING,
                      IN putV : METHOD( IN STRING ),
                      IN exep : METHOD( IN METHOD ) : BOOL,
                      IN getItem : METHOD( IN INT ) : STRING
                    ) : ComboBox;

  METHOD AddBcdfield( IN name : STRING,
                      IN getV : METHOD() : BCD,
                      IN putV : METHOD( IN BCD ),
                      IN exep : METHOD( IN METHOD ) : BOOL
                    ) : Bcdfield;
  METHOD AddDatefield( IN name : STRING,
                       IN getV : METHOD() : Date,
                       IN putV : METHOD( IN Date ),
                       IN exep : METHOD( IN METHOD ) : BOOL
                     ) : Datefield;
  METHOD AddDoublefield( IN name : STRING,
                         IN getV : METHOD() : DOUBLE,
                         IN putV : METHOD( IN DOUBLE ),
                         IN exep : METHOD( IN METHOD ) : BOOL
                       ) : Doublefield;
  METHOD AddIntfield( IN name : STRING,
                      IN getV : METHOD() : INT,
                      IN putV : METHOD( IN INT ),
                      IN exep : METHOD( IN METHOD ) : BOOL
                    ) : Intfield;
  METHOD AddStringfield( IN name : STRING,
                         IN getV : METHOD() : STRING,
                         IN putV : METHOD( IN STRING ),
                         IN exep : METHOD( IN METHOD ) : BOOL
                       ) : Stringfield;

  METHOD AddLabel( IN name : STRING, 
                   IN getV : METHOD() : STRING ) : Label;

  METHOD AddTable( IN name : STRING,
                   IN posi : METHOD( IN INT, IN INT )
                 ) : Table;

  METHOD AddTextfield( IN name : STRING,
                       IN getV : METHOD() : REF ARRAY OF CHAR,
                       IN putV : METHOD( IN REF ARRAY OF CHAR ),
                       IN exep : METHOD( IN METHOD ) : BOOL
                     ) : Textfield;

  METHOD AddListBox( IN name : STRING,
                     IN getItem : METHOD( IN INT ) : STRING,
                     IN select  : METHOD( IN INT ) 
                   ) : ListBox; 
--
-- adds a new ListBox (or returns an existing one, based on name).
-- 'getItem' specifies the action-method for GetContentEvent and
-- 'select' is executed on an select event (single click).
-- For activateing (double click) an item see 'OnActivate..'.
--

  METHOD Danger( IN message : STRING, IN helpAction : METHOD );
-- show a DangerBox with the message in it.
-- 'helpAction' allows to specify a call for help about this danger.  

  METHOD Error( IN message : STRING, IN helpAction : METHOD );
-- show an ErrorBox with the message in it. 
-- 'helpAction' allows to specify a call for help about this error. 

  METHOD Prompt( IN message : STRING,
                 IN get : METHOD : STRING,
                 IN put : METHOD(IN STRING),
                 IN expt : METHOD(IN METHOD):BOOL,
                 IN helpAction : METHOD );
-- a PromptDialog is carried out.   

  METHOD UpdateDisplay;
-- handles 'exposure events' at the display server.

  METHOD RaiseToTop;
-- move this DIO to top of display.

  METHOD SetWindowTitle( IN title : STRING );

  METHOD ClearAllParts;

  METHOD CloseEvent;
  METHOD CloseRequestEvent;
  METHOD GetContentEvent;
  METHOD IconizeEvent;
  METHOD ReopenEvent;
  METHOD ResizeEvent;
  --
  METHOD Initialize( IN element : STRING, IN fileName : STRING );
  METHOD initWidget( IN element : STRING ) : WIDGET;
  --
  METHOD OnClose( IN action : METHOD ) : WindowObject;
  METHOD OnCloseFrom( IN action : METHOD( IN WindowObject )
                    ) : WindowObject;

  METHOD OnCloseRequest( IN action : METHOD ) : WindowObject;
  METHOD OnCloseRequestFrom( IN action : METHOD( IN WindowObject )
                           ) : WindowObject;

  METHOD OnIconize( IN action : METHOD ) : WindowObject;
  METHOD OnIconizeFrom( IN action : METHOD( IN WindowObject )
                      ) : WindowObject;

  METHOD OnReopen( IN action : METHOD ) : WindowObject;
  METHOD OnReopenFrom( IN action : METHOD( IN WindowObject )
                     ) : WindowObject;

  METHOD OnResize( IN action : METHOD ) : WindowObject;
  METHOD OnResizeFrom( IN action : METHOD( IN WindowObject )
                     ) : WindowObject;
  
  METHOD isDialog : BOOL;
  METHOD shellWidget : WIDGET;

PROTECTED

  METHOD addChild( IN child : WindowObject );
  METHOD removeChild( IN child : WindowObject );
  METHOD close;
  METHOD root : Application;

STATE
  Parent : WindowObject;
  ChildList : List [WindowObject];

  closeRequestAction : METHOD;
  closeRequestFromAction : METHOD( IN WindowObject );

  closeAction : METHOD;
  closeFromAction : METHOD( IN WindowObject );

  iconizeAction : METHOD;
  iconizeFromAction : METHOD( IN WindowObject );

  reopenAction : METHOD;
  reopenFromAction : METHOD( IN WindowObject );

  resizeAction : METHOD;
  resizeFromAction : METHOD( IN WindowObject );

  visible : BOOL;            -- indicates on/off screen

  doiService : DoiService;   -- a Doi Service object

END OBJECT;

END SPECIFICATION;     (* WindowObj *)

