(*---------------------------------------------------------------------
-- Dialog Interface Objects
-----------------------------------------------------------------------
-- Copyright: (c) Sietec GmbH & Co oHG
--            All rights reserved 1993
-----------------------------------------------------------------------
-- Modul    : Toggle
-- Author   : Gold, Herbert
-- angelegt : 1993-12-02
---------------------------------------------------------------------*)
SPECIFICATION Toggle

IMPORT Button       FROM Button;
IMPORT WindowObject FROM WindowObj;

TYPE ToggleButton = Button
     OBJECT( IN theOwner : WindowObject, IN name : STRING )

PUBLIC

  METHOD GetValue : BOOL;
  METHOD PutValue( IN value : BOOL );

  METHOD OnGetContent( IN action : METHOD() : BOOL ) : ToggleButton;
  METHOD OnPutContent( IN action : METHOD( IN BOOL ) ) : ToggleButton;

PROTECTED

  METHOD get;
  METHOD put;
  METHOD getValue : STRING;              -- from Screen

STATE
  getAction : METHOD() : BOOL;
  putAction : METHOD(IN BOOL);

END OBJECT;

END SPECIFICATION;    (* Toggle *)

-- --------------------------------------------
