(*---------------------------------------------------------------------
-- Dialog Interface Objects
-----------------------------------------------------------------------
-- Copyright: (c) Sietec GmbH & Co oHG
--            All rights reserved 1993
-----------------------------------------------------------------------
-- Modul    : SmallSet  for Events and Dependents in DIO
-- Author   : Gold, Herbert
-- angelegt : 03.02.1994
---------------------------------------------------------------------*)
SPECIFICATION SmallSet

-- SmallSet emulates a generic Set 

   EXCEPTION ContainerEmpty;
   EXCEPTION CursorUndefined;
   EXCEPTION NoMoreElements;

TYPE SmallSet [Event] = OBJECT

PUBLIC
   METHOD GetEntry : Event;
   METHOD ResetCursor;
   METHOD InsertEntry( IN event : Event );
   METHOD RemoveEntry( IN event : Event );  

PROTECTED


STATE
  Pos    : INT;           -- Cursor's Position in Set
  Number : INT;           -- Number of Objects in the Set
  Cursor : Node [Event];  -- current Node

END OBJECT;



TYPE Node [Event] = OBJECT( prev : Node [Event], entry : Event )

PUBLIC

   METHOD Last : Node [Event];
   METHOD SetNext( IN evNode : Node [Event] );
   METHOD SetPrev( IN evNode : Node [Event] );
   METHOD First : Node [Event];
   METHOD Entry : Event;
   METHOD Next  : Node [Event];
 
PROTECTED

STATE
   PrevNode : Node [Event];
   NextNode : Node [Event];
   EvEntry  : Event;

END OBJECT;

END SPECIFICATION;         (* SmallSet *)


