#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/CoreP.h>
#include <X11/CompositeP.h>
#include <X11/Intrinsic.h>
#include <Mrm/MrmPublic.h>
#include <Xm/Xm.h>
#include <Xm/List.h>
#include <Xm/Text.h>


/* +==========================================================================+
 * |									      |
 * |	INTERNAL TYPES
 * |									      |
 * +==========================================================================+
 */

/* +==========================================================================+
 * |									      |
 * |	GLOBAL VARIABLES
 * |									      |
 * +==========================================================================+
 */
static int initialize=0;

/* +==========================================================================+
 * |									      |
 * |	EXTERNAL SPECIFICATION
 * |									      |
 * +==========================================================================+
 */

int RSHopenResource(		/*in*/	char	*resourceFile,
				/*out*/	int	*resourceId,
				/*in*/	int	 check	);

int RSHreadDialogObject(	/*in*/	void	*resourceId,
					char	*resObjName,
					char	*doiName,
					void	*shell,
				/*out*/	void	**widget,
					char	**widgetClass	);
int RSHmapSubNameToWidgetId(	/*in*/	Widget	 parent,
					char	*name,
				/*out*/	void	**widget	);

int RSHcloseResource(		/*in*/	void	*resourceId );

int RSHregisterNames(		/*in*/	void	*resourceId,
					void	*rsharglist,
					int	 argc	);

int PMSsetPopupMenu(		/*in*/	void	*object,
					void	*popup,
					int	 button	);

int PMSremovePopupMenu(		/*in*/	void	*object	);

void	*PMSgetPopupMenu(	/*in*/	void	*object	);

/* +==========================================================================+
 * |									      |
 * |	INTERNALS
 * |									      |
 * +==========================================================================+
 */

static Widget RSHGetChildByName(	/*in*/	Widget	 parent,
						char	*name )
{ int		i;
  Widget	child,
		result;

    if( strcmp(XtName(parent), name)==0 )
	return( parent );

    if( !XtIsComposite(parent) )
	return( NULL );

/*
    printf( "parentName = |%s|, name = |%s|, nrOfChilds = %d\n", XtName(parent), name, ((CompositeWidget)parent)->composite.num_children );
*/
    for( i=0; i<((CompositeWidget)parent)->composite.num_children; i++ )
    {   child = ((CompositeWidget)parent)->composite.children[i];
/*
	printf( "childName[%d] = %s\n", i, XtName(child) );
*/
	result = RSHGetChildByName( child, name );
	if( result!=NULL )
	    return( result );
    }

    return( NULL );
}

/* +==========================================================================+
 * |									      |
 * |	EXTERNAL IMPLEMENTATION
 * |									      |
 * +==========================================================================+
 */

int RSHopenResource(	/*in*/	char	*resourceFile,
			/*out*/	int	*resourceId,
			/*in*/	int	 check	)

{ char		*fileList[2];
  MrmHierarchy	 mrmHierarchy;

    if( !initialize )
    {   initialize = 1;
	MrmInitialize();
    }

    fileList[0] = resourceFile;
    fileList[1] = NULL;

    if( MrmOpenHierarchy(1, fileList, NULL, &mrmHierarchy)!=MrmSUCCESS )
	return( -1 );
    *resourceId = (int) mrmHierarchy;
    return( 0 );
}

int RSHreadDialogObject(	/*in*/	void	*resourceId,
					char	*resObjName,
					char	*doiName,
					void	*shell,
				/*out*/	void	**widget,
					char	**widgetClass	)
{ MrmHierarchy	mrmHierarchy;

    mrmHierarchy = (MrmHierarchy) resourceId;
    *widget = NULL;
/*
    if( MrmFetchWidget(*mrmHierarchy, resObjName, shell,
		       (Widget *)widget, (MrmType *)widgetClass)!=MrmSUCCESS )
	return( -1 );
*/
    switch( MrmFetchWidget(mrmHierarchy, resObjName, shell,
		       (Widget *)widget, (MrmType *)widgetClass) )
    {   case MrmBAD_HIERARCHY:
	    return( -1 );
	case MrmNOT_FOUND:
	    return( -1 );
	case MrmFAILURE:
	    return( -1 );
    }
/*
    XtManageChild( *widget );
    XtRealizeWidget( *widget );
    XtMainLoop();
*/
    return( 0 );
}

int RSHmapSubNameToWidgetId(	/*in*/	Widget	 parent,
					char	*name,
				/*out*/	void	**widget	)
{ char buffer[256];
  WidgetClass wc;

/*
    printf( "parentName = |%s|, name = |%s|\n", XtName(parent), name );
*/
    *widget = (void *) RSHGetChildByName( parent, name );
    if( *widget==NULL )
    {   printf( "RSHmapSubNameToWidgetId failed: child %s not found\n", name );
	return( -1 );
    }
    return( 0 );
/*
    sprintf( buffer, "%sSW", name );
    printf( "parent.name: %s\nparent.num_popups: %d\nparent.popup_list: %d\nname: %s\n", XtName((Widget)parent), parent->core.num_popups, parent->core.popup_list, buffer );
    *widget = XtNameToWidget( (Widget)parent, buffer );
    if( *widget!=NULL )
        parent = *widget;

    *widget = XtNameToWidget( (Widget)parent, name );
    if( *widget==NULL )
    {   printf( "RSHmapSubNameToWidgetId failed while going deeper: child %s not found\n", name );
	return( -1 );
    }
    printf( "widget: %d\n", (int)(*widget) );
    wc = XtClass( (Widget)(*widget) );
    if (XtClass((Widget)(*widget)) != xmTextWidgetClass)
        printf( "class is not xmTextWidgetClass\n" );

    printf( "className: %s\n", wc->core_class.class_name );
    return( 0 );
*/
}


int RSHcloseResource(		/*in*/	void	*resourceId )
{ MrmHierarchy	mrmHierarchy;

    mrmHierarchy = (MrmHierarchy) resourceId;
    if( MrmCloseHierarchy(mrmHierarchy)!=MrmSUCCESS )
	return( -1 );

    free( mrmHierarchy );
    return( 0 );
}


int RSHregisterNames(		/*in*/	void	*resourceId,
					void	*rsharglist,
					int	 argc	)
{   if( MrmRegisterNamesInHierarchy((MrmHierarchy) resourceId, 
				    (MrmRegisterArglist)rsharglist, argc)!=MrmSUCCESS )
	return( -1 );
    return( 0 );
}

/*
int PMSsetPopupMenu(			void	*object,
					void	*popup,
					int	 button	)
{   return( 0 );
}

int PMSremovePopupMenu(			void	*object	)
{   return( 0 );
}

void	*PMSgetPopupMenu(		void	*object	)
{   return( 0 );
}
*/


/* +==========================================================================+
 * |									      |
 * |
 * |									      |
 * +==========================================================================+
 */
