(*---------------------------------------------------------------------
-- Dialog Interface Objects
-----------------------------------------------------------------------
-- Copyright: (c) Sietec GmbH & Co oHG
--            All rights reserved 1993
-----------------------------------------------------------------------
-- Modul    : Push
-- Author   : Gold, Herbert
-- angelegt : 1993-12-01
---------------------------------------------------------------------*)
SPECIFICATION Push 

IMPORT Button       FROM Button;
IMPORT WindowObject FROM WindowObj;

TYPE PushButton = Button
     OBJECT( IN theOwner : WindowObject, 
             IN name : STRING )

PUBLIC

  METHOD SelectEvent;

  METHOD OnSelect( IN action : METHOD ) : PushButton;
  METHOD OnSelectFrom( IN action : METHOD( IN PushButton )
                     ) : PushButton;

PROTECTED

  METHOD get;
  METHOD put;
  METHOD getValue : STRING;              -- from Screen as Dummy here !

STATE
  selectAction : METHOD;
  selectFromAction : METHOD( IN PushButton ); 

END OBJECT;

END SPECIFICATION;         (* Push *)

-- --------------------------------------------------------------------
