(*---------------------------------------------------------------------
-- Dialog Interface Objects
-----------------------------------------------------------------------
-- Copyright: (c) Sietec GmbH & Co oHG
--            All rights reserved 1993
-----------------------------------------------------------------------
-- Modul    : Event
-- Author   : Gold, Herbert
-- angelegt : 1993-12-01
---------------------------------------------------------------------*)
SPECIFICATION Event

-- Events represent the Callbacks to Motif. The set of events per
-- DialogInterface object holds only one callback identified by its
-- string representation. This is checked in DialogInterface "AddEvent".

IMPORT DialogInterface FROM DialogIF;
IMPORT WIDGET          FROM DoiServ;

TYPE CallBack = ENUM
			close,
			closeRequest,
			iconize,
			reopen,
			resize,
 			help,
                        activate,
                        entry,
                        losingFocus,
                        valueChanged,
                        select,
                        defaultAction
	        END ENUM;

TYPE Event = OBJECT( IN source : DialogInterface, 
                     IN reason : CallBack, 
                     IN event  : METHOD )

PUBLIC

  METHOD Delete;
  METHOD IsReason( IN reason : CallBack ) : BOOL;
  METHOD Raise( IN callData : ADDRESS );

PROTECTED

  METHOD CreateCallback;

STATE
  Target : DialogInterface; 
  Reason : CallBack;
  Action : METHOD;
  --

END OBJECT;



TYPE TableEvent = Event 
          OBJECT( IN source : DialogInterface, 
                  IN reason : CallBack,
                  IN event  : METHOD,
                  IN position : METHOD( IN INT, IN INT ) )
PUBLIC

PROTECTED

STATE
  PosAction : METHOD( IN INT, IN INT );

END OBJECT;

END SPECIFICATION;
