-----------------------------------------------------------------
SPECIFICATION DoiMotif 
-----------------------------------------------------------------
-- for Dialog Builder run time calls 
-- & functions to realize the OSF/Motif interface
-----------------------------------------------------------------

IMPORT XcDATE, DISPLAY, WIDGET, WINDOW, RSHELEMENT
  FROM Doi;

TYPE size_t = UNSIGNED INT;     (* len param for string funcs *)

-----------------------------------------------------------------
------ Dialog Builder run time calls ----------------------------
-----------------------------------------------------------------
FOREIGN PROCEDURE RSHopenResource
                   (IN  resourceName : REF ARRAY OF CHAR,
                    OUT resourceId   : INT,
                    IN  check        : INT
                   ) : INT;
FOREIGN PROCEDURE RSHreadDialogObject
                   (IN  resourceId  : INT,
                    IN  resObjName  : REF ARRAY OF CHAR,
                    IN  doiName     : REF ARRAY OF CHAR,
                    IN  shell       : WIDGET,
                    OUT widget      : WIDGET,
                    OUT widgetclass : REF ARRAY OF CHAR
                   ) : INT;
FOREIGN PROCEDURE RSHmapSubNameToWidgetId
                   (IN instName   : REF ARRAY OF CHAR,
                    IN name       : REF ARRAY OF CHAR,
                    OUT widget    : WIDGET
                   ) : INT;
FOREIGN PROCEDURE RSHcloseResource
                   (IN resourceId : INT
                   ) : INT;
FOREIGN PROCEDURE RSHregisterNames
                   (IN resourceId : INT,
                    IN rsharglist : REF ARRAY OF RSHELEMENT
                   ) : INT;
FOREIGN PROCEDURE PMSsetPopupMenu
                   (IN object : WIDGET,
                    IN popup  : WIDGET,
                    IN button : INT);
FOREIGN PROCEDURE PMSremovePopupMenu
                   (IN object : WIDGET);
FOREIGN PROCEDURE PMSgetPopupMenu
                   (IN object : WIDGET) : WIDGET;
-----------------------------------------------------------------

-----------------------------------------------------------------
--------- The following C functions realize the     -------------
---------        OSF/Motif interface                -------------
-----------------------------------------------------------------
FOREIGN PROCEDURE DoiInitDebug ();
FOREIGN PROCEDURE DoiSetIconName (IN widget : WIDGET);
FOREIGN PROCEDURE DoiCreateLockWindow
                   (IN  widget       : WIDGET,
                    OUT lockWindow   : WINDOW,
                    IN  cursorShape  : INT,
                    IN  foreground   : REF ARRAY OF CHAR,
                    IN  background   : REF ARRAY OF CHAR
                   ) : INT;
FOREIGN PROCEDURE DoiDestroyLockWindow
                   (IN lockWindow : WINDOW);
FOREIGN PROCEDURE DoiSetLockWindow
                   (IN lockWindow : WINDOW);
FOREIGN PROCEDURE DoiResetLockWindow
                   (IN lockWindow : WINDOW);
FOREIGN PROCEDURE DoiSetAppClass
                   (IN doiClass : REF ARRAY OF CHAR);
FOREIGN PROCEDURE DoiGetDisplay () : DISPLAY;
FOREIGN PROCEDURE DoiInit
                   (IN    title : REF ARRAY OF CHAR,
                    INOUT shell : WIDGET,
                    INOUT argc  : INT,
                    IN    argv  : ARRAY OF REF ARRAY OF CHAR
                   );
FOREIGN PROCEDURE DoiManageChild
                   (IN widget : WIDGET,
                    IN shell  : WIDGET);
FOREIGN PROCEDURE DoiRealizeParentWidget
                   (IN widget : WIDGET);
FOREIGN PROCEDURE DoiDestroyWidget
                   (IN widget : WIDGET);
FOREIGN PROCEDURE DoiShow
                   (IN widget  : WIDGET,
                    IN shell   : WIDGET,
                    IN managed : INT);
FOREIGN PROCEDURE DoiHide
                   (IN widget : WIDGET);
FOREIGN PROCEDURE DoiLock
                   (IN widget : WIDGET);
FOREIGN PROCEDURE DoiUnlock
                   (IN widget : WIDGET);
FOREIGN PROCEDURE DoiGetInt
                   (IN  widget   : WIDGET,
                    OUT data     : INT,
                    IN  property : ARRAY OF CHAR
                   ) : INT;
FOREIGN PROCEDURE DoiClearIntF
                   (IN  widget : WIDGET);
FOREIGN PROCEDURE DoiClearDoubleF
                   (IN  widget : WIDGET);
FOREIGN PROCEDURE DoiClearIntFTable
                   (IN  widget : WIDGET,
                    IN  row    : INT,
                    IN  col    : INT);
FOREIGN PROCEDURE DoiClearDoubleFTable
                   (IN  widget : WIDGET,
                    IN  row    : INT,
                    IN  col    : INT);
FOREIGN PROCEDURE DoiGetIntF
                   (IN  widget   : WIDGET,
                    OUT data     : INT,
                    OUT valid    : INT
                   ) : INT;
FOREIGN PROCEDURE DoiGetString
                   (IN  widget    : WIDGET,
                    OUT data      : ARRAY OF CHAR,
                    IN  maxLength : INT,
                    IN  property  : ARRAY OF CHAR
                   ) : INT;
FOREIGN PROCEDURE DoiGetDouble
                   (IN  widget   : WIDGET,
                    OUT data     : DOUBLE,
                    IN  property : ARRAY OF CHAR
                   ) : INT;
FOREIGN PROCEDURE DoiGetDoubleF
                   (IN  widget   : WIDGET,
                    OUT data     : DOUBLE,
                    OUT valid    : INT
                   ) : INT;
FOREIGN PROCEDURE DoiGetDate
                   (IN  widget   : WIDGET,
                    OUT data     : XcDATE,
                    IN  property : ARRAY OF CHAR
                   ) : INT;
FOREIGN PROCEDURE DoiPutInt
                   (IN widget   : WIDGET,
                    IN data     : INT,
                    IN property : ARRAY OF CHAR);
FOREIGN PROCEDURE DoiPutString
                   (IN widget   : WIDGET,
                    IN data     : ARRAY OF CHAR,
                    IN property : ARRAY OF CHAR);
FOREIGN PROCEDURE DoiPutDouble
                   (IN widget   : WIDGET,
                    IN data     : DOUBLE,
                    IN property : ARRAY OF CHAR);
FOREIGN PROCEDURE DoiPutDate
                   (IN widget   : WIDGET,
                    IN data     : XcDATE,
                    IN property : ARRAY OF CHAR);
(* -- FOREIGN in TYPE Event
FOREIGN PROCEDURE DoiAddCallback
                   (IN widget     : WIDGET,
                    IN callback   : PROCEDURE (IN WIDGET,
                                               IN ADDRESS,
                                               IN ADDRESS),
                    IN reason     : ARRAY OF CHAR,
                    IN clientData : WIDGET);
*)
(* -- FOREIGN in TYPE Event
FOREIGN PROCEDURE DoiAddWMCloseCallback
                   (IN shell      : WIDGET,
                    IN widget     : WIDGET,
                    IN callback   : PROCEDURE (IN WIDGET,
                                               IN ADDRESS,
                                               IN ADDRESS),
                    IN clientData : WIDGET);
*)
(* -- FOREIGN in TYPE Event
FOREIGN PROCEDURE DoiRemoveCallback
                   (IN widget     : WIDGET,
                    IN callback   : PROCEDURE (IN WIDGET,
                                               IN ADDRESS,
                                               IN ADDRESS),
                    IN reason     : ARRAY OF CHAR,
                    IN clientData : ADDRESS);
*)
FOREIGN PROCEDURE DoiAddTabGroup    (IN widget : WIDGET);
FOREIGN PROCEDURE DoiRemoveTabGroup (IN widget : WIDGET);
FOREIGN PROCEDURE DoiLoop           ();
FOREIGN PROCEDURE DoiDoLocalLoop    (IN blocking : INT);
FOREIGN PROCEDURE DoiRemoveInputEvents ();
FOREIGN PROCEDURE DoiUpdateDisplay (IN widget : WIDGET);
FOREIGN PROCEDURE DoiBell           (IN widget : WIDGET);
FOREIGN PROCEDURE DoiSetFontCursor  (IN widget : WIDGET,
                                    IN shape  : INT,
                                    IN foreground : REF ARRAY OF CHAR,
                                    IN background : REF ARRAY OF CHAR);
FOREIGN PROCEDURE DoiResetFontCursor(IN widget : WIDGET);
FOREIGN PROCEDURE DoiMalloc         (IN size : size_t) : ADDRESS;
FOREIGN PROCEDURE DoiFree           (IN adr : ADDRESS);
FOREIGN PROCEDURE DoiGetWidgetName  (IN  widget    : WIDGET,
                                    OUT popupName : ARRAY OF CHAR,
                                    IN  maxLength : INT
                                   ) : INT;
FOREIGN PROCEDURE DoiAddListItem    (IN widget : WIDGET,
                                    IN item   : ARRAY OF CHAR,
                                    IN pos    : INT);
FOREIGN PROCEDURE DoiDeleteListItem (IN widget : WIDGET,
                                    IN pos    : INT);
FOREIGN PROCEDURE DoiSetListPosition(IN widget : WIDGET,
                                    IN pos    : INT);
FOREIGN PROCEDURE DoiSelectListPos  (IN widget : WIDGET,
                                    IN pos    : INT);
FOREIGN PROCEDURE DoiDeselectListPos(IN widget : WIDGET,
                                    IN pos    : INT);
FOREIGN PROCEDURE DoiDeselectAllItems
                   (IN widget : WIDGET);
FOREIGN PROCEDURE DoiGetSelectedItem
                   (IN widget : WIDGET,
                    OUT item  : ARRAY OF CHAR,
                    IN  maxLength : INT
                   ) : INT;
FOREIGN PROCEDURE DoiGetListCount
                   (IN widget : WIDGET,
                    OUT pos   : INT) : INT;
FOREIGN PROCEDURE DoiEmptyList
                  (IN list : WIDGET);
FOREIGN PROCEDURE DoiCommandAppendValue
                  (IN command : WIDGET,
                   IN value   : ARRAY OF CHAR);
FOREIGN PROCEDURE DoiCommandError
                  (IN command : WIDGET,
                   IN value   : ARRAY OF CHAR);
FOREIGN PROCEDURE DoiCommandSetValue
                  (IN command : WIDGET,
                   IN value   : ARRAY OF CHAR);
FOREIGN PROCEDURE DoiGetRows
                  (IN table : WIDGET,
                   OUT rows  : INT) : INT;
FOREIGN PROCEDURE DoiGetColumns
                  (IN table   : WIDGET,
                   OUT columns : INT) : INT;
FOREIGN PROCEDURE DoiGetVisibleRows
                  (IN table   : WIDGET,
                   OUT visRows : INT) : INT;
FOREIGN PROCEDURE DoiSetTopRow
                  (IN table : WIDGET,
                   IN row   : INT);
FOREIGN PROCEDURE DoiGetSelectedRow
                  (IN table : WIDGET,
                   OUT row   : INT) : INT;
FOREIGN PROCEDURE DoiEmptyTable
                  (IN table : WIDGET);
FOREIGN PROCEDURE DoiAddRows
                  (IN table : WIDGET,
                   IN rows  : INT,
                   IN pos   : INT);
FOREIGN PROCEDURE DoiDeleteRow
                  (IN table : WIDGET,
                   IN row   : INT);
FOREIGN PROCEDURE DoiSelectRow
                  (IN table : WIDGET,
                   IN row   : INT);
FOREIGN PROCEDURE DoiDeselectRow
                  (IN table : WIDGET,
                   IN row   : INT);
FOREIGN PROCEDURE DoiDeselectTable
                  (IN table : WIDGET);
FOREIGN PROCEDURE DoiPutDateTable
                  (IN table : WIDGET,
                   IN date  : XcDATE,
                   IN row   : INT,
                   IN col   : INT);
FOREIGN PROCEDURE DoiPutStringTable
                  (IN table  : WIDGET,
                   IN string : ARRAY OF CHAR,
                   IN row    : INT,
                   IN col    : INT);
FOREIGN PROCEDURE DoiPutIntTable
                  (IN table : WIDGET,
                   IN int   : INT,
                   IN row   : INT,
                   IN col   : INT);
FOREIGN PROCEDURE DoiPutDoubleTable
                  (IN table  : WIDGET,
                   IN double : DOUBLE,
                   IN row    : INT,
                   IN col    : INT);
FOREIGN PROCEDURE DoiGetDateTable
                  (IN  table : WIDGET, 
                   OUT date  : XcDATE,
                   IN  row   : INT,
                   IN  col   : INT) : INT;
FOREIGN PROCEDURE DoiGetStringTable
                  (IN  table     : WIDGET,
                   OUT string    : ARRAY OF CHAR,
                   IN  maxLength : INT,
                   IN  row       : INT,
                   IN  col       : INT) : INT;
FOREIGN PROCEDURE DoiGetIntFTable
                  (IN  table : WIDGET,
                   OUT int   : INT,
                   OUT valid : INT,
                   IN  row   : INT,
                   IN  col   : INT) : INT;
FOREIGN PROCEDURE DoiGetIntTable
                  (IN  table : WIDGET,
                   OUT int   : INT,
                   IN  row   : INT,
                   IN  col   : INT) : INT;
FOREIGN PROCEDURE DoiGetDoubleTable
                  (IN  table  : WIDGET,
                   OUT double : DOUBLE,
                   IN  row    : INT,
                   IN  col    : INT) : INT;
FOREIGN PROCEDURE DoiGetDoubleFTable
                  (IN  table  : WIDGET,
                   OUT double : DOUBLE,
                   OUT valid  : INT,
                   IN  row    : INT,
                   IN  col    : INT) : INT;
FOREIGN PROCEDURE DoiSetInputFocus
                  (IN  widget  : WIDGET);
FOREIGN PROCEDURE DoiSetInputFocusTable
                  (IN  table  : WIDGET,
                   IN  row    : INT,
                   IN  col    : INT);
FOREIGN PROCEDURE DoiGetChild
                  (IN widget  : WIDGET,
                   IN child   : INT) : WIDGET;
FOREIGN PROCEDURE DoiGetDialogElement
                  (IN  name    : WIDGET,
                   OUT childId : INT) : INT;
-----------------------------------------------------------------

-----------------------------------------------------------------
END SPECIFICATION;   (* DoiMotif *)
-----------------------------------------------------------------
