(*---------------------------------------------------------------------
-- Dialog Interface Objects
-----------------------------------------------------------------------
-- Copyright: (c) Sietec GmbH & Co oHG
--            All rights reserved 1993
-----------------------------------------------------------------------
-- Modul    : DialogIF.cs
-- Inhalt   : DialogInterface, Rootobject type 
-- Author   : Gold, Herbert
-- angelegt : 1993-12-01
---------------------------------------------------------------------*)

SPECIFICATION DialogIF

IMPORT Application     FROM Applic;
IMPORT Control         FROM Control;
IMPORT Event, CallBack FROM Event;
IMPORT WIDGET          FROM DoiServ;
IMPORT SmallSet        FROM SmallSet;

EXCEPTION NoResourceInitialized;


TYPE DialogInterface = ABSTRACT OBJECT

PUBLIC

  METHOD Nop; 
  METHOD Show;
  METHOD Hide; 

  METHOD HelpEvent;
  METHOD OnHelp( IN help : METHOD );
  METHOD ShowHelp( IN chapter : STRING, IN item : STRING );
  METHOD Trace( IN item : STRING );
  METHOD DependsOn( IN dio : DialogInterface ); 
  ABSTRACT METHOD GetContentEvent;

  METHOD AddEvent( IN callback:CallBack, IN event:METHOD );
  METHOD DelEvent( IN callback:CallBack ); 

  METHOD addDependent( IN dio : DialogInterface );
  METHOD addPart( IN part : Control );
  METHOD chkPart( IN name : STRING ) : Control;
  METHOD clear;
  METHOD getContent;
  METHOD putContent : BOOL;    --
  METHOD resetContent;
  METHOD resize;
  METHOD changeRequest;               -- raise GetContentEvent at Dependents
  METHOD name : STRING;
  METHOD getWidget : WIDGET;
  ABSTRACT METHOD shellWidget : WIDGET;

PROTECTED

  METHOD findEvent( IN callback:CallBack ) : Event;

STATE
  Events     : SmallSet [Event];  -- Set of all activated events / callbacks 
  PartLink   : Control;           -- all Parts are linked through this var
  Dependents : SmallSet[ DialogInterface ];
                             -- dependent Dio elements

  widget : WIDGET;             -- handle for dialogelement
  elementName : STRING;        -- the doiName = element-name
  helpAction : METHOD;         -- on help event

END OBJECT;

END SPECIFICATION;             (* DialogIF *)

