(*---------------------------------------------------------------------
-- Dialog Interface Objects
-----------------------------------------------------------------------
-- Copyright: (c) Sietec GmbH & Co oHG
--            All rights reserved 1993
-----------------------------------------------------------------------
-- Modul    : Dialog
-- Author   : Gold, Herbert
-- angelegt : 1993-12-09
---------------------------------------------------------------------*)
SPECIFICATION Dialog

IMPORT PushButton   FROM Push;
IMPORT WindowObject FROM WindowObj;
IMPORT Application  FROM Applic;


TYPE Dialog = WindowObject OBJECT( IN theParent : WindowObject )

PUBLIC

  METHOD AddOkButton( IN name : STRING ) : PushButton;
  METHOD AddCancelButton( IN name : STRING ) : PushButton;
  METHOD AddHelpButton( IN name : STRING ) : PushButton;
  -- METHOD AddApplyButton( IN name : STRING ) : PushButton;

  METHOD DefaultSetUp : BOOL;

  METHOD OkEvent;
  METHOD CancelEvent;

  METHOD OnOk( IN action : METHOD ) : Dialog;
  METHOD OnOkFrom( IN action : METHOD( IN Dialog ) ) : Dialog;

  METHOD OnCancel( IN action : METHOD ) : Dialog;
  METHOD OnCancelFrom( IN action : METHOD( IN Dialog ) ) : Dialog;

PROTECTED

 
STATE

  OkButton      : PushButton;
  CancelButton  : PushButton;
  HelpButton    : PushButton;
  -- ApplyButton   : PushButton;

  okAction     : METHOD;  
  okFromAction : METHOD( IN Dialog );

  cancelAction     : METHOD;
  cancelFromAction : METHOD( IN Dialog ); 

  raisedError : BOOL;

END OBJECT;       (* Dialog *)

TYPE DialogBox = Dialog
        OBJECT( IN theParent : WindowObject )

PUBLIC
   METHOD doLocalLoop;
   METHOD setRoot(IN applic : Application);

PROTECTED

STATE
   privateRoot : Application;
 

END OBJECT;             (* DialogBox *)

END SPECIFICATION;            (* Dialog *)
-- --------------------------------------------------------------------
