(*---------------------------------------------------------------------
-- Dialog Interface Objects
-----------------------------------------------------------------------
-- Copyright: (c) Sietec GmbH & Co oHG
--            All rights reserved 1993
-----------------------------------------------------------------------
-- Modul    : Datefield
-- Author   : Gold, Herbert
-- angelegt : 1993-12-02
---------------------------------------------------------------------*)
SPECIFICATION Datefield

IMPORT Format       FROM Format;
IMPORT WindowObject FROM WindowObj;
IMPORT Date         FROM Date;

TYPE Datefield = Format 
     OBJECT( IN theOwner : WindowObject, IN name : STRING )

PUBLIC

  METHOD GetValue : Date;
  METHOD PutValue( IN value : Date );

  METHOD OnGetContent( IN action : METHOD() : Date ) : Datefield;
  METHOD OnPutContent( IN action : METHOD( IN Date ) ) : Datefield;

PROTECTED

  METHOD get;
  METHOD put;

STATE
  getAction : METHOD() : Date;
  putAction : METHOD(IN Date);

END OBJECT;

END SPECIFICATION;         (* Datefield *)

