(*---------------------------------------------------------------------
-- Dialog Interface Objects
-----------------------------------------------------------------------
-- Copyright: (c) Sietec GmbH & Co oHG
--            All rights reserved 1993
-----------------------------------------------------------------------
-- Modul    : Control.cm
-- Author   : Gold, Herbert
-- angelegt : 1993-12-01
---------------------------------------------------------------------*)
SPECIFICATION Control

-- Each Control activates a losingFocusEvent on Initialisation.
-- This event checks, if the value has changed via oldValue.

IMPORT DialogInterface FROM DialogIF;
IMPORT WindowObject    FROM WindowObj;

IMPORT WIDGET          FROM DoiServ;


TYPE Control = DialogInterface ABSTRACT
     OBJECT( IN theOwner : WindowObject, IN name : STRING )

PUBLIC

  METHOD Clear;
  METHOD GetContentEvent;
  METHOD PutContentEvent;
  METHOD SetException( IN handler : METHOD( IN METHOD ):BOOL );
  METHOD Lock;      -- disable interaction(s)
  METHOD Unlock;    -- enable interaction(s) 

  METHOD shellWidget : WIDGET;

PROTECTED

  METHOD addDefaultCB;
  -- add losingFocusCallback as default CB.

  ABSTRACT METHOD get;
  ABSTRACT METHOD put;
  ABSTRACT METHOD getValue : STRING;     -- from Screen
  METHOD putValue( IN value : STRING );  -- to Screen needs redef.

  METHOD losingFocusEvent;

STATE
  Owner       : WindowObject;

  -- private state --
  dialogOwner : BOOL;      -- TRUE if Owner is a Dialog ( speedup var )
  exeptions   : METHOD( IN METHOD ) : BOOL; -- holds exception handling method  
  modified    : BOOL;      -- remember changes
  oldValue    : STRING;    -- remember initial value to detect modifications
  raisedError : BOOL;      -- error flag raised during PutContentEvent

END OBJECT;
 
END SPECIFICATION;         (* Control *)  

-- -------------------------------------------------------------------
