(*---------------------------------------------------------------------
-- Dialog Interface Objects
-----------------------------------------------------------------------
-- Copyright: (c) Sietec GmbH & Co oHG
--            All rights reserved 1993
-----------------------------------------------------------------------
-- Modul    : ComboBox
-- Author   : Gold, Herbert
-- angelegt : 1993-12-01
---------------------------------------------------------------------*)
SPECIFICATION ComboBox

IMPORT Control      FROM Control;
IMPORT WindowObject FROM WindowObj;

TYPE ComboBox = Control 
     OBJECT( IN theOwner : WindowObject, IN name : STRING )

PUBLIC

  METHOD GetValue : STRING;
  METHOD PutValue( IN value : STRING );

  METHOD OnGetContent( IN action : METHOD() : STRING ) : ComboBox;
  METHOD OnPutContent( IN action : METHOD( IN STRING ) ) : ComboBox;
  METHOD OnGetItem( IN getItem : METHOD( IN INT ) : STRING ) : ComboBox;

  METHOD SelectEvent;   -- a new value has been selected 

PROTECTED

  METHOD get;
  METHOD put;
  METHOD getValue : STRING;              -- from Screen

STATE
  getAction  : METHOD() : STRING;
  putAction  : METHOD(IN STRING);
  getItemAct : METHOD( IN INT ) : STRING;

END OBJECT;

END SPECIFICATION;         (* ComboBox *)

