'module' types

'export' 
     InitTypes
     
     IsInvalidTypeRec IsInvalidPtrRec
     
     IsConstTypeCompatible IsAssignmentCompatible IsReturnValueCompatible 
     IsInParamCompatible IsOutParamCompatible IsInOutParamCompatible
     IsEquivType IsEquivClassId IsSubType IsEquivEnumList
     
     IsIntArith IsFloatingPointArith IsStringArith 
     IsAddressPlusArith IsAddressMinusArith 
     IsRelOpCompare IsBoolCompare
     
     CheckClassType
     CheckNumericType CheckIntegerType CheckStringType CheckBoolType
     IsClassType
     IsNumericType IsIntegerType IsFloatingPointType 
     IsConstantType IsStringType IsErrorType

     DECLKIND DeclKind
     WellFormedOpenTypeIndex WellFormedTypeIndex 
     WellFormedRecordOrUnionTypeIndex WellFormedFParams
     ContainsString
     
     FollowNameChainIndex FollowNameChain IsTypeId GetTypeIdDef
     
'use' ast extspecs misc const decls
     
-- ========================================================================
--  Initialization
-- ========================================================================
     
'action' InitTypes
     
     'rule' InitTypes :
	  DeclKind <- coolDecl
	  
-- ========================================================================
--  Check on invalid recursion of types 
--  Example :
--    TYPE T = RECORD e : T; END RECORD;          
--  The additional parameter of IsInvalidTypeRec_h contains a list of
--  typenames used within the type definition. If a typename stored in the
--  list is applied inside the type definition, a recursive type definition
--  is detected (typenames, arrays, records and union have to be checked).
-- ========================================================================

'condition' IsInvalidTypeRec (Name : ID, Type : TYPE)

     'rule' IsInvalidTypeRec (Id, Type) :
	  IsInvalidTypeRec_h (Type, idlist (Id, nil))
	  
---------------------------------------------------------------------------

'condition' IsInvalidTypeRec_h (Type : TYPE, UsedNames : IDLIST)
     
     'rule' IsInvalidTypeRec_h (composite (Composite), L) :
	  IsInvalidCompositeTypeRec_h (Composite, L)
	  
---------------------------------------------------------------------------

'condition' IsInvalidCompositeTypeRec_h (CompositeType : COMPOSITETYPE, 
					 UsedNames : IDLIST)

     'rule' IsInvalidCompositeTypeRec_h (typename (Id), L) :
	  (|
	       GetIdMeaning (Id -> type (_))
	  ||
	       GetIdMeaning (Id -> foreigntype (_))
	  |)
	  IsQualifiedIdInList (Id, L)

     'rule' IsInvalidCompositeTypeRec_h (typename (Id), L) :
	  GetTypeIdDef (Id -> BaseType)
	  IsInvalidTypeRec_h (BaseType, idlist (Id, L))

     'rule' IsInvalidCompositeTypeRec_h (record (Fields), L) :
	  IsInvalidTypeRec_Field (Fields, L)

     'rule' IsInvalidCompositeTypeRec_h (union (Fields), L) :
	  IsInvalidTypeRec_Field (Fields, L)

     'rule' IsInvalidCompositeTypeRec_h (array( _, BaseTypeI), L) :
	  BaseTypeI'Type -> BaseType
	  IsInvalidTypeRec_h (BaseType, L)

     'rule' IsInvalidCompositeTypeRec_h (openarray(BaseTypeI), L) :
	  BaseTypeI'Type -> BaseType
	  IsInvalidTypeRec_h (BaseType, L)

---------------------------------------------------------------------------

'condition' IsInvalidTypeRec_Field (FIELD, IDLIST)
     
     'rule' IsInvalidTypeRec_Field (seq (Left, _), L)
	  IsInvalidTypeRec_Field (Left, L)
     
     'rule' IsInvalidTypeRec_Field (seq (_, Right), L)
	  IsInvalidTypeRec_Field (Right, L)

     'rule' IsInvalidTypeRec_Field (field (_, _, FieldTypeI), L) :
	  FieldTypeI'Type -> FieldType
	  IsInvalidTypeRec_h (FieldType, L)
     
-- ========================================================================
--  Check on useless types (which can't be translated to C)
--  Example :
--    TYPE T = REF T;
--    TYPE T = ARRAY [2] OF REF T;
--  This test is like IsInvalidTypeRec but reference types are included.
-- ========================================================================

'condition' IsInvalidPtrRec (TYPE) .

     'rule' IsInvalidPtrRec (composite (typename (Id))) :
	  GetTypeIdDef (Id -> BaseType)
	  IsInvalidPtrRec (BaseType)
	  
     'rule' IsInvalidPtrRec (Other) :
	  IsInvalidPtrRec_h (Other, nil)
	
---------------------------------------------------------------------------

'condition' IsInvalidPtrRec_h (TYPE, IDLIST)
     
     'rule' IsInvalidPtrRec_h (composite (Composite), L) :
	  IsInvalidPtrRec_Composite (Composite, L)
	  
---------------------------------------------------------------------------

'condition' IsInvalidPtrRec_Composite (COMPOSITETYPE, IDLIST)

     'rule' IsInvalidPtrRec_Composite (typename (Id), L) :
	  (|
	       GetIdMeaning (Id -> type (_))
	  ||
	       GetIdMeaning (Id -> foreigntype (_))
	  |)
	  IsQualifiedIdInList (Id, L)
	  
     'rule' IsInvalidPtrRec_Composite (typename (Id), L) :
	  GetTypeIdDef (Id -> BaseType)
	  IsInvalidPtrRec_h (BaseType, idlist (Id, L))
     
     'rule' IsInvalidPtrRec_Composite (array (_, BaseTypeI), L) :
	  BaseTypeI'Type -> BaseType
	  IsInvalidPtrRec_h (BaseType, L)
     
     'rule' IsInvalidPtrRec_Composite (openarray (BaseTypeI), L) :
	  BaseTypeI'Type -> BaseType
	  IsInvalidPtrRec_h(BaseType, L)
     
     'rule' IsInvalidPtrRec_Composite (ref (BaseTypeI), L) :
	  BaseTypeI'Type -> BaseType
	  IsInvalidPtrRec_h (BaseType, L)
     
-- ========================================================================
--  Typeequivalence
--  CAUTION:
--    The test has a recursive call to the compontents of structured
--    types and may not terminate. In the case of recursive type
--    definitions the test ends if the parameter are two types, which
--    were already compared. 
--    TYPEPAIRS is the list of already compared types.
--    Example:
--      TYPE R1 = RECORD e : REF R1; END RECORD;
--      TYPE R2 = RECORD e : REF R2; END RECORD;
-- ========================================================================

'condition' IsEquivTypeIndex (TYPEINDEX, TYPEINDEX)

     'rule' IsEquivTypeIndex (TypeIndex1, TypeIndex2) :
	  TypeIndex1'Type -> Type1
	  TypeIndex2'Type -> Type2
	  IsEquivType (Type1, Type2)

---------------------------------------------------------------------------

'condition' IsEquivType (TYPE, TYPE) .

     'rule' IsEquivType (T1, T2) :
	  IsEquivType_h (T1, T2, nil)

---------------------------------------------------------------------------
       
'condition' IsEquivType_h (TYPE, TYPE, visitedTypePairs : TYPEPAIRS)

     'rule' IsEquivType_h (error, _, L) : .
     'rule' IsEquivType_h (_, error, L) : .
	  
     'rule' IsEquivType_h (simple (S1), simple (S2), L) :
	  eq (S1, S2)
	  
     'rule' IsEquivType_h (composite (typename (Id1)), 
			   composite (typename (Id2)), L) :
	  EqQualifiedId (Id1, Id2)
	  
     'rule' IsEquivType_h (T1:composite (typename (Id)), T2, L) :
	  GetTypeIdDef (Id -> T1Def)
	  IsEquivType_h (T1Def, T2, pair (T1, T2, L))
     
     'rule' IsEquivType_h (T1, T2:composite (typename (Id)), L) :
	  GetTypeIdDef (Id -> T2Def)
	  IsEquivType_h (T1, T2Def, pair (T1, T2, L))

     'rule' IsEquivType_h (composite (enum (EnumList1)), 
			   composite (enum (EnumList2)), L) :
	  IsEquivEnumList (EnumList1, EnumList2)
     
     'rule' IsEquivType_h (composite (record (F1)), 
			   composite (record (F2)), L) :
	  IsEquivFieldList (F1, F2, L)

     'rule' IsEquivType_h (composite (union (F1)), 
			   composite (union (F2)), L) :
	  IsEquivFieldList (F1, F2, L)
	  
     'rule' IsEquivType_h (composite (array (Range1, BaseTypeI1)),
		           composite (array (Range2, BaseTypeI2)), L) :
	  IsEqualConstRange (Range1, Range2)
	  BaseTypeI1'Type -> BaseType1
	  BaseTypeI2'Type -> BaseType2
	  IsEquivType_h (BaseType1, BaseType2, L)
	
     'rule' IsEquivType_h (composite (openarray (BaseTypeI1)),
			   composite (openarray (BaseTypeI2)), L) :
	  BaseTypeI1'Type -> BaseType1
	  BaseTypeI2'Type -> BaseType2
	  IsEquivType_h (BaseType1, BaseType2, L)
	

     'rule' IsEquivType_h (composite (ref (RefTypeI1)),
		           composite (ref (RefTypeI2)), L) :
	  RefTypeI1'Type -> RefType1
	  RefTypeI2'Type -> RefType2
	  IsEquivType_h (RefType1, RefType2, L)
	  
     'rule' IsEquivType_h (composite (procedure (F1, ResultTypeI1)),
		           composite (procedure (F2, ResultTypeI2)), L) :
	  IsEquivFParamList (F1, F2, L)
	  ResultTypeI1'Type -> ResultType1
	  ResultTypeI2'Type -> ResultType2
	  IsEquivType_h (ResultType1, ResultType2, L)

     'rule' IsEquivType_h (composite (method (F1, ResultTypeI1)),
		           composite (method (F2, ResultTypeI2)), L) :
	  IsEquivFParamList (F1, F2, L)
	  ResultTypeI1'Type -> ResultType1
	  ResultTypeI2'Type -> ResultType2
	  IsEquivType_h (ResultType1, ResultType2, L)

     'rule' IsEquivType_h (composite (classtype (Id1, _, _)), 
			   composite (classtype (Id2, _, _)), L)
	  EqQualifiedId (Id1, Id2)
     
     'rule' IsEquivType_h (generic (genericinst (Id1, ActParams1)), 
			   generic (genericinst (Id2, ActParams2)), L) :
	  IsEquivClassId (Id1, Id2)
	  IsEquivTypeIndexList (ActParams1, ActParams2)
	  
     'rule' IsEquivType_h (generic (unconstrained (Id1)), 
			   generic (unconstrained (Id2)), L) :
	  EqId (Id1, Id2)
	  
     'rule' IsEquivType_h (generic (constrained (Id1, _)), 
			   generic (constrained (Id2, _)), L) :
	  EqId (Id1, Id2)
	  
     'rule' IsEquivType_h (T1, T2, L) :
	  IsActivePair (T1, T2, L)

---------------------------------------------------------------------------
       
'condition' IsEquivEnumList (ENUMERATORLIST, ENUMERATORLIST)
     
     'rule' IsEquivEnumList (enumeratorlist (enumerator (_, Id1), Tail1), 
			     enumeratorlist (enumerator (_, Id2), Tail2)) :
	  EqId (Id1, Id2)
	  IsEquivEnumList (Tail1, Tail2)
	  
     'rule' IsEquivEnumList (nil, nil) :
	  
---------------------------------------------------------------------------
       
'condition' IsEquivFieldList (FIELD, FIELD, TYPEPAIRS)
     
     'rule' IsEquivFieldList (seq (Left1, Right1), seq (Left2, Right2), L) :
	  IsEquivFieldList (Left1, Left2, L)
	  IsEquivFieldList (Right1, Right2, L)
	  
     'rule' IsEquivFieldList (field (_, _, FieldTypeI1),
			      field (_, _, FieldTypeI2), L) :
	  FieldTypeI1'Type -> FieldType1
	  FieldTypeI2'Type -> FieldType2
	  IsEquivType_h (FieldType1, FieldType2, L)
	  
     'rule' IsEquivFieldList (nil, nil, L) :
     
     'rule' IsEquivFieldList (error, _, L) :
	  
     'rule' IsEquivFieldList (_, error, L) :

---------------------------------------------------------------------------
       
'condition' IsEquivFParamList (FPARAMLIST, FPARAMLIST, TYPEPAIRS)
     
     'rule' IsEquivFParamList (fparamlist (fparam (_, _, M1, ParamTypeI1),
					   Tail1),
			       fparamlist (fparam (_, _, M2, ParamTypeI2), 
					   Tail2), L) :
	  eq (M1, M2)
	  ParamTypeI1'Type -> ParamType1
	  ParamTypeI2'Type -> ParamType2
	  IsEquivType_h (ParamType1, ParamType2, L)
	  IsEquivFParamList (Tail1, Tail2, L)

     'rule' IsEquivFParamList (error , _, L) :
	  
     'rule' IsEquivFParamList (_, error , L) :
	  
     'rule' IsEquivFParamList (ellipsis, _, L) :
     
     'rule' IsEquivFParamList (_, ellipsis, L) :
     
     'rule' IsEquivFParamList (nil, nil, L) :

---------------------------------------------------------------------------
       
'type' TYPEPAIRS
     pair (TYPE, TYPE, TYPEPAIRS)
     nil
     
'condition' IsActivePair (TYPE, TYPE, TYPEPAIRS)

     'rule' IsActivePair (T1, T2, pair(X1, X2, Tail) ) :
	  eq (T1, X1)
	  eq (T2, X2)
	  
     'rule' IsActivePair (T1, T2, pair(X1, X2, Tail) ) :
	  IsActivePair (T1, T2, Tail) .

---------------------------------------------------------------------------

'condition' IsEquivTypeIndexList (TYPEINDEXLIST, TYPEINDEXLIST)
     
     'rule' IsEquivTypeIndexList (typeindexlist (TypeIndex1, Tail1), 
				  typeindexlist (TypeIndex2, Tail2)) :
	  IsEquivTypeIndex (TypeIndex1, TypeIndex2)
	  IsEquivTypeIndexList (Tail1, Tail2)
	  
     'rule' IsEquivTypeIndexList (nil , nil) :

---------------------------------------------------------------------------

'condition' IsEquivClassId (ID, ID)
     
     'rule' IsEquivClassId (Id1, Id2) :
	  IsTypeId (Id1 -> Type1)
	  IsTypeId (Id2 -> Type2)
	  (|
	       where (Type1 -> error)
	  ||
	       where (Type2 -> error)
	  ||
	       where (Type1 -> composite (classtype (CId1, _, _)))
	       where (Type2 -> composite (classtype (CId2, _, _)))
	       EqQualifiedId (CId1, CId2)
	  |)
	  
-- ========================================================================
--  Type compatibitily
--  IsTypeCompatible (X, Y) : X is compatible to Y 
--    (var := expr, where X is the type of expr and Y ist the type of var)
--    CAUTION: the types must not be typenames.
--  IsSubType (X, Y) : X is subtype of Y
--  IsTypeIndexSuperList is needed by the type compatibility test to check
--  the lists of actual generic parameters within the instantiation of two
--  generic types. 
--  IsConstTypeCompatible (X, Y) checks compatibility to constant types,
--    where X is the constant type (i.e. intliteraltype).
--  IsAssignmentCompatible checks assignment compatibility, containing
--    special rules for numeric types and the type of a stringliteral.
--  IsReturnValueCompatible checks the compatibility of the return value of
--    a routine.
--  IsInParamCompatible checks the compatibility of actual and formal 
--    parameters, conatining a special rule for the type of a stringliteral.  
--  IsOutParamCompatible checks the compatibility out parameters.
--  IsInOutParamCompatible checks the compatibility inout parameters.
-- ========================================================================

'condition' IsTypeCompatible (TYPE, TYPE)
     
     'rule' IsTypeCompatible (X, _) :
	  IsErrorType (X)
     
     'rule' IsTypeCompatible (_, Y) :
	  IsErrorType (Y)
     
     'rule' IsTypeCompatible (X , Y) : -- (1) 
	  IsEquivType (X, Y)
	  
     'rule' IsTypeCompatible (X , Y) : -- (2) 
	  IsSubType (X, Y)
	  
     'rule' IsTypeCompatible (generic (genericinst (Id1, TypeIndexList1)),
		              generic (genericinst (Id2, TypeIndexList2))) :
                                       -- (3)
	  GetTypeIdDef (Id1 -> T1)
	  FollowNameChain (T1 -> T1Def)
	  GetTypeIdDef (Id2 -> T2)
	  FollowNameChain (T2 -> T2Def)
	  IsSubType (T1Def, T2Def)
	  IsTypeIndexSuperList (TypeIndexList1, TypeIndexList2)
	  
     'rule' IsTypeCompatible (generic (constrained (_, Id1)),
			      composite (classtype (Id2, _, _))) : -- (4)
	  IsEquivClassId (Id1, Id2)
	  
     'rule' IsTypeCompatible (composite (array (_, T1I)), 
			      composite (openarray (T2I))) :      -- (5)
	  FollowNameChainIndex (T1I -> T1Def)
	  FollowNameChainIndex (T2I -> T2Def)
	  IsEquivType (T1Def, T2Def)
     
     'rule' IsTypeCompatible (composite (openarray (T1I)), 
			      composite (array (_, T2I))) :       -- (5)
	  FollowNameChainIndex (T1I -> T1Def)
	  FollowNameChainIndex (T2I -> T2Def)
	  IsEquivType (T1Def, T2Def)
			 
     'rule' IsTypeCompatible (simple (address),
			      composite (ref (_))) :             -- (6)
	  
     'rule' IsTypeCompatible (composite (ref (_)), 
			      simple (address)) :                -- (6)
	  
     'rule' IsTypeCompatible (simple (niltype), Y) :             -- (7)
	  (|
	       where (Y -> composite (classtype (_, _, _)))
	  ||
	       where (Y -> generic (_))
	  ||
	       where (Y -> composite (ref (_)))
	  ||
	       where (Y -> simple (address))
	  ||
	       where (Y -> composite (procedure (_, _)))
	  ||
	       where (Y -> composite (method (_, _)))
	  |)
		      
     'rule' IsTypeCompatible (X, Y) :
	  IsConstTypeCompatible (X, Y)

---------------------------------------------------------------------------
       
'condition' IsSubType (TYPE, TYPE)

     'rule' IsSubType (composite (classtype (Id1, _, _)),
		       composite (classtype (Id2, _, _))) :
	  EqQualifiedId (Id1, Id2)

     'rule' IsSubType (composite (classtype (Id1, _, Interface)),
		       T:composite (classtype ( _, _, _))) :
	  Interface'Supertype -> super (Id2)
	  GetTypeIdDef (Id2 -> DefType)
	  FollowNameChain (DefType -> DefType2)
	  IsSubType (DefType2, T)
     
     'rule' IsSubType (T1:composite (classtype (_, _, _)), 
		       generic (genericinst (Id, _))) :
	  GetTypeIdDef (Id -> T2:composite (classtype (_, _, _)))
	  IsSubType (T1, T2)
	  
     'rule' IsSubType (generic (genericinst (Id, _)), 
		       T2:composite (classtype (_, _, _))) :
	  GetTypeIdDef (Id -> T1:composite (classtype (_, _, _)))
	  IsSubType (T1, T2)
	  
     'rule' IsSubType (error, _) : 
	  
     'rule' IsSubType (_, error) : 

---------------------------------------------------------------------------

'condition' IsTypeIndexSuperList (TYPEINDEXLIST, TYPEINDEXLIST)
     
     'rule' IsTypeIndexSuperList (typeindexlist (TypeIndex1, Tail1), 
				  typeindexlist (TypeIndex2, Tail2)) :
	  IsEquivTypeIndex (TypeIndex1, TypeIndex2)
	  IsTypeIndexSuperList (Tail1, Tail2)
	  
-- the first list may contain more elements than the second	  
     'rule' IsTypeIndexSuperList (_ , nil) :

---------------------------------------------------------------------------
       
'condition' IsConstTypeCompatible (TYPE, TYPE) 

     'rule' IsConstTypeCompatible (simple (intliteraltype), Y) :
	  IsIntegerType (Y)
	       
     'rule' IsConstTypeCompatible (simple (doubleliteraltype), Y) :
	  IsFloatingPointType (Y)
	  
     'rule' IsConstTypeCompatible (simple (stringliteraltype), 
				   simple (string)) :
	  
---------------------------------------------------------------------------

'condition' IsAssignmentCompatible (source : TYPE, target : TYPE)

     'rule' IsAssignmentCompatible (X, Y) :
	  IsTypeCompatible (X, Y)
	  
     'rule' IsAssignmentCompatible (X, Y) :
	  IsNumericType (X)
	  IsNumericType (Y)
	  
     'rule' IsAssignmentCompatible (simple (stringliteraltype), 
			            composite (array (_, BaseTypeI)))
	  FollowNameChainIndex (BaseTypeI -> simple (char))
	  
     'rule' IsAssignmentCompatible (simple (stringliteraltype), 
			            composite (ref (RefTypeI))) :
	  FollowNameChainIndex (RefTypeI -> RefType)
	  (|
	       where (RefType -> composite (array (_, BaseTypeI)))
	  ||
	       where (RefType -> composite (openarray (BaseTypeI)))
	  |)
	  FollowNameChainIndex (BaseTypeI -> simple (char))
     
---------------------------------------------------------------------------
       
'condition' IsReturnValueCompatible (Value : TYPE, ResultType : TYPE)
     
     'rule' IsReturnValueCompatible (X, Y) :
	  IsTypeCompatible (X, Y)
	  
---------------------------------------------------------------------------

'condition' IsInParamCompatible (actual : TYPE, formal : TYPE)
	  
     'rule' IsInParamCompatible (X, Y) :
	  IsTypeCompatible (X, Y)
	  
     'rule' IsInParamCompatible (simple (stringliteraltype), Y) :
	  (|
	       where (Y -> composite (array (_, BaseTypeI)))
	  ||
	       where (Y -> composite (openarray (BaseTypeI)))
	  ||
	       where (Y -> composite (ref (RefTypeI)))
	       FollowNameChainIndex (RefTypeI -> RefType2)
	       (|
		    where (RefType2 -> composite (array (_, BaseTypeI)))
	       ||
		    where (RefType2 -> composite (openarray (BaseTypeI)))
	       |)
	  |)
	  FollowNameChainIndex (BaseTypeI -> simple (char))
	  
---------------------------------------------------------------------------
       
'condition' IsOutParamCompatible (actual : TYPE, formal : TYPE)
     
     'rule' IsOutParamCompatible (X, Y) :
	  IsTypeCompatible (Y, X)

---------------------------------------------------------------------------
       
'condition' IsInOutParamCompatible (actual : TYPE, formal : TYPE)
     
     'rule' IsInOutParamCompatible (X, Y) :
	  IsTypeCompatible (X, Y)
	  IsTypeCompatible (Y, X)

-- ========================================================================
--  Check on special types
--    CAUTION: the types must not be typenames in Is...Type predicates.
-- ========================================================================

'action' CheckClassType (POS, TYPE -> TYPE)
     
     'rule' CheckClassType (_, T -> TDef) :
	  FollowNameChain (T -> TDef)
	  IsClassType (TDef)
	  
     'rule' CheckClassType (Pos, _ -> error) :
	  Error ("object type expected", Pos)
	  
---------------------------------------------------------------------------

'condition' IsClassType (TYPE) 
     
     'rule' IsClassType (composite (classtype (_, _, _))) :
	  
     'rule' IsClassType (generic (genericinst (Id, Params))) :
	  GetTypeIdDef (Id -> TDef)
	  IsClassType (TDef)
	  
     'rule' IsClassType (T) :
	  IsErrorType (T)
	  
---------------------------------------------------------------------------

'action' CheckNumericType (POS, TYPE -> TYPE)
     
     'rule' CheckNumericType (_, T -> TDef) :
	  FollowNameChain (T -> TDef)
	  IsNumericType (TDef)
	  
     'rule' CheckNumericType (Pos, _ -> error) :
	  Error ("numeric type expected", Pos)

---------------------------------------------------------------------------

'condition' IsNumericType (TYPE) 
     
     'rule' IsNumericType (T) :
	  IsIntegerType (T) 
     
     'rule' IsNumericType (T) :
	  IsFloatingPointType (T)
	  
---------------------------------------------------------------------------

'action' CheckIntegerType (POS, TYPE -> TYPE)
     
     'rule' CheckIntegerType (_, T -> DefT) :
	  FollowNameChain (T -> DefT)
	  IsIntegerType (DefT)
	  
     'rule' CheckIntegerType (Pos, _ -> error) :
	  Error ("integer type expected", Pos)
	  
---------------------------------------------------------------------------
       
'condition' IsIntegerType (TYPE)
     
     'rule' IsIntegerType (simple (X)) :
	  IsSimpleIntegerType (X)
	  
     'rule' IsIntegerType (X) :
	  IsErrorType (X)

---------------------------------------------------------------------------

 'condition' IsSimpleIntegerType (SIMPLETYPE)

     'rule' IsSimpleIntegerType (shortint) : 
     'rule' IsSimpleIntegerType (unsignedshortint) :
     'rule' IsSimpleIntegerType (int) :
     'rule' IsSimpleIntegerType (unsignedint) :
     'rule' IsSimpleIntegerType (longint) :
     'rule' IsSimpleIntegerType (unsignedlongint) :
     'rule' IsSimpleIntegerType (intliteraltype) :

---------------------------------------------------------------------------
       
'condition' IsFloatingPointType (TYPE) .

     'rule' IsFloatingPointType (simple (float)) :
     'rule' IsFloatingPointType (simple (double)) :
     'rule' IsFloatingPointType (simple (doubleliteraltype)) :
     'rule' IsFloatingPointType (X) :
	  IsErrorType (X)
	  
---------------------------------------------------------------------------
       
'condition' IsConstantType (TYPE)
     
     'rule' IsConstantType (composite (enum (_))) :
     'rule' IsConstantType (simple (bool)) :
     'rule' IsConstantType (simple (char)) :
     'rule' IsConstantType (simple (string)) :
     'rule' IsConstantType (X) :
	  IsNumericType (X)
	  
---------------------------------------------------------------------------

'action' CheckStringType (POS, TYPE -> TYPE)
     
     'rule' CheckStringType (_, T -> TDef) :
	  FollowNameChain (T -> TDef)
	  IsStringType (TDef)
	  
     'rule' CheckStringType (Pos, _ -> error) :
	  Error ("STRING expected", Pos)
	  
---------------------------------------------------------------------------
       
'condition' IsStringType (TYPE)
     
     'rule' IsStringType (simple (string)) :
     'rule' IsStringType (simple (stringliteraltype)) :
     'rule' IsStringType (X)
	  IsErrorType (X)
	  
---------------------------------------------------------------------------
       
'action' CheckBoolType (POS, TYPE -> TYPE)
     
     'rule' CheckBoolType (Pos, T -> TDef) :
	  FollowNameChain (T -> TDef)
	  IsBoolType (TDef)
	  
     'rule' CheckBoolType (Pos, _ -> error) :
	  Error ("BOOL expected", Pos)

---------------------------------------------------------------------------
       
'condition' IsBoolType (TYPE)
     
     'rule' IsBoolType (simple (bool)) :
	  
     'rule' IsBoolType (T)
	  IsErrorType (T)
	  
---------------------------------------------------------------------------
       
'condition' IsErrorType (TYPE) 
     
     'rule' IsErrorType (error) :
     'rule' IsErrorType (simple(error)) :
     'rule' IsErrorType (generic (error)) :
     'rule' IsErrorType (composite(error)) :
	  
-- ========================================================================
--  type checks on dyadic operations
-- ========================================================================
       
'condition' IsIntArith (SIMPLETYPE, SIMPLETYPE -> SIMPLETYPE)
     
     'rule' IsIntArith (intliteraltype, T -> T)
	  IsSimpleIntegerType (T)
     'rule' IsIntArith (T, intliteraltype -> T)
	  IsSimpleIntegerType (T)
	  
     'rule' IsIntArith (shortint, shortint -> shortint) :
     'rule' IsIntArith (shortint, unsignedshortint -> shortint) :
     'rule' IsIntArith (shortint, T -> T) :
	  IsSimpleIntegerType (T)
	  
     'rule' IsIntArith (unsignedshortint, shortint -> unsignedshortint) :
     'rule' IsIntArith (unsignedshortint, unsignedshortint -> 
			unsignedshortint) :
     'rule' IsIntArith (unsignedshortint, T -> T) :
	  IsSimpleIntegerType (T)
     
     'rule' IsIntArith (int, T -> int) :
	  IsSimpleIntegerType (T)
     
     'rule' IsIntArith (unsignedint, unsignedshortint -> unsignedint) :
     'rule' IsIntArith (unsignedint, shortint -> unsignedint) :
     'rule' IsIntArith (unsignedint, T -> T) :
	  IsSimpleIntegerType (T)

     'rule' IsIntArith (longint, int -> int) :
     'rule' IsIntArith (longint, T -> longint) :
	  IsSimpleIntegerType (T)
     
     'rule' IsIntArith (unsignedlongint, int -> int) :
     'rule' IsIntArith (unsignedlongint, longint -> longint) :
     'rule' IsIntArith (unsignedlongint, T -> unsignedlongint) :
	  IsSimpleIntegerType (T)
     
---------------------------------------------------------------------------

'condition' IsFloatingPointArith (SIMPLETYPE, SIMPLETYPE -> SIMPLETYPE)
     
     'rule' IsFloatingPointArith (doubleliteraltype, doubleliteraltype -> 
				  doubleliteraltype) : 
     'rule' IsFloatingPointArith (doubleliteraltype, intliteraltype ->
				  doubleliteraltype) :
     'rule' IsFloatingPointArith (doubleliteraltype, float -> float) :
     'rule' IsFloatingPointArith (doubleliteraltype, double -> double) :
     'rule' IsFloatingPointArith (doubleliteraltype, T -> float) :
	  IsSimpleIntegerType (T)
     'rule' IsFloatingPointArith (intliteraltype, doubleliteraltype ->
				  doubleliteraltype) :
     'rule' IsFloatingPointArith (float, doubleliteraltype  -> float) :
     'rule' IsFloatingPointArith (double, doubleliteraltype  -> double) :
     'rule' IsFloatingPointArith (T, doubleliteraltype  -> float) :
	  IsSimpleIntegerType (T)
	  
     'rule' IsFloatingPointArith (float, float -> float) :
     'rule' IsFloatingPointArith (float, double -> double) :
     'rule' IsFloatingPointArith (float, T -> float) :
	  IsSimpleIntegerType (T)
	  
     'rule' IsFloatingPointArith (double, double -> double) :
     'rule' IsFloatingPointArith (double, float -> double) : 
     'rule' IsFloatingPointArith (double, T -> double) : 
	  IsSimpleIntegerType (T)

---------------------------------------------------------------------------

'condition' IsStringArith (SIMPLETYPE, SIMPLETYPE -> SIMPLETYPE)
     
     'rule' IsStringArith (string, string -> string) :
     'rule' IsStringArith (string, stringliteraltype -> string) :
     'rule' IsStringArith (string, char -> string)
	  
     'rule' IsStringArith (stringliteraltype, string -> string) :
     'rule' IsStringArith (stringliteraltype, stringliteraltype -> 
			   string) : 
            -- the result is string and not stringliteraltype, 
	    -- to forbit ARRAY OF CHAR := "string" + "string". 
	    -- The result should be stringliteraltype in the case of
	    -- constant expression evaluation in expressions.
     'rule' IsStringArith (stringliteraltype, char -> string)
	  
     'rule' IsStringArith (char, string -> string)
     'rule' IsStringArith (char, stringliteraltype -> string)
     'rule' IsStringArith (char, char -> string)
	  
---------------------------------------------------------------------------

'condition' IsAddressPlusArith (SIMPLETYPE, SIMPLETYPE -> SIMPLETYPE)
	  
     'rule' IsAddressPlusArith (T, address -> address) :
	  IsSimpleIntegerType (T)
     
     'rule' IsAddressPlusArith (address, T -> address) :
	  IsSimpleIntegerType (T)
	  
---------------------------------------------------------------------------

'condition' IsAddressMinusArith (SIMPLETYPE, SIMPLETYPE -> SIMPLETYPE)
	  
     'rule' IsAddressMinusArith (address, T -> address) :
	  IsSimpleIntegerType (T)
     
     'rule' IsAddressMinusArith (address, address -> int) :
	  
---------------------------------------------------------------------------

'condition' IsRelOpCompare (SIMPLETYPE, SIMPLETYPE)
     
     'rule' IsRelOpCompare (LType, RType) :
	  IsIntArith (LType, RType -> _)
	  
     'rule' IsRelOpCompare (LType, RType) :
	  IsFloatingPointArith (LType, RType -> _)
	  
     'rule' IsRelOpCompare (LType, RType) :
	  IsCharCompare (LType, RType)
	  
     'rule' IsRelOpCompare (LType, RType) :
	  IsStringCompare (LType, RType)
	  
---------------------------------------------------------------------------

'condition' IsCharCompare (SIMPLETYPE, SIMPLETYPE)
     
     'rule' IsCharCompare (char, char) :
	  
---------------------------------------------------------------------------

'condition' IsBoolCompare (SIMPLETYPE, SIMPLETYPE)
     
     'rule' IsBoolCompare (bool, bool) :
	  
---------------------------------------------------------------------------

'condition' IsStringCompare (SIMPLETYPE, SIMPLETYPE)
     
     'rule' IsStringCompare (T1, T2) :
	  IsStringArith (T1, T2 -> _)

-- ========================================================================
--  DeclKind indicates whether the actual declaration is a foreign or a cool
--    declaration (used to check the ellipsis in a formal parameter list). 
--  WellFormedRecordOrUnionType is a special predicate to forbit unnamed
--    records and unions (the rules of this predicate have to be integrated
--    into WellFormedType if the restriction in the code generation
--    concering unnamed types is removed).
--  WellFormedType checks the given type.
--  WellFormedOpenType allows open array types in addition
--  WellFormedTypeIndex and WellFormedOpenTypeIndex rewrite the type in
--    the field Type of TYPEINDEX with the checked type. 
--  WellFormedTypename is a special predicate to check the application of a
--    typename.
--  WellFormedEnumerators and CheckIdInEnumeratorList check the list of
--    enumerators on muliple definitions.
--  WellFormedFields and CheckIdInFieldList check a record or union
--    fieldlist on muliple definitions.
--  WellFormedProcTypeParams checks the parameters of procedure and method
--    types. 
--  WellFormedSuperType, WellFormedObjParams, WellFormedGenParams and
--    WellFormedDecls are special predicates to check a classtype. The check
--    of a classtypes computes the complete interface, including all
--    inherited methods and instance variables, of the classtype.
--  WellFormedFParams checks the formal parameters of procedures, methods
--    and classes (object and formal generic parameters).
--  WellFormedEllipsis checks whether the ellipsis appears in a foriegn
--    declaration.
-- ========================================================================

'type' DECLKIND
     foreignDecl
     coolDecl

'var' DeclKind : DECLKIND

---------------------------------------------------------------------------

'action' WellFormedRecordOrUnionTypeIndex (TYPEINDEX)
     
     'rule' WellFormedRecordOrUnionTypeIndex (TypeI)
	  TypeI'Pos  -> Pos
	  TypeI'Type -> Type
	  WellFormedRecordOrUnionType (Pos, Type -> Type2)
  	  TypeI'Type <- Type2

---------------------------------------------------------------------------
	  
'action' WellFormedRecordOrUnionType (POS, TYPE -> TYPE)
     
     'rule' WellFormedRecordOrUnionType 
               (Pos, Type:composite (record (Fields)) -> Type2) :
	  (|
	       where (Fields -> nil)
	       Error ("nonempty fieldlist expected", Pos)
	       let (TYPE'error -> Type2)
	  ||
	       WellFormedFields (Fields, Fields)
	       let (Type -> Type2)
	  |)
	   
     'rule' WellFormedRecordOrUnionType 
               (Pos, Type:composite (union (Fields)) -> Type2) :
	  (|
	       where (Fields -> nil)
	       Error ("nonempty fieldlist expected", Pos)
	       let (TYPE'error -> Type2)
	  ||
	       ContainsStringField (Fields)
	       Error ("invalid STRING in union type", Pos)
	       let (TYPE'error -> Type2)
	  ||
	       WellFormedFields (Fields, Fields)
	       let (Type -> Type2)
	  |)
	
     'rule' WellFormedRecordOrUnionType (Pos, Type:composite (typename (_)) ->
					 Type2) :
	  WellFormedTypename (Pos, Type -> Type2)
	  
     'rule' WellFormedRecordOrUnionType (Pos, Type -> Type2) :
	  WellFormedOpenType (Pos, Type -> Type2)
	  
---------------------------------------------------------------------------

'action' WellFormedOpenTypeIndex (TYPEINDEX)
     
     'rule' WellFormedOpenTypeIndex (TypeI) :
	  TypeI'Pos  -> Pos
	  TypeI'Type -> Type
	  WellFormedOpenType (Pos, Type -> Type2)
  	  TypeI'Type <- Type2

---------------------------------------------------------------------------
	  
'action' WellFormedOpenType (POS, TYPE -> TYPE)
     
     'rule' WellFormedOpenType (Pos, 
				Type:composite (openarray (BaseTypeI)) ->
				Type2) :
	  WellFormedTypeIndex (BaseTypeI)
	  let (Type -> Type2)
	  
     'rule' WellFormedOpenType (Pos, Type:composite (typename (_)) ->
				Type2) :
	  WellFormedTypename (Pos, Type -> Type2)
     
     'rule' WellFormedOpenType (Pos, Type -> Type2) :
	  WellFormedType (Pos, Type -> Type2)
	  
---------------------------------------------------------------------------
	  
'action' WellFormedTypeIndex (TYPEINDEX)
     
     'rule' WellFormedTypeIndex (TypeI) :
	  TypeI'Pos  -> Pos
	  TypeI'Type -> Type
	  WellFormedType (Pos, Type -> Type2)
  	  TypeI'Type <- Type2
	  
---------------------------------------------------------------------------

'action' WellFormedType	(POS, TYPE -> TYPE)
     
     'rule' WellFormedType (Pos, Type:composite (typename (Id)) -> Type3) :
	  WellFormedTypename (Pos, Type -> Type2)
	  (|
	       FollowNameChain (Type2 -> composite (openarray (_)))
	       Id'Ident -> I
	       ErrorI ("open array type '", I, "' in invalid context",
		       Pos)
	       let (TYPE'error -> Type3)
	  ||
	       let (Type2 -> Type3)
	  |)
	  
     'rule' WellFormedType (Pos, Type:composite (enum (Enumerators)) -> 
			    Type2) :
	  (|
	       where (Enumerators -> nil)
	       Error ("nonempty enumeratorlist expected", Pos)
	       let (TYPE'error -> Type2)
	  ||
	       WellFormedEnumerators (Enumerators)
	       let (Type -> Type2)
	  |)
	  
     'rule' WellFormedType (Pos, Type:composite (record (_)) -> error) :
	  Error ("unnamed record types : not yet implemented", Pos) 
	  
     'rule' WellFormedType (Pos, Type:composite (union (_)) -> error) :
	  Error ("unnamed union types : not yet implemented", Pos) 
	   
     'rule' WellFormedType (Pos, composite (array (Range, BaseTypeI)) ->
			    Type2) :
	  CheckArrayRange (Range -> Range2)
	  WellFormedTypeIndex (BaseTypeI)
	  let (composite (array (Range2, BaseTypeI)) -> Type2)
	  
     'rule' WellFormedType (Pos, composite (openarray (_)) -> error) :
	  Error ("open array in invalid context", Pos)
	  
     'rule' WellFormedType (_, Type:composite (ref (BaseTypeI)) -> Type) :
	  WellFormedOpenTypeIndex (BaseTypeI)
	  
     'rule' WellFormedType (_, Type:composite (procedure (Params, 
							  ResultTypeI)) -> 
			    Type)
	  WellFormedProcTypeParams (Params)
	  WellFormedTypeIndex (ResultTypeI)
	  
     'rule' WellFormedType (_, Type:composite (method (Params, 
						       ResultTypeI)) -> 
			    Type)
	  WellFormedProcTypeParams (Params)
	  WellFormedTypeIndex (ResultTypeI)
	  
     'rule' WellFormedType (_, Type:composite (classtype (Id, GenPar, In)) ->
			    composite (classtype (Id, GenPar, In2))) :
	  WellFormedFParams (GenPar)
	  GetCompleteInterface (Id, In ->
				In2:interface (S, _, Par, ExpMeth, IV))
	  WellFormedSuperType (Id, S)
	  WellFormedGenParams (Id, S, GenPar)
	  WellFormedObjParams (Id, S, Par)
	  WellFormedDecls (ExpMeth)
	  WellFormedDecls (IV)
     
     'rule' WellFormedType (Pos, Type:generic (genericinst (Id, ActParams))
			    -> Type) :
	  CheckId (Id)
	  IsTypeId (Id -> DefType)
	  (|
	       where (DefType -> error)
	  ||
	       where (DefType -> composite (classtype (_, FGenParams, _)))
	       WellFormedActGenParams (Pos, ActParams, FGenParams)
	  |)
	       
     'rule' WellFormedType (_, generic (genericinst (Id, _)) -> error) :
	  Id'Pos   -> Pos
	  Id'Ident -> I
	  ErrorI ("'", I, "' is not declared as object type", Pos)
	  
     'rule' WellFormedType (_, Type:generic (constrained (_, Id)) -> Type)
	  CheckId (Id)
	  IsTypeId (Id -> DefType)
	  (|
	       where (DefType -> error)
	  ||
	       where (DefType -> composite (classtype (_, FGenParams, _)))
	  |)
	       
     'rule' WellFormedType (_, generic (constrained (_, Id)) -> error) :
	  Id'Pos   -> Pos
	  Id'Ident -> I
	  ErrorI ("'", I, "' is not declared as object type", Pos) 
     
     'rule' WellFormedType (_, Type -> Type) :

---------------------------------------------------------------------------
	  
'action' WellFormedActGenParams (POS, TYPEINDEXLIST, FPARAMLIST)
     
     'rule' WellFormedActGenParams (_, typeindexlist (TypeI, Tail), error) :
     
     'rule' WellFormedActGenParams (Pos, typeindexlist (ActParam, 
							ActParamTail), 
				    fparamlist (FParam, FParamTail)) :
	  WellFormedActGenParam (ActParam, FParam)
	  WellFormedActGenParams (Pos, ActParamTail, FParamTail)
     
     'rule' WellFormedActGenParams (_, nil, nil) :
     
     'rule' WellFormedActGenParams (Pos, nil, _) :
	  Error ("too few actual generic parameters", Pos)
	   
     'rule' WellFormedActGenParams (Pos, _, nil) :
	  Error ("too many actual generic parameters", Pos)
	  
---------------------------------------------------------------------------

'action' WellFormedActGenParam (TYPEINDEX, FPARAM)

     'rule' WellFormedActGenParam (ActParam, unconstrained (_, _)) :
	  WellFormedTypeIndex (ActParam)
	  ActParam'Pos -> Pos
	  FollowNameChainIndex (ActParam -> Type)
	  (|
	       IsClassType (Type)
	  ||
	       where (Type -> generic (unconstrained (_)))
	  ||
	       where (Type -> generic (constrained (_, _)))
	  ||
	       Error ("object type expected", Pos)
	       ActParam'Type <- error
	  |)
	  
     'rule' WellFormedActGenParam (ActParam, constrained (_, _, CId)) :
	  WellFormedTypeIndex (ActParam)
	  ActParam'Pos -> Pos
	  FollowNameChainIndex (ActParam -> Type)
	  IsTypeId (CId -> ClassType)
	  (| 
	       where (Type -> generic (constrained (_, CId2))) -- @@@ check this
	       IsTypeId (CId2 -> ClassType2)
	       IsSubType (ClassType2, ClassType)
	  ||
	       IsSubType (Type, ClassType)
	  ||
	       CId'Ident -> I
	       ErrorI ("subtype of '", I, 
		       "' expected as actual generic parameter", Pos)
	       ActParam'Type <- error
	  |)
	  
     'rule' WellFormedActGenParam (_, _) : -- in the case of error in
					   -- constrained definition
	  
---------------------------------------------------------------------------
	  
'action' WellFormedTypename (POS, TYPE -> TYPE)
     
     'rule' WellFormedTypename (Pos, Type:composite (typename (Id)) ->
				Type2) :
	  CheckId (Id)
	  FollowNameChain (Type -> DefType)
	  (|
	       where (DefType -> error)
	       let (TYPE'error -> Type2)
	  ||
               where (DefType -> 
		      composite (classtype (_, fparamlist (_, _),_)))
	       Id'Ident -> I
	       ErrorI ("missing instantiation of generic object type '", 
		       I, "'", Pos)
	       let (TYPE'error -> Type2)
	  ||
	       let (Type -> Type2)
	  |)

---------------------------------------------------------------------------

'action' WellFormedEnumerators (List : ENUMERATORLIST)
     
     'rule' WellFormedEnumerators (enumeratorlist (enumerator (_, Id),
						   Tail)) :
	  Id'State -> State
	  (|
	       IsChecked (State)
	  ||
	       DefineMeaning (Id, enumerator)
	       CheckId (Id)
	  |)
	  CheckIdInEnumeratorList (Id, Tail)
	  WellFormedEnumerators (Tail)
	  
     'rule' WellFormedEnumerators (nil) :
	  
---------------------------------------------------------------------------

'action' CheckIdInEnumeratorList (ID, ENUMERATORLIST)
     
     'rule' CheckIdInEnumeratorList 
                (Id1, enumeratorlist (enumerator (_, Id2), Tail)) :
	  (|
	       EqId (Id1, Id2)
	       Id2'Pos   -> Pos
	       Id2'Ident -> I
	       ErrorI ("ambiguous enumerator name '", I, "'", Pos)
	  ||
	       CheckIdInEnumeratorList (Id1, Tail)
	  |)
	  
     'rule' CheckIdInEnumeratorList (_, nil) :
	  
---------------------------------------------------------------------------

'action' WellFormedFields (ToCheck: FIELD, AllFields : FIELD)
     
     'rule' WellFormedFields (seq (Left, Right), Fields) :
	  WellFormedFields (Left, Fields)
	  WellFormedFields (Right, Fields)
	  
     'rule' WellFormedFields (field (Pos, Id, TypeI), Fields) :
	  Id'State -> State
	  (|
	       IsChecked (State)
	  ||
	       DefineMeaning (Id, field (TypeI))
	       CheckId (Id)
	       CheckIdInFieldList (Id, Fields)
	  |)
	  
     'rule' WellFormedFields (Other , Fields) :
	  
---------------------------------------------------------------------------

'action' CheckIdInFieldList (ID, FIELD)
     
     'rule' CheckIdInFieldList (Id, seq (Left, Right)) :
	  CheckIdInFieldList (Id, Left)
	  CheckIdInFieldList (Id, Right)
	  
     'rule' CheckIdInFieldList (Id1, field (_, Id2, _)) :
	  [|
	       Id2'State -> undeclared
	       EqId (Id1, Id2)
	       Id2'Pos   -> Pos
	       Id2'Ident -> I
	       ErrorI ("ambiguous field name '", I, "'", Pos)
	  |]
	  
     'rule' CheckIdInFieldList (_, Other) :
	  
---------------------------------------------------------------------------

'action' WellFormedProcTypeParams (FPARAMLIST)
     
     'rule' WellFormedProcTypeParams (fparamlist (fparam (_, _, _, TypeI),
						  Tail)) :
	  WellFormedOpenTypeIndex (TypeI)
	  
     'rule' WellFormedProcTypeParams (ellipsis (Pos)) :
	  WellFormedEllipsis (Pos)
	  
     'rule' WellFormedProcTypeParams (Other) :
	  
---------------------------------------------------------------------------

'action' WellFormedSuperType (ClassId : ID, SuperType : SUPERTYPE)
     
     'rule' WellFormedSuperType (ClassId , super (SuperId)) :
	  (|
	       GetIdMeaning (SuperId -> error) -- no message in the case of
					       -- error SuperId
	  ||
	       IsEquivClassId (ClassId, SuperId)
	       ClassId'Ident -> I
	       ClassId'Pos   -> Pos
	       ErrorI ("cyclic supertype chain for '", I, "'", Pos)
	  |)
	       
     'rule' WellFormedSuperType (Id, super (SuperId)) :
	  (|
	       GetTypeIdDef (SuperId -> 
			     composite (classtype (_, _, Interface)))
	       Interface'Supertype -> SuperOfSuper
	       WellFormedSuperType (Id, SuperOfSuper)
	  ||
	       SuperId'Ident -> I
	       SuperId'Pos   -> Pos
	       ErrorI ("'", I, "' is not declared as object type", Pos)
	  |)
	  
     'rule' WellFormedSuperType (_, Other) :
	  
---------------------------------------------------------------------------
	  
'action' WellFormedObjParams (ClassId : ID, 
			      SuperType : SUPERTYPE, Params : FPARAMLIST)
     
     'rule' WellFormedObjParams (ClassId, super (SuperId), Params) :
	  ClassId'Pos -> CPos
	  IsTypeId (SuperId -> composite (classtype (_, _, SuperInterface)))
	  SuperInterface'Objparams -> SuperParams
	  WellFormedFParams (Params)
	  CheckEqFParams (CPos, object, SuperParams, Params)
		    
     'rule' WellFormedObjParams (_, _, Params) :
	  WellFormedFParams (Params)

---------------------------------------------------------------------------
	  
'action' WellFormedGenParams (ClassId : ID, 
			      SuperType : SUPERTYPE, Params : FPARAMLIST)
     
     'rule' WellFormedGenParams (ClassId, super (SuperId), GenParams) :
	  ClassId'Pos -> CPos
	  IsTypeId (SuperId -> composite (classtype (_, SuperGenParams, _)))
	  WellFormedFParams (GenParams)
	  CheckEqFParams (CPos, formalGeneric, SuperGenParams, GenParams)
		    
     'rule' WellFormedGenParams (_, _, GenParams) :
	  WellFormedFParams (GenParams)
	  
---------------------------------------------------------------------------
	  
'action' WellFormedDecls (DECL)
     
     'rule' WellFormedDecls (seq (_, Left, Right)) :
	  WellFormedDecls (Left)
	  WellFormedDecls (Right)
	  
     'rule' WellFormedDecls (methodspec (_, Id, _, _, _, _, _)) :
	  CheckId (Id)
	  
     'rule' WellFormedDecls (instvar (_, Id, _)) :
	  CheckId (Id)
	  
     'rule' WellFormedDecls (nil (_)) :
	  
     'rule' WellFormedDecls (error (_)) :
     
---------------------------------------------------------------------------
	  
'action' WellFormedFParams (FPARAMLIST)
     
     'rule' WellFormedFParams (fparamlist (FParam, Tail)) :
	  WellFormedFParam (FParam)
	  WellFormedFParams (Tail)
	  
     'rule' WellFormedFParams (ellipsis (Pos)) :
	  WellFormedEllipsis (Pos)
	  
     'rule' WellFormedFParams (Other) :
	  
---------------------------------------------------------------------------

'action' WellFormedFParam (FPARAM)
     
     'rule' WellFormedFParam (fparam (_, Id, _, _)) :
	  CheckId (Id)
	  
     'rule' WellFormedFParam (unconstrained (_, Id)) :
	  CheckId (Id)
	  
     'rule' WellFormedFParam (constrained (_, Id, _)) :
	  CheckId (Id)
	  
---------------------------------------------------------------------------

'action' WellFormedEllipsis (POS)
     
     'rule' WellFormedEllipsis (Pos) : 
	  [|
	       DeclKind -> coolDecl
	       Error ("invalid use of ellipsis", Pos)
	  |]
---------------------------------------------------------------------------

'condition' ContainsString (TYPE)
     
     'rule' ContainsString (simple (string)) :
	  
     'rule' ContainsString (composite (record (Fields))) :
	  ContainsStringField (Fields)
	  
     'rule' ContainsString (composite (union (Fields))) :
	  ContainsStringField (Fields)
	  
     'rule' ContainsString (composite (array (_, BaseTypeI))) :
	  FollowNameChainIndex (BaseTypeI -> BaseType)
	  ContainsString (BaseType)
     
     'rule' ContainsString (composite (openarray (BaseTypeI))) :
	  FollowNameChainIndex (BaseTypeI -> BaseType)
	  ContainsString (BaseType)
	  
---------------------------------------------------------------------------

'condition' ContainsStringField (FIELD)
     
     'rule' ContainsStringField (seq (Left, _))
	  ContainsStringField (Left)

     'rule' ContainsStringField (seq (_, Right))
	  ContainsStringField (Right)

     'rule' ContainsStringField (field (_, _, FieldTypeI)) :
	  FollowNameChainIndex (FieldTypeI -> FieldType)
	  ContainsString (FieldType)
	  
---------------------------------------------------------------------------

'condition' ContainsFormalGeneric (TYPE)
     
     'rule' ContainsFormalGeneric (generic (unconstrained (_))) :
	  
     'rule' ContainsFormalGeneric (generic (constrained (_, _))) :
	  
     'rule' ContainsFormalGeneric (composite (record (Fields))) :
	  ContainsFormalGenericField (Fields)
	  
     'rule' ContainsFormalGeneric (composite (union (Fields))) :
	  ContainsFormalGenericField (Fields)
	  
     'rule' ContainsFormalGeneric (composite (array (_, BaseTypeI))) :
	  FollowNameChainIndex (BaseTypeI -> BaseType)
	  ContainsFormalGeneric (BaseType)
     
     'rule' ContainsFormalGeneric (composite (openarray (BaseTypeI))) :
	  FollowNameChainIndex (BaseTypeI -> BaseType)
	  ContainsFormalGeneric (BaseType)
	  
---------------------------------------------------------------------------

'condition' ContainsFormalGenericField (FIELD)
     
     'rule' ContainsFormalGenericField (seq (Left, _))
	  ContainsFormalGenericField (Left)

     'rule' ContainsFormalGenericField (seq (_, Right))
	  ContainsFormalGenericField (Right)

     'rule' ContainsFormalGenericField (field (_, _, FieldTypeI)) :
	  FollowNameChainIndex (FieldTypeI -> FieldType)
	  ContainsFormalGeneric (FieldType)
	  
-- ========================================================================
--  Miscellaneous
--  FollowNameChain gets the definition of a named type, otherwise the type
--    is unchanged. 
--  IsTypeId checks whether the given name is defined as type.
--  GetTypeIdDef, same as IsTypeId including an error message.
-- ========================================================================

'action' FollowNameChainIndex (TYPEINDEX -> TYPE)
     
     'rule' FollowNameChainIndex (TypeIndex -> DefType) :
	  TypeIndex'Type -> Type
	  FollowNameChain (Type -> DefType)
	  
---------------------------------------------------------------------------
       
'action' FollowNameChain (TYPE -> TYPE)

     'rule' FollowNameChain (composite (typename (Id)) -> T2) :
	  GetTypeIdDef (Id -> T1)
	  FollowNameChain (T1 -> T2)

     'rule' FollowNameChain (T -> T) :

---------------------------------------------------------------------------

'condition' IsTypeId (ID -> TYPE)
     
     'rule' IsTypeId (Id -> DefType) :
	  GetIdMeaning (Id -> Meaning)
	  (|
	       where (Meaning -> type (DefTypeI))
	       DefTypeI'Type -> DefType
	  ||
	       where (Meaning -> foreigntype (DefTypeI))
	       DefTypeI'Type -> DefType
	  ||
	       where (Meaning -> error)
	       let (TYPE'error -> DefType)
	  |)
	  
---------------------------------------------------------------------------
	  
'action' GetTypeIdDef (ID -> TYPE)
     
     'rule' GetTypeIdDef (Id -> DefType) :
	  GetIdMeaning (Id -> Meaning)
	  (|
	       where (Meaning -> type (DefTypeI))
	       DefTypeI'Type -> DefType
	  ||
	       where (Meaning -> foreigntype (DefTypeI))
	       DefTypeI'Type -> DefType
	  ||
	       where (Meaning -> error)
	       let (TYPE'error -> DefType)
	  ||
	       Id'Pos   -> Pos
	       Id'Ident -> I
	       ErrorI ("'", I, "' is not declared as type", Pos)
	       let (TYPE'error -> DefType)
	  |)

---------------------------------------------------------------------------

'end'
