'module' stmts

'export'
     AnalyseMethodStmts AnalyseProcStmts

'use' ast extspecs misc const decls expr types

-- ========================================================================
--  global variables
-- ========================================================================

'var' ActualResultType : TYPE -- result type of the actual analysed routine
     
'type' LOOPFLAG
     outside
     loop (Hidden : LOOPFLAG)

'var' LoopFlag : LOOPFLAG  -- indicates block inside loop

'type' TRYFLAG
     outside
     try (Hidden : TRYFLAG)

'var' TryFlag : TRYFLAG    -- indicates block inside try

-- ========================================================================
--  Special predicates to initialize all global flags before analysing the
--  statements.
-- ========================================================================

'action' AnalyseMethodStmts (BLOCK, ResultType : TYPE -> BLOCK)
     
     'rule' AnalyseMethodStmts (block (BeginPos, EndPos, S1), Type -> 
				block (BeginPos, EndPos, S2)) :
	  ScopeFlag <- method
	  LoopFlag <- outside
	  TryFlag <- outside
	  ActualResultType <- Type
	  AnalyseStmts (S1 -> S2)
	  
     'rule' AnalyseMethodStmts (Other, _ -> Other) :
	  
---------------------------------------------------------------------------

'action' AnalyseProcStmts (BLOCK, ResultType : TYPE -> BLOCK)
     
     'rule' AnalyseProcStmts (block (BeginPos, EndPos, S1), Type -> 
			      block (BeginPos, EndPos, S2)) :
	  ScopeFlag <- routine
	  LoopFlag <- outside
	  TryFlag <- outside
	  ActualResultType <- Type
	  AnalyseStmts (S1 -> S2)
	  
     'rule' AnalyseProcStmts (Other, _ -> Other) :
	  
-- ========================================================================
--  AnalyseStmts is the main perdicate to analyse a statement block.	  
-- ========================================================================

'action' AnalyseStmts (STMT -> STMT)
     
     'rule' AnalyseStmts (seq (Pos, Left1, Right1) -> 
			  seq (Pos, Left2, Right2)) :
	  AnalyseStmts (Left1 -> Left2)
	  AnalyseStmts (Right1 -> Right2)
	  
     'rule' AnalyseStmts (assign (Pos, _, Dest, Source) -> Stmt) :
	  AnalyseWritableDesig (Dest -> DestTypeI, DestDesig)
	  FollowNameChainIndex (DestTypeI -> DestType2)
	  AnalyseExpr (Source -> SourceType, SourceExpr)
	  FollowNameChain (SourceType -> SourceType2)
	  (|
	       where (DestType2 -> composite (openarray (_)))
	       Error ("open array cannot be target of assignment", Pos)
	       let (STMT'error (Pos) -> Stmt)
	  ||
	       -- assignment of stringliteral to array of char
	       -- arraysize := Upb - Lwb + 1 
	       -- stringlength := length (stringliteral) + 1 (additional \0)
	       -- error if stringlength < arraysize 
	       where (DestType2 -> composite (array (range (_, Lwb, Upb), 
						     BaseTypeI)))
	       FollowNameChainIndex (BaseTypeI -> simple (char))
	       where (SourceExpr -> stringliteral (_, String))
	       UnspecTypeIndex -> TypeI
	       EvalConstant (dyop (Pos, TypeI, minus, Upb, Lwb) -> 
			     _, posintliteral (_, Size))
	       StringLength (String -> Length)
	       gt (Length, Size)
	       Error ("string literal length exceeds array size", Pos)
	       let (STMT'error (Pos) -> Stmt)
	  ||
	       IsAssignmentCompatible (SourceType2, DestType2)
	       let (assign (Pos, DestTypeI, DestDesig, SourceExpr) -> Stmt)
	  ||
	       Error ("types are not assignment compatible", Pos)
	       let (STMT'error (Pos) -> Stmt)
	  |)
	  
     'rule' AnalyseStmts (stmtcall (Pos, Call) -> stmtcall (Pos, Call2)) :
	  AnalyseExpr (Call -> Type, Call2)
	  FollowNameChain (Type -> Type2)
	  (|
	       where (Type2 -> simple (void))
	  ||
	       IsErrorType (Type2)
	  ||
	       Error ("call must not return a value", Pos)
	  |)
	  
     'rule' AnalyseStmts (Stmt:return (Pos) -> Stmt) :
	  ActualResultType -> ResultType
	  FollowNameChain (ResultType -> ResultType2)
	  (|
	       where (ResultType2 -> simple (void))
	  ||
	       IsErrorType (ResultType2)
	  ||
	       Error ("RETURN must provide value", Pos)
	  |)
 
	  
     'rule' AnalyseStmts (returnvalue (Pos, Expr) -> 
			  returnvalue (Pos, Expr2)) :
	  AnalyseExpr (Expr -> ExprType, Expr2)
	  FollowNameChain (ExprType -> ExprType2)
	  ActualResultType -> ResultType
	  FollowNameChain (ResultType -> ResultType2)
	  (|
	       where (ResultType -> simple (void))
	       Error ("invalid result", Pos)
	  ||
	       IsReturnValueCompatible (ExprType2, ResultType2)
	  ||
	       Error ("value is not compatible with result type", Pos)
	  |)
     
     'rule' AnalyseStmts (ifelse (Pos, Cond, Then, Else) ->
			  ifelse (Pos, Cond2, Then2, Else2)) :
	  AnalyseExpr (Cond -> CondType, Cond2)
	  Cond'Pos -> CondPos
	  CheckBoolType (CondPos, CondType -> _)
	  AnalyseStmts (Then -> Then2)
	  AnalyseStmts (Else -> Else2)
     
     'rule' AnalyseStmts (select (Pos, Selector, Cases, Otherwise) -> 
			  select (Pos, Selector2, Cases2, Otherwise2)) :
	  AnalyseExpr (Selector -> SelectorType, Selector2)
	  Selector'Pos -> SelectorPos
	  CheckSelectorType (SelectorPos, SelectorType -> SelectorType2)
	  AnalyseCases (Cases, SelectorType2 -> Cases2, Labels)
	  CheckUniqueLabels (Labels)
	  AnalyseStmts (Otherwise -> Otherwise2)
	  
     'rule' AnalyseStmts (typeselect (Pos, I:implicitvar (_, Id), Init, 
				      TypeCases, Otherwise) -> 
			  typeselect (Pos, I, Init2, 
				      TypeCases2, Otherwise2)) :
	  AnalyseExpr (Init -> InitType, Init2)
	  Init'Pos -> InitPos
	  CheckClassType (InitPos, InitType -> InitType2)
	  AnalyseTypeCases (TypeCases, InitType2, Id -> TypeCases2, IdList)
	  CheckUniqueTypes (IdList)
	  NewTypeIndex (InitPos, InitType2 -> TypeI)
	  Id'Meaning <- implicitvar (TypeI)
	  AnalyseStmts (Otherwise -> Otherwise2)
	  
     'rule' AnalyseStmts (loop (Pos, Body) -> loop (Pos, Body2)) :
	  AnalyseLoopBody (Body -> Body2)
	  
     'rule' AnalyseStmts (while (Pos, Cond, Body) -> 
			  while (Pos, Cond2, Body2)) :
	  AnalyseExpr (Cond -> CondType, Cond2)
	  Cond'Pos -> CondPos
	  CheckBoolType (CondPos, CondType -> _)
	  AnalyseLoopBody (Body -> Body2)
	  
     'rule' AnalyseStmts (for (Pos, ImplicitVar:implicitvar (IPos, Id), 
			       range (RPos, Lwb, Upb), Step, Body) -> 
			  for (Pos, ImplicitVar, range (RPos, Lwb2, Upb2),
			       Step2, Body2)) :
	  NewTypeIndex (IPos, simple (int) -> TypeI)
	  Id'Meaning <- implicitvar (TypeI)
	  AnalyseExpr (Lwb -> LwbType, Lwb2)
	  Lwb'Pos -> LwbPos
	  CheckIntegerType (LwbPos, LwbType -> _)
	  AnalyseExpr (Upb -> UpbType, Upb2)
	  Upb'Pos -> UpbPos
	  CheckIntegerType (UpbPos, UpbType -> _)
	  AnalyseStep (Step -> Step2)
	  AnalyseLoopBody (Body -> Body2)
	  
     'rule' AnalyseStmts (Stmt:exit (Pos) -> Stmt) :
	  [|
	       LoopFlag -> outside
	       Error ("EXIT outside LOOP", Pos)
	  |]
	  
     'rule' AnalyseStmts (raise (Pos, Id, AParams) -> Stmt) :
	  CheckId (Id)
	  GetIdMeaning (Id -> Meaning)
	  (|
	       where (Meaning -> exception (FParams))
	       AnalyseAParams (Pos, AParams, FParams -> AParams2)
	       let (raise (Pos, Id, AParams2) -> Stmt)
	  ||
	       where (Meaning -> error)
	       let (STMT'error (Pos) -> Stmt)
	  ||
	       Id'Pos -> IPos
	       Id'Ident -> I
	       ErrorI ("", I, " is not declared as exception", IPos)
	       let (STMT'error (Pos) -> Stmt)
	  |)
		      
     'rule' AnalyseStmts (try (Pos, Body, Handlers, Otherwise) -> 
			  try (Pos, Body2, Handlers2, Otherwise2)) :
	  AnalyseStmts (Body -> Body2)
	  TryFlag -> Hidden
	  TryFlag <- try (Hidden)
	  AnalyseHandlers (Handlers -> Handlers2, Exceptions)
	  CheckUniqueExceptions (Exceptions)
	  AnalyseStmts (Otherwise -> Otherwise2)
	  TryFlag <- Hidden
	  
     'rule' AnalyseStmts (Stmt:retry (Pos) -> Stmt) :
	  [|
	       TryFlag -> outside
	       Error ("RETRY outside TRY", Pos)
	  |]
	  
     'rule' AnalyseStmts (Stmt:reraise (Pos) -> Stmt) :
	  [|
	       TryFlag -> outside
	       Error ("RERAISE outside TRY", Pos)
	  |]
	  
     'rule' AnalyseStmts (delete (Pos, Expr) -> delete (Pos, Object)) :
	  AnalyseExpr (Expr -> Type, Object)
	  Expr'Pos -> ExprPos
	  CheckClassType (ExprPos, Type -> _)
	  
     'rule' AnalyseStmts (Stmt:nil (Pos) -> Stmt) :
	  
     'rule' AnalyseStmts (Stmt:error (Pos) -> Stmt) :
	  
-- ========================================================================
--  Special predicates to analyse LOOP statements.
--  AnalyseLoopBody initializes the global flag LoopFlag to indicate that
--    the following statement block is inside a loop.
--  AnalyseStep analyses the value given after STEP to be a valid integer.
-- ========================================================================

'action' AnalyseLoopBody (BLOCK -> BLOCK)
	  
     'rule' AnalyseLoopBody (block (BeginPos, EndPos, Body) -> 
			     block (BeginPos, EndPos, Body2)) :
	  LoopFlag -> Hidden
	  LoopFlag <- loop (Hidden)
	  AnalyseStmts (Body -> Body2)
	  LoopFlag <- Hidden
	  
     'rule' AnalyseLoopBody (Other -> Other) :
	  
---------------------------------------------------------------------------

'action' AnalyseStep (STEP -> STEP)
     
     'rule' AnalyseStep (incr (Value) -> incr (Value2)) :
	  AnalyseExpr (Value -> Type, Value2)
	  Value'Pos -> ValuePos
	  CheckIntegerType (ValuePos, Type -> _)
	  
     'rule' AnalyseStep (decr (Value) -> decr (Value2)) :
	  AnalyseExpr (Value -> Type, Value2)
	  Value'Pos -> ValuePos
	  CheckIntegerType (ValuePos, Type -> _)
	  
-- ========================================================================
--  Special predicates to analyse the SELECT statement.
--  CheckSelectorType analyses the type of the selector expression to be
--    interger type ([UNSIGNED] [LONG | SHORT] INT), BOOL, CHAR or an
--    enumeration type. 
--  AnalyseCases and AnalyseLabel(s) check each label to be a valid value of
--    the selector type. 
--  AnalyseRangeLabel checks whether the given range denotes a positive
--    number of values.
--  CheckUniqueLabels checks whether a label occures multiple times insside
--    the select statement.
-- ========================================================================

'action' CheckSelectorType (POS, TYPE -> TYPE)
	  
     'rule' CheckSelectorType (_, T -> TDef) :
	  FollowNameChain (T -> TDef)
	  IsCaseSelectorType (TDef)
	  
     'rule' CheckSelectorType (Pos, _ -> error) :
	  Error ("invalid type of selector", Pos)
	  
---------------------------------------------------------------------------

'condition' IsCaseSelectorType (TYPE)

     'rule' IsCaseSelectorType (simple (bool)) :
     'rule' IsCaseSelectorType (T) :
	  IsIntegerType (T)
	  
     'rule' IsCaseSelectorType (simple (char)) :
	  
     'rule' IsCaseSelectorType (composite (enum (_))) :
	  
---------------------------------------------------------------------------

'action' AnalyseCases (CASE, SelectorType : TYPE -> CASE, Labels : EXPRLIST)
     
     'rule' AnalyseCases (seq (Left, Right), SelectorType -> 
			  seq (Left2, Right2), Labels) :
	  AnalyseCases (Left, SelectorType -> Left2, LLabels)
	  AnalyseCases (Right, SelectorType -> Right2, RLabels)
	  ConcatLabels (LLabels, RLabels -> Labels)
	  
     'rule' AnalyseCases (case (Pos, Labels, Body), SelectorType ->
			  case (Pos, Labels2, Body2), Labels2) :
	  AnalyseLabels (Labels, SelectorType -> Labels2)
	  AnalyseStmts (Body -> Body2)
	  
     'rule' AnalyseCases (nil, _ -> nil, nil) :
	  
---------------------------------------------------------------------------

'action' AnalyseLabels (EXPRLIST, SelectorType : TYPE  -> EXPRLIST)

     'rule' AnalyseLabels (exprlist (Expr, Tail), SelectorType ->
			   exprlist (Expr2, Tail2)) :
	  AnalyseLabel (Expr, SelectorType -> Expr2)
	  AnalyseLabels (Tail, SelectorType -> Tail2)
	  
     'rule' AnalyseLabels (Other, _ -> Other) :
	  
---------------------------------------------------------------------------

'action' AnalyseLabel (EXPR, SelectorType : TYPE -> EXPR)
     
     'rule' AnalyseLabel (range (Pos, Lwb, Upb), SelectorType -> Range) :
	  AnalyseLabel (Lwb, SelectorType -> Lwb2)
	  AnalyseLabel (Upb, SelectorType -> Upb2)
	  AnalyseRangeLabel (Pos, Lwb2, Upb2 -> Range)
	  
     'rule' AnalyseLabel (Expr, SelectorType -> Expr2) :
	  EvalConstant (Expr -> ExprType, Expr2)
	  (|
	       IsEquivType (SelectorType, ExprType)
	  ||
	       IsConstTypeCompatible (ExprType, SelectorType)
	  ||
	       IsConstTypeCompatible (SelectorType, ExprType)
	  |)
     
     'rule' AnalyseLabel (Expr, SelectorType -> error (Pos)) :
	  Expr'Pos -> Pos
	  Error ("value is not compatible to selector type", Pos)

---------------------------------------------------------------------------

'action' AnalyseRangeLabel (POS, EXPR, EXPR -> EXPR)
     
     'rule' AnalyseRangeLabel (Pos, error (_), _ -> error (Pos)) :
     
     'rule' AnalyseRangeLabel (Pos, _, error (_) -> error (Pos)) :
	  
     'rule' AnalyseRangeLabel (Pos, Lwb, Upb -> range (Pos, Lwb, Upb)) :
	  UnspecTypeIndex -> TypeI
	  EvalConstant (dyop (Pos, TypeI, le, Lwb, Upb) -> _, true (_))
	  
     'rule' AnalyseRangeLabel (Pos, _, _ -> error (Pos)) :
	  Error ("invalid range", Pos)
	  
---------------------------------------------------------------------------

'action' ConcatLabels (EXPRLIST, EXPRLIST -> EXPRLIST)
     
     'rule' ConcatLabels (exprlist (Head, Tail), List -> 
			  exprlist (Head, Tail2)) :
	  ConcatLabels (Tail, List -> Tail2)
	  
     'rule' ConcatLabels (_, List -> List) :
	  
---------------------------------------------------------------------------

'action' CheckUniqueLabels (EXPRLIST)
     
     'rule' CheckUniqueLabels (exprlist (ConstExpr, Tail)) :
	  CheckConstantInList (ConstExpr, Tail)
	  CheckUniqueLabels (Tail)
	  
     'rule' CheckUniqueLabels (_) :
	  
---------------------------------------------------------------------------

-- This predicate has a different implementation than CheckTypenameInList
-- and CheckExceptionNameInList, because of the label ranges. 
-- IsEqualLabel is not transitive : 
--   IsEqualLabel ((1 .. 3), (2 .. 4)) and 
--   IsEqualLabel ((2 .. 4), 4) but  
--   IsEqualLabel ((1 .. 3), 4) does not hold.	  
-- Each label has to be compared with any other label and multiple error
-- messages at the same position have to be skipped.	  
	  
'action' CheckConstantInList (EXPR, EXPRLIST)
     
     'rule' CheckConstantInList (Expr, exprlist (Expr2, Tail)) :
	  [|
	       IsEqualLabel (Expr, Expr2 -> true (_))
	       Expr2'Pos -> Pos
	       Error ("multiple occurence of case value", Pos)
	  |]
	  CheckConstantInList (Expr, Tail)
	  
     'rule' CheckConstantInList (_, _) :
	  
---------------------------------------------------------------------------

'action' IsEqualLabel (EXPR, EXPR -> EXPR)
     
     'rule' IsEqualLabel (range (Pos, Lwb1, Upb1), 
			  range (_, Lwb2, Upb2) -> true (Pos))
	  UnspecTypeIndex -> T
	  EvalConstant (dyop (Pos, T, le, Lwb1, Lwb2) -> _, LwbCompare)
	  (|
	       where (LwbCompare -> true (_))
	       EvalConstant (dyop (Pos, T, le, Lwb2, Upb1) -> _, true (_))
	  ||
	       where (LwbCompare -> false (_))
	       EvalConstant (dyop (Pos, T, le, Lwb1, Upb2) -> _, true (_))
	  |)
		      
     'rule' IsEqualLabel (range (Pos, _, _), range (_, _, _) -> false (Pos)) :
	  
     'rule' IsEqualLabel (range (Pos, Lwb, Upb), Const -> true (Pos)) :
	  UnspecTypeIndex -> TypeI
	  EvalConstant (dyop (Pos, TypeI, le, Lwb, Const) -> _, true (_))
	  EvalConstant (dyop (Pos, TypeI, le, Const, Upb) -> _, true (_))
     
     'rule' IsEqualLabel (range (Pos, _, _), Const -> false (Pos)) :
	  
     'rule' IsEqualLabel (Const, Range:range (_, _, _) -> Res) :
	  IsEqualLabel (Range, Const -> Res)
	  
     'rule' IsEqualLabel (Const1, Const2 -> Res) :
	  UnspecTypeIndex -> TypeI
	  Const1'Pos -> Pos
	  EvalConstant (dyop (Pos, TypeI, eq, Const1, Const2) -> _, Res)
	  
-- ========================================================================
--  Special predicates to analyse the TYPESELECT statement.
--  AnalyseTypeCases checks the given Identifier to be declred as an object
--    type which has to be a subtype of the selector type.
--  CheckUniqueTypes checks whether a type ocuures multiple times inside the
--    typeselect statement.
-- ========================================================================

'action' AnalyseTypeCases (TYPECASE, SelectorType : TYPE, 
			   Implicitvar : ID -> TYPECASE, IDLIST)

     'rule' AnalyseTypeCases (seq (Left1, Right1), SelectorType, Id -> 
			      seq (Left2, Right2), IdList) :
	  AnalyseTypeCases (Left1, SelectorType, Id -> Left2, LIdList)
	  AnalyseTypeCases (Right1, SelectorType, Id -> Right2, RIdList)
	  ConcatIdList (LIdList, RIdList -> IdList)
	  
     'rule' AnalyseTypeCases (typecase (Pos, TId, Body), SelectorType, 
			      ImplicitId -> 
			      typecase (Pos, TId, Body2), idlist (TId, nil)) :
	  CheckId (TId)
	  TId'Pos -> TPos
	  GetIdMeaning (TId -> Meaning)
	  (|
	       where (Meaning -> error)
	       let (TYPE'error -> Type)
	  ||
	       where (Meaning -> type (BaseI))
	       FollowNameChainIndex (BaseI -> TDef)
	       IsClassType (TDef)
	       (|
		    IsSubType (TDef, SelectorType)
		    let (composite (typename (TId)) -> Type)
	       ||
		    Error ("type must be subtype of selector type", TPos)
		    let (TYPE'error -> Type)
	       |)
	  ||
	       TId'Ident -> I
	       ErrorI ("'", I, "' is not declared as object type", TPos)
	       let (TYPE'error -> Type)
	  |)
	  NewTypeIndex (TPos, Type -> TypeI)
	  ImplicitId'Meaning <- implicitvar (TypeI)
	  AnalyseStmts (Body -> Body2)
	  
     'rule' AnalyseTypeCases (nil, _, _ -> nil, nil) :
	  
---------------------------------------------------------------------------

'action' CheckUniqueTypes (IDLIST)
	  
     'rule' CheckUniqueTypes (idlist (Id, Tail)) :
	  CheckTypeNameInList (Id, Tail)
	  CheckUniqueTypes (Tail)
	  
     'rule' CheckUniqueTypes (nil) :

---------------------------------------------------------------------------

'action' CheckTypeNameInList (ID, IDLIST)
     
     'rule' CheckTypeNameInList (Id1, idlist (Id2, Tail)) :
	  (|
	       EqQualifiedId (Id1, Id2)
	       Id2'Pos -> Pos
	       Id2'Ident -> I
	       ErrorI ("multiple occurence of type '", I, "'", Pos) 
	  ||
	       CheckTypeNameInList (Id1, Tail)
	  |)
	  
     'rule' CheckTypeNameInList (_, _) :
	  
-- ========================================================================
--  Special predicates to analyse the TRY statement.
--  AnalyseHandlers checks the given identifiers to be declared as exception
--    and the given parameters to be equal to the exception declaration.
--  CheckUniqueExceptions checks whether an exception occurs multiple times
--    inside the TRY statement.
-- ========================================================================

'action' AnalyseHandlers (HANDLER -> HANDLER, IDLIST)
     
     'rule' AnalyseHandlers (seq (Left, Right) -> 
			     seq (Left2, Right2), IdList)
	  AnalyseHandlers (Left -> Left2, LIdList)
	  AnalyseHandlers (Right -> Right2, RIdList)
	  ConcatIdList (LIdList, RIdList -> IdList)
	  
     'rule' AnalyseHandlers (handler (Pos, EId, Params, Body) -> 
			     handler (Pos, EId, Params, Body2), 
			     idlist (EId, nil)) :
	  CheckId (EId)
	  GetIdMeaning (EId -> Meaning)
	  (|
	       where (Meaning -> error)
	  ||
	       where (Meaning -> exception (FParams))
	       CheckEqFParams (Pos, exception, FParams, Params)
	  ||
	       EId'Pos -> EPos
	       EId'Ident -> I
	       ErrorI ("'", I, "' not defined as exception", EPos)
	  |)
	  AnalyseStmts (Body -> Body2)
	  
     'rule' AnalyseHandlers (nil -> nil, nil) :
	  
---------------------------------------------------------------------------

'action' CheckUniqueExceptions (IDLIST)
	  
     'rule' CheckUniqueExceptions (idlist (Id, Tail)) :
	  CheckExceptionNameInList (Id, Tail)
	  CheckUniqueExceptions (Tail)
	  
     'rule' CheckUniqueExceptions (nil) :

---------------------------------------------------------------------------

'action' CheckExceptionNameInList (ID, IDLIST)
     
     'rule' CheckExceptionNameInList (Id1, idlist (Id2, Tail)) :
	  (|
	       EqQualifiedId (Id1, Id2)
	       Id2'Pos -> Pos
	       Id2'Ident -> I
	       ErrorI ("multiple occurence of exception '", I, "'", Pos) 
	  ||
	       CheckExceptionNameInList (Id1, Tail)
	  |)
	  
     'rule' CheckExceptionNameInList (_, _) :
	
---------------------------------------------------------------------------

'end'
