/***************************************************************************/
/*                  CooL-V2.0 - destination code interface                 */
/*-------------------------------------------------------------------------*/
/*                coding utilities routines, C implementation              */
/*                            Version 1.0, 1993                            */
/***************************************************************************/

# include <stdio.h>
# include <string.h>
# include <stdlib.h>
# include "output.h"
# include "pos.h"
# include "files.h"

FILE *DestinationFile;
FILE *MAXInterfaceFile;

int CLineNumber = 0;

/*---- GetIntergerValue ---------------------------------------------------*/

void GetIntegerValue( long Char, long *Int )
{
    *Int = Char;
}

/*---- Write --------------------------------------------------------------*/

void Write( char *String )
{
    fprintf( DestinationFile, "%s", String );
}

/*---- WriteInt -----------------------------------------------------------*/

void WriteInt( long IntNumber )
{
    fprintf( DestinationFile, "%ld", IntNumber );
}

/*---- WriteUnsignedInt ---------------------------------------------------*/

void WriteUnsignedInt( long IntNumber )
{
    if (IntNumber < 0) 
      fprintf( DestinationFile, "%luU", IntNumber );
    else
      fprintf( DestinationFile, "%lu", IntNumber );
}

/*---- WriteDouble --------------------------------------------------------*/

void WriteDouble( double *Double )
{
    fprintf( DestinationFile, "%.20E", *Double );
}

/*---- WriteChar ----------------------------------------------------------*/

void WriteChar( char Character )
{
    fprintf( DestinationFile, "\'\\%o\'", Character );
}

/*---- WriteString --------------------------------------------------------*/

void WriteString( char *String )
{
    fprintf( DestinationFile, "\"%s\"", String );
}

/*---- Writeln ------------------------------------------------------------*/

void Writeln( char *String )
{
    fprintf( DestinationFile, "%s\n", String );
    CLineNumber++;
}

/*--------------------------------------------------------------------*/
/* Output files */
/*--------------------------------------------------------------------*/

void OpenSpecificationFile (void)
{
  DestinationFile = OpenOutputFile (HEADER_SUFFIX);
}

/*--------------------------------------------------------------------*/

void CloseSpecificationFile (void)
{
  fclose( DestinationFile );
}

/*--------------------------------------------------------------------*/

void OpenImplementationFile (void)
{
  DestinationFile = OpenOutputFile (DEST_SUFFIX);
  if (IsDebugMode() ) {
    CLineNumber = 1;
    MAXInterfaceFile = OpenOutputFile( MAX_SUFFIX );
  }
}

/*--------------------------------------------------------------------*/

void CloseImplementationFile (void)
{
  fclose( DestinationFile );
  if (IsDebugMode()) {
    fclose( MAXInterfaceFile );
  }
}

/*--------------------------------------------------------------------*/
/* Max info */
/*--------------------------------------------------------------------*/

/*---- PrintMAXLineInfo ---------------------------------------------------*/

FileId * lastFileId = 0;

void PrintMAXLineInfo( long pos )
{
    long line, column;
    FileId * file;

    if ( ( IsDebugMode() ) && ( pos != DEFAULTPOS ) ) {
        yyDecryptPos( pos, &line, &column, &file );
        fprintf( MAXInterfaceFile, "%d:%d:", CLineNumber, line);
	fprintf( DestinationFile, "/* %d:%d:", CLineNumber, line);
	if (file != lastFileId) {
	    lastFileId = file;
	    fprintFileId( MAXInterfaceFile, file );
	    fprintFileId( DestinationFile, file );
	}
	fprintf( MAXInterfaceFile, "\n" );
	fprintf( DestinationFile, " */ " );
    }
}
