#include <stdio.h>
#include <stdlib.h>
#include "files.h"
#include "errmsg.h"
#include "output.h"

#ifdef YYDEBUG
extern int yydebug;
#endif /* defined YYDEBUG */

extern char * release (void); /* version string */

/*--------------------------------------------------------------------*/
/* aux functions handling options */
/*--------------------------------------------------------------------*/

/* undocumented test feature : printing ast */
/* 0 = no printing, 1 = printing syntax tree, 2 = printing context tree */

int printMode = 0;

int IsPrintSyntaxMode (void)
{
  return (printMode == 1);
}

int IsPrintContextMode (void)
{
  return (printMode == 2);
}

/*--------------------------------------------------------------------*/

int analyseMode = 0;

int IsAnalyseMode (void)
{
  return (analyseMode == 1);
}

/*--------------------------------------------------------------------*/

int debugMode = 0;

int IsDebugMode (void)
{
  return (debugMode == 1);
}

/*--------------------------------------------------------------------*/

int printDependenciesMode = 0;

int IsPrintDependenciesMode (void)
{
  return (printDependenciesMode == 1);
}

/*--------------------------------------------------------------------*/
/* system dependencies  */
/*--------------------------------------------------------------------*/

int IsWindowsNT (void)
{
#ifdef s_win_nt
  return 1;
#else
  return 0;
#endif /* defined s_win_nt */
}

/*--------------------------------------------------------------------*/
/* main  */
/*--------------------------------------------------------------------*/

int main (int argc, char **argv)

{
  int n;
  char msg[200];
  int source_defined = 0;
  char * filename;
  
  /* INITIALIZE */
  
  InitFiles ();
  
  /* argument parsing */

  n = 1;
  while (n < argc) {
    if (argv[n][0] == '-') { /* possible option */
      switch (argv[n][1]) {
#ifdef YYDEBUG
      case 'Y' :             /* undocumented test feature */
	if (strcmp (&argv[n][2], "ACC") == 0) {
	  yydebug = 1;
	}
	else {
	  sprintf(msg,"invalid argument: '%s'", argv[n]);
	  ErrorUsage (msg);
	}
	n++;
	break;
#endif /* defined YYDEBUG */
      case 'N' :             /* undocumented test feature */
	if (strcmp (&argv[n][2], "OSORT") == 0) {
	  nosort = 1;
	}
	else {
	  sprintf(msg,"invalid argument: '%s'", argv[n]);
	  ErrorUsage (msg);
	}
	n++;
	break;
      case 'P' :            /* undocumented test feature */
	if (strcmp (&argv[n][2], "SYN") == 0) {
	  printMode = 1;
	}
	else if (strcmp (&argv[n][2], "CON") == 0) {
	  printMode = 2;
	}
	else {
	  sprintf(msg,"invalid argument: '%s'", argv[n]);
	  ErrorUsage (msg);
	}
	n++;
	break;
      case 'V' :  
	if (argv[n][2] != '\0') {
	  sprintf(msg,"invalid argument: '%s'", argv[n]);
	  ErrorUsage (msg);
	}
	fprintf(stderr,"%s\n", release ());
	n++;
	break;
      case 'g' :
	if (argv[n][2] != '\0') {
	  sprintf(msg,"invalid argument: '%s'", argv[n]);
	  ErrorUsage (msg);
	}
	debugMode = 1;
	n++;
	break;
      case 'd' :
	if (argv[n][2] == '\0') {
	  n++;
	  if (n == argc || argv[n][0] == '-') {
	    ErrorUsage ("no argument for -d");
	  }
	  InsertDir (argv[n]);
	}
	else {
	  InsertDir (&argv[n][2]);
	}
	n++;
	break;
      case 'a' :
	if (argv[n][2] != '\0') {
	  sprintf(msg,"invalid argument: '%s'", argv[n]);
	  ErrorUsage (msg);
	}
	analyseMode = 1;
	n++;
	break;
      case 'M' :
	if (argv[n][2] != '\0') {
	  sprintf(msg,"invalid argument: '%s'", argv[n]);
	  ErrorUsage (msg);
	}
	printDependenciesMode = 1;
	n++;
	break;
      default :
	sprintf(msg,"invalid argument: '%s'", argv[n]);
	ErrorUsage (msg);
	break;
      }
    }
    else {                   /* source files */
      if (source_defined) {
	sprintf(msg,"multiple source files ('%s') not allowed", argv[n]);
	ErrorUsage(msg);
      }
      source_defined = 1;
      filename = argv [n];
      n++;
    }
  }
  if (! source_defined) {
    ErrorUsage ("missing source file");
  }

  OpenFile (filename);
  
  /* INVOKE GENERATED PROGRAM */
  
  ROOT();
  
  /* FINALIZE */
  
  exit(0);
}
