
'module' extspecs

'export'
-- Simple external types
     DOUBLE CHAR 
-- Module: idents
     Ident string_to_id id_to_string 
     DefMeaning UndefMeaning HasMeaning 
     DefModuleMeaning UndefModuleMeaning HasModuleMeaning 
-- Module: files
     InsertImportFile PrintDependencies 
     CheckSpecModuleName CheckImplModuleName
-- Module: lexfunc
     SkipRestOfFile
-- Module: errmsg
     Warning WarningI Error ErrorI 
     CheckErrorMessages FlushMessages 
     Fatal
-- Module pos
     DefaultPos
-- Module arith
     IsLessInt IsEqualInt ModInt
     IsLessDouble IsEqualDouble IsZeroDouble IsNegativeDouble
     NegateDouble PlusDouble MinusDouble TimesDouble DivDouble
     IntToDouble DoubleToInt
     IsLessChar IsEqualChar 
     IsLessString IsEqualString
     PlusStringString PlusStringChar PlusCharString PlusCharChar
     StringLength
-- Module: main (options)
     IsPrintSyntaxMode IsPrintContextMode IsAnalyseMode 
     IsPrintDependenciesMode
     IsWindowsNT
-- Module: output     
     GetIntegerValue
     Write
     WriteInt
     WriteUnsignedInt
     WriteDouble
     WriteChar
     WriteString
     Writeln
     OpenSpecificationFile
     CloseSpecificationFile
     OpenImplementationFile
     CloseImplementationFile
     PrintMAXLineInfo
     
'use' ast

-------------------------------------------------------------------------------
-- Simple external types
-------------------------------------------------------------------------------

'type' DOUBLE
'type' CHAR

-------------------------------------------------------------------------------
-- Module: idents
-------------------------------------------------------------------------------

'type' Ident

'action' string_to_id (STRING -> Ident)
'action' id_to_string (Ident -> STRING)
'action' DefMeaning (Ident, MEANING)
'action' UndefMeaning (Ident)
'condition' HasMeaning (Ident -> MEANING)
'action' DefModuleMeaning (Ident, DECL)
'action' UndefModuleMeaning (Ident)
'condition' HasModuleMeaning (Ident -> DECL)

-------------------------------------------------------------------------------
-- Module: files
-------------------------------------------------------------------------------

'action' InsertImportFile (Ident)
'action' PrintDependencies
'action' CheckSpecModuleName (POS, Ident)
'action' CheckImplModuleName (POS, Ident)

-------------------------------------------------------------------------------
-- Module: lexfunc
-------------------------------------------------------------------------------

'action' SkipRestOfFile

-------------------------------------------------------------------------------
-- Module: errmsg
-------------------------------------------------------------------------------

'action' Warning (STRING, POS)
'action' WarningI (STRING, Ident, STRING, POS)
'action' Error (STRING, POS)
'action' ErrorI (STRING, Ident, STRING, POS)
'action' CheckErrorMessages
'action' FlushMessages
'action' Fatal (STRING)

-------------------------------------------------------------------------------
-- Module: pos
-------------------------------------------------------------------------------

'action' DefaultPos (-> POS)

-------------------------------------------------------------------------------
-- Module: arith
-------------------------------------------------------------------------------

'condition' IsLessInt (INT, INT)
'condition' IsEqualInt (INT, INT)
'action' ModInt (INT, INT -> INT)
'condition' IsLessDouble (DOUBLE, DOUBLE)
'condition' IsEqualDouble (DOUBLE, DOUBLE)
'condition' IsZeroDouble (DOUBLE)
'condition' IsNegativeDouble (DOUBLE)
'action' NegateDouble (DOUBLE -> DOUBLE)
'action' PlusDouble (DOUBLE, DOUBLE -> DOUBLE)
'action' MinusDouble (DOUBLE, DOUBLE -> DOUBLE)
'action' TimesDouble (DOUBLE, DOUBLE -> DOUBLE)
'action' DivDouble (DOUBLE, DOUBLE -> DOUBLE)
'action' IntToDouble (INT -> DOUBLE)
'action' DoubleToInt (DOUBLE -> INT)
'condition' IsLessChar (CHAR, CHAR)
'condition' IsEqualChar (CHAR, CHAR)
'condition' IsLessString (STRING, STRING)
'condition' IsEqualString (STRING, STRING)
'action' PlusStringString (STRING, STRING -> STRING)
'action' PlusStringChar (STRING, CHAR -> STRING)
'action' PlusCharString (CHAR, STRING -> STRING)
'action' PlusCharChar (CHAR, CHAR -> STRING)
'action' StringLength (STRING -> INT)

-------------------------------------------------------------------------------
-- Module: main
-------------------------------------------------------------------------------

'condition' IsPrintSyntaxMode
'condition' IsPrintContextMode
'condition' IsAnalyseMode
'condition' IsPrintDependenciesMode
'condition' IsWindowsNT

-----------------------------------------------------------------------------
-- Module: output
-----------------------------------------------------------------------------

'action' GetIntegerValue (CHAR -> INT)
'action' Write (STRING)
'action' WriteInt (INT)
'action' WriteUnsignedInt (INT)
'action' WriteDouble (DOUBLE)
'action' WriteChar (CHAR)
'action' WriteString (STRING)
'action' Writeln (STRING)
'action' OpenSpecificationFile
'action' CloseSpecificationFile
'action' OpenImplementationFile
'action' CloseImplementationFile
'action' PrintMAXLineInfo (POS)

-------------------------------------------------------------------------------

'end'
