'module' expr

'export'
     AnalyseExpr
     AnalyseDesig AnalyseWritableDesig
     AnalyseAParams
     ScopeFlag ROUTINESCOPE 

'use' ast extspecs misc const decls types

-- ========================================================================
--  global variables
-- ========================================================================

'var' ScopeFlag : ROUTINESCOPE -- indicates scope:
                               -- method : inside a method of an object type
			       -- routine : inside a procedure or function

'type' ROUTINESCOPE
     routine
     method

-- ========================================================================
--  Main predicate of expression analyse.
-- ========================================================================

'action' AnalyseExpr (EXPR -> TYPE, EXPR)
     
     'rule' AnalyseExpr (C:false (_) -> simple (bool), C) :
     'rule' AnalyseExpr (C:true (_) -> simple (bool), C) :
     'rule' AnalyseExpr (C:posintliteral (_, _) ->
			 simple (intliteraltype), C) :
     'rule' AnalyseExpr (C:negintliteral (_, _) -> 
			 simple (intliteraltype), C) :
     'rule' AnalyseExpr (C:doubleliteral (_, _) -> 
			 simple (doubleliteraltype), C) :
     'rule' AnalyseExpr (C:charliteral (_, _) -> simple (char), C) :
     'rule' AnalyseExpr (C:stringliteral (_, _) -> 
			 simple (stringliteraltype), C) :
     'rule' AnalyseExpr (C:expr_nil (_) -> simple (niltype), C) :
     
     'rule' AnalyseExpr (dyop (Pos, _, DyOp, Left, Right) -> 
			 Type, dyop (Pos, TypeI, DyOp, LExpr, RExpr)) :
	  AnalyseExpr (Left -> LType, LExpr)
	  FollowNameChain (LType -> LType2)
	  AnalyseExpr (Right -> RType, RExpr)
	  FollowNameChain (RType -> RType2)
	  AnalyseDyadicExpr (Pos, DyOp, LType2, RType2 -> Type)
	  NewTypeIndex (Pos, Type -> TypeI)
	  
     'rule' AnalyseExpr (monop (Pos, _, MonOp, Operand) -> 
			 Type, monop (Pos, TypeI, MonOp, OpExpr)) :
	  AnalyseExpr (Operand -> OpType, OpExpr)
	  FollowNameChain (OpType -> OpType2)
	  AnalyseMonadicExpr (Pos, MonOp, OpType2 -> Type)
	  NewTypeIndex (Pos, Type -> TypeI)
	  
     'rule' AnalyseExpr (adr (Pos, Desig) -> 
			 simple (address), adr (Pos, Desig2)) :
	  AnalyseDesig (Desig -> TypeI, Desig2)
	  (|
	       TypeI'Type -> Type
	       IsErrorType (Type)
	  ||
	       Desig'Pos -> DPos
	       CheckAdrDesig (DPos, Desig2)
	  |)
	  
     'rule' AnalyseExpr (Expr:sizeof (Pos, TypeI) ->
			 simple (unsignedint), Expr) :
	  WellFormedTypeIndex (TypeI)
	  
     'rule' AnalyseExpr (callexpr (Pos, Receiver, AParams) -> 
			 RealType, call (Pos, SpecTypeI, RealType, 
						Receiver2, AParams2)) :
	  AnalyseReceiver (Receiver -> FParams, SpecTypeI, RealType, 
			   Receiver2)
	  AnalyseAParams (Pos, AParams, FParams -> AParams2)
	  
     'rule' AnalyseExpr (Expr:new (Pos, _) -> Type, NewExpr) :
	  AnalyseExpr (callexpr (Pos, Expr, nil) -> Type, NewExpr)
	  
     'rule' AnalyseExpr (Expr:error (_) -> error, Expr) :
	  
     'rule' AnalyseExpr (Expr:nil (_) -> error, Expr) :
	  
     'rule' AnalyseExpr (dot (Pos, Desig:applied (_, TId), Id) -> 
			 EnumType, DotExpr) :
	  IsTypeId (TId -> composite (enum (Enumerators)))
	  (|
	       LookupEnumerator (Id, Enumerators -> N)
	       let (composite (typename (TId)) -> EnumType)
	       NewTypeIndex (Pos, EnumType -> EnumTypeI)
	       let (enumsel (Pos, EnumTypeI, Id, N) -> DotExpr)
	  ||
	       Id'Pos -> IPos
	       Id'Ident -> I
	       ErrorI ("'", I, "' is not declared as enumerator", Pos)
	       let (TYPE'error -> EnumType)
	       let (EXPR'error (Pos) -> DotExpr)
	  |)
	  
     'rule' AnalyseExpr (dot (Pos, Desig, Id) -> RealType, DotExpr) :
	  AnalyseExpr (Desig -> DesigType, Desig2)
	  AnalyseDotExpr (Pos, DesigType, Desig2, Id -> 
			  SpecTypeI, RealType, DotExpr)
	  
     'rule' AnalyseExpr (Expr -> Type, Desig)
	  AnalyseDesig (Expr -> TypeI, Desig)
	  TypeI'Type -> Type

-- ========================================================================
--  Dyadic expressions
-- ========================================================================

'action' AnalyseDyadicExpr (POS, DOP, TYPE, TYPE -> TYPE)
	  
     'rule' AnalyseDyadicExpr (_, _, T, _ -> error) :
	  IsErrorType (T)
	  
     'rule' AnalyseDyadicExpr (_, _, _, T -> error) :
	  IsErrorType (T)
	  
     'rule' AnalyseDyadicExpr (Pos, or, LType, RType -> Type) :
	  CheckOr (Pos, LType, RType -> Type)
     
     'rule' AnalyseDyadicExpr (Pos, and, LType, RType -> Type) :
	  CheckAnd (Pos, LType, RType -> Type)
	  
     'rule' AnalyseDyadicExpr (Pos, eq, LType, RType -> Type) :
	  CheckEqCompare (Pos, LType, RType -> Type)
	  
     'rule' AnalyseDyadicExpr (Pos, ne, LType, RType -> Type) :
	  CheckNeCompare (Pos, LType, RType -> Type)
	  
     'rule' AnalyseDyadicExpr (Pos, lt, LType, RType -> Type) :
	  CheckLtCompare (Pos, LType, RType -> Type)
	  
     'rule' AnalyseDyadicExpr (Pos, le, LType, RType -> Type) :
	  CheckLeCompare (Pos, LType, RType -> Type)
	  
     'rule' AnalyseDyadicExpr (Pos, gt, LType, RType -> Type) :
	  CheckGtCompare (Pos, LType, RType -> Type)
	  
     'rule' AnalyseDyadicExpr (Pos, ge, LType, RType -> Type) :
	  CheckGeCompare (Pos, LType, RType -> Type)
	  
     'rule' AnalyseDyadicExpr (Pos, plus, LType, RType -> Type) :
	  CheckPlusArith (Pos, LType, RType -> Type)
	  
     'rule' AnalyseDyadicExpr (Pos, minus, LType, RType -> Type) :
	  CheckMinusArith (Pos, LType, RType -> Type)
	  
     'rule' AnalyseDyadicExpr (Pos, times, LType, RType -> Type) :
	  CheckTimesArith (Pos, LType, RType -> Type)
	  
     'rule' AnalyseDyadicExpr (Pos, div, LType, RType -> Type) :
	  CheckDivArith (Pos, LType, RType -> Type)
	  
     'rule' AnalyseDyadicExpr (Pos, idiv, LType, RType -> Type) :
	  CheckIDivArith (Pos, LType, RType -> Type)
	  
     'rule' AnalyseDyadicExpr (Pos, mod, LType, RType -> Type) :
	  CheckModArith (Pos, LType, RType -> Type)
	  
-- ========================================================================
--  Monadic expressions
-- ========================================================================

'action' AnalyseMonadicExpr (POS, MOP, TYPE -> TYPE)
	  
     'rule' AnalyseMonadicExpr (Pos, _, Type -> error) :
	  IsErrorType (Type)
	  
     'rule' AnalyseMonadicExpr (Pos, minus, Type -> Type2) :
	  CheckNumericType (Pos, Type -> Type2)
	  
     'rule' AnalyseMonadicExpr (Pos, plus, Type -> Type2) :
	  CheckNumericType (Pos, Type -> Type2)
     
     'rule' AnalyseMonadicExpr (Pos, not, Type -> Type2) :
	  CheckBoolType (Pos, Type -> Type2)
	  
-- ========================================================================
--  Calls
-- ------------------------------------------------------------------------
--  AnalyseReceiver analyses the expression describing the procedure or
--   method to be called.
--  AnalyseIdReceiver is used if the receiver is given by the identifier of
--   the procedure or method without object prefix.
--  AnalyseSuperReceiver is used if the case of SUPER.method.
--  AnalyseDotReceiver analyses calls like expr.id, where expr is a record
--   or a union and id denotes a procedure field or expr denotes an object
--   and id an exported method.
--  InspectCallType is used to check if the giuven expression has a
--   procedure or method type and denotes a valid receiver.
--  AnalyseNew checks the NEW expression.
--  GetClassParams returns the object parameter of a class.
--  AnalyseAParams and AnalyseAParam analyse the actual parameter of a call.
-- ========================================================================

'action' AnalyseReceiver (ReceiverExpr : EXPR -> 
			  FParams : FPARAMLIST, 
			  SpecResult : TYPEINDEX, RealResult : TYPE,
			  Receiver : RECEIVER)
	  
     'rule' AnalyseReceiver (Expr:applied (Pos, Id) -> 
			     FParams, ResultI, Result, Receiver) :
	  CheckId (Id)
	  GetIdMeaning (Id -> Meaning)
	  AnalyseIdReceiver (Meaning, Id -> FParams, ResultI, Receiver)
	  ResultI'Type -> Result
	  
     'rule' AnalyseReceiver (dot (Pos, super (SPos), MId) -> 
			     error, ErrorI,  error, error) :
	  ScopeFlag -> routine 
	  Error ("SUPER only valid inside method bodies", SPos)
     	  ErrorTypeIndex -> ErrorI

     'rule' AnalyseReceiver (Desig:dot (Pos, super (SPos), MId) -> 
			     FParams, ResultI, Result, Receiver) :
	  ActualClassId -> ClassId
          GetTypeIdDef (ClassId -> composite (classtype (_, _, Interface)))
	  Interface'Supertype -> SuperType
	  AnalyseSuperReceiver (SPos, SuperType, MId -> 
				FParams, ResultI, Receiver)
	  ResultI'Type -> Result

     'rule' AnalyseReceiver (dot (Pos, Expr, Id) -> 
			     FParams, SpecResultI, RealResult, Receiver) :
	  AnalyseExpr (Expr -> ExprType, Expr2)
	  FollowNameChain (ExprType -> ExprType2)
	  AnalyseDotReceiver (Pos, ExprType2, Expr2, Id -> -- ExprType2 ???
			      FParams, SpecResultI, RealResult, Receiver)
	  
     'rule' AnalyseReceiver (new (Pos, TypeI) -> 
			     FParams, TypeI, Type, new (TypeI)) :
	  WellFormedTypeIndex (TypeI)
	  FollowNameChainIndex (TypeI -> TypeDef)
	  TypeI'Type -> Type
	  GetClassParams (Pos, TypeDef -> FParams)
	  
     'rule' AnalyseReceiver (error (_) -> error, ErrorI, error, error) :
	  ErrorTypeIndex -> ErrorI
	  
     'rule' AnalyseReceiver (Expr -> FParams, ResultI, Result, Receiver) :
	  AnalyseExpr (Expr -> Type, Expr2)
	  FollowNameChain (Type -> Type2)
	  Expr'Pos -> Pos
	  InspectCallType (Pos, Type2, Expr2 -> FParams, ResultI, Receiver)
	  ResultI'Type -> Result -- SpecResult ???

---------------------------------------------------------------------------

'action' AnalyseIdReceiver (MEANING, ID -> FPARAMLIST, TYPEINDEX, RECEIVER)
     
     'rule' AnalyseIdReceiver (method (_, _, FParams, ResultI), MId -> 
			       FParams, ResultI, Receiver) :
	  ActualClassId -> ClassId
	  (|
	       LookupExportedMethod (ClassId, MId -> _)
	       MId'Pos -> Pos
	       let (RECEIVER'method (current (Pos), MId) -> Receiver)
	  ||
	       let (localmethod (ClassId, MId) -> Receiver)
	  |)
	  
     'rule' AnalyseIdReceiver (proc (_, _, FParams, ResultI), Id -> 
			       FParams, ResultI, proc (Id)) :
	  
     'rule' AnalyseIdReceiver (foreignproc (_, FParams, ResultI), Id -> 
			       FParams, ResultI,  foreignproc (Id)) :

     'rule' AnalyseIdReceiver (error, Id -> error, ErrorI, error) :
	  ErrorTypeIndex -> ErrorI
	  
     'rule' AnalyseIdReceiver (_, Id -> FParams, ResultI, Receiver) :
	  Id'Pos -> Pos
	  AnalyseExpr (applied (Pos, Id) -> Type, Expr)
	  FollowNameChain (Type -> Type2)
	  InspectCallType (Pos, Type2, Expr -> FParams, ResultI, Receiver)
	    
---------------------------------------------------------------------------

'action' AnalyseSuperReceiver (POS, SUPERTYPE, ID -> 
			       FPARAMLIST, TYPEINDEX, RECEIVER)
     
     'rule' AnalyseSuperReceiver (SPos, super (SId), MId -> 
				  Params, ResultI, super (SId, MId)) :
	  LookupExportedMethod (SId, MId -> methodspec (_, _, Mode, Abstract, 
							_, Params, ResultI))
          DefineMeaning (MId, method (Mode, Abstract, Params,
					  ResultI)) --- @@@ check Qualifier!!!
	  [|
	       where (Abstract -> abstract)
	       Error ("supertype method is declared as ABSTRACT", SPos)
	  |]
	  
	  
     'rule' AnalyseSuperReceiver (SPos, super (SId), MId -> 
				  error, ErrorI, error) :
	  MId'Pos -> Pos
	  MId'Ident -> I
	  ErrorI ("'", I, "' is not an exported method", Pos)
	  ErrorTypeIndex -> ErrorI

     'rule' AnalyseSuperReceiver (SPos, none, _ -> error, ErrorI, error) :
	  ActualClassId -> ClassId
	  ClassId'Ident -> I
	  ErrorI ("object type '", I, "' has no super type", SPos)
	  ErrorTypeIndex -> ErrorI
     
     'rule' AnalyseSuperReceiver (SPos, error, _ -> error, ErrorI, error) :
	  ErrorTypeIndex -> ErrorI

---------------------------------------------------------------------------
	  
'action' AnalyseDotReceiver (POS, TYPE, EXPR, ID -> 
			     FPARAMLIST, TYPEINDEX, TYPE, RECEIVER)
     
     'rule' AnalyseDotReceiver (Pos, ClassType, ObjectDesig, Id ->
                                RealFParams, SpecResultI, RealResult, 
				method (ObjectDesig, Id)) :
	  AnalyseMethodAppl (Pos, ClassType, Id -> 
			     SpecFParams, RealFParams, 
			     SpecResultI, RealResultI)
	  RealResultI'Type -> RealResult
	  
     'rule' AnalyseDotReceiver (Pos, RecordType, Record, Id -> 
				FParams, SpecResultI, RealResult, Receiver) :
	  AnalyseRecordOrUnionDotExpr (Pos, RecordType, Record, Id -> 
				       FieldTypeI, FieldSel)
	  FollowNameChainIndex (FieldTypeI -> FieldType2)
	  InspectCallType (Pos, FieldType2, FieldSel -> 
			   FParams, SpecResultI, Receiver)
	  SpecResultI'Type -> RealResult
	  
---------------------------------------------------------------------------
	  
'action' InspectCallType (POS, TYPE, EXPR -> FPARAMLIST, TYPEINDEX, RECEIVER)
     
     'rule' InspectCallType (_, composite (procedure (FParams, ResultI)),
			     Expr -> FParams, ResultI, procexpr (Expr)) :
	  
     'rule' InspectCallType (_, composite (method (FParams, ResultI)),
			     Expr -> FParams, ResultI, methodexpr (Expr)) :
	  
     'rule' InspectCallType (Pos, T, _ -> error, ErrorI, error) :
	  ErrorTypeIndex -> ErrorI
	  (|
	       IsErrorType (T)
	  ||
	       Error ("expression of type PROCEDURE or METHOD expected",
		      Pos) 
	  |)

---------------------------------------------------------------------------
	  
'action' GetClassParams (POS, TYPE -> ObjectParams : FPARAMLIST)
     
     'rule' GetClassParams (_, composite (classtype (_, _, Interface)) ->
			    FParams) :
	  Interface'Objparams -> FParams
	  
     'rule' GetClassParams (_, generic (genericinst (Id, ActGenParams)) -> 
			    FParams2)
	  GetTypeIdDef (Id -> IdDef)
	  (|
	       where (IdDef -> composite (classtype (_, FGenParams, 
						     Interface)))
	       Interface'Objparams -> FParams
	       ExpandGenericsInFParamList (FParams, FGenParams, 
					   ActGenParams -> FParams2)
	  ||
	       let (FPARAMLIST'error -> FParams2)
	  |)
	       
     'rule' GetClassParams (Pos, T -> error) :
	  (|
	       IsErrorType (T)
	  ||
	       Error ("object type expected", Pos)
	  |)
	  
---------------------------------------------------------------------------
	  
'action' AnalyseAParams (POS, ActParams : APARAMLIST, FParams : FPARAMLIST -> 
			 APARAMLIST)
	  
     'rule' AnalyseAParams (_, error, _ -> error) :
	  
     'rule' AnalyseAParams (_, _, error -> error) :
	  
     'rule' AnalyseAParams (Pos, aparamlist (Param, Tail), 
			    fparamlist (FParam, FTail) -> 
			    aparamlist (Param2, Tail2)) :
	  AnalyseAParam (Param, FParam -> Param2)
	  AnalyseAParams (Pos, Tail, FTail -> Tail2)
     
     'rule' AnalyseAParams (Pos, aparamlist (Param, Tail), 
			    F:ellipsis ->
			    aparamlist (Param2, Tail2)) :
	  AnalyseAParamEllipsis (Param -> Param2)
	  AnalyseAParams (Pos, Tail, F -> Tail2)
     
     'rule' AnalyseAParams (_, nil, ellipsis -> nil) :
	  
     'rule' AnalyseAParams (_, nil, nil -> nil) :
	  
     'rule' AnalyseAParams (Pos, nil, _ -> error) :
	  Error ("too few actual parameters", Pos)

     'rule' AnalyseAParams (Pos, _, nil -> error) :
	  Error ("too many actual parameters", Pos)

---------------------------------------------------------------------------
	  
'action' AnalyseAParam (AParam : APARAM, FParam : FPARAM -> APARAM)
     
     'rule' AnalyseAParam (unspec (Expr), fparam (_, _, in, FTypeI) -> 
			   in (Expr2)) :
	  AnalyseExpr (Expr -> ExprType, Expr2)
	  FollowNameChain (ExprType -> ExprType2)
	  FollowNameChainIndex (FTypeI -> FType2)
	  (|
	       IsInParamCompatible (ExprType2, FType2)
	  ||
	       Expr'Pos -> Pos
	       Error ("incompatible type of IN parameter", Pos)
	  |)
	  
     'rule' AnalyseAParam (unspec (Expr), fparam (_, _, out, FTypeI) -> 
			   out (Expr2)) :
	  AnalyseDesig (Expr -> ExprTypeI, Expr2)
	  Expr'Pos -> Pos
	  CheckWritableDesig (Pos, Expr2)
	  FollowNameChainIndex (ExprTypeI -> ExprType2)
	  FollowNameChainIndex (FTypeI -> FType2)
	  (|
	       IsOutParamCompatible (ExprType2, FType2)
	  ||
	       Error ("incompatible type of OUT parameter", Pos)
	  |)
	  
     'rule' AnalyseAParam (unspec (Expr), fparam (_, _, inout, FTypeI) -> 
			   inout (Expr2)) :
	  AnalyseDesig (Expr -> ExprTypeI, Expr2)
	  Expr'Pos -> Pos
	  CheckWritableDesig (Pos, Expr2)
	  FollowNameChainIndex (ExprTypeI -> ExprType2)
	  FollowNameChainIndex (FTypeI -> FType2)
	  (|
	       IsInOutParamCompatible (ExprType2, FType2)
	  ||
	       Error ("incompatible type of INOUT parameter", Pos)
	  |)
	  
---------------------------------------------------------------------------
	  
'action' AnalyseAParamEllipsis (AParam : APARAM -> APARAM)
     
     'rule' AnalyseAParamEllipsis (unspec (Expr) -> in (Expr2)) :
	  AnalyseExpr (Expr -> ExprType, Expr2)
	  [|
	       FollowNameChain (ExprType -> simple (void))
	       Expr'Pos -> Pos
	       Error ("value expected", Pos)
	  |]
	  
-- ========================================================================
--  Designators
-- ------------------------------------------------------------------------
--  The following expressions are invalid designators
-- ------------------------------------------------------------------------
--  false, true
--  posintliteral, negintliteral, doubleliteral
--  charliteral, stringliteral
--  expr_nil
--  dyop
--  monop
--  adr
--  sizeof
--  enumsel
--  methodpointer
--  range
--  applied if Id has one of the following meanings
--    type
--    method
--    exception
--  foreigntype
--  call
--  callexpr
--  super
--  new
-- ------------------------------------------------------------------------
--  The following expressions are valid designators
--  designator       writable   ADR operand
-- ------------------------------------------------------------------------
--  dot			x           x
--  fieldsel		x           x
--  unionsel		x           x
--  subscr		x           x
--  arraysubscr         x           x
--  stringsubscr        x
--  substring		x
--  deref		x           x
--  applied   
--    proc  
--    const  
--    globalvar		x           x
--    localvar		x           x
--    instvar		x
--    implicitvar		    x
--    fparam (in)		    x
--    fparam (out)	x           x
--    fparam (inout)	x           x
--    foreignvar	x           x
--    foreignproc    
--  current
-- ------------------------------------------------------------------------
--  AnalyseWritableDesig checks the given expression if it is a valid
--   writable designator.
--  AnalyseDesig checks the given expression if it is a valid designator.
--  CheckAdrDesig checks if the designator is a valid argument of ADR.
--  CheckWritableDesig checks id the designator is writable.
--  CheckSubscription checks if the type of the subscribed expression is an
--   array type or string.
--  GetReferencedType returns the type, where the designator points to.
--  AnalyseRange is used to analyse the given range in the case of a
--   substring expression.
--  AnalyseDotExpr analyses expressions like expr.id, where expr denotes a
--   record or union and id denotes a field or, inside a methodpointer, expr
--   denotes an object and id is an exported method.
--  CheckAccessMode analyses if a protected method is used outside its
--   scope.
--  AnalyseIdAppl analyses the use of an identifier as an designator.
-- ========================================================================

'action' AnalyseWritableDesig (Designator : EXPR -> TYPEINDEX, EXPR)
     
     'rule' AnalyseWritableDesig (Desig -> TypeI, Desig2) :
	  AnalyseDesig (Desig -> TypeI, Desig2)
	  (|
	       TypeI'Type -> Type
	       IsErrorType (Type)
	  ||
	       Desig'Pos -> Pos
	       CheckWritableDesig (Pos, Desig2)
	  |)
	  
---------------------------------------------------------------------------

'action' AnalyseDesig (Designator : EXPR -> TYPEINDEX, EXPR)
     
     'rule' AnalyseDesig (dot (Pos, Desig, Id) -> Type2, DotExpr)
	  AnalyseExpr (Desig -> Type, Desig2)
	  AnalyseRecordOrUnionDotExpr (Pos, Type, Desig2, Id -> Type2, DotExpr)
     
     'rule' AnalyseDesig (Desig:fieldsel (_, TypeI, _, _) -> TypeI, Desig)
	  
     'rule' AnalyseDesig (Desig:unionsel (_, TypeI, _, _) -> TypeI, Desig)
	  
     'rule' AnalyseDesig (subscr (Pos, SubDesig, Expr) -> ElemTypeI, Subscr) :
	  AnalyseDesig (SubDesig -> SubTypeI, SubDesig2)
	  FollowNameChainIndex (SubTypeI -> SubType2)
	  AnalyseExpr (Expr -> ExprType, Expr2)
	  Expr'Pos -> ExprPos
	  CheckIntegerType (ExprPos, ExprType -> _)
	  CheckSubscription (Pos, SubType2, SubDesig2, Expr2 -> 
			     ElemTypeI, Subscr) 
			  
     'rule' AnalyseDesig (substring (Pos, StringDesig, Range) ->
			  TypeI, 
			  substring (Pos, StringDesig2, Range2)) :
	  AnalyseDesig (StringDesig -> StringTypeI, StringDesig2)
	  StringDesig'Pos -> StringPos
	  StringTypeI'Type -> StringType
	  CheckStringType (StringPos, StringType -> _)
	  AnalyseRange (Range -> Range2)
	  NewTypeIndex (Pos, simple (string) -> TypeI)
	  
     'rule' AnalyseDesig (deref (Pos, _, Pointer) -> 
			  RefTypeI , deref (Pos, RefTypeI, Pointer2)) :
	  AnalyseDesig (Pointer -> PointerTypeI, Pointer2)
	  FollowNameChainIndex (PointerTypeI -> PointerType2)
	  Pointer'Pos -> PointerPos
	  GetReferencedType (PointerPos, PointerType2 -> RefTypeI)
	  
     'rule' AnalyseDesig (Desig:applied (Pos, Id) -> TypeI, Expr) :
	  CheckId (Id)
	  GetIdMeaning (Id -> Meaning)
	  (|
	       where (Meaning -> const (TypeI, Value))
	       let (Value -> Expr)
	  ||
	       AnalyseIdAppl (Meaning, Id -> TypeI)
	       let (Desig -> Expr)
	  |)
	  
     'rule' AnalyseDesig (Expr:current (Pos) -> TypeI, Expr) :
	  ScopeFlag -> method
	  ActualClassId -> ClassId
	  NewTypeIndex (Pos, composite (typename (ClassId)) -> TypeI)
	  
     'rule' AnalyseDesig (current (Pos) -> TypeI, error (Pos)) :
	  Error ("CURRENT only valid inside method bodies", Pos)
	  ErrorTypeIndex -> TypeI 
	  
     'rule' AnalyseDesig (Desig -> TypeI, error (Pos)) :
	  (|
	       where (Desig -> error (Pos))
	  ||
	       Desig'Pos -> Pos
	       Error ("invalid designator", Pos)
	  |)
	  ErrorTypeIndex -> TypeI
	  
---------------------------------------------------------------------------

'condition' CheckAdrDesig (POS, EXPR)
     
     'rule' CheckAdrDesig (Pos, fieldsel (_, _, RecordDesig, _ )) :
	  CheckAdrDesig (Pos, RecordDesig)
	  
     'rule' CheckAdrDesig (Pos, unionsel (_, _, UnionDesig, _ )) :
	  CheckAdrDesig (Pos, UnionDesig)
	  
     'rule' CheckAdrDesig (Pos, arraysubscr (_, _, SubDesig, _ )) :
	  CheckAdrDesig (Pos, SubDesig)
	  
     'rule' CheckAdrDesig (_, deref (_, _, _)) :
	  
     'rule' CheckAdrDesig (_, applied (_, Id)) :
	  GetIdMeaning (Id -> Meaning)
	  (|
	       where (Meaning -> globalvar (_, _))
	  ||
	       where (Meaning -> localvar (_))
	  ||
	       where (Meaning -> implicitvar (_))
	  ||
	       where (Meaning -> fparam (_, _))
	  ||
	       where (Meaning -> foreignvar (_))
	  ||
	       where (Meaning -> error)
	  |)
     
     'rule' CheckAdrDesig (_, error (_)) :
	  
     'rule' CheckAdrDesig (Pos, _) :
	  Error ("invalid operand of ADR", Pos)
	  
---------------------------------------------------------------------------

'action' CheckWritableDesig (POS, EXPR)
     
     'rule' CheckWritableDesig (Pos, fieldsel (_, _, RecordDesig, _ )) :
	  CheckWritableDesig (Pos, RecordDesig)
     
     'rule' CheckWritableDesig (Pos, unionsel (_, _, UnionDesig, _ )) :
	  CheckWritableDesig (Pos, UnionDesig)
	  
     'rule' CheckWritableDesig (Pos, arraysubscr (_, _, SubDesig, _ )) :
	  CheckWritableDesig (Pos, SubDesig)
	  
     'rule' CheckWritableDesig (Pos, stringsubscr (_, SubDesig, _ )) :
	  CheckWritableDesig (Pos, SubDesig)
	  
     'rule' CheckWritableDesig (Pos, substring (_, String, _ )) :
	  CheckWritableDesig (Pos, String)
	  
     'rule' CheckWritableDesig (_, deref (_, _, _)) :
	  
     'rule' CheckWritableDesig (_, applied (_, Id)) :
	  GetIdMeaning (Id -> Meaning)
	  (|
	       where (Meaning -> globalvar (_, _))
	  ||
	       where (Meaning -> localvar (_))
	  ||
	       where (Meaning -> instvar (_))
	  ||
	       where (Meaning -> fparam (out, _))
	  ||
	       where (Meaning -> fparam (inout, _))
	  ||
	       where (Meaning -> foreignvar (_))
	  ||
	       where (Meaning -> error)
	  |)
     
     'rule' CheckWritableDesig (_, error (_)) :
	  
     'rule' CheckWritableDesig (Pos, _) :
	  Error ("designator is not writable", Pos)
	  
---------------------------------------------------------------------------

'action' CheckSubscription (ExprPos : POS, 
			    DesigType : TYPE, 
			    SubcribedDesig : EXPR, 
			    Index : EXPR -> 
			    ElemType : TYPEINDEX, Desig : EXPR)
	  
     'rule' CheckSubscription (Pos, composite (ArrayType), Desig, Index -> 
			       ElemTypeI, arraysubscr (Pos, ElemTypeI, 
						       Desig, Index)) :
	  (|
	       where (ArrayType -> array (_, ElemTypeI))
	  ||
	       where (ArrayType -> openarray (ElemTypeI))
	  |)
	  
     'rule' CheckSubscription (Pos, simple (string), Desig, Index -> 
			       TypeI, stringsubscr (Pos, Desig, Index)) :
	  NewTypeIndex (Pos, simple (char) -> TypeI)
	  
     'rule' CheckSubscription (Pos, T, Desig, _ -> ErrorI, error (Pos)) :
	  ErrorTypeIndex -> ErrorI
	  (|
	       IsErrorType (T)
	  ||
	       Desig'Pos -> DesigPos
	       Error ("subscripted designator must be an array or a string",
		      DesigPos)
	  |)
	  
---------------------------------------------------------------------------

'action' GetReferencedType (POS, PointerType : TYPE -> PointedTo : TYPEINDEX)
     
     'rule' GetReferencedType (_, composite (ref (RefTypeI)) -> RefTypeI) :
	  
     'rule' GetReferencedType (Pos, T -> ErrorI) :
	  ErrorTypeIndex -> ErrorI
	  (|
	       IsErrorType (T)
	  ||
	       Error ("pointer type expected", Pos)
	  |)

---------------------------------------------------------------------------

'action' AnalyseRange (EXPR -> EXPR)
     
     'rule' AnalyseRange (range (Pos, Lwb, Upb) -> range (Pos, Lwb2, Upb2)) :
	  AnalyseExpr (Lwb -> LwbType, Lwb2)
	  Lwb'Pos -> LwbPos
	  CheckIntegerType (LwbPos, LwbType -> _)
	  AnalyseExpr (Upb -> UpbType, Upb2)
	  Upb'Pos -> UpbPos
	  CheckIntegerType (UpbPos, UpbType -> _)

---------------------------------------------------------------------------

'action' AnalyseDotExpr (POS, DesigType : TYPE, Desig : EXPR, 
			 Selector : ID -> 
			 SpecTypeIndex : TYPEINDEX, ReadType: TYPE, 
			 DotExpr : EXPR)
     'rule' AnalyseDotExpr (Pos, ClassType, ObjectDesig, Id -> 
			    SpecTypeI, 
			    composite (method (RealFParams, RealResultI)), 
			    methodpointer (Pos, RealResultI, ObjectDesig, 
					   Id)) :
	  AnalyseMethodAppl (Pos, ClassType, Id -> 
			     SpecFParams, RealFParams, 
			     SpecResultI, RealResultI)
	  NewTypeIndex (Pos, composite (method (SpecFParams, SpecResultI)) -> 
			SpecTypeI)
	  
     'rule' AnalyseDotExpr (Pos, Type, Desig, Id -> 
			    SpecTypeI, RealType, DotExpr) :
	  AnalyseRecordOrUnionDotExpr (Pos, Type, Desig, Id -> 
				       SpecTypeI, DotExpr)
	  SpecTypeI'Type -> RealType

---------------------------------------------------------------------------

'condition' AnalyseMethodAppl (POS, DesigType : TYPE, MethodId : ID ->
			       SpecFParams : FPARAMLIST, 
			       RealFParams : FPARAMLIST, 
			       SpecResult : TYPEINDEX, 
			       RealResultI : TYPEINDEX)
     
     'rule' AnalyseMethodAppl (Pos, ClassType, Id -> 
			       FParams, FParams, ResultI, ResultI) :
	  FollowNameChain (ClassType -> 
			   ClassType2:composite (classtype (ClassId, _, _)))
	  (|
	       LookupExportedMethod (ClassId, Id -> 
				     methodspec (_, _, Mode, Abstract, _, 
						 FParams, ResultI))
	       CheckAccessMode (Pos, Mode, ClassType2)
	       DefineMeaning (Id, method (Mode, Abstract, FParams,
					  ResultI)) -- @@@ check
						        -- Qualifier!!!
	  ||
	       Id'Pos -> IPos
	       Id'Ident -> I
	       ErrorI ("'", I, "' is not an exported method", Pos)
	       let (FPARAMLIST'error -> FParams)
	       ErrorTypeIndex -> ResultI
	  |)
	  
     'rule' AnalyseMethodAppl (Pos, GenericInst, Id -> 
			       SpecFParams, RealFParams, 
			       SpecResultI, RealResultI) :
	  FollowNameChain (GenericInst -> 
			   generic (genericinst (CId, ActGenParams)))
	  IsTypeId (CId -> ClassType2:composite (classtype (ClassId, 
							    FGenParams, _)))
	  (|
	       LookupExportedMethod (ClassId, Id -> 
				     methodspec (_, _, Mode, Abstract, _, 
						 SpecFParams, SpecResultI))
	       CheckAccessMode (Pos, Mode, ClassType2)
	       ExpandGenericsInFParamList (SpecFParams, FGenParams, 
					   ActGenParams -> RealFParams)
	       ExpandGenericsInTypeIndex (SpecResultI, FGenParams, 
					  ActGenParams -> RealResultI)
	       DefineMeaning (Id, method (Mode, Abstract, SpecFParams,
					  SpecResultI)) -- @@@ check
							-- Qualifier!!!
	  ||
	       Id'Pos -> IPos
	       Id'Ident -> I
	       ErrorI ("'", I, "' is not an exported method", Pos)
	       let (FPARAMLIST'error -> SpecFParams)
	       let (FPARAMLIST'error -> RealFParams)
	       ErrorTypeIndex -> SpecResultI
	       ErrorTypeIndex -> RealResultI
	  |)
	  
     'rule' AnalyseMethodAppl (Pos, ConstainedType, Id -> 
			       SpecFParams, RealFParams, 
			       SpecTypeI, RealTypeI) :
	  FollowNameChain (ConstainedType -> generic (constrained (_, CId)))
	  AnalyseMethodAppl (Pos, composite (typename (CId)), Id -> 
			     SpecFParams, RealFParams, SpecTypeI, RealTypeI)
	  
---------------------------------------------------------------------------

'action' AnalyseRecordOrUnionDotExpr (POS, DesigType : TYPE, Desig : EXPR, 
				      Selector : ID -> 
				      FieldType : TYPEINDEX, DotExpr : EXPR)
     
     'rule' AnalyseRecordOrUnionDotExpr (Pos, RecordType, RecordDesig, Id -> 
					 TypeI, DotExpr) :
	  FollowNameChain (RecordType -> composite (record (Fields)))
	  (|
	       LookupField (Id, Fields -> TypeI)
	       let (fieldsel (Pos, TypeI, RecordDesig, Id) -> DotExpr)
	  ||
	       Id'Pos -> IPos
	       Id'Ident -> I
	       ErrorI ("'", I, "' is not declared as record selector", IPos)
	       let (EXPR'error (Pos) -> DotExpr)
	       ErrorTypeIndex -> TypeI
	  |)
     
     'rule' AnalyseRecordOrUnionDotExpr (Pos, UnionType, UnionDesig, Id -> 
					 TypeI, DotExpr) :
	  FollowNameChain (UnionType -> composite (union (Fields)))
	  (|
	       LookupField (Id, Fields -> TypeI)
	       let (unionsel (Pos, TypeI, UnionDesig, Id) -> DotExpr)
	  ||
	       Id'Pos -> IPos
	       Id'Ident -> I
	       ErrorI ("'", I, "' is not declared as union selector", IPos)
	       let (EXPR'error (Pos) -> DotExpr)
	       ErrorTypeIndex -> TypeI
	  |)

     'rule' AnalyseRecordOrUnionDotExpr (Pos, Type, Desig, Id -> 
					 TypeI, error (Pos)) :
	  FollowNameChain (Type -> DefType)
	  (|
	       IsErrorType (DefType)
	  ||
	       Error ("invalid designator in selection", Pos)
	  |)
	  ErrorTypeIndex -> TypeI

---------------------------------------------------------------------------
	  
'action' CheckAccessMode (POS, ACCESSMODE, TYPE)
     
     'rule' CheckAccessMode (_, public, _) :
	  
     'rule' CheckAccessMode (_, protected, Type) :
	  ScopeFlag -> method
	  ActualClassId -> Id
	  GetTypeIdDef (Id -> ActualClassType)
	  IsSubType (ActualClassType, Type)
     
     'rule' CheckAccessMode (Pos, protected, _)
	  Error ("invalid use of protected method", Pos)
	  
---------------------------------------------------------------------------

'action' AnalyseIdAppl (MEANING, ID -> TYPEINDEX)
 
     'rule' AnalyseIdAppl (type (_), Id -> TypeI)
	  Id'Pos   -> Pos
	  Id'Ident -> I
	  ErrorI ("invalid use of type '", I, "'", Pos)
	  ErrorTypeIndex -> TypeI
     
     'rule' AnalyseIdAppl (method (_, _, _, _), Id -> TypeI)
	  Id'Pos   -> Pos
	  Id'Ident -> I
	  ErrorI ("invalid use of method '", I, "'", Pos)
	  ErrorTypeIndex -> TypeI

     'rule' AnalyseIdAppl (proc (_, _, Params, Result), Id -> TypeI) :
	  Id'Pos -> Pos
	  NewTypeIndex (Pos, composite (procedure (Params, Result)) -> TypeI)
     
     'rule' AnalyseIdAppl (globalvar (_, TypeI), Id -> TypeI) :
	  
     'rule' AnalyseIdAppl (localvar (TypeI), Id -> TypeI) :
	  
     'rule' AnalyseIdAppl (instvar (TypeI), Id -> TypeI) :
	  
     'rule' AnalyseIdAppl (implicitvar (TypeI), Id -> TypeI) :
	  
     'rule' AnalyseIdAppl (exception (_), Id -> TypeI)
	  Id'Pos   -> Pos
	  Id'Ident -> I
	  ErrorI ("invalid use of exception '", I, "'", Pos)
	  ErrorTypeIndex -> TypeI

     'rule' AnalyseIdAppl (fparam (_, TypeI), Id -> TypeI) :

     'rule' AnalyseIdAppl (foreignvar (TypeI), Id -> TypeI) :

     'rule' AnalyseIdAppl (foreignproc (_, Params, Result), Id -> TypeI)
	  Id'Pos -> Pos
	  NewTypeIndex (Pos, composite (procedure (Params, Result)) -> TypeI)

     'rule' AnalyseIdAppl (foreigntype (_), Id -> TypeI)
	  Id'Pos   -> Pos
	  Id'Ident -> I
	  ErrorI ("invalid use of type '", I, "'", Pos)
	  ErrorTypeIndex -> TypeI
     
     'rule' AnalyseIdAppl (error, _ -> TypeI) :
	  ErrorTypeIndex -> TypeI

-- ========================================================================
--  ExpandGenerics predicates are used to replace formal generic parameters
--   with the actual generic parameters.
-- ========================================================================

'action' ExpandGenericsInFParamList (FPARAMLIST, FGenParams : FPARAMLIST,
                                     ActGenParams : TYPEINDEXLIST ->
                                     FPARAMLIST)

     'rule' ExpandGenericsInFParamList
               (fparamlist (fparam (Pos, Id, Mode, TypeI), Tail), F, A ->
                fparamlist (fparam (Pos, Id, Mode, TypeI2), Tail2)) :
          ExpandGenericsInTypeIndex (TypeI, F, A -> TypeI2)
          ExpandGenericsInFParamList (Tail, F, A -> Tail2)

     'rule' ExpandGenericsInFParamList (Other, _, _ -> Other) :

---------------------------------------------------------------------------

'action' ExpandGenericsInTypeIndexList (TYPEINDEXLIST, FPARAMLIST,
                                        TYPEINDEXLIST -> TYPEINDEXLIST)

     'rule' ExpandGenericsInTypeIndexList (typeindexlist (Hd1, Tl1), F, A ->
                                           typeindexlist (Hd2, Tl2)) :
          ExpandGenericsInTypeIndex (Hd1, F, A -> Hd2)
          ExpandGenericsInTypeIndexList (Tl1, F, A -> Tl2)

     'rule' ExpandGenericsInTypeIndexList (nil, _, _ -> nil) :

---------------------------------------------------------------------------

'action' ExpandGenericsInTypeIndex (TYPEINDEX, FPARAMLIST, 
				    TYPEINDEXLIST -> TYPEINDEX)
     
     'rule' ExpandGenericsInTypeIndex (TypeI, F, A -> TypeI2) :
	  TypeI'Pos -> Pos
	  TypeI'Type -> Type
	  ExpandGenericsInType (Type, F, A -> Type2)
	  NewTypeIndex (Pos, Type2 -> TypeI2)
	  
---------------------------------------------------------------------------

'action' ExpandGenericsInType (TYPE, FPARAMLIST, TYPEINDEXLIST -> TYPE)
     
     'rule' ExpandGenericsInType (T:composite (typename (Id)), 
				  FGenParams, ActGenParams -> Type) :
	  FollowNameChain (T -> TDef)
	  (|
	       where (TDef -> generic (unconstrained (_)))
	  ||
	       where (TDef -> generic (constrained (_, _)))
	  |)
	  (|
	       GetActGenParam (Id, FGenParams, ActGenParams -> Type)
	  ||
	       let (T -> Type)
	  |)
	       
     'rule' ExpandGenericsInType (composite (record (Fields)), F, A -> 
				  composite (record (Fields2))) :
	  ExpandGenericsInField (Fields, F, A -> Fields2)
	  
     'rule' ExpandGenericsInType (composite (union (Fields)), F, A -> 
				  composite (union (Fields2))) :
	  ExpandGenericsInField (Fields, F, A -> Fields2)
	  
     'rule' ExpandGenericsInType (composite (array (R, BaseTypeI)),
				  F, A -> 
				  composite (array (R, BaseTypeI2))) :
	  ExpandGenericsInTypeIndex (BaseTypeI, F, A -> BaseTypeI2)
     
     'rule' ExpandGenericsInType (composite (openarray (BaseTypeI)),
				  F, A -> 
				  composite (openarray (BaseTypeI2))) :
	  ExpandGenericsInTypeIndex (BaseTypeI, F, A -> BaseTypeI2)
     
     'rule' ExpandGenericsInType (composite (ref (BaseTypeI)), F, A ->
				  composite (ref (BaseTypeI2))) : 	  
	  ExpandGenericsInTypeIndex (BaseTypeI, F, A -> BaseTypeI2)
	  
     'rule' ExpandGenericsInType (composite (procedure (FParams, ResultI)),
				  F, A -> composite (procedure (FParams2,
								ResultI2))) :
	  ExpandGenericsInFParamList (FParams, F, A -> FParams2)
	  ExpandGenericsInTypeIndex (ResultI, F, A -> ResultI2)
	  
     'rule' ExpandGenericsInType (composite (method (FParams, ResultI)),
				  F, A -> composite (method (FParams2,
							     ResultI2))) :
	  ExpandGenericsInFParamList (FParams, F, A -> FParams2)
	  ExpandGenericsInTypeIndex (ResultI, F, A -> ResultI2)
	  
     'rule' ExpandGenericsInType (generic (genericinst (Id, L1)), F, A -> 
				  generic (genericinst (Id, L2))) :
	  ExpandGenericsInTypeIndexList (L1, F, A -> L2)
	  
     'rule' ExpandGenericsInType (Type, _, _ -> Type) :
	  
---------------------------------------------------------------------------

'action' ExpandGenericsInField (FIELD, FPARAMLIST, TYPEINDEXLIST -> FIELD)
     
     'rule' ExpandGenericsInField (seq (Left, Right), F, A -> 
				   seq (Left2, Right2)) :
	  ExpandGenericsInField (Left, F, A -> Left2)
	  ExpandGenericsInField (Right, F, A -> Right2)
	  
     'rule' ExpandGenericsInField (field (Pos, Name, TypeI), F, A -> 
				   field (Pos, Name, TypeI2)) :
	  ExpandGenericsInTypeIndex (TypeI, F, A -> TypeI2)
	  
     'rule' ExpandGenericsInField (nil, _, _ -> nil) :
	  
---------------------------------------------------------------------------

'condition' GetActGenParam (ID, FPARAMLIST, TYPEINDEXLIST -> TYPE)
     
     'rule' GetActGenParam (Id , fparamlist (FParam, FParamTail), 
			    typeindexlist (TypeI, TypeTail) -> Type) :
	  FParam'Id -> Id2
	  (|
	       EqId (Id, Id2)
	       TypeI'Type -> Type
	  ||
	       GetActGenParam (Id, FParamTail, TypeTail -> Type)
	  |)
	  
---------------------------------------------------------------------------

'end'
