
'module' decls

'export'
     AnalyseImportedItems 
     AnalyseSpecDecls AnalyseSpecsInImplPart AnalyseImplDecls 
     ActualClassId
     GetCompleteInterface
     CheckId IsChecked FPARAMKIND CheckEqFParams
     LookupClassImpl LookupMethodSpec LookupMethodImpl LookupProcImpl
     LookupDecl LookupExportedMethod LookupEnumerator LookupField
     GetDeclId
     
'use' ast extspecs misc const scopes stmts types 

-- ========================================================================
--  AnalyseImportedItems checks all importeditems to avoid errors in the
--    codegeneration in the case of unused imports.
--  AnalyseSpec is used to analyse the declarations inside a specification
--    part. 
--  AnalyseSpecsInImplPart is used to analyse the declarations of the
--    specification part in the case of compiling the implementation part 
--    of a module. It is checked whether the implementation part provides an
--    implementation to a classspec or a procspec. The signatures of
--    procspec and procimpl are checked.
--  AnalyseImplDecls is used to analyse the declarations of the
--    implemetation part of a module. This predicate provides a special rule
--    to analyse a classimpl.
-- ========================================================================

'action' AnalyseImportedItems (IMPORT)
     
     'rule' AnalyseImportedItems (seq (Left, Right)) :
	  AnalyseImportedItems (Left)
	  AnalyseImportedItems (Right)
	  
     'rule' AnalyseImportedItems (importitem (MId, IId)) :
	  CheckId (IId)
	  
     'rule' AnalyseImportedItems (_) :
	  
---------------------------------------------------------------------------
	  
'action' AnalyseSpecDecls (DECL -> DECL)
     
     'rule' AnalyseSpecDecls (Spec -> Spec2) :
	  AnalyseDecls (Spec -> Spec2)
	  
---------------------------------------------------------------------------
	  
'action' AnalyseSpecsInImplPart (POS, Specs : DECL, Impls : DECL -> DECL)
     
     'rule' AnalyseSpecsInImplPart (MPos, seq (Pos, Left1, Right1), Impls -> 
				    seq (Pos, Left2, Right2)) :
	  AnalyseSpecsInImplPart (MPos, Left1, Impls -> Left2)
	  AnalyseSpecsInImplPart (MPos, Right1, Impls -> Right2)
     
     'rule' AnalyseSpecsInImplPart (MPos, Spec:classspec (_, SId, _, _),
				    Impls -> Decl) :
	  (|
	       LookupClassImpl (SId, Impls -> _)
	  ||
	       SId'Ident -> I
	       ErrorI ("missing implementation of exported object type '",
		       I, "'", MPos)
	  |)
	  AnalyseDecls (Spec -> Decl)
	  
     'rule' AnalyseSpecsInImplPart (MPos, Spec:procspec (_, SId, _, _, 
							 SParams, SResult),
				    Impls -> ProcDecl) :
	  CheckId (SId)
	  (|
	       LookupProcImpl (SId, Impls -> 
			       procimpl (IPos, IId, IParams, IResult, _, _))
	       CheckId (IId)
	       CheckEqFParams (IPos, methodSpec, SParams, IParams)
	       CheckEqTypeIndex (methodSpec, SResult, IResult)
	  ||
	       SId'Ident -> I
	       ErrorI ("missing implementation of exported procedure '",
		       I, "'", MPos)
	  |)
	  AnalyseDecls (Spec -> ProcDecl)
     
     'rule' AnalyseSpecsInImplPart (MPos, Spec, Impls -> Spec2) :
	  AnalyseSpecDecls (Spec -> Spec2)
	  
---------------------------------------------------------------------------
	  
'action' AnalyseImplDecls (Impls : DECL, Specs : DECL -> DECL)
     
     'rule' AnalyseImplDecls (seq (Pos, Left1, Right1), Impls -> 
			      seq (Pos, Left2, Right2)) :
	  AnalyseImplDecls (Left1, Impls -> Left2)
	  AnalyseImplDecls (Right1, Impls -> Right2)
     
     'rule' AnalyseImplDecls (classimpl (IPos, IId, MethodImpls), 
			      Specs -> ClassDecl) :
	  (|
	       LookupClassSpec (IId, Specs -> 
				classspec (SPos, SId, SGenParams, 
					   SLocalDefs))
	       AnalyseDecls (class (IPos, IId, SGenParams, SLocalDefs, 
				    MethodImpls) ->
			     class (_, _, _, _, MethodImpls2))
	       let (classimpl (IPos, IId, MethodImpls2) -> ClassDecl)
	  ||
	       IId'Ident -> I
	       Error ("missing specification of object type implementation", 
		      IPos)
	       let (DECL'nil (IPos) -> ClassDecl)
	  |)
     
     'rule' AnalyseImplDecls (Impl, Specs -> Impl2) :
	  AnalyseDecls (Impl -> Impl2)
	  
-- ========================================================================
--  AnalyseDecls is the main predicate of the third pass of the context
--  analysis. Each decaration is checked and the identifier state is set to
--  transformed.
-- ========================================================================

'action' AnalyseDecls (DECL -> DECL)
     
     'rule' AnalyseDecls (seq (P, Left, Right) -> seq (P, Left2, Right2)) :
	  AnalyseDecls (Left -> Left2)
	  AnalyseDecls (Right -> Right2)
	  
     'rule' AnalyseDecls (TypeDecl:type (Pos, Id, TypeI) -> TypeDecl) :
	  TypeI'Type -> Type
	  (|
	       GetIdMeaning (Id -> error)
	  ||
	       FollowNameChain (Type -> composite (classtype (Id2, _, _)))
	       Id2'Ident -> I
	       ErrorI ("object type '", I, "' cannot be renamed", Pos)
	       Id'Meaning <- error
	  ||
	       IsInvalidPtrRec (Type)
	       Id'Ident -> I
               ErrorI ("useless definition of type '", I, "'", Pos)
	       Id'Meaning <- error
	  ||
	       CheckId (Id)
	  |)
	  Id'State <- transformed
     
     'rule' AnalyseDecls (class (Pos, Id, _, _, MethImpls) -> 
			  class (Pos, Id, GenParams, CompleteInterface,
				 MethImpls2))
	  CheckId (Id)
	  ActualClassId <- Id
	  GetIdMeaning (Id -> type (BaseTypeI))
	  BaseTypeI'Type -> 
	     composite (classtype (_, GenParams, 
				   interface (S, Ab, Par, ExpMeth, IV)))
	  AnalyseMethPairs (Pos, Ab, ExpMeth, MethImpls -> ExpMeth2)
	  AnalyseMethImpls (MethImpls, MethImpls -> MethImpls2)
	  AnalyseDecls (IV -> _)
	  let (interface (S, Ab, Par, ExpMeth2, IV) -> 
	       CompleteInterface)
	  BaseTypeI'Type <- composite (classtype (Id, GenParams,
						  CompleteInterface))
	  Id'State <- transformed

     'rule' AnalyseDecls (classspec (Pos, Id, _, _) -> 
			  classspec (Pos, Id, GenParams, Interf))
	  CheckId (Id)
	  ActualClassId <- Id
	  GetIdMeaning (Id -> type (BaseTypeI))
	  BaseTypeI'Type -> 
	     composite (classtype (_, GenParams, 
				   Interf:interface (_, Ab, _, ExpMeth, IV)))
	  AnalyseMethSpecs (Pos, Ab, ExpMeth)
	  AnalyseDecls (IV -> _)
	  Id'State <- transformed
     
     'rule' AnalyseDecls (const (Pos, Id, TypeI, _) -> 
			  const (Pos, Id, TypeI, Value)) :
	  CheckId (Id)
	  Id'State <- transformed
	  (|
	       GetIdMeaning (Id -> const (_, Value))
	  ||
	       let (EXPR'error (Pos) -> Value)
	  |)
	  
     'rule' AnalyseDecls (globalvar (Pos, Id, Export, TypeI, Init) -> 
			  globalvar (Pos, Id, Export, TypeI, Init2)) :
	  CheckId (Id)
	  Id'State <- transformed
	  CheckVariableInitialization (TypeI, Init -> Init2)
	  
     'rule' AnalyseDecls (localvar (Pos, Id, TypeI, Init) -> 
			  localvar (Pos, Id, TypeI, Init2)) :
	  CheckId (Id)
	  Id'State <- transformed
	  CheckVariableInitialization (TypeI, Init -> Init2)

     'rule' AnalyseDecls (Decl:instvar (Pos, Id, _) -> Decl) :
	  CheckId (Id)
	  Id'State <- transformed

     'rule' AnalyseDecls (Decl:implicitvar (Pos, Id) -> Decl) :
	  CheckId (Id)
	  Id'State <- transformed
     
     'rule' AnalyseDecls (Decl:exception (Pos, Id, _) -> Decl) :
	  CheckId (Id)
	  Id'State <- transformed
	  
     'rule' AnalyseDecls (Decl:procspec (Pos, Id, _, _, _, _) -> Decl) :
	  CheckId (Id)
	  Id'State <- transformed
	  
     'rule' AnalyseDecls (procimpl (Pos, Id, Par, Result, LVars, Body) -> 
			  procimpl (Pos, Id, Par, Result, LVars2, Body2)) :
	  CheckId (Id)
	  Id'State <- transformed
	  AnalyseDecls (LVars -> LVars2)
	  FollowNameChainIndex (Result -> Type)
	  AnalyseProcStmts (Body, Type -> Body2)
     
     'rule' AnalyseDecls (Decl:foreignproc (_, Id, _, _, _) -> Decl) :
	  CheckId (Id)
	  Id'State <- transformed
	  
     'rule' AnalyseDecls (Decl:foreignvar (_, Id, _) -> Decl) :
	  CheckId (Id)
	  Id'State <- transformed
	  
     'rule' AnalyseDecls (Decl:foreigntype (Pos, Id, TypeI) -> Decl) :
	  AnalyseDecls (type (Pos, Id, TypeI) -> _)
	  
     'rule' AnalyseDecls (D -> D) :
	  
-- ========================================================================
--  Special predicates to analyse classes
--  ActualClassId is a global varibale containing th ID of the actual
--    analysed class.
--  AnalyseMethPairs computes and analyses the complete interface of a 
--    class implementation. The signatures of method specification and
--    implementation are checked to be equal (the same with the signatures
--    of abstract and defining specification of a method,
--    AnalyseSpecOfDefinedMeth). The flag of the specification of an
--    redefined inherited method is set to redef. 
--  AnalyseMethSpecs is used within a class specification to analyse the
--    interface of the class.
--  AnalyseSpecOfDefinedMeth checks the signatures of abstract and defining
--    specification of a method.
--  AnalyseMethImpls analyses the method implementations including initially
--    and finally.
-- ========================================================================

'var' ActualClassId : ID

---------------------------------------------------------------------------
	  
'action' AnalyseMethPairs (ClassPos : POS, Abstract : ABSTRACT,
			   MethSpecs : DECL, AllMethImpls : DECL -> 
			   RedefMethSpecs : DECL)
     
     'rule' AnalyseMethPairs (CPos, Ab, seq (Pos, Left1, Right1), Impls -> 
			      seq (Pos, Left2, Right2)) :
	  AnalyseMethPairs (CPos, Ab, Left1, Impls -> Left2)
	  AnalyseMethPairs (CPos, Ab, Right1, Impls -> Right2)
     
     'rule' AnalyseMethPairs (CPos, ClassAbstract, 
			      Spec:methodspec (SPos, SId, _, abstract, 
					       SFlag, SParams, SResult), 
			      Impls -> Spec) :
	  CheckId (SId)
	  CheckAbstractClass (CPos, ClassAbstract, SFlag, SId)
	  [|
	       where (SFlag -> defines)
	       AnalyseSpecOfDefinedMeth (Spec)
	  |]
	  [|
	       LookupMethodImpl (SId, Impls -> 
				 Impl:methodimpl (IPos, IId, _, IParams, 
						  IResult, _, _))
	       SId'Ident -> I
	       ErrorI ("invalid implementation of abstract method '", 
		       I, "'", IPos)
	       CheckId (IId)
	       CheckEqFParams (IPos, abstractMethodSpec, SParams, IParams)
	       CheckEqTypeIndex (abstractMethodSpec, SResult, IResult)
	  |]
	  
	  
     'rule' AnalyseMethPairs (CPos, _, 
			      Spec:methodspec (SPos, SId, SMode, concrete, 
					       inherited, SParams, SResult),
			      Impls ->  Spec2) :
	  CheckId (SId)
	  (|
	       LookupMethodImpl (SId, Impls -> 
				 Impl:methodimpl (IPos, IId, IFlag, 
						  IParams, IResult, _, _))
	       CheckId (IId)
	       CheckRedef (IPos, IFlag)
	       CheckEqFParams (IPos, methodSpec, SParams, IParams)
	       CheckEqTypeIndex (methodSpec, SResult, IResult)
	       let (methodspec (SPos, SId, SMode, concrete, redef,
				SParams, SResult) -> Spec2)
	  ||
	       let (Spec -> Spec2)
	  |)
	  
     'rule' AnalyseMethPairs (CPos, _, 
			      Spec:methodspec (SPos, SId, _, concrete, 
					       SFlag, SParams, SResult), 
			      Impls -> Spec) :
	  CheckId (SId)
	  [|
	       where (SFlag -> defines)
	       AnalyseSpecOfDefinedMeth (Spec)
	  |]
	  (|
	       LookupMethodImpl (SId, Impls -> 
				 Impl:methodimpl (IPos, IId, IFlag, 
						  IParams, IResult, _, _))
	       CheckId (IId)
	       CheckFirstdef (IPos, IFlag)
	       CheckEqFParams (IPos, methodSpec, SParams, IParams)
	       CheckEqTypeIndex (methodSpec, SResult, IResult)

	  ||
	       SId'Ident -> I
	       ErrorI ("missing implementation of exported method '", I, 
		       "'", CPos)
	  |)
	  
     'rule' AnalyseMethPairs (_, _, Decl:nil (_), _ -> Decl) :

---------------------------------------------------------------------------
	  
'action' AnalyseMethSpecs (ClassPos : POS, Abstract : ABSTRACT,
			   MethSpecs : DECL)

     'rule' AnalyseMethSpecs (CPos, Ab, seq (Pos, Left1, Right1)) :
	  AnalyseMethSpecs (CPos, Ab, Left1)
	  AnalyseMethSpecs (CPos, Ab, Right1)
     
     'rule' AnalyseMethSpecs (CPos, ClassAbstract, 
			      Spec:methodspec (SPos, SId, _, abstract, 
					       SFlag, _, _)) :
	  CheckId (SId)
	  CheckAbstractClass (CPos, ClassAbstract, SFlag, SId)
	  [|
	       where (SFlag -> defines)
	       AnalyseSpecOfDefinedMeth (Spec)
	  |]
	  
     'rule' AnalyseMethSpecs (_, _, _) :
	  
---------------------------------------------------------------------------
	  
'action' AnalyseSpecOfDefinedMeth (MethSpec : DECL)
     
     'rule' AnalyseSpecOfDefinedMeth (methodspec (SPos, SId, SMode, SAbstract, 
						  defines, SParams, SResult)) :
	  ActualClassId -> ClassId
	  GetIdMeaning (ClassId -> type (BaseTypeI))
	  BaseTypeI'Type -> composite (classtype (_, _, Interface))
	  Interface'Supertype -> super (SuperId)
	  LookupExportedMethod (SuperId, SId -> 
				methodspec (_, _, AMode, abstract, _,
					    AParams, AResult))
	  CheckEqAccessmode (SPos, AMode, SMode)
	  CheckNonAbstractMethod (SPos, SAbstract)
	  CheckEqFParams (SPos, abstractMethodSpec, AParams, SParams)
	  CheckEqTypeIndex (abstractMethodSpec, AResult, SResult)
	  
     'rule' AnalyseSpecOfDefinedMeth (X) :
	  
---------------------------------------------------------------------------
	  
'action' AnalyseMethImpls (MethImpls : DECL, AllImpls : DECL -> DECL)

     'rule' AnalyseMethImpls (seq (Pos, Left1, Right1), AllImpls ->
			      seq (Pos, Left2, Right2)) :
	  AnalyseMethImpls (Left1, AllImpls  -> Left2)
	  AnalyseMethImpls (Right1, AllImpls -> Right2)
     
     'rule' AnalyseMethImpls (methodimpl (Pos, Id, Flag, Params, Result,
					  LVars, Body), AllImpls -> 
			      methodimpl (Pos, Id, Flag, Params, Result,
					  LVars2, Body2)) :
	  CheckId (Id)
	  Id'State <- transformed
	  CheckPrivateFirstdef (Pos, Id, Flag)
	  CheckSingleMethImpl (Id, AllImpls)
	  AnalyseDecls (LVars -> LVars2)
	  FollowNameChainIndex (Result -> Type)
	  AnalyseMethodStmts (Body, Type -> Body2)
     
     'rule' AnalyseMethImpls (initially (Pos, Params, LVars, Body), 
			      AllImpls -> 
			      initially (Pos, Params, LVars2, Body2)) :
	  ActualClassId -> Id
	  GetIdMeaning (Id -> type (BaseTypeI))
	  BaseTypeI'Type -> 
	     composite (classtype (_, _, 
				   interface (_, _, ObjParams, _, _)))
	  CheckEqFParams (Pos, methodSpec, ObjParams, Params)
	  AnalyseDecls (LVars -> LVars2)
	  AnalyseMethodStmts (Body, simple (void) -> Body2)
	  
     'rule' AnalyseMethImpls (finally (Pos, LVars, Body), AllImpls -> 
			      finally (Pos, LVars2, Body2)) :
	  AnalyseDecls (LVars -> LVars2)
	  AnalyseMethodStmts (Body, simple (void) -> Body2)

     'rule' AnalyseMethImpls (Nil:nil(_), _ -> Nil)
	  
-- ========================================================================
--  GetCompleteInterface checks whether the complete interface was already
--    computed (Main predicate called by types.g)
--  GetInterfaceDecls computes the interface of a class.
--  AdaptInhMethods set the methodflag of the inherited methods (defines is
--    set in the case of the definition of an abstract method, inherited
--    otherwise) 
--  ConcatLocalMethods concatenates those methodspecs defined in the actual
--    class to the list of inherited methods, which are not the definition
--    of an inherited abstract method.
-- ========================================================================

'action' GetCompleteInterface (StartId : ID, LocalDefs : CLASSINTERFACE ->
			       Interface : CLASSINTERFACE)
	  
     'rule' GetCompleteInterface (StartId, localdefs (Super, Ab, Par,
						 LocalMeth, LocalIV) ->
				  interface (Super, Ab, Par, 
					     ExportedMeth, IV)) :
	  GetInterfaceDecls (StartId, Super, LocalMeth, LocalIV ->
			     ExportedMeth, IV) 
	  
     'rule' GetCompleteInterface (Id, Interface -> Interface) :
	  
---------------------------------------------------------------------------
	  
'action' GetInterfaceDecls (StartId : ID, Super : SUPERTYPE, 
			    LocalMeth : DECL, LocalIV : DECL -> 
			    ExportedMeth : DECL, IV : DECL)
     
     'rule' GetInterfaceDecls (StartId, super (SuperId), Meth, IV -> 
			       Meth, IV) :
          IsEquivClassId (StartId, SuperId) -- cyclic supertype chain
     
     'rule' GetInterfaceDecls (StartId, super (SuperId), Meth, IV ->
			       CompleteMeths, CompleteIV) :
	  CheckId (SuperId)
	  GetIdMeaning (SuperId -> type (BaseTypeI))
	  BaseTypeI'Type -> composite (classtype (_, _, Interf))
	  GetCompleteInterface (StartId, Interf -> 
				interface (_, _, _, InhMeth, InhIV))
	  (|
	       where (InhMeth -> nil (_))
	       let (Meth -> CompleteMeths)
	  ||
	       AdaptInhMethods (InhMeth, Meth -> InhMeth2)
	       ConcatLocalMethods (InhMeth2, Meth -> CompleteMeths)
	  |)
	  (|
	       where (InhIV -> nil(_))
	       let (IV -> CompleteIV)
	  ||
	       where (IV -> nil (_))
	       let (InhIV -> CompleteIV)
	  ||
	       DefaultPos (-> DfltPos)
	       let (DECL'seq (DfltPos, InhIV, IV) -> CompleteIV)
	  |)
	  
     'rule' GetInterfaceDecls (StartId, Super, Meth, IV -> Meth, IV) :

---------------------------------------------------------------------------

'action' AdaptInhMethods (InhMethods : DECL, LocalSpecs : DECL -> DECL)
     
     'rule' AdaptInhMethods (seq (Pos, Left1, Right1), LocalSpecs ->
			     seq (Pos, Left2, Right2)) :
	  AdaptInhMethods (Left1, LocalSpecs -> Left2)
	  AdaptInhMethods (Right1, LocalSpecs -> Right2)
	  
     'rule' AdaptInhMethods (methodspec (Pos, Id, Mode, abstract,
					 Flag, Params, Result), 
			     LocalSpecs -> MethSpec) :
	  (|
	       LookupMethodSpec (Id, LocalSpecs -> 
				 methodspec (Pos2, Id2, Mode2, Abstract2,
					     Flag2, Params2, Result2))
	       Id2'State <- included
	       let (methodspec (Pos2, Id2, Mode2, Abstract2, defines, 
				Params2, Result2) -> MethSpec)
	  ||
	       let (methodspec (Pos, Id, Mode, abstract, inherited,
				Params, Result) -> MethSpec)
	  |)
	       
     'rule' AdaptInhMethods (methodspec (P, I, M, concrete, Flag, Par, R), 
			     LocalSpecs -> 
			     methodspec (P, I, M, concrete, inherited,
					 Par, R)) :
     
     'rule' AdaptInhMethods (Other, LocalSpecs -> Other) :
	  
---------------------------------------------------------------------------
	  
'action' ConcatLocalMethods (MethList : DECL, LocalMethods : DECL ->
			     CompleteList : DECL)

     'rule' ConcatLocalMethods (L1, seq (Pos, Left1, Right1) ->
				CompleteList) :
	  ConcatLocalMethods (L1, Left1 -> L2)
	  ConcatLocalMethods (L2, Right1 -> CompleteList)
	  
     'rule' ConcatLocalMethods (L, M:methodspec (_, Id, _, _, _, _, _) ->
				CompleteList) :
	  (|
	       Id'State -> included -- definition of an inherited
	                            -- abstract method 
	       let (L -> CompleteList)
	       Id'State <- declared
	  ||
	       L'Pos -> Pos
	       let (DECL'seq (Pos, L, M) -> CompleteList)
	  |)
	  
     'rule' ConcatLocalMethods (L, Other -> L) :

-- ========================================================================
--  Check predicates
--  The type FPARAMKIND specifies the error message in the case of wrong
--  fparams.
--  CheckEqFParams : equal formal paramater lists
--  CheckEqPMode : equal formal parameter modes
--  CheckEqTypeIndex : equal types 
--  CheckEqAccessmode : equal accessmode in abstract and defining method
--  CheckAbstractClass : abstract method in abtract class
--  CheckNonAbstractMethod : definition of abstract method is non abstract
--  CheckFirstdef : first implementation not prefixed by REDEFINED
--  CheckRedef : redefinition not prefixed by REDEFINED
--  CheckPrivateFirstdef : private (local) method not prefixed by REDEFINED
--  CheckSingleMethImpl : method not implemented twice
--  CheckExceptionParamMode : check exception parameters on mode IN
-- ========================================================================

'type' FPARAMKIND
     abstractMethodSpec
     methodSpec
     object
     formalGeneric
     exception

---------------------------------------------------------------------------

'action' CheckEqFParams (POS, Kind : FPARAMKIND,
			 Impl : FPARAMLIST, Spec : FPARAMLIST)
     
     'rule' CheckEqFParams (_, _, error, _) :
	  
     'rule' CheckEqFParams (_, _, _, error) :
	  
     'rule' CheckEqFParams (Pos, Kind, fparamlist (P1, Tail1), 
			    fparamlist (P2, Tail2)) :
	  (|
	       where (Kind -> formalGeneric)
	       CheckEqGenParam (P1, P2)
	  ||
	       CheckEqFParam (Kind, P1, P2)
	  |)
	  CheckEqFParams (Pos, Kind, Tail1, Tail2)
	  
     'rule' CheckEqFParams (_, _, ellipsis, ellipsis) :
	  
     'rule' CheckEqFParams (_, _, nil, nil) :
	  
     'rule' CheckEqFParams (Pos, Kind, nil, _) :
	  (|
	       where (Kind -> abstractMethodSpec)
	       Error ("specification has more parameters than inherited abstract specification", Pos)
	  ||
	       where (Kind -> methodSpec)
	       Error ("implementation has more parameters than specification", Pos)
	  ||
	       where (Kind -> exception)
	       Error ("application has more parameters than specification", Pos)
	  ||
	       -- no error msg in the case of object and formalGeneric
	  |)
     
     'rule' CheckEqFParams (Pos, Kind, _, nil) :
	  (|
	       where (Kind -> abstractMethodSpec)
	       Error ("specification has fewer parameters than inherited abstract specification", Pos)
	  ||
	       where (Kind -> methodSpec)
	       Error ("implementation has fewer parameters than specification",
		      Pos)
	  ||
	       where (Kind ->  object)
	       Error ("subtype has fewer parameters than supertype", Pos)
	  ||
	       where (Kind -> formalGeneric)
	       Error ("subtyp has fewer formal generic parameters than supertype", Pos)
	  ||
	       where (Kind -> exception)
	       Error ("application has fewer parameters than specification", Pos)
	  |)
	       
---------------------------------------------------------------------------

'action' CheckEqGenParam (Param1 : FPARAM, Params2 : FPARAM)
     
     'rule' CheckEqGenParam (unconstrained (_, Id1), 
			     unconstrained (_, Id2)) :
	  EqId (Id1, Id2)
			   
     'rule' CheckEqGenParam (constrained (_, Id1, CId1), 
			     constrained (Pos2, Id2, CId2)) :
	  EqId (Id1, Id2)
	  (|
	       IsEquivClassId (CId1, CId2)
	  ||
	       Error ("different constraints in supertype and subtype", Pos2)
	  |)
     
     'rule' CheckEqGenParam (P1, P2)
	  P2'Pos -> Pos2
	  Error ("different formal generic parameters in supertype and subtype", Pos2)

---------------------------------------------------------------------------

'action' CheckEqFParam (Kind : FPARAMKIND, Param1 : FPARAM, Params2 : FPARAM)
     
     'rule' CheckEqFParam (Kind, fparam (_, Id1, M1, T1), 
			   fparam (Pos2, Id2, M2, T2)) :
	  CheckEqPMode (Pos2, Kind, M1, M2)
	  CheckEqId (Kind, Id1, Id2)
	  CheckEqTypeIndex (Kind, T1, T2)
	  
---------------------------------------------------------------------------

'action' CheckEqPMode (POS, Kind : FPARAMKIND, 
		       SpecMode : PMODE, ImplMode : PMODE)	  
	  
     'rule' CheckEqPMode (_, _, Mode1, Mode2) :
	  eq (Mode1, Mode2)
	
     'rule' CheckEqPMode (Pos, Kind, _, _) :
	  (|
	       where (Kind -> abstractMethodSpec)
	       Error ("different modes in inherited and local specification", Pos)
	  ||
	       where (Kind -> methodSpec)
	       Error ("different modes in specification and implementation", Pos)
	  ||
	       where (Kind -> object)
	       Error ("different modes in supertype and subtype", Pos)
	  ||
	       where (Kind -> exception)
	       Error ("different modes in specification and application", Pos)
	  ||
	       -- formal generic params -> CheckEqGenParam
	  |)
	  
---------------------------------------------------------------------------

'action' CheckEqId (Kind : FPARAMKIND, SId : ID, IId : ID)
	  
     'rule' CheckEqId (_, Id1, Id2) :
	  EqId (Id1, Id2)
	
     'rule' CheckEqId (Kind, _, Id2) :
	  Id2'Pos -> Pos
	  (|
	       where (Kind -> abstractMethodSpec)
	       Error ("different names in inherited and local specification", Pos)
	  ||
	       where (Kind -> methodSpec)
	       Error ("different names in specification and implementation", Pos)
	  ||
	       where (Kind -> object)
	       Error ("different names in supertype and subtype", Pos)
	  ||
	       where (Kind -> exception)
	       Error ("different names in specification and application", Pos)
	  ||
	       -- formal generic param -> CheckEqGenParam
	  |)
	  
---------------------------------------------------------------------------

'action' CheckEqTypeIndex (Kind : FPARAMKIND, 
			   SpecType : TYPEINDEX, ImplType : TYPEINDEX)
     
     'rule' CheckEqTypeIndex (_, TypeI1, TypeI2) :
	  TypeI1'Type -> Type1
	  TypeI2'Type -> Type2
	  IsEquivType (Type1, Type2)
	  
     'rule' CheckEqTypeIndex (Kind, _, TypeI2) :
	  TypeI2'Pos -> Pos
	  (|
	       where (Kind -> abstractMethodSpec)
	       Error ("different types in inherited and local specification", Pos)
	  ||
	       where (Kind -> methodSpec)
	       Error ("different types in specification and implementation", Pos)
	  ||
	       where (Kind -> object)
	       Error ("different types in supertype and subtype", Pos)
	  ||
	       where (Kind -> exception)
	       Error ("different types in specification and application", Pos)
	  ||
	       -- formal generic params -> CheckEqGenParam
	  |)
	  
---------------------------------------------------------------------------
	  
'action' CheckEqAccessmode (POS, Abstract : ACCESSMODE, 
			    Define : ACCESSMODE)
     
     'rule' CheckEqAccessmode (Pos, public, protected) :
	  Error ("public abstract method specified as protected", Pos)
     
     'rule' CheckEqAccessmode (Pos, protected, public) :
	  Error ("protected abstract method specified as public", Pos)
	  
     'rule' CheckEqAccessmode (_, _, _) :
	  
---------------------------------------------------------------------------
	  
'action' CheckAbstractClass (ClassPos : POS, ABSTRACT, 
			     MethodFlag : METHODFLAG, MethodId : ID)
     
     'rule' CheckAbstractClass (CPos, concrete, Flag, Id) :
	  (|
	       where (Flag -> inherited)
	       Id'Ident -> I
	       ErrorI ("inherited abstract method '", I, 
		       "' in non abstract object type", CPos)
	  ||
	       Id'Pos -> Pos
	       Error ("abstract method in non abstract object type", Pos)
	  |)
	  
     'rule' CheckAbstractClass (_, _, _, _) :

---------------------------------------------------------------------------

'action' CheckNonAbstractMethod (POS, ABSTRACT)
     
     'rule' CheckNonAbstractMethod (Pos, abstract) :
	  Error ("specification of inherited abstract method prefixed by ABSTRACT", Pos)
	  
     'rule' CheckNonAbstractMethod (_, _) :

---------------------------------------------------------------------------
	  
'action' CheckFirstdef (POS, ImplFlag : METHODFLAG)
     
     'rule' CheckFirstdef (Pos, redef) :
	  Error ("original definition prefixed by REDEFINED", Pos)
	  
     'rule' CheckFirstdef (_ , _) :
	  
---------------------------------------------------------------------------

'action' CheckRedef (POS, ImplFlag : METHODFLAG)

     'rule' CheckRedef (Pos, firstdef)
	  Error ("redefinition not prefixed by REDEFINED", Pos)
	  
     'rule' CheckRedef (_ , _) :
	  
---------------------------------------------------------------------------

'action' CheckPrivateFirstdef (POS, Id : ID, ImplFlag : METHODFLAG)
	  
     'rule' CheckPrivateFirstdef (Pos, Id, redef)
	  (|
	       ActualClassId -> ClassId
	       LookupExportedMethod (ClassId, Id -> _)
	  ||
	       Error ("local method prefixed by REDEFINED", Pos)
	  |)
	  
     'rule' CheckPrivateFirstdef (_ , _, _) :
	  
---------------------------------------------------------------------------
	  
'action' CheckSingleMethImpl (MethodId : ID, MethList : DECL)
     
     'rule' CheckSingleMethImpl (Id, seq (_, Left, Right)) :
	  CheckSingleMethImpl (Id, Left)
	  CheckSingleMethImpl (Id, Right)
	  
     'rule' CheckSingleMethImpl (Id1, methodimpl (_, Id2, _, _, _, _, _)) :
	  (|
	       Id2'State -> transformed
	  ||
	       Id1'Ident -> I1
	       Id2'Ident -> I2
	       eq (I1, I2)
	       Id2'Pos   -> Pos2
	       ErrorI ("multiple implementation of method '", I2, "'", 
		       Pos2) 
	  ||
	  |)
	  
     'rule' CheckSingleMethImpl (_, _) :
	  
---------------------------------------------------------------------------
	  
'action' CheckExceptionParamMode (FParams : FPARAMLIST)
     
     'rule' CheckExceptionParamMode (fparamlist (fparam (Pos, _, Mode, _), 
						 Tail)) :
	  (|
	       where (Mode -> in)
	  ||
	       Error ("invalid mode of exception parameter", Pos)
	  |)
	  CheckExceptionParamMode (Tail)
	  
     'rule' CheckExceptionParamMode (Other) :
	  
-- ========================================================================
--  Check ID meaning
--  The meaning of an identifier is checked if it was not checked before. 
-- ========================================================================

'action' CheckId (ID)
     
     'rule' CheckId (Id) :
	  Id'State -> State
	  IsChecked (State)
	  
     'rule' CheckId (Id) :
	  Id'Meaning -> Meaning
	  Id'State   <- checked
	  (| 
	       where (Meaning -> definingid (DefId))
	       CheckId (DefId)
	  ||
	       CheckMeaning (Meaning -> Meaning2)
	       Id'Meaning <- Meaning2
	  |)
	  
---------------------------------------------------------------------------
	  
'action' CheckMeaning (MEANING -> MEANING)
	  
     'rule' CheckMeaning (Meaning:const (TypeI, Expr) -> 
			  const (TypeI, Value)) :
	  WellFormedTypeIndex (TypeI)
	  CheckConstantDefinition (TypeI, Expr -> Value)
	  
     'rule' CheckMeaning (Other -> Other) :
	  CheckMeaning_h (Other)

---------------------------------------------------------------------------
	  
'action' CheckMeaning_h (MEANING)
	  
     'rule' CheckMeaning_h (type (BaseTypeI)) :
	  -- problem : unnamed types are currently only valid at type
	  -- declaration position, so call an extra predicate
          -- WellFormedOpenTypeIndex (BaseTypeI)
	  WellFormedRecordOrUnionTypeIndex (BaseTypeI) 
	  
     'rule' CheckMeaning_h (method (_, _, Params, ResultTypeI)) :
	  WellFormedFParams (Params)
	  WellFormedTypeIndex (ResultTypeI)
	  
     'rule' CheckMeaning_h (proc (_, _, Params, ResultTypeI)) :
	  WellFormedFParams (Params)
	  WellFormedTypeIndex (ResultTypeI)
	  
     'rule' CheckMeaning_h (globalvar (_, TypeI)) :
	  WellFormedTypeIndex (TypeI)

     'rule' CheckMeaning_h (localvar (TypeI)) :
	  WellFormedTypeIndex (TypeI)

     'rule' CheckMeaning_h (instvar (TypeI)) :
	  WellFormedTypeIndex (TypeI)
 	  
     'rule' CheckMeaning_h (exception (Params)) :
	  WellFormedFParams (Params)
	  CheckExceptionParamMode (Params)
     
     'rule' CheckMeaning_h (fparam (_, TypeI)) :
	  WellFormedOpenTypeIndex (TypeI)
	  
     'rule' CheckMeaning_h (field (TypeI)) :
	  WellFormedTypeIndex (TypeI)
	  
     'rule' CheckMeaning_h (foreignvar (TypeI)) :
	  DeclKind <- foreignDecl
	  WellFormedOpenTypeIndex (TypeI)
	  DeclKind <- coolDecl
	  
     'rule' CheckMeaning_h (foreignproc (_, Params, ResultTypeI)) :
	  DeclKind <- foreignDecl
	  WellFormedFParams (Params)
	  WellFormedTypeIndex (ResultTypeI)
	  DeclKind <- coolDecl
	  
     'rule' CheckMeaning_h (foreigntype (BaseTypeI)) :
	  DeclKind <- foreignDecl
          -- problem : unnamed types are currently only valid at type
	  -- declaration position, so call an extra predicate
          -- WellFormedOpenTypeIndex (BaseTypeI)
	  WellFormedRecordOrUnionTypeIndex (BaseTypeI) 
	  DeclKind <- coolDecl
	  
     'rule' CheckMeaning_h (Other) :
	  
---------------------------------------------------------------------------
	  
'condition' IsChecked (STATE)
	  
     'rule' IsChecked (checked) :
     'rule' IsChecked (transformed) :
	  
-- ========================================================================
--  Lookup predicates : test on identifier definition in list
--  LookupClassImpl : get the implementation of an exported class 
--  LookupMethodSpec : get the specification of a method
--  LookupMethodImpl : get the implementation of a method 
--  LookupProcImpl : get the implementation of a procedure
--  LookupDecl : get the first declaration declaring the given ID
--  LookupExportedMethod : get the specification of a method provided by a
--    class with the given identifier.
-- ========================================================================

'condition' LookupClassSpec (ID, DECL -> DECL)
     
     'rule' LookupClassSpec (Id, seq (_, Left, _) -> Spec) :
	  LookupClassSpec (Id, Left -> Spec)
     
     'rule' LookupClassSpec (Id, seq (_, _, Right) -> Spec) :
	  LookupClassSpec (Id, Right -> Spec)
     
     'rule' LookupClassSpec (Id1, Spec:classspec (_, Id2, _, _) -> Spec) :
	  EqId (Id1, Id2)

---------------------------------------------------------------------------

'condition' LookupClassImpl (ID, DECL -> DECL)
     
     'rule' LookupClassImpl (Id, seq (_, Left, _) -> Impl) :
	  LookupClassImpl (Id, Left -> Impl)
     
     'rule' LookupClassImpl (Id, seq (_, _, Right) -> Impl) :
	  LookupClassImpl (Id, Right -> Impl)
     
     'rule' LookupClassImpl (Id1, Impl:classimpl (_, Id2, _) -> Impl) :
	  EqId (Id1, Id2)

---------------------------------------------------------------------------
	  
'condition' LookupMethodSpec (ID, DECL -> DECL)
     
     'rule' LookupMethodSpec (Id, seq (_, Left, _) -> Spec) :
	  LookupMethodSpec (Id, Left -> Spec)
     
     'rule' LookupMethodSpec (Id, seq (_, _, Right) -> Spec) :
	  LookupMethodSpec (Id, Right -> Spec)
     
     'rule' LookupMethodSpec (Id1, Spec:methodspec (_, Id2, _, _, _,
						   _, _) -> Spec) :
	  EqId (Id1, Id2)
	  
---------------------------------------------------------------------------

'condition' LookupMethodImpl (ID, DECL -> DECL)
     
     'rule' LookupMethodImpl (Id, seq (_, Left, _) -> Impl) :
	  LookupMethodImpl (Id, Left -> Impl)
     
     'rule' LookupMethodImpl (Id, seq (_, _, Right) -> Impl) :
	  LookupMethodImpl (Id, Right -> Impl)
     
     'rule' LookupMethodImpl (Id1, Impl:methodimpl (_, Id2, _, _, _,
						   _, _) -> Impl) :
	  EqId (Id1, Id2)
	  
---------------------------------------------------------------------------

'condition' LookupProcImpl (ID, DECL -> DECL)
     
     'rule' LookupProcImpl (Id, seq (_, Left, _) -> Impl) :
	  LookupProcImpl (Id, Left -> Impl)
     
     'rule' LookupProcImpl (Id, seq (_, _, Right) -> Impl) :
	  LookupProcImpl (Id, Right -> Impl)
     
     'rule' LookupProcImpl (Id1, Impl:procimpl (_, Id2, _, _, _, _) -> Impl) :
	  EqId (Id1, Id2)

---------------------------------------------------------------------------

'condition' LookupDecl (ID, DECL -> DECL)
     
     'rule' LookupDecl (Id, seq (_, Left, _) -> Decl) :
	  LookupDecl (Id, Left -> Decl)
     
     'rule' LookupDecl (Id, seq (_, _, Right) -> Decl) :
	  LookupDecl (Id, Right -> Decl)
	  
     'rule' LookupDecl (Id1, Decl -> Decl) :
	  GetDeclId (Decl -> Id2)
	  EqId (Id1, Id2)

---------------------------------------------------------------------------
	  
'condition' LookupExportedMethod (ClassId : ID, MethodId : ID -> DECL)
     
     'rule' LookupExportedMethod (ClassId, MethodId -> MethSpec) :
	  GetIdMeaning (ClassId -> type (BaseTypeI))
	  BaseTypeI'Type -> composite (classtype (_, _, Interface))
	  where (Interface -> interface (_, _, _, ExportedMeth, _))
	  LookupMethodSpec (MethodId, ExportedMeth -> MethSpec)
	       
---------------------------------------------------------------------------

'condition' LookupEnumerator (ID, Enumerators : ENUMERATORLIST ->
			      EnumNumber : INT)
     
     'rule' LookupEnumerator (Id, EnumList -> N) :
	  LookupEnumerator_h (Id, EnumList, 0 -> N)
	  
---------------------------------------------------------------------------

'condition' LookupEnumerator_h (Enumertor : ID, ENUMERATORLIST, INT -> 
				Number : INT)
     
     'rule' LookupEnumerator_h (Id1, enumeratorlist (enumerator (_, Id2),
						     Tail), N -> M) : 
	  (|
	       EqId (Id1, Id2)
	       let (N + 1 -> M)
	  ||
	       LookupEnumerator_h (Id1, Tail, N + 1 -> M)
	  |)
	  
---------------------------------------------------------------------------

'condition' LookupField (FieldName : ID, FieldList : FIELD -> 
			 FieldType : TYPEINDEX)
     
     'rule' LookupField (Id, seq (Left, _) -> Type) :
	  LookupField (Id, Left -> Type)
     
     'rule' LookupField (Id, seq (_, Right) -> Type) :
	  LookupField (Id, Right -> Type)
	  
     'rule' LookupField (Id1, field (_, Id2, TypeI) -> TypeI) :
	  EqId (Id1, Id2)
	  
-- ========================================================================
--  Miscellaneous
--  GetDeclId : get the identifier (ID) of a declaration
-- ========================================================================

'action' GetDeclId (DECL -> ID)
	  
     'rule' GetDeclId (type (_, Id, _) -> Id) :
     'rule' GetDeclId (class (_, Id, _, _, _) -> Id) :
     'rule' GetDeclId (classspec (_, Id, _, _) -> Id) :
     'rule' GetDeclId (classimpl (_, Id, _) -> Id) :
     'rule' GetDeclId (methodspec (_, Id, _, _, _, _, _) -> Id) :
     'rule' GetDeclId (methodimpl (_, Id, _, _, _, _, _) -> Id) :
     'rule' GetDeclId (const (_, Id, _, _) -> Id) :
     'rule' GetDeclId (globalvar (_, Id, _, _, _) -> Id) :
     'rule' GetDeclId (localvar (_, Id, _, _) -> Id) :
     'rule' GetDeclId (instvar (_,Id, _) -> Id) :
     'rule' GetDeclId (implicitvar (_,Id) -> Id) :
     'rule' GetDeclId (exception (_, Id, _) -> Id) :
     'rule' GetDeclId (procspec (_, Id, _, _, _, _) -> Id) :
     'rule' GetDeclId (procimpl (_, Id, _, _, _, _) -> Id) :
     'rule' GetDeclId (foreignproc (_, Id, _, _, _) -> Id) :
     'rule' GetDeclId (foreignvar (_, Id, _) -> Id) :
     'rule' GetDeclId (foreigntype (_, Id, _) -> Id) :
     'rule' GetDeclId (Other -> Id)
	  ErrorId -> Id
	  
---------------------------------------------------------------------------

'end'

