
'module' context 

'export' 
     InitContext
     ContextAnalysisSpec
     ContextAnalysisImpl

'use' ast extspecs misc  const decls scopes types

-- ========================================================================
--  Initialization
-- ========================================================================

'action' InitContext
     
     'rule' InitContext :
	  InitScopes
	  InitTypes
	  
-- ========================================================================
--  Main predicates of context analysis
--  The context analysis has three passes 
--  first  pass : scope handling (NameAnalysis, VisitDecls and VisiAppls
--                implemented in this module) 
--  second pass : check on invalid recursion in the definition of constants
--                and types (mplemented in this module)
--  third  pass : analysis of each declaration (implemented in decls.g)
-- ========================================================================

'action' ContextAnalysisSpec (Spec : MODULE, 
			      ImportedModules : MODULE -> 
			      AnalysedSpec : MODULE)
     
     'rule' ContextAnalysisSpec (Spec:specification (SId, Imports, 
						     SpecDecls),
				 ImportedModules -> 
				 specification (SId, Imports, Decls)) :
	  HandleImportedModules (Spec, ImportedModules)
	  NameAnalysis (Spec)
	  CheckInvalidRecursion (SpecDecls)
	  AnalyseImportedItems (Imports)
	  AnalyseSpecDecls (SpecDecls -> Decls)

---------------------------------------------------------------------------
	  
'action' ContextAnalysisImpl (Spec : MODULE, Impl : MODULE, 
			      ImportedModules : MODULE -> 
			      AnalysedSpec : MODULE, AnalysedImpl : MODULE)

     'rule' ContextAnalysisImpl (Spec:specification (SId, SImports, SDecls),
				 implementation (IId, IImports, IDecls),
				 ImportedModules -> 
				 specification (SId, SImports, SDecls2),
				 implementation (IId, IImports, IDecls2)) :
	  HandleImportedModules (Spec, ImportedModules)
	  ActModuleQualifier <- module (SId)
	  EnterScope
 	  DeclareId (SId, module (SDecls))
	  VisitImportDecls (SImports)
	  VisitImportDecls (IImports)
	  VisitPairDecls (SDecls, IDecls)
	  VisitDecls (IDecls)
	  VisitAppls (SDecls)
	  VisitAppls (IDecls)
	  NameAnalysisPairs (SDecls, IDecls)
	  NameAnalysis (IDecls)
	  LeaveScope
	  CheckInvalidRecursion (SDecls)
	  CheckInvalidRecursion (IDecls)
	  AnalyseImportedItems (SImports)
	  AnalyseImportedItems (IImports)
	  IId'Pos -> Pos
	  AnalyseSpecsInImplPart (Pos, SDecls, IDecls -> SDecls2)
	  AnalyseImplDecls (IDecls, SDecls -> IDecls2)
	  
-- ========================================================================
--  Handling of imported modules
--  The global variable 'ImportedModules' contains a list of modules, which
--  are imported by the actual compilation unit or which are imported by
--  imported modules (transitive closure). 
--  The scope (name) analysis is done for all imported modules first.
-- ========================================================================

'var' ImportedModules : MODULE
'var' SpecModule : MODULE -- needed for recursive import of the actual
			  -- specification 

---------------------------------------------------------------------------

'action' HandleImportedModules (ActualSpec: MODULE, MODULE)
     
     'rule' HandleImportedModules (Spec, Imports) :
	  SpecModule <- Spec
	  DefineModuleMeaning (Spec)
	  ImportedModules <- Imports
	  DefineModuleMeaning (Imports)
	  NameAnalysis (Imports)
	  
---------------------------------------------------------------------------

'action' DefineModuleMeaning (MODULE)

     'rule' DefineModuleMeaning (seq (Left, Right)) :
	  DefineModuleMeaning (Left)
	  DefineModuleMeaning (Right)
	  
     'rule' DefineModuleMeaning (specification (Id, _, SpecDecls)) :
     	  Id'State   <- declared
	  Id'Meaning <- module (SpecDecls)

     'rule' DefineModuleMeaning (nil) :
	  
-- ========================================================================
--  NameAnalysis predicates handle all functors opening a new scope
--  NameAnalysisPairs is a special predicate to handle the class
--  implementation in a implementation module.
--  All declarations inside the new block are visited first
--  (VisitDecl-predicates), that means an identifier is visible in the
--  whole scope, especially befor the position of its declaration.
--  Then all identifier applications are handled (VisitAppls).
-- ========================================================================

'action' NameAnalysisPairs (Specs : DECL, Impls : DECL)
     
     'rule' NameAnalysisPairs (seq (_, Left, Right), Impls) :
	  NameAnalysisPairs (Left, Impls)
	  NameAnalysisPairs (Right, Impls)
     
     'rule' NameAnalysisPairs (Spec:classspec (Pos, Id, FGenParams, 
					       Interface), Impls) :
	  (|
	       LookupClassImpl (Id, Impls -> 
				classimpl (IPos, ImplId, MethImpls))
	       ImplId'State <- declared
	       NameAnalysis (class (IPos, ImplId, FGenParams, 
				    Interface, MethImpls))
	  ||
	       NameAnalysis (Spec)
	  |)
	  
     'rule' NameAnalysisPairs (Other, Impls) :
	  NameAnalysis (Other)

--------------------------------------------------------------------------
	  
'sweep' NameAnalysis (ANY)
     
     'rule' NameAnalysis (specification (Id, ImportDecls, SpecDecls))
	  ActModuleQualifier <- module (Id)
	  EnterScope
 	  DeclareId (Id, module (SpecDecls))
	  VisitImportDecls (ImportDecls)
	  VisitDecls (SpecDecls)
	  VisitAppls (SpecDecls)
	  NameAnalysis (SpecDecls)
	  LeaveScope
	  
     'rule' NameAnalysis (class (P, Id, FGenParams,
				 localdefs (Super, _,
					    ObjParams, Methspecs, IV),
				 Impls)) :
	  EnterScope
	  VisitInhDecls (Id, Super)
	  VisitFParamDecls (FGenParams)
	  VisitPairDecls (Methspecs, Impls)
	  VisitDecls (IV)
	  VisitDecls (Impls)
	  VisitAppls (FGenParams)
	  VisitAppls (ObjParams)
	  VisitAppls (Methspecs)
	  VisitAppls (IV)
	  VisitAppls (Impls)
	  NameAnalysis (Methspecs)
	  NameAnalysis (Impls)
	  LeaveScope
	  
     'rule' NameAnalysis (classspec (Pos, Id, FGenParams,
				     localdefs (Super, _, ObjParams, 
						Methspecs, IV))) :
	  EnterScope
	  VisitInhDecls (Id, Super)
	  VisitFParamDecls (FGenParams)
	  VisitDecls (Methspecs)
	  VisitDecls (IV)
	  VisitAppls (FGenParams)
	  VisitAppls (ObjParams)
	  VisitAppls (Methspecs)
	  VisitAppls (IV)
	  NameAnalysis (Methspecs)
	  LeaveScope

     'rule' NameAnalysis (classimpl (_, _, _)) :
	  
     'rule' NameAnalysis (methodspec (_, _, _, _, _, FParams, ResultI)) :
	  DefaultPos (-> Pos) 
	  ResultI'Type -> Result
	  NameAnalysisRoutine (FParams, Result, nil (Pos), error)
     
     'rule' NameAnalysis (methodimpl (_, _, _, 
				      FParams, ResultI, Locals, Body)) :
	  ResultI'Type -> Result
	  NameAnalysisRoutine (FParams, Result, Locals, Body)
     
     'rule' NameAnalysis (initially (_, FParams, Locals, Body)) :
	  NameAnalysisRoutine (FParams, simple (void), Locals, Body)
     
     'rule' NameAnalysis (finally (_, Locals, Body)) :
	  NameAnalysisRoutine (nil, simple (void) , Locals, Body)
     
     'rule' NameAnalysis (procspec (_, _, _, _, FParams, ResultI)) :
	  DefaultPos (-> Pos) 
	  ResultI'Type -> Result
	  NameAnalysisRoutine (FParams, Result, nil (Pos), error)
     
     'rule' NameAnalysis (procimpl (_, _, FParams, ResultI, Locals, Body)) :
	  ResultI'Type -> Result
	  NameAnalysisRoutine (FParams, Result, Locals, Body)
	  
     'rule' NameAnalysis (DECL'foreignproc (_, _, _, FParams, ResultI)) :
	  DefaultPos (-> Pos) 
	  ResultI'Type -> Result
	  NameAnalysisRoutine (FParams, Result, nil (Pos), error)
	  
     'rule' NameAnalysis (DECL'exception (_, _, FParams)) :
	  EnterScope
	  VisitFParamDecls (FParams)
	  VisitAppls (FParams)
	  LeaveScope
	  
     'rule' NameAnalysis (handler (_, _, Params, Body)) :
	  EnterScope
	  VisitFParamDecls (Params)
	  VisitAppls (Params)
	  VisitAppls (Body)
	  LeaveScope
     
     'rule' NameAnalysis (typeselect (_, ImplicitVar, Init, Cases, 
				      Otherwise)) :
	  VisitAppls (Init)
	  EnterScope
	  VisitDecls (ImplicitVar)
	  VisitAppls (ImplicitVar)
	  VisitAppls (Cases)
	  VisitAppls (Otherwise)
	  NameAnalysis (Cases)
	  NameAnalysis (Otherwise)
	  LeaveScope

     'rule' NameAnalysis (for (_, ImplicitVar, Range, Step, Body)) :
	  VisitAppls (Range)
	  VisitAppls (Step)
	  EnterScope
	  VisitDecls (ImplicitVar)
	  VisitAppls (ImplicitVar)
	  VisitAppls (Body)
	  NameAnalysis (Body)
	  LeaveScope
	  
---------------------------------------------------------------------------

'action' NameAnalysisRoutine (FParams : FPARAMLIST, Result : TYPE,
			      Locals : DECL, Body : BLOCK)
	  
     'rule' NameAnalysisRoutine (FParams, Result, Locals, Body) :
	  EnterScope
	  VisitFParamDecls (FParams)
	  VisitDecls (Locals)
	  VisitAppls (FParams)
	  VisitAppls (Result)
	  VisitAppls (Locals)
	  VisitAppls (Body)
	  NameAnalysis (Body)
	  LeaveScope

-- ========================================================================
--  VisitDecl predicates handle declaration functors.
-- ------------------------------------------------------------------------
--  VisitImportDecls handles all import clauses. 
--    importitem : the name of the item is announced, the name of the modul
--    is unknown. 
--    import : the name of the module is announced.
--  GetModuleDecls and LookupModuleDecls : get the declarations provided by
--    a specification part of a module given by the module name.
--  VisitPairDecls is a special predicate to handle declarations in the case
--    of an implementation part. Some declarations taken form the
--    specification parts have an implemetation in the implementation part:
--    classspec/classimpl, procspec/proimpl, methodspec/methodimpl. The must
--    not be handled twice.
--  VisitDecls decares each identifier in the actual scope. The meaning part
--    of the identifier is initialized.
--  VisitFParamDecls is a special predicate to handle the declarartion of
--    formal parameters (procedure and method parameters, class parameters
--    and formal generic parameters).
--  VisitInhDecls and VisitSuperDecls announce all inherited featues 
--    (method-specifications and instance variables) from the supertypes of
--    an object type. 
--  DeclareId announces an identifier in the actual scope (a former
--    declaration is hidden in the scope) and defines the meaning field of
--    the ID. 
--  DeclareImportedId announces an imported identifier in the actual scope.
-- ========================================================================

'action' VisitImportDecls (IMPORT)

     'rule' VisitImportDecls (seq (Left, Right)) :
	  VisitImportDecls (Left)
	  VisitImportDecls (Right)
	  
     'rule' VisitImportDecls (importitem (ModuleId, Id)) :
	  GetModuleDecls (ModuleId -> Decls)
	  DefineMeaning (ModuleId, module (Decls))
	  (|
	       LookupDecl (Id, Decls -> Decl)
	       GetDeclId (Decl -> DefId)
	       DeclareImportedId (Id, DefId, ModuleId)
	  ||
	       Id'Ident -> I
	       Id'Pos   -> IPos
	       ErrorI ("'", I, "' is not exported", IPos)
	       DeclareId (Id, error)
	  |)
     
     'rule' VisitImportDecls (importmodule (Id)) :
	  GetModuleDecls (Id -> Decls)
	  DeclareId (Id, module (Decls))
	  
     'rule' VisitImportDecls (_) :
	  
---------------------------------------------------------------------------

'action' GetModuleDecls (ModuleId : ID -> Decls : DECL)
     
     'rule' GetModuleDecls (ModuleId -> Decls) :
	  ImportedModules -> Imports
	  LookupModuleDecls (ModuleId, Imports -> Decls)
	  
     'rule' GetModuleDecls (ModuleId -> Decls) :
	  -- recursive import of the actual specification
	  SpecModule -> Spec
	  LookupModuleDecls (ModuleId, Spec -> Decls)
	  
---------------------------------------------------------------------------

'condition' LookupModuleDecls (ModuleId : ID, AllModules : MODULE -> 
			       Decls : DECL)
     
     'rule' LookupModuleDecls (Id, seq (Left, _) -> Decls) :
	  LookupModuleDecls (Id, Left -> Decls)
     
     'rule' LookupModuleDecls (Id, seq (_, Right) -> Decls) :
	  LookupModuleDecls (Id, Right -> Decls)
     
     'rule' LookupModuleDecls (Id1, specification (Id2, _, Decls) -> Decls) :
	  EqId (Id1, Id2)

---------------------------------------------------------------------------

'action' VisitPairDecls (Specs : DECL, Impls : DECL)
     
     'rule' VisitPairDecls (seq (_, Left, Right), Impls) :
	  VisitPairDecls (Left, Impls)
	  VisitPairDecls (Right, Impls)
     
     'rule' VisitPairDecls (Spec:classspec (_, SId, GenPar, Interface),
			    Impls) :
	  [|
	       LookupClassImpl (SId, Impls -> classimpl (IPos, IId, _))
	       DefineMeaning (IId, definingid (SId))
	  |]
	  VisitDecls (Spec)
	  
     'rule' VisitPairDecls (Spec:procspec (_, SId, Export, CallConv, 
					   _, _), Impls) :
	  [|
	       LookupProcImpl (SId, Impls -> 
			       Impl:procimpl (_, IId, IParams, IResult, 
					      _, _))
	       DefineMeaning (IId, proc (Export, CallConv, IParams, IResult))
	  |]
	  VisitDecls (Spec)
     
     'rule' VisitPairDecls (Spec:methodspec (_, SId, Mode, Abstract, 
					     _, _, _), Impls) :
	  [|
	       LookupMethodImpl (SId, Impls -> 
				 Impl:methodimpl (IPos, IId, _, IParams, 
						  IResult, _, _))
	       DefineMeaning (IId, method (Mode, Abstract, IParams, IResult))
	  |]
	  VisitDecls (Spec)
	  
     'rule' VisitPairDecls (Spec, Impls) :
	  VisitDecls (Spec)
	  
---------------------------------------------------------------------------

'action' VisitDecls (DECL)
     
     'rule' VisitDecls (seq (_, Left, Right)) :
	  VisitDecls (Left)
	  VisitDecls (Right)
	  
     'rule' VisitDecls (type (_, Id, TypeI)) :
	  DeclareId (Id, type (TypeI))

     'rule' VisitDecls (class (Pos, Id, FGenParams, Interface, Impls))
	  NewTypeIndex (Pos, composite (classtype (Id, FGenParams, 
						   Interface)) -> TypeI)
	  DeclareId (Id, type (TypeI))
			
     'rule' VisitDecls (classspec (Pos, Id, FGenParams, Interface)) :
	  NewTypeIndex (Pos, composite (classtype (Id, FGenParams, 
						   Interface)) -> TypeI)
	  DeclareId (Id, type (TypeI))
     
     'rule' VisitDecls (classimpl (_, _,_)) :
	  
     'rule' VisitDecls (const (_, Id, TypeI, Value)) :
	  DeclareId (Id, const (TypeI, Value))
	  
     'rule' VisitDecls (globalvar (Pos, Id, Export, TypeI, _)) :
	  DeclareId (Id, globalvar (Export, TypeI))
	  [|
	       where (Export -> foreign)
	       DefineForeignExport (Pos, Id)
	  |]
	  
     'rule' VisitDecls (localvar (_, Id, TypeI, _)) :
	  DeclareId (Id, localvar (TypeI))
	  
     'rule' VisitDecls (instvar (_, Id, TypeI)) :
	  DeclareId (Id, instvar (TypeI))
     
     'rule' VisitDecls (implicitvar (_, Id)) :
	  UnspecTypeIndex -> TypeI
	  DeclareId (Id, implicitvar (TypeI))

     'rule' VisitDecls (exception (_, Id, Params)) :
	  DeclareId (Id, exception (Params))
	  
     'rule' VisitDecls (procspec (Pos, Id, Export, CallConv, Params, 
				  Result)) :
	  DeclareId (Id, proc (Export, CallConv, Params, Result))
	  (|
	       where (Export -> foreign)
	       DefineForeignExport (Pos, Id)
	  ||
	       where (Export -> root)
	       DefineRoot (Pos, Id)
	       DefineForeignExport (Pos, Id)
	  ||
	  |)
	  
     'rule' VisitDecls (procimpl (_, Id, Params, Result, _, _)) :
	  [|
	       Id'State -> undeclared
	       DeclareId (Id, proc (cool, c, Params, Result))
	  |]
	  
     'rule' VisitDecls (methodspec (_, Id, Mode, Abstract, _, 
				    Params, Result)) :
	  Id'Pos   -> Pos
	  Id'Ident -> I
	  (|
	       HasMeaning (I -> Meaning)
	       GetDefinitionMeaning (Meaning -> method (_, abstract, _, _))
	       DefMeaning (I, definingid (Id))
	       DefineMeaning (Id, method (Mode, Abstract, Params, Result))
	  ||
	       DeclareId (Id, method (Mode, Abstract, Params, Result))
	  |)

     'rule' VisitDecls (methodimpl (_, Id, Methodflag, Params, Result, 
				    _, _)) : 
	  (|
	       Id'State -> declared
	  ||
	       Id'Ident -> I
	       HasMeaning (I -> definingid (DefId))
	       GetIdMeaning (DefId -> method (_, _, _, _))
	       DefineMeaning (Id, definingid (DefId))
	  ||
	       DeclareId (Id, method (private, concrete, Params, Result))
	  |)
     
     'rule' VisitDecls (foreignvar (_, Id, TypeI)) :
	  DeclareId (Id, foreignvar (TypeI))
     
     'rule' VisitDecls (foreignproc (_, Id, CallConv, Params, Result)) :
	  DeclareId (Id, foreignproc (CallConv, Params, Result))
	  
     'rule' VisitDecls (foreigntype (_, Id, TypeI)) :
	  DeclareId (Id, foreigntype (TypeI))
	  
     'rule' VisitDecls (Other) :
	  
---------------------------------------------------------------------------

'action' VisitFParamDecls (FPARAMLIST)
     
     'rule' VisitFParamDecls (fparamlist (Param, Tail)) :
	  VisitFParamDecl (Param)
	  VisitFParamDecls (Tail)
	  
     'rule' VisitFParamDecls (_) :

---------------------------------------------------------------------------
	  
'action' VisitFParamDecl (FPARAM)
     
     'rule' VisitFParamDecl (fparam (_, Id, Mode, TypeI)) :
	  DeclareId (Id, fparam (Mode, TypeI))
     
     'rule' VisitFParamDecl (unconstrained (Pos, Id)) :
	  NewTypeIndex (Pos, generic (unconstrained (Id)) -> TypeI)
	  DeclareId (Id, type (TypeI))
	  
     'rule' VisitFParamDecl (constrained (Pos, Id, Constaint)) :
	  NewTypeIndex (Pos, generic (constrained (Id, Constaint)) -> TypeI)
	  DeclareId (Id, type (TypeI))
	  
---------------------------------------------------------------------------
	  
'action' VisitInhDecls (ID, SUPERTYPE) -- SUPERTYPE is already updated
				       -- (VisitAppl)!!!
     
     'rule' VisitInhDecls (Id1, super (Id2)) :
	  IsDefinedInActualModule (Id2)
	  [|
	       GetIdMeaning (Id2 -> type (BaseTypeI))
	       BaseTypeI'Type -> 
	          composite (classtype (ClassId, _, 
					localdefs (Super, _, _, Meth, IV)))
	       VisitSuperDecls (Id1, ClassId, Super, Meth, IV)
	  |]
	       
     'rule' VisitInhDecls (Id1, super (Id2)) :
          -- not defined in the actual module
	  Id2'Module -> module (MId) 
	  (|
               -- MId already declared
	       GetIdMeaning (MId -> module (Decls))
	  || 
               -- MId yet undeclared => search module in the list of
	       -- imported modules
	       ImportedModules -> Imports
	       LookupModuleDecls (MId, Imports -> Decls)
	  |)
	  [|
	       LookupDecl (Id2, Decls -> 
			   classspec (_, ClassId, _, 
				      localdefs (Super, _, _, Meth, IV)))
	       VisitSuperDecls (Id1, ClassId, Super, Meth, IV)
	  |]
     
     'rule' VisitInhDecls (_, _) :
	  -- SUPERTYPE = super (Id) and Id is erroneous or
	  -- SUPERTYPE = none or 
	  -- SUPERTYPE = error
	  
---------------------------------------------------------------------------
	  
'action' VisitSuperDecls (StartId : ID, SuperId : ID, 
			  SuperSuper : SUPERTYPE, 
			  SuperMeth : DECL, SuperIV : DECL)
     
     'rule' VisitSuperDecls (StartId, SId, _, _, _) :
	  EqQualifiedId (StartId, SId) -- cyclic supertype chain
	  
     'rule' VisitSuperDecls (StartId, _, SSuper, SMeth, SIV) :
	  VisitInhDecls (StartId, SSuper)
	  VisitDecls (SMeth)
	  VisitDecls (SIV)
	  
---------------------------------------------------------------------------
	  
'action' DeclareImportedId (ID, DefdId : ID, ModuleId : ID)
     
     'rule' DeclareImportedId (Id, DefId, ModuleId) :
	  let (definingid (DefId) -> Meaning)
	  let (QUALIFIER'module (ModuleId) -> Qualifier)
	  DefId'Module <- Qualifier
	  Id'State <- declared
	  Id'Meaning <- Meaning
	  Id'Module <- Qualifier
	  Id'Ident -> I
	  Id'Pos   -> Pos
	  Define (Pos, I, Meaning)

---------------------------------------------------------------------------
	  
'action' DeclareId (ID, MEANING)	  
     
     'rule' DeclareId (Id, Meaning:module (Decls)) :
	  DefineMeaning (Id, Meaning)
	  Id'Ident -> I
   	  Id'Pos   -> Pos
	  DefineModule (Pos, I, Decls)
	  
     'rule' DeclareId (Id, Meaning) :
	  DefineMeaning (Id, Meaning)
	  Id'Ident -> I
   	  Id'Pos   -> Pos
	  Define (Pos, I, definingid (Id))

-- ========================================================================
--  VisitAppl handles funtors applying an identifier.
--  UpdateMeaning 	  
--    The meaning of the identifier is set to definingid (DefId), where
--    DefId is the identifier taken from the actual valid declaration or
--    from the given module in the case of the term Moule::Id.
--    The module field of the ID is set to the Qualifier of the actual
--    module (ActModuleQualifier) in the case of a non qualified identifier
--    application. 
-- ========================================================================

'sweep' VisitAppls (ANY)
     
     'rule' VisitAppls (class (_, _, _, Interface, _)) : 
	  Interface'Supertype -> SuperType
	  VisitAppls (SuperType)
     
     'rule' VisitAppls (classspec (_, _, _, Interface)) :
 	  Interface'Supertype -> SuperType
	  VisitAppls (SuperType)
    
     'rule' VisitAppls (SUPERTYPE'super (Id)) :
 	  UpdateMeaning (Id)

     'rule' VisitAppls (typename (Id)) :
     	  UpdateMeaning (Id)

     'rule' VisitAppls (genericinst (Id, Params)) :
	  UpdateMeaning (Id)
	  VisitAppls (Params)

     'rule' VisitAppls (GENERICTYPE'constrained (_, Constraint)) :
	  UpdateMeaning (Constraint)

     'rule' VisitAppls (FPARAM'constrained (_, _, Constraint)) :
	  UpdateMeaning (Constraint)

     'rule' VisitAppls (raise (_, Id, Params)) :
	  UpdateMeaning (Id)
	  VisitAppls (Params)
	  
     'rule' VisitAppls (typecase (_, Id, Body))
	  UpdateMeaning (Id)
	  VisitAppls (Body)
	  
     'rule' VisitAppls (handler (_, Id, _, _)) :
	  UpdateMeaning (Id)
	  
     'rule' VisitAppls (applied (_, Id))
	  UpdateMeaning (Id)
	  
-- these rules handle functors, which have an argument of type TYPEINDEX
-- ('table') or declare a new scope and are handled in NameAnalysis 
-- (= rules with an empty body) 
 
     'rule' VisitAppls (DECL'type (_, _, TypeI)) :
	  TypeI'Type -> Type
	  VisitAppls (Type)
	  
     'rule' VisitAppls (methodspec (_, _, _, _, _, _, _)) :
     
     'rule' VisitAppls (methodimpl (_, _, _, _, _, _, _)) :
     
     'rule' VisitAppls (initially (_, _, _, _)) :
     
     'rule' VisitAppls (finally (_, _, _)) :
     
     'rule' VisitAppls (DECL'const (_, _, TypeI, Init)) :
	  TypeI'Type -> Type
	  VisitAppls (Type)
	  VisitAppls (Init)
	  
     'rule' VisitAppls (DECL'globalvar (_, _, _, TypeI, Init)) :
	  TypeI'Type -> Type
	  VisitAppls (Type)
	  VisitAppls (Init)
	  
     'rule' VisitAppls (DECL'localvar (_, _, TypeI, Init)) :
	  TypeI'Type -> Type
	  VisitAppls (Type)
	  VisitAppls (Init)

     'rule' VisitAppls (DECL'instvar (_, _, TypeI)) :
	  TypeI'Type -> Type
	  VisitAppls (Type)
	  
     'rule' VisitAppls (procspec (_, _, _, _, _, _)) :
     
     'rule' VisitAppls (procimpl (_, _, _, _, _, _)) :
     
     'rule' VisitAppls (DECL'exception (_, _, _)) :
	  
     'rule' VisitAppls (FPARAM'fparam (_, _, _, TypeI)) :
	  TypeI'Type -> Type
	  VisitAppls (Type)
	  
     'rule' VisitAppls (DECL'foreignproc (_, _, _, _, _)) :
	  
     'rule' VisitAppls (DECL'foreignvar (_, _, TypeI)) :
	  TypeI'Type -> Type
	  VisitAppls (Type)
	  
     'rule' VisitAppls (DECL'foreigntype (_, _, TypeI)) :
	  TypeI'Type -> Type
	  VisitAppls (Type)
	  
     'rule' VisitAppls (typeindexlist (TypeI, Tail)) :
	  TypeI'Type -> Type
	  VisitAppls (Type)
	  VisitAppls (Tail)
	  
     'rule' VisitAppls (array (Range, TypeI)) :
	  VisitAppls (Range)
	  TypeI'Type -> Type
	  VisitAppls (Type)
	  
     'rule' VisitAppls (openarray (TypeI)) :
	  TypeI'Type -> Type
	  VisitAppls (Type)
	  
     'rule' VisitAppls (ref (TypeI)) :
	  TypeI'Type -> Type
	  VisitAppls (Type)
	  
     'rule' VisitAppls (procedure (Params, TypeI)) :
	  VisitAppls (Params)
	  TypeI'Type -> Type
	  VisitAppls (Type)
	  
     'rule' VisitAppls (COMPOSITETYPE'method (Params, TypeI)) :
	  VisitAppls (Params)
	  TypeI'Type -> Type
	  VisitAppls (Type)
	  
     'rule' VisitAppls (FIELD'field (_, _, TypeI)) :
	  TypeI'Type -> Type
	  VisitAppls (Type)
	  
     'rule' VisitAppls (typeselect (_, _, _, _, _)) :
     
     'rule' VisitAppls (for (_, _, _, _, _)) :
     
     'rule' VisitAppls (sizeof (_, TypeI)) :
	  TypeI'Type -> Type
	  VisitAppls (Type)
	  
     'rule' VisitAppls (EXPR'new (_, TypeI)) :
	  TypeI'Type -> Type
	  VisitAppls (Type)
	  
---------------------------------------------------------------------------

'action' UpdateMeaning (ID)
     
     'rule' UpdateMeaning (Id) :
	  Id'State -> declared -- already updated
	  
     'rule' UpdateMeaning (Id) :
	  Id'Module -> actual
	  Id'Pos   -> Pos
	  Id'Ident -> Ident
	  Apply (Pos, Ident -> Meaning)
	  (|
	       where (Meaning -> definingid (DefId))
	       DefId'Module -> Qualifier
	  ||
	       ActModuleQualifier -> Qualifier
	  |)
	  Id'Module  <- Qualifier
	  Id'State   <- declared
	  Id'Meaning <- Meaning  
    
     'rule' UpdateMeaning (Id) :
	  Id'Module -> module (ModuleId)
	  ModuleId'Ident -> M
	  ModuleId'Pos   -> MPos
	  ApplyModule (MPos, M -> Decls) 
	  (|
	       LookupDecl (Id, Decls -> Decl)
	       GetDeclId (Decl -> DefId)
	       ModuleId'Meaning <- module (Decls)
	       Id'Meaning <- definingid (DefId)
	  ||
	       (|
		    where (Decls -> error (_)) -- no error msg, if M is not
					       -- declared as module 
	       ||
		    Id'Pos   -> IPos
		    Id'Ident -> I
		    ErrorI ("'", I, "' is not exported", IPos)
	       |)
	       ModuleId'Meaning <- error
	       Id'Meaning <- error
	  |)
	  ModuleId'State <- declared
	  Id'State   <- declared
     
-- ========================================================================
--  Check invalid definitions of types and constants 
--  (see types.g and const.g).
-- ========================================================================

'action' CheckInvalidRecursion (decl : DECL)
     
     'rule' CheckInvalidRecursion (seq (_, Left, Right)) :
	  CheckInvalidRecursion (Left)
	  CheckInvalidRecursion (Right)

     'rule' CheckInvalidRecursion (type (P, Id, TypeI)) :
	  [|
	       TypeI'Type -> Type
	       IsInvalidTypeRec (Id, Type)
	       DefineMeaning (Id, error)
	       Id'Ident -> I
	       ErrorI ("invalid recursion in definition of type '", 
		       I, "'", P)
	  |]
	  
     'rule' CheckInvalidRecursion (foreigntype (P, Id, TypeI)) :
	  CheckInvalidRecursion (type (P, Id, TypeI))
	  
     'rule' CheckInvalidRecursion (const (P, Id, _, Value)) :
	  [|
	       IsInvalidConstRec (Id, Value)
	       DefineMeaning (Id, error)
	       Id'Ident -> I
	       ErrorI ("invalid recursion in definition of constant '", 
		       I, "'", P)
	  |]
	  
     'rule' CheckInvalidRecursion (Other) :
	  
---------------------------------------------------------------------------

'end'

