-----------------------------------------------------------------------------
--                  CooL-V2.0 - destination code interface                 --
-----------------------------------------------------------------------------
--                        type generation routines                         --
--                            Version 1.0, 1993                            --
-----------------------------------------------------------------------------

'module' codetype

'export' GenerateForwardDeclaration
         GenerateForwardSuperDeclaration
         GenerateForwardDeclaredType
         GenerateTypeDeclaration
         GenerateClassSpecification
         GenerateClassForwardSpecification
         GenerateNEWSpecification
         TransformTypeIndex
         TransformType
         TransformResultType
         RecomputeMethodInterface
         ExpandParameterMode
         GenerateTypeIndex
         GenerateType
         GenerateBaseType
         GenerateBaseTypeExtension
         GenerateParameterTypeList
         GenerateParameterTypeList2
         InitCodeType
         BuildRefBaseType
         IsFormalGenericTypeIndex
         GenerateCastIfNecessary
         GenerateCast
         GenerateMethodCast
         SetCast
         ResetCast
         CAST

'use' ast
      extspecs -- DefaultPos
      misc     -- DummyId
      types    -- FollowNameChainIndex
      mapping
      coder
      codedecl -- TransformProcedureType
      codeexpr -- GetArrayDimensions

-----------------------------------------------------------------------------

-- InitCodeType -------------------------------------------------------------

'action' InitCodeType

    'rule' InitCodeType
        InCast <- false

-- GenerateClassForwardSpecification ----------------------------------------

'action' GenerateClassForwardSpecification (ID)

     'rule' GenerateClassForwardSpecification (ClassName)
	  GetIdMeaning (ClassName -> type (TypeIndex))
	  TypeIndex'Flag -> specified

     'rule' GenerateClassForwardSpecification (ClassName)
	  GetIdMeaning (ClassName -> type (TypeIndex))
	  TypeIndex'Type -> 
	     composite (classtype (_, GenParams, interface (_, _, _, _, 
							    IVars)))
	  GenerateTypePrelude (ClassName)
	  GenerateStaticObjectType (ClassName, GenParams, IVars)
	  GenerateTypePostlude (ClassName)
	  TypeIndex'Flag <- specified

-----------------------------------------------------------------------------
-- Generate Type declarations -----------------------------------------------
-----------------------------------------------------------------------------

-- GenerateClassSpecification -----------------------------------------------

-- This predicate generates a class specification. A class specification
-- comprises a static object type (the static object type is a specific
-- memory decription block [see Heap-Management CoolV2.0] for the object
-- type, whereby the static object type is defined as pointer to the specific
-- memory decription in the C-file), the definition of the instance variable
-- record, the definition of the method table record (method access) and
-- the specification of the NEW- and INITIALLY-function.

'action' GenerateClassSpecification (DECL)

     'rule' GenerateClassSpecification 
              (classspec (Pos, ClassName, GenParams, 
			  Interface:interface(Super, _, ObjParams,
					      Methods, InstVars))) :
	  GetDefiningId (ClassName -> ClassName1)
	  (|
	       ClassName1'State -> generated
	  ||
	       ClassName1'State <- marked
	       MapInterface (Interface)
	       GenerateClassForwardSpecification (ClassName)
	       ClassName1'State <- generated
	       GenerateIfdefModule (ClassName) -- tricky tricky
	       GenerateInstanceVariables (ClassName, GenParams, InstVars)
	       GenerateMethodTableSpecification (ClassName, Super, 
						 ObjParams, Methods)
	       GenerateMethodSpecifications (ClassName, Methods)
	       GenerateNEWSpecification (ClassName, GenParams, ObjParams)
	       GenerateNEWInitSpecification (ClassName)
	       GenerateINITIALLYSpecification (ClassName, ObjParams)
	       GenerateFINALLYSpecification (ClassName)
	       GenerateDELETESpecification (ClassName)
	       GenerateEndifModule (ClassName)
	  |)

-- GenerateMethodTableSpecification -----------------------------------------

-- This predicate generates the static object type

'action' GenerateMethodTableSpecification (ID, SUPERTYPE, FPARAMLIST, DECL)

     'rule' GenerateMethodTableSpecification (ClassName, SuperType,
					      ObjParams, Methods)
	  Write ("struct ")
	  GenerateMTabTypeName (ClassName)
	  Writeln ("")
	  Writeln ("{")
	  GenerateSuperType (SuperType)
	  Write( "  void (*C3IFINALLY) (")
--	  GenerateClassName (ClassName)
	  Writeln (");")
	  GenerateMethodSpecificationList (ClassName, Methods)
	  Writeln ("};")

-- GenerateNEWInitSpecification ---------------------------------------------

'action' GenerateNEWInitSpecification( ID )

     'rule' GenerateNEWInitSpecification( ClassName )
	  Write ("void ")
	  GenerateQualifiedCooLName (ClassName)
	  GenerateHiddenName ("NEW")
	  Writeln (" (void);")

-- GenerateNEWSpecification -------------------------------------------------

'action' GenerateNEWSpecification (ClassName : ID, GenParams : FPARAMLIST,
				   ObjParams : FPARAMLIST)

     'rule' GenerateNEWSpecification (ClassName, nil, nil)
	  GenerateClassName (ClassName)
	  Write (" ")
	  GenerateQualifiedCooLName (ClassName)
	  Writeln ("C3INEW (void);")

     'rule' GenerateNEWSpecification (ClassName, nil, ObjParams)
	  GenerateClassName (ClassName)
	  Write (" ")
	  GenerateQualifiedCooLName (ClassName)
	  Write ("C3INEW (")
	  GenerateParameterTypeList (ObjParams)
	  Writeln (");")

     'rule' GenerateNEWSpecification (ClassName, GenParams, nil)
	  GenerateClassName (ClassName)
	  Write (" ")
	  GenerateQualifiedCooLName (ClassName)
	  Write ("C3INEW (")
	  GenerateGenParameterTypeList (GenParams)
	  Writeln (");")

     'rule' GenerateNEWSpecification (ClassName, GenParams, ObjParams)
	  GenerateClassName (ClassName)
	  Write (" ")
	  GenerateQualifiedCooLName (ClassName)
	  Write ("C3INEW (")
	  GenerateGenParameterTypeList (GenParams)
	  Write (", ")
	  GenerateParameterTypeList (ObjParams)
	  Writeln (");")

-- GenerateGenParameterTypeList ---------------------------------------------

'action' GenerateGenParameterTypeList (FPARAMLIST)

     'rule' GenerateGenParameterTypeList (nil)

     'rule' GenerateGenParameterTypeList (fparamlist( _, nil))
	  GenerateHiddenName ("TYPENAME")

     'rule' GenerateGenParameterTypeList (fparamlist( _, List))
	  GenerateHiddenName ("TYPENAME")
	  Write (", ")
	  GenerateGenParameterTypeList (List)

-- GenerateMethodSpecifications ---------------------------------------------

'action' GenerateMethodSpecifications (ID, DECL)

     'rule' GenerateMethodSpecifications (ClassName, seq( _, Left, Right)) :
	  GenerateMethodSpecifications (ClassName, Left)
	  GenerateMethodSpecifications (ClassName, Right)

     'rule' GenerateMethodSpecifications (ClassName, nil (_)) :

     'rule' GenerateMethodSpecifications (ClassName, 
					  methodspec (_, _, _, abstract,
						      _, _, _ )) :

     'rule' GenerateMethodSpecifications (ClassName, 
					  methodspec (_, _, _, _, 
						      inherited, _, _ )) :
     'rule' GenerateMethodSpecifications (ClassName, 
					  methodspec (_, Name, _, _, _,
						      FParams, Result)) :
	  RecomputeMethodInterface (ClassName, FParams, Result ->
				    NewFParams, NewResult)
	  GenerateBaseType (NewResult)
	  GenerateQualifiedCooLName (ClassName)
	  GenerateCooLName (Name)
	  Write (" (")
	  GenerateParameterTypeList (NewFParams)
	  Write (")")
	  GenerateBaseTypeExtension (NewResult)
	  Writeln( ";" )
	   
-- GenerateDELETESpecification ---------------------------------------------

'action' GenerateDELETESpecification (ID)

     'rule' GenerateDELETESpecification (ClassName)
	  Write ("void ")
	  GenerateQualifiedCooLName (ClassName)
	  Write ("C3IDELETE (")
	  GenerateClassName (ClassName)
	  Writeln (") ;")

-- GenerateFINALLYSpecification ---------------------------------------------

'action' GenerateFINALLYSpecification (ID)

     'rule' GenerateFINALLYSpecification (ClassName)
	  Write ("void ")
	  GenerateQualifiedCooLName (ClassName)
	  Write ("C3IFINALLY (")
	  GenerateClassName (ClassName)
	  Writeln (");")

-- GenerateINITIALLYSpecification -------------------------------------------

'action' GenerateINITIALLYSpecification (ID, FPARAMLIST)

     'rule' GenerateINITIALLYSpecification (ClassName, nil)
	  Write ("void ")
	  GenerateQualifiedCooLName (ClassName)
	  Write ("C3IINITIALLY (")
	  GenerateClassName (ClassName)
	  Writeln (");")

     'rule' GenerateINITIALLYSpecification (ClassName, ObjParams)
	  Write ("void ")
	  GenerateQualifiedCooLName (ClassName)
	  Write ("C3IINITIALLY (")
	  GenerateClassName (ClassName)
	  Write (", ")
--        CastStarts
	  GenerateParameterTypeList2 (ObjParams)
--        CastEnds
	  Writeln (");")

-- GenerateSuperType --------------------------------------------------------

'action' GenerateSuperType (SUPERTYPE)

     'rule' GenerateSuperType (super (SuperType))
	  Write ("  struct ")
	  GenerateMTabTypeName (SuperType)
	  Writeln (" * C3ISUPER;")

     'rule' GenerateSuperType (none) 
	  Writeln ("  void * C3ISUPER;")

-- GenerateMethodSpecificationList ------------------------------------------

'action' GenerateMethodSpecificationList (ID, DECL)

     'rule' GenerateMethodSpecificationList (ClassName, seq (_, Left, Right))
	  GenerateMethodSpecificationList (ClassName, Left)
	  GenerateMethodSpecificationList (ClassName, Right)

     'rule' GenerateMethodSpecificationList (_, nil (_))
     
     'rule' GenerateMethodSpecificationList (ClassName,
					     methodspec (_, Name, _, _, _,
							 FParams, Result)) :
	  RecomputeMethodInterface (ClassName, FParams, Result ->
				    NewFParams, NewResult)
	  Write ("  ")
	  GenerateBaseType (NewResult)
	  Write ("(*")
	  GenerateCooLName (Name)
	  Write (") (")
--	  GenerateParameterTypeList (NewFParams) -- problem ATT-C-Compiler
                                                 -- on RM400/600
	  Write (")")
	  GenerateBaseTypeExtension (NewResult)
	  Writeln( ";" )  
	  
-- RecomputeMethodInterface -------------------------------------------------

'action' RecomputeMethodInterface (ClassName : ID, 
				   FParams   : FPARAMLIST, 
				   Result    : TYPEINDEX ->
				   NewFParams : FPARAMLIST, 
				   NewResult : TYPE )

     'rule' RecomputeMethodInterface (ClassName, FParams, ResultI -> 
				      NewFParams, NewResult)
	  CheckResult (ResultI, FParams -> NewResult, FParams2)
	  DefaultPos (-> Pos)
	  CurrentId -> Id
	  NewTypeIndex (Pos, composite (typename (ClassName)) -> TypeI)
	  let (fparamlist (fparam (Pos, Id, in, TypeI), FParams2) -> 
	       NewFParams)

-- CheckResult --------------------------------------------------------------
	 
'action' CheckResult (Result : TYPEINDEX, FParams : FPARAMLIST -> 
		      NewResult : TYPE, NewFParams : FPARAMLIST)
	 
     'rule' CheckResult (Result, FP -> NewResult,
			 fparamlist (fparam (Pos, Id, out, Result), FP)) :
	  FollowNameChainIndex (Result -> composite (array (_, _)))
	  ReturnId -> Id
	  DefaultPos (-> Pos)
	  BuildRefBaseType (Result -> NewResult)
	  
     'rule' CheckResult (Result, FP -> ResultType, FP) :
	  Result'Type -> ResultType
	  
-- BuildRefBaseType ---------------------------------------------------------

'action' BuildRefBaseType( TYPEINDEX -> TYPE )

    'rule' BuildRefBaseType( TypeIndex -> NewType )
        FollowNameChainIndex( TypeIndex -> composite( array( _, BaseType ) ) )
        BuildRefBaseType( BaseType -> NewType )

    'rule' BuildRefBaseType( TypeIndex -> composite( ref( TypeIndex ) ) )

-- GenerateInstanceVariables ------------------------------------------------

-- This predicate generates the instance variables record.

'action' GenerateInstanceVariables (ClassName : ID, GenParams : FPARAMLIST, 
				    InstVars : DECL)

     'rule' GenerateInstanceVariables (_, nil, nil (_))

     'rule' GenerateInstanceVariables (ClassName, GenParams, InstVars)
	  Write ("struct ")
	  GenerateHiddenName ("IV")
	  GenerateQualifiedCooLName (ClassName)
	  Writeln ("")
	  Writeln ("{")
	  GenerateInstances (InstVars)
	  GenerateTypeInfo (GenParams)
	  Writeln ("};")

-- IsFormalGenericTypeIndex---------------------------------------------------
       
'condition' IsFormalGenericTypeIndex (TYPEINDEX -> ID)
     
     'rule' IsFormalGenericTypeIndex (TypeI -> TypeId) :
	  FollowNameChainIndex (TypeI -> generic (unconstrained (TypeId)))
	  
     'rule' IsFormalGenericTypeIndex (TypeI -> TypeId) :
	  FollowNameChainIndex (TypeI -> generic (constrained (TypeId, _)))

-- GenerateTypeInfo ---------------------------------------------------------

'action' GenerateTypeInfo (GenericParams : FPARAMLIST)

    'rule' GenerateTypeInfo (nil)

     'rule' GenerateTypeInfo (fparamlist (Param, List))
	  (|
	       where (Param -> unconstrained (_, Id))
	  ||
	       where (Param -> constrained (_, Id, _))
	  |)
	  Write ("  ")
	  GenerateHiddenName ("TYPE")
	  Write (" ")
	  GenerateCooLName (Id)
	  Writeln (";")
	  GenerateTypeInfo (List)

-- GenerateInstances --------------------------------------------------------

-- This predicate generates an instance variable field. This predicate is
-- quasi the same as GenerateField.

'action' GenerateInstances (DECL)

     'rule' GenerateInstances (seq( _, Left, Right))
	  GenerateInstances (Left)
	  GenerateInstances (Right)

     'rule' GenerateInstances (nil (_))

     'rule' GenerateInstances (instvar (_, Id, TypeI))
	  TransformTypeIndex (TypeI -> ActualType)
	  Write ("  ")
	  GenerateBaseType (ActualType)
	  GenerateCooLName (Id)
	  [|
	       IsFormalGenericTypeIndex (TypeI -> TypeId)
	       GenerateCooLName (TypeId)
	  |]
	  GenerateBaseTypeExtension (ActualType)
	  Writeln( ";" )

-- GenerateStaticObjectType -------------------------------------------------

-- This predicate generates the static object definition (pointer to memory
-- description).

'action' GenerateStaticObjectType (ClassName : ID, GenParams : FPARAMLIST, 
				   InstVars : DECL )

    'rule' GenerateStaticObjectType( ClassName, nil, nil( _ ) )
	Write( "struct " )
	 GenerateMTabTypeName (ClassName)
        Writeln( ";" )
        Write( "typedef struct " )
	  GenerateClassName (ClassName)
        Writeln( "" )
        Writeln( "{" )
        Writeln( "  void *C3IIVR;" )
        Write( "  struct " )
        GenerateMTabTypeName( ClassName )
        Writeln( " *C3IMTABR;" )
        Write( "} * " )
	  GenerateClassName (ClassName)
        Writeln( ";" )
        GenerateMTABRSpecification( ClassName )

    'rule' GenerateStaticObjectType( ClassName, _, _ )
        Write( "struct " )
        GenerateIVRecName( ClassName )
        Writeln( ";" )
        Write( "struct " )
        GenerateMTabTypeName( ClassName )
        Writeln( ";" )
        Write( "typedef struct " )
	  GenerateClassName (ClassName)
        Writeln( "" )
        Writeln( "{" )
        Write( "  struct " )
        GenerateIVRecName( ClassName )
        Writeln( " *C3IIVR;" )
        Write( "  struct " )
        GenerateMTabTypeName( ClassName )
        Writeln( " *C3IMTABR;" )
        Write( "} * " )
	  GenerateClassName (ClassName)
        Writeln( ";" )
        GenerateMTABRSpecification( ClassName )

-- GenerateMTABRSpecification -----------------------------------------------

'action' GenerateMTABRSpecification (ID)

     'rule' GenerateMTABRSpecification (ClassName)
	  Write( "extern struct ")
	  GenerateMTabTypeName (ClassName)
	  Write (" ")
	  GenerateMTabVarName (ClassName)
	  Writeln (";")

-- GenerateTypeDeclaration --------------------------------------------------

-- This predicate generates a type declation. The type declaration has the
-- following form:
--            'typedef' Basetype TypeName BaseTypeExtensions ';'
-- This predicate is only applied for nonobject types.
-- To generate a type declaration the base type must have the state generated
-- or in case of ref record or ref union types the base type must have the
-- state specified (coded in the Flag value). To check this condition the 
-- predicate MapType is used. If while checking the base type a type is found 
-- which was not generated before then this type must be generated in the 
-- C-file first. Depending on the required mapping the type is generated fully
-- or it is only a type specification generated (ref record or ref union type). 

'action' GenerateTypeDeclaration( DECL )

    -- If the actual type to be defined was generated already, 
    -- then this declaration node must be skipped.

    'rule' GenerateTypeDeclaration( type( _, TypeId, TypeIndex ) )
	TypeId'State -> generated
 
    -- The type was not delcared before.
    -- The State of TypeIndex is undeclared
 
     'rule' GenerateTypeDeclaration (type (Pos, TypeId, TypeIndex))
	  TypeId'State <- marked
	  MapTypeIndex (TypeIndex, implementation -> ActualType)
	  GenerateTypePrelude (TypeId)
	  Write ("typedef ")
	  GenerateBaseTypeDeclaration (ActualType, TypeId)
	  GenerateQualifiedCooLName (TypeId)
	  GenerateBaseTypeExtension (ActualType)
	  Writeln (";")
	-- generate forward specification of copy and equal routines in the
	-- case of dynamic strings
	  GenerateTypePostlude (TypeId)
	  TypeId'State <- generated

-- GenerateTypePrelude ------------------------------------------------------

'action' GenerateTypePrelude (TypeId : ID)
     
     'rule' GenerateTypePrelude (TypeId) :
	  Write ("# ifndef ")
	  GenerateIfdefPrelude
	  GenerateQualifiedCooLName (TypeId)
	  Writeln ("")
	  Write ("# define ")
	  GenerateIfdefPrelude
	  GenerateQualifiedCooLName (TypeId)
	  Writeln ("")

-- GenerateTypePostlude -----------------------------------------------------

'action' GenerateTypePostlude (TypeId : ID)
     
     'rule' GenerateTypePostlude (TypeId) :
	  Write ("# endif /* ")
	  GenerateIfdefPrelude
	  GenerateQualifiedCooLName (TypeId)
	  Writeln (" */")
	  
-- TransformType returns the TYPE representation for TYPEINDEX. If the type
-- to be returned is a procedure type which returns a value of type array
-- then this type is transformed to a procedure type which has no return 
-- value (type void) but has an additional out parameter (at the first 
-- position) which has the type of the original return value.
	
-- TransformTypeIndex--------------------------------------------------------

'action' TransformTypeIndex (TYPEINDEX -> TYPE)
     
     'rule' TransformTypeIndex (TypeI -> TransformedType) :
	  TypeI'Type -> Type
	  TransformType (Type -> TransformedType)
	  
-- TransformType -----------------------------------------------------------

'action' TransformType (TYPE -> TYPE)

     'rule' TransformType (Type -> 
			   composite (procedure (fparamlist 
                                    (fparam (NewPos, NewId, out, ResultTypeI),
				     Params), NewResultI)))
	  FollowNameChain (Type -> 
			   composite (procedure (Params, ResultTypeI)))
	  FollowNameChainIndex (ResultTypeI -> composite (array ( _, _ )))
	  ReturnId -> NewId
	  DefaultPos(-> NewPos)
	  BuildRefBaseType (ResultTypeI -> NewResultType)
	  NewTypeIndex (NewPos, NewResultType -> NewResultI)
	  NewResultI'State <- generated

     'rule' TransformType (Type -> Type)

-- TransformMessageType ----------------------------------------------------

'action' TransformMessageType (COMPOSITETYPE -> TYPE)

    'rule' TransformMessageType (method (Params, ResultTypeI) ->
				 composite (procedure (NewParams, NewResultI)))
	 FollowNameChainIndex (ResultTypeI -> composite (array (_, _ )))
	 ReturnId -> NewId
	 DefaultPos (-> NewPos)
	 let (fparamlist (fparam (NewPos, NewId, out, ResultTypeI), Params)
	      -> NewParams)
	 BuildRefBaseType (ResultTypeI -> NewResultType)
	 NewTypeIndex (NewPos, NewResultType -> NewResultI)
	 NewResultI'State <- generated

     'rule' TransformMessageType (method (Params, ResultTypeI) -> 
				  composite (procedure (Params, ResultTypeI)))

-- TransformResultType -----------------------------------------------------

'action' TransformResultType (TYPE -> TYPE)

    'rule' TransformResultType (Type -> 
			  composite( procedure( NewParams, NewResultI)))
	 FollowNameChain (Type -> composite (procedure (Params, ResultTypeI)))
	 FollowNameChainIndex (ResultTypeI -> composite (array ( _, _ )))
	 ReturnId -> NewId
	 DefaultPos (-> NewPos)
	 let (fparamlist (fparam( NewPos, NewId, out, ResultTypeI), 
			  Params) -> NewParams)
	 BuildRefBaseType (ResultTypeI -> NewResultType)
	 NewTypeIndex (NewPos, NewResultType -> NewResultI)
	 NewResultI'State <- generated

     'rule' TransformResultType( Type -> Type )

-- GenerateBaseTypeDeclaration ----------------------------------------------

-- The predicate GenerateBaseTypeDeclaration is only called from the predicate
-- GenerateTypeDeclaration. The typename is used to declare enumerations,
-- records or unions. This typename is used to identify the type (C-compilers
-- map a typedef-name to the original type). The typedef-name and the typename
-- are equal. This is possible because enumerations, records and unions have
-- an own name space in C.

'action' GenerateBaseTypeDeclaration( TYPE, ID )

   'rule' GenerateBaseTypeDeclaration( simple( SimpleType ), _ )
       GenerateSimpleType( SimpleType )

   'rule' GenerateBaseTypeDeclaration( generic( GenericType ), _ )
        GenerateGenericType( GenericType )

   'rule' GenerateBaseTypeDeclaration( composite( CompositeType ), TypeId )
        GenerateCompositeTypeDeclaration( CompositeType, TypeId ) 

-- GenerateBaseType ---------------------------------------------------------

-- This predicate generates an unnamed type. This predicate is used to 
-- generate a type which was applied in any position.

'action' GenerateBaseType( TYPE )

   'rule' GenerateBaseType( simple( SimpleType ) )
       GenerateSimpleType( SimpleType )

   'rule' GenerateBaseType( generic( GenericType ) )
        GenerateGenericType( GenericType )

   'rule' GenerateBaseType( composite( CompositeType ) )
        GenerateCompositeType( CompositeType ) 

-- GenerateBaseTypeExtension ------------------------------------------------

-- Only an array type or an open array type may have base type
-- extensions. These extensions are noted at the end of a type
-- or variable declaration.
--
-- 'typedef' BaseType TypeName BaseTypeExtension ';' or
-- Type VariableName BaseTypeExtension;
--
-- The pointer to a base type is not counted to the base type 
-- extensions (In C pointer and functions are base type extensions). 

'action' GenerateBaseTypeExtension (TYPE)

     'rule' GenerateBaseTypeExtension (composite (array (Range, 
							 BaseTypeIndex))) :
	  (|
	       InCast -> true
	       Write (")")
	  ||
	       Write ("[")
	       GetArrayDimension (Range -> Dimension)
	       WriteInt (Dimension)
	       Write ("]")
	  |)
	  TransformTypeIndex (BaseTypeIndex -> ActualBaseType)
	  GenerateBaseTypeExtension (ActualBaseType)

     'rule' GenerateBaseTypeExtension (composite (openarray (BaseTypeIndex))) :
	  (|
	       InCast -> true
	       Write (")")  -- old version "[]"
	  ||
	       Write ("[]")
	  |)
	  TransformTypeIndex (BaseTypeIndex -> ActualBaseType)
	  GenerateBaseTypeExtension (ActualBaseType)

     'rule' GenerateBaseTypeExtension (composite (ref( BaseTypeIndex))) :
	  SetCast (false -> Save)
	  Write (")")
	  TransformTypeIndex (BaseTypeIndex -> ActualBaseType)
	  GenerateBaseTypeExtension (ActualBaseType)
	  ResetCast (Save)
	 
     'rule' GenerateBaseTypeExtension (composite (procedure (Params, Result)))
	  Write (")(")
	  TransformTypeIndex (Result -> ActualResultType)
	  [|
	       InCast -> false
--	       GenerateParameterTypeList (Params) -- problem ATT-C-Compiler
						  -- on RM600/400
	  |]
	  Write (")")
	  GenerateBaseTypeExtension (ActualResultType)

    'rule' GenerateBaseTypeExtension (_)

-- GenerateCompositeTypeDeclaration -----------------------------------------

-- This predicate generates named types. The attribute named is only used
-- for enumeration, record and union types.
-- An aliassing for object types is not possible in CooLV2.0. Therefore,
-- a predicate for classtype( _, _, _ ) is not necessary.
-- unnamed not yet implemented
	 
'action' GenerateCompositeTypeDeclaration( COMPOSITETYPE, ID )

     'rule' GenerateCompositeTypeDeclaration (typename (TypeName), _) :
	  GetIdMeaning (TypeName -> foreigntype (_))
	  GenerateCName (TypeName)
	  Write (" ")
	  
    'rule' GenerateCompositeTypeDeclaration( typename( TypeName ), _ )
        TypeName'Meaning -> definingid( Id2 )
        Id2'State -> generated
        GenerateQualifiedCooLName( TypeName )
	 Write( " " )
	  
    'rule' GenerateCompositeTypeDeclaration( typename( TypeName ), _ )
        TypeName'Meaning -> definingid( Id2 )
        Id2'Meaning -> type ( TypeIndex )
        TypeIndex'Type -> composite( ActualType )
        GenerateForwardDeclaredType( ActualType, TypeName )

    -- generic type is forward declared

    'rule' GenerateCompositeTypeDeclaration( typename( TypeName ), _ )
        TypeName'Meaning -> definingid( Id2 )
        Id2'Meaning -> type ( TypeIndex )
        TypeIndex'Type -> generic( ActualType )
        GenerateGenericType( ActualType )

    'rule' GenerateCompositeTypeDeclaration( enum( Enumerators ), 
					     EnumTypeNameId       )
	Write( "enum " )
        GenerateQualifiedCooLName( EnumTypeNameId )
        Writeln( "" )
	Writeln( "{" )
	GenerateEnumerators( Enumerators, EnumTypeNameId )
	Write( "} " )

    'rule' GenerateCompositeTypeDeclaration( record( Fields ), 
					     RecordTypeNameId  )
	Write( "struct " )
        GenerateQualifiedCooLName( RecordTypeNameId )
        Writeln( "" )
        Writeln( "{" )
        GenerateFields( Fields )
        Write( "} " )
	
    'rule' GenerateCompositeTypeDeclaration( union( Fields ), 
					     UnionTypeNameId  )
	Write( "union " )
        GenerateQualifiedCooLName( UnionTypeNameId )
        Writeln( "" )
        Writeln( "{" )
        GenerateFields( Fields )
        Write( "} " )
	
    'rule' GenerateCompositeTypeDeclaration( array( Range, BaseTypeI ), _ ) 
	TransformTypeIndex (BaseTypeI -> ActualBaseType )
	GenerateBaseType( ActualBaseType )

    'rule' GenerateCompositeTypeDeclaration( openarray( BaseTypeI ), _ )
	TransformTypeIndex (BaseTypeI -> ActualBaseType )
	GenerateBaseType( ActualBaseType )

    'rule' GenerateCompositeTypeDeclaration( ref( BaseTypeI ), _ )
	TransformTypeIndex (BaseTypeI -> ActualBaseType )
	GenerateBaseType( ActualBaseType )
        Write( "(*" )

     'rule' GenerateCompositeTypeDeclaration (method (_, _), _) :
	  Write ("C3IMETHOD")
	  Write (" ") 
	  
    'rule' GenerateCompositeTypeDeclaration( procedure( Params, ResultI ), _ )
	 TransformTypeIndex (ResultI -> ActualResultType)
	 GenerateBaseType( ActualResultType )
	Write( "(*" )		    

-- GenerateGenericType ------------------------------------------------------

-- This predicate generates the C-representation of generic types.

'action' GenerateGenericType( GENERICTYPE )

    'rule' GenerateGenericType( genericinst( TypeName, ActualParams ) )
        TypeName'Meaning -> definingid( Id2 )
        Id2'State -> generated
	  GenerateClassName (TypeName)
        Write( " " )

    'rule' GenerateGenericType( genericinst( TypeName, ActualParams ) )
        TypeName'Meaning -> definingid( Id2 )
        Id2'Meaning -> type ( TypeIndex )
        TypeIndex'Type -> composite( ActualType )
        GenerateForwardDeclaredType( ActualType, TypeName )

     'rule' GenerateGenericType (unconstrained (_))
	  GenerateHiddenName ("GENERIC ")

    'rule' GenerateGenericType( constrained( _, ConstrainedTypeName ) )
        ConstrainedTypeName'Meaning -> definingid( Id2 )
        Id2'State -> generated
	  GenerateClassName (ConstrainedTypeName)
        Write( " " )

    'rule' GenerateGenericType( constrained( _, ConstrainedTypeName ) )
        ConstrainedTypeName'Meaning -> definingid( Id2 )
        Id2'Meaning -> type ( TypeIndex )
        TypeIndex'Type -> composite( ActualType )
        GenerateForwardDeclaredType( ActualType, ConstrainedTypeName )

-- GenerateSimpleType -------------------------------------------------------

-- GenerateSimpleType generates the C-representations for the CooLV2.0
-- builtin types. This predicate can be used to declare new types and
-- to apply a type (inside composite types or variable declarations).

'action' GenerateSimpleType( SIMPLETYPE )

    'rule' GenerateSimpleType( void )
        Write( "void " )

    'rule' GenerateSimpleType( bool )
        Write( "C3IBOOL " )

    'rule' GenerateSimpleType( shortint )
        Write( "short int " )

    'rule' GenerateSimpleType( unsignedshortint )
        Write( "unsigned short int " )

    'rule' GenerateSimpleType( int )
        Write( "int " )

    'rule' GenerateSimpleType( unsignedint )
        Write( "unsigned int " )

    'rule' GenerateSimpleType( longint )
        Write( "long int " )

    'rule' GenerateSimpleType( unsignedlongint )
        Write( "unsigned long int " )

    'rule' GenerateSimpleType( float )
        Write( "float " )

    'rule' GenerateSimpleType( double )
        Write( "double " )

    'rule' GenerateSimpleType( unsignedchar )
        Write( "unsigned char " )
     
    'rule' GenerateSimpleType( string )
        Write( "C3ISTRING " )

    'rule' GenerateSimpleType( char )
        Write( "char " )

    'rule' GenerateSimpleType( address )
	 Write( "C3IADDRESS " )
	 
     'rule' GenerateSimpleType (niltype) :
	 Write ("void *")
	  
-- GenerateCompositeType ---------------------------------------------------

-- This predicate generates applied types. A type can be applied in field
-- or variable declaration.
-- For typenames two rules are reserved. The first generates the original
-- typename the second the forward declared type (consist of struct/union and
-- typename).
-- For unnamed enumerations are used a predefined enumeration type having
-- only one component (see module predifinitions in the C-file).
-- An aliassing for object types is not possible in CooLV2.0. Therefore,
-- a predicate for classtype( _, _, _ ) is not necessary.
	
'action' GenerateCompositeType( COMPOSITETYPE )

     'rule' GenerateCompositeType (typename (TypeName)) :
	  GetIdMeaning (TypeName -> foreigntype (_))
	  GenerateCName (TypeName)
	  Write (" ")

     'rule' GenerateCompositeType (typename (TypeName))
	  GetDefiningId (TypeName -> Id2)
	  Id2'State -> generated
	  Id2'Meaning -> type (TypeIndex)
	  FollowNameChainIndex (TypeIndex -> BaseType)
	  (|
	       where (BaseType -> composite (classtype (_, _, _)))
	       GenerateClassName (TypeName)
	       Write (" ")
	  ||
	       where (BaseType -> generic (GenericType))
	       GenerateGenericType (GenericType)
	  ||
	       GenerateQualifiedCooLName (TypeName)
	       Write (" ")
	  |)
	  
     'rule' GenerateCompositeType (typename (TypeName))
	  GetIdMeaning (TypeName -> type (TypeIndex))
	  (|
	       TypeIndex'Type -> composite (CompositeType)
	       GenerateForwardDeclaredType (CompositeType, TypeName)
	  ||
	       TypeIndex'Type -> generic (GenericType)
	       GenerateGenericType (GenericType)
	  |)

    'rule' GenerateCompositeType( enum( Enumerators ) )
	Write( "C3IENUM " )

    'rule' GenerateCompositeType( record( Fields ) )
	Writeln( "struct" )
        Writeln( "{" )
        GenerateFields( Fields )
        Write( "} " )
	
    'rule' GenerateCompositeType( union( Fields ) )
	Writeln( "union" )
        Writeln( "{" )
        GenerateFields( Fields )
        Write( "} " )
	
     'rule' GenerateCompositeType (array (Range, BaseTypeI)) :
	  TransformTypeIndex (BaseTypeI -> ActualBaseType)
	  GenerateBaseType (ActualBaseType)
	  [|
	       InCast -> true
	       Write ("(*")
	  |]

     'rule' GenerateCompositeType (openarray (BaseTypeI)) :
	  TransformTypeIndex (BaseTypeI -> ActualBaseType)
	  GenerateBaseType (ActualBaseType)
	  [|
	       InCast -> true
	       Write( "(*" )
	  |]

     'rule' GenerateCompositeType (ref (BaseTypeI))
	  SetCast (false -> Save)
	  TransformTypeIndex (BaseTypeI -> ActualBaseType)
	  GenerateBaseType (ActualBaseType)
	  ResetCast (Save)
	  Write ("(*")

     'rule' GenerateCompositeType (Type:method( Params, Result))
	  Write ("C3IMETHOD ")

    'rule' GenerateCompositeType( procedure( Params, ResultI ) )
	TransformTypeIndex (ResultI -> ActualResultType)
        GenerateBaseType( ActualResultType )
	Write( "(*" )
     
    'rule' GenerateCompositeType( classtype( Id, _, _ ) )
	 GenerateCompositeType (typename (Id))
	  
-- GenerateFields -----------------------------------------------------------

-- This predicate generates the fields of a record or union type.

'action' GenerateFields( FIELD )

    'rule' GenerateFields( seq( Left, Right ) )
        GenerateFields( Left )
        GenerateFields( Right )

    'rule' GenerateFields( nil )

    'rule' GenerateFields( field( Pos, FieldNameId, TypeIndex ) )
	TransformTypeIndex (TypeIndex -> ActualType)
        GenerateBaseType( ActualType )
        GenerateCooLName( FieldNameId )
        GenerateBaseTypeExtension( ActualType )
        Writeln( ";" )

-- GenerateEnumerators ------------------------------------------------------

-- This predicate generates the enumerators. An enumerator has the form:
--                C3ImoduleC3ItypeEnumeratorName

'action' GenerateEnumerators( ENUMERATORLIST, ID )

    'rule' GenerateEnumerators( enumeratorlist( Enumerator, nil ), TypeNameId )
        GenerateEnumerator( Enumerator, TypeNameId )

    'rule' GenerateEnumerators( enumeratorlist( Enumerator, List ), TypeNameId )
        GenerateEnumerator( Enumerator, TypeNameId )
        Writeln( "," )
        GenerateEnumerators( List, TypeNameId )

    'rule' GenerateEnumerators( nil, _ )

-- GenerateEnumerator -------------------------------------------------------

'action' GenerateEnumerator( ENUMERATOR, ID )

    'rule' GenerateEnumerator( enumerator( Pos, NameId ), TypeNameId )
	 GenerateQualifiedCooLName (TypeNameId)
	 GenerateCooLName (NameId)

-- GenerateParameterTypeList ------------------------------------------------

-- This predicate generates a parameter type list. In case of the list
-- is empty a special rule is applied.

'action' GenerateParameterTypeList( FPARAMLIST )

    'rule' GenerateParameterTypeList( nil )
        Write( "void" )

    'rule' GenerateParameterTypeList( List )
        GenerateParameterTypeList2( List )

-- GenerateParameterTypeList2 ----------------------------------------------

'action' GenerateParameterTypeList2( FPARAMLIST )

     'rule' GenerateParameterTypeList2 (fparamlist (Param, nil))
	  GenerateParameterType (Param)

     'rule' GenerateParameterTypeList2 (fparamlist (Param, List))
	  GenerateParameterType (Param)
	 Write (", ")
	  GenerateParameterTypeList2 (List)

     'rule' GenerateParameterTypeList2 (ellipsis)
	  Write ("...")

     'rule' GenerateParameterTypeList2 (nil)

-- GenerateParameterType --------------------------------------------------

-- This predicate generates a parameter type. The mode of the parameter
-- is expanded and with the parameter type connected.

'action' GenerateParameterType( FPARAM )

    'rule' GenerateParameterType( fparam( Pos, _, Mode, TypeIndex ) )
	 ExpandParameterMode( Mode, TypeIndex -> ParameterType )
	 GenerateBaseType( ParameterType )
	 GenerateBaseTypeExtension( ParameterType )

    'rule' GenerateParameterType( unconstrained( _, _) )
        Write( "C3IC3IGENERIC " )

    'rule' GenerateParameterType( constrained( _, _, Constrained ) )
        GetDefiningId( Constrained -> Id2 )
        Id2'State -> generated
	  GenerateClassName (Constrained)
        Write( " " )

     'rule' GenerateParameterType (constrained (_, _, Constrained))
	  GetIdMeaning (Constrained -> type (TypeIndex))
	  TypeIndex'Type -> composite (ActualType)
	  GenerateForwardDeclaredType (ActualType, Constrained)

     'rule' GenerateParameterType (constrained (_, _, Constrained))
	  GetIdMeaning (Constrained -> type (TypeIndex))
	  TypeIndex'Type -> generic (genericinst (TypeName, _ ))
	  GetDefiningId (TypeName -> TypeName1)
	  GenerateCompositeType (typename (TypeName1))

-- GenerateParamNameIfCast ------------------------------------------------
	 
'action' GenerateParamNameIfCast (ID, INT)
     
     'rule' GenerateParamNameIfCast (Id, N) :
	  InCast -> true
	  DummyId -> DId
	  (|
	       eq (DId, Id)
	       GenerateHiddenName ("")
	       WriteInt (N)
	  ||
	       GenerateCooLName (Id)
	  |)
	  
     'rule' GenerateParamNameIfCast (_, _) :
	  
-- GenerateTypeIndex --------------------------------------------------------

'action' GenerateTypeIndex (TYPEINDEX)

     'rule' GenerateTypeIndex (TypeI)
	  TypeI'Type -> Type
	  GenerateType (Type)

-- GenerateType -------------------------------------------------------------

'action' GenerateType (TYPE)

     'rule' GenerateType (Type)
	  TransformType (Type -> ActualType) 
	  GenerateBaseType (ActualType)
	  GenerateBaseTypeExtension (ActualType)

-- GenerateParameterMode ----------------------------------------------------

-- This predicate expands the parameter mode

'action' ExpandParameterMode (PMODE, TYPEINDEX -> TYPE)

     'rule' ExpandParameterMode (_, TypeI -> Type)
	  FollowNameChainIndex (TypeI -> composite (array (_, _ )))
	  TypeI'Type -> Type

     'rule' ExpandParameterMode (_, TypeI -> Type)
	  FollowNameChainIndex (TypeI -> composite( openarray( _ )))
	  TypeI'Type -> Type

     'rule' ExpandParameterMode (in, TypeI -> Type)
	  TypeI'Type -> Type

     'rule' ExpandParameterMode (Mode, TypeI -> composite (ref (TypeI)))

-----------------------------------------------------------------------------
-- Forward declarations -----------------------------------------------------
-----------------------------------------------------------------------------
--
-- Forward declarations are necessary if a struct or union type is used
-- in a type definition which will be defined later. This situation appears
-- often in case of list type definitions.
-- An undefined struct or union type can be used also in a procedure type
-- definition (pointer to function), but this type is allowed to use only
-- after the struct or union type was defined.
--
-- The generated forward declaration has this form:
--
--   struct/union C3IModuleNameC3ITypeName;
--
--   for object types:
--
--   struct C3IModuleNameC3ITypeName;
--
-- GenerateForwardDeclaration -----------------------------------------------

'action' GenerateForwardDeclaration( ID , TYPEINDEX )

    'rule' GenerateForwardDeclaration( TypeID, TypeIndex )
        TypeIndex'Type -> composite( union( _ ) )
        GenerateIfdefModule( TypeID )
        Write( "union " )
        GenerateQualifiedCooLName( TypeID )
        Writeln( ";" )
        GenerateEndifModule( TypeID )

    'rule' GenerateForwardDeclaration( TypeID, TypeIndex )
        TypeIndex'Type -> composite( record( _ ) )
        GenerateIfdefModule( TypeID )
        Write( "struct " )
        GenerateQualifiedCooLName( TypeID )
        Writeln( ";" )
	-- generate forward specification of copy and equal routines in the
	-- case of dynamic strings
        GenerateEndifModule( TypeID )

    'rule' GenerateForwardDeclaration( TypeID, TypeIndex )
        TypeID'Pos -> Pos
        GenerateTypeDeclaration( type( Pos, TypeID, TypeIndex ) )

-- GenerateForwardDeclaredType ----------------------------------------------

-- This predicate generates for an applied type the forward notation if
-- the applied type is not generated.
-- A classtype is generated as pointer to object type.

'action' GenerateForwardDeclaredType( COMPOSITETYPE, ID )

    'rule' GenerateForwardDeclaredType( union( _ ) , TypeName )
        Write( "union " )
        GenerateQualifiedCooLName( TypeName)
        Write( " " )

    'rule' GenerateForwardDeclaredType( record( _ ), TypeName )
        Write( "struct " )
        GenerateQualifiedCooLName( TypeName)
        Write( " " )

    'rule' GenerateForwardDeclaredType( classtype( _, _, _ ), TypeName )
	  GenerateClassName (TypeName)
	 Write( " " )

-- GenerateForwardSuperDeclaration ------------------------------------------

-- This predicate generates a forward declaration of the method table
-- record of nongenerated super type.

'action' GenerateForwardSuperDeclaration (ID)

     'rule' GenerateForwardSuperDeclaration (SuperType)
	  GenerateIfdefModule (SuperType)
	  Write ("struct ")
	  GenerateMTabTypeName (SuperType)
	  Writeln (";")
	  GenerateEndifModule (SuperType)

-- GenerateIfdefModule ------------------------------------------------------

'action' GenerateIfdefModule (ID)

     'rule' GenerateIfdefModule (TypeName)
	  TypeName'Module -> module (ModuleName)
	  (|
	       CurrentModule -> CurrentModuleId
	       EqId (ModuleName, CurrentModuleId)
	  ||
	       GetIDString (ModuleName -> ModuleNameString)
	       Write ("# ifndef ")
	       GenerateIfdefPrelude
	       Write (ModuleNameString)
	       Writeln ("")
	  |)


-- GenerateEndifModule ------------------------------------------------------

'action' GenerateEndifModule (ID)

     'rule' GenerateEndifModule (TypeName)
	  TypeName'Module -> module (ModuleName)
	  (|
	       CurrentModule -> CurrentModuleId
	       EqId (ModuleName, CurrentModuleId)
	  ||
	       GetIDString (ModuleName -> ModuleNameString)
	       Write ("# endif /*")
	       GenerateIfdefPrelude
	       Write (ModuleNameString)
	       Writeln ("*/")
	  |)

-- ========================================================================
--  Casts
-- ========================================================================

'type' CAST
     true
     false

'var' InCast : CAST

'action' SetCast (New : CAST -> Old : CAST)

     'rule' SetCast (New -> Old)
	  InCast -> Old  
	  InCast <- New

'action' ResetCast (Old : CAST)

     'rule' ResetCast (Old)
	  InCast <- Old

-- GenerateCastIfNecessary --------------------------------------------------

'action' GenerateCastIfNecessary (ActualType : TYPE, ExpectedType : TYPE, 
				  Mode : PMODE)
     
     'rule' GenerateCastIfNecessary (ActualType:composite (typename (_)), 
				     ExpectedType, Mode) :
	  FollowNameChain (ActualType -> ActualType2)
	  GenerateCastIfNecessary (ActualType2, ExpectedType, Mode)
     
     'rule' GenerateCastIfNecessary (ActualType, 
				     ExpectedType:composite (typename (_)), 
				     Mode) :
	  FollowNameChain (ExpectedType -> ExpectedType2)
	  GenerateCastIfNecessary (ActualType, ExpectedType2, Mode)
     
     'rule' GenerateCastIfNecessary (simple (niltype), ExpectedType, Mode) :
	  GenerateCast (ExpectedType, Mode)
	  
     'rule' GenerateCastIfNecessary (simple (address), ExpectedType, Mode) :
	  (|
	       where (ExpectedType -> simple (address))
	  ||
	       GenerateCast (ExpectedType, Mode)
	  |)
	  
     'rule' GenerateCastIfNecessary (composite (classtype (Id1, _, _)), 
				     ExpectedType, Mode) :
	  (|
	       where (ExpectedType -> composite (classtype (Id2, _, _)))
	       NeQualifiedId (Id1, Id2)
	  ||
	       where (ExpectedType -> generic (genericinst (Id2, _)))
	       NeQualifiedId (Id1, Id2)
	  ||
	       where (ExpectedType -> generic (unconstrained (_)))
	  ||
	       where (ExpectedType -> generic (constrained (_, Id2)))
	       NeQualifiedId (Id1, Id2)
	  |)
	  GenerateCast (ExpectedType, Mode)
	  
	  
     'rule' GenerateCastIfNecessary (generic (genericinst (Id1,_)), 
				     ExpectedType, Mode) :
	  GenerateCastIfNecessary (composite (typename (Id1)), 
				   ExpectedType, Mode)
     
     'rule' GenerateCastIfNecessary 
               (ActualType:generic (unconstrained (_)), ExpectedType, Mode) :
	  (|
	       where (ExpectedType -> composite (classtype (_, _, _)))
	  ||
	       where (ExpectedType -> generic (genericinst (_, _)))
	  ||
	       where (ExpectedType -> generic (constrained (_, _)))
	  |)
	  GenerateCast (ExpectedType, Mode)
     
     'rule' GenerateCastIfNecessary 
               (ActualType:generic (constrained (_, CId)), 
		ExpectedType, Mode) :
	  GenerateCastIfNecessary (composite (typename (CId)), ExpectedType, 
				   Mode)
	  
     'rule' GenerateCastIfNecessary (composite (procedure (_, _)), 
				     ExpectedType, Mode) :
	  GenerateCast (ExpectedType, Mode)
	  
     'rule' GenerateCastIfNecessary (_, _, _) :
	  
-- GenerateCast -------------------------------------------------------------

'action' GenerateCast (Type : TYPE, Mode : PMODE)

     'rule' GenerateCast (Type, in) :
	  Write ("(")
	  SetCast (true -> Save)
	  GenerateType (Type)
	  ResetCast (Save)
	  Write (")")
	  
     'rule' GenerateCast (Type, OtherMode) :
	  Write ("(")
	  DefaultPos (-> Pos)
	  NewTypeIndex (Pos, Type -> BaseTypeI)
	  SetCast (true -> Save)
	  GenerateType (composite (ref (BaseTypeI)))
	  ResetCast (Save)
	  Write (")")

-- GenerateMethodCast -------------------------------------------------------

'action' GenerateMethodCast (FPARAMLIST, TYPEINDEX)

     'rule' GenerateMethodCast (FParams, ResultI)
	  SetCast (true -> Save)
	  CheckResult (ResultI, FParams -> NewResult, NewFParams)
	  Write ("(")
	  GenerateBaseType (NewResult)
	  Write ("(*)() ")
	  GenerateBaseTypeExtension (NewResult)
	  Write (")")
	  ResetCast (Save)


