-----------------------------------------------------------------------------
--                  CooL-V2.0 - destination code interface                 --
-----------------------------------------------------------------------------
--                       statement generation routines                     --
--                            Version 1.0, 1993                            --
-----------------------------------------------------------------------------

'module' codestmt

'export' 
     InitCodeStmt
     GenerateStatements
     GenerateBody
     GenerateTemporary
     Temporaries
     GenerateLineInfo

'use' ast
      extspecs
      misc
      types
      codeexpr
      codetype
      codedecl

-----------------------------------------------------------------------------

'var' Temporaries : INT
'var' TypeSelects : INT
'var' ActualTry : INT
'var' ActLabel : INT     -- actual label number
'var' ActExitLabel : INT -- actual exit label number

'var' TryProcPrelude : TRY_PRELUDE
'var' TryLoopPrelude : TRY_PRELUDE

'type' TRY_PRELUDE
    true
    false

-- InitCodeStmt -------------------------------------------------------------

'action' InitCodeStmt

     'rule' InitCodeStmt
	  TypeSelects <- 0
	  ActualTry <- 0
	  ActLabel <- 0
	  ActExitLabel <- 0

-- GenerateProcPrelude ------------------------------------------------------

'action' GenerateProcPrelude (STMT)

     'rule' GenerateProcPrelude (Stmts)
	  StatementsContainTry (Stmts)
	  TryProcPrelude <- true
	  Writeln ("int C3IC3ISaveRtnExcLevel = C3IC3IExceptLevel;")
	  Writeln ("jmp_buf C3IC3IRtnExceptBuf;")
	  Writeln ("C3IC3IMemCpy (&C3IC3IRtnExceptBuf, &C3IC3ICurrExceptBuf, sizeof (jmp_buf));")

     'rule' GenerateProcPrelude (_)
	  TryProcPrelude <- false

-- GenerateProcPostlude ------------------------------------------------------

'action' GenerateProcPostlude

     'rule' GenerateProcPostlude
	  TryProcPrelude -> true
	  Writeln ("C3IC3IExceptLevel = C3IC3ISaveRtnExcLevel;")
	  Writeln ("C3IC3IMemCpy (&C3IC3ICurrExceptBuf, &C3IC3IRtnExceptBuf, sizeof (jmp_buf));")

     'rule' GenerateProcPostlude

-- GenerateLoopPrelude ------------------------------------------------------

'action' GenerateLoopPrelude (STMT)

     'rule' GenerateLoopPrelude (Stmts)
	  StatementsContainTry (Stmts)
	  TryLoopPrelude <- true
	  Writeln ("int C3IC3ISaveLoopExcLevel = C3IC3IExceptLevel;")
	  Writeln ("jmp_buf C3IC3ILoopExceptBuf;")
	  Writeln ("C3IC3IMemCpy (&C3IC3ILoopExceptBuf, &C3IC3ICurrExceptBuf, sizeof (jmp_buf));")

     'rule' GenerateLoopPrelude (_)
	  TryLoopPrelude <- false

-- GenerateLoopPostlude ------------------------------------------------------

'action' GenerateLoopPostlude

     'rule' GenerateLoopPostlude
	  TryLoopPrelude -> true
	  Writeln ("C3IC3IExceptLevel = C3IC3ISaveLoopExcLevel;")
	  Writeln ("C3IC3IMemCpy (&C3IC3ICurrExceptBuf, &C3IC3ILoopExceptBuf, sizeof (jmp_buf));")

     'rule' GenerateLoopPostlude

-- StatementsContainTry -----------------------------------------------------

'condition' StatementsContainTry( STMT )

    'rule' StatementsContainTry( seq( _, Left, Right ) )
        StatementsContainTry( Left )

    'rule' StatementsContainTry( try( _, _, _, _ ) )

    'rule' StatementsContainTry( seq( _, Left, Right ) )
        StatementsContainTry( Right )
 
    'rule' StatementsContainTry( ifelse( _, _, Then, Else ) )
        StatementsContainTry( Then )

    'rule' StatementsContainTry( ifelse( _, _, Then, Else ) )
        StatementsContainTry( Else )

    'rule' StatementsContainTry( select( _, _, Cases, Otherwise ) )
	CasesContainTry( Cases )
				
    'rule' StatementsContainTry( select( _, _, Cases, Otherwise ) )
        StatementsContainTry( Otherwise )
				
    'rule' StatementsContainTry( typeselect( _, _, _, TypeCases, Otherwise ) )
        TypeCasesContainTry( TypeCases )
				
    'rule' StatementsContainTry( typeselect( _, _, _, TypeCases, Otherwise ) )
        StatementsContainTry( Otherwise )
				
    'rule' StatementsContainTry( loop( _, block( _, _, Body ) ) )
	StatementsContainTry( Body )

    'rule' StatementsContainTry( while( _, _, block( _, _, Body ) ) )
	StatementsContainTry( Body )

    'rule' StatementsContainTry( for( _, _, _, _, block( _, _, Body ) ) )
	StatementsContainTry( Body )

-- CasesContainTry ----------------------------------------------------------

'condition' CasesContainTry( CASE )

    'rule' CasesContainTry( seq( Left, Right ) )
        CasesContainTry( Left )

    'rule' CasesContainTry( seq( Left, Right ) )
        CasesContainTry( Right )

    'rule' CasesContainTry( case( _, _, Body ) )
        StatementsContainTry( Body )

-- TypeCasesContainTry ------------------------------------------------------

'condition' TypeCasesContainTry( TYPECASE )

    'rule' TypeCasesContainTry( seq( Left, Right ) )
        TypeCasesContainTry( Left )

    'rule' TypeCasesContainTry( seq( Left, Right ) )
        TypeCasesContainTry( Right )

    'rule' TypeCasesContainTry( typecase( _, _, Body ) )
        StatementsContainTry( Body )

-- Incr ---------------------------------------------------------------------

'action' Incr( INT -> INT )

    'rule' Incr( Int -> Int + 1 )

-- GenerateTemporaryDecl ----------------------------------------------------

'action' GenerateTemporaryDecl (INT, TYPE)

    'rule' GenerateTemporaryDecl (Number, Type)
	 TransformType (Type -> ActualType)
	 GenerateBaseType (ActualType)
	 GenerateTemporary (Number)
	 GenerateBaseTypeExtension (ActualType)
	 Writeln (";")

-- GenerateMethodTemporaryDecl -----------------------------------------------

'action' GenerateMethodTemporaryDecl (INT)

     'rule' GenerateMethodTemporaryDecl (Number)
	  Write ("C3IMETHOD ")
	  GenerateTemporary (Number)
	  Writeln (";")

-- GenerateTemporary --------------------------------------------------------

'action' GenerateTemporary (INT)

     'rule' GenerateTemporary (Number)
	  GenerateHiddenName ("TEMP")
	  WriteInt (Number)

-- GenerateObjectTemporaryDecl ----------------------------------------------

'action' GenerateObjectTemporaryDecl (EXPR, INT)

     'rule' GenerateObjectTemporaryDecl (Object, Number)
	  GetExpressionRealType (Object -> ObjectType)
	  GenerateBaseType (ObjectType)
	  GenerateTemporary (Number)
	  GenerateBaseTypeExtension (ObjectType)
	  Writeln (";")

-- AllocTemporary -------------------------------------------------------

'sweep' AllocTemporary (ANY, INT -> INT)
     
     'rule' AllocTemporary (methodpointer (_, _, Object:call (_, _, _, _, _), 
					   MethodName), N1 -> N2) :
	  GenerateObjectTemporaryDecl (Object, N1)
	  AllocTemporary (Object, N1 + 1 -> N2)
	  
     'rule' AllocTemporary (call (_, _, RealResult, Receiver, AParams), 
			    N1 -> N3) :
	  AllocReceiverTemporary (Receiver, AParams, N1 -> N2)
	  (|
	       FollowNameChain (RealResult -> composite (array( _, _ )))
	       GenerateTemporaryDecl (N2, RealResult)
	       AllocTemporary (AParams, N2 + 1 -> N3)
	  ||
	       AllocTemporary (AParams, N2 -> N3)
	  |)
	  
     'rule' AllocTemporary (dyop (_, _, eq, Left, Right), N1 -> N3)
	  AllocDyOpTemporary (Left, N1 -> N2)
	  AllocDyOpTemporary (Right, N2 -> N3)

     'rule' AllocTemporary (dyop (_, _, ne, Left, Right), N1 -> N3)
	  AllocDyOpTemporary (Left, N1 -> N2)
	  AllocDyOpTemporary (Right, N2 -> N3)

     'rule' AllocTemporary (typeselect (_, _, Init, TypeCases, Otherwise),
			    N1 -> N3)
	  AllocTemporary (Init, N1 -> N2)
	  -- TypeCases is done while generation
	  AllocTemporary (Otherwise, N2 -> N3)

-- AllocReceiverTemporary ----------------------------------------------------

'action' AllocReceiverTemporary (RECEIVER, APARAMLIST, INT -> INT)

     'rule' AllocReceiverTemporary (method (Object, _), AParams, N1 -> N2) :
	  (|
	       where (Object -> call (_, _, _, _, _))
	  ||
	       ContainsCall (AParams)
	  |)
	  GenerateObjectTemporaryDecl (Object, N1)
	  AllocTemporary (Object, N1 + 1 -> N2)
     
     'rule' AllocReceiverTemporary (method (Object, _), _, N1 -> N2) :
	  AllocTemporary (Object, N1 -> N2)

     'rule' AllocReceiverTemporary (procexpr (Expr), _, N1 -> N2) :
	  AllocTemporary (Expr, N1 -> N2)

     'rule' AllocReceiverTemporary (methodexpr( MethodPtr ), _, N1 -> N2) :
	  GenerateMethodTemporaryDecl (N1)
	  AllocTemporary (MethodPtr, N1 + 1 -> N2)

     'rule' AllocReceiverTemporary (_, _, N -> N) :

-- AllocDyOpTemporary -----------------------------------------------------

'action' AllocDyOpTemporary (EXPR, INT -> INT)
     
     'rule' AllocDyOpTemporary (Expr:call (_, _, RealResult, _, _), N1 ->
				N2) :
	  FollowNameChain (RealResult -> Type)
	  (|
	       where (Type -> composite (array (_, _)))
	       AllocTemporary (Expr, N1 -> N2)
	  ||
	       NeededEqualFunction (Type)
	       GenerateTemporaryDecl (N1, RealResult)
	       AllocTemporary (Expr, N1 + 1 -> N2)
	  |)
	  
     'rule' AllocDyOpTemporary (Expr, N1 -> N2) :
	  AllocTemporary (Expr, N1 -> N2)
	  
-- GenerateBody -------------------------------------------------------------

'action' GenerateBody (STMT, DECL)

     'rule' GenerateBody (Statements, Locals)
	  AllocTemporary (Statements, 0 -> NewNumber)
	  Temporaries <- 0
	  GenerateProcPrelude (Statements)
	  GenerateLocalVarInit (Locals)
	  GenerateStatements (Statements)
	  GenerateProcPostlude

-- GenerateLocalVarInit -----------------------------------------------------

'action' GenerateLocalVarInit (DECL)

     'rule' GenerateLocalVarInit (seq (_, Left, Right))
	  GenerateLocalVarInit (Left)
	  GenerateLocalVarInit (Right)
	  
     'rule' GenerateLocalVarInit (localvar (_, _, _, nil (_)))
     
     'rule' GenerateLocalVarInit (localvar (Pos, LocalId, _, Init))
	  GenerateLineInfo (Pos)
	  GenerateCooLName (LocalId)
	  Write (" = ")
	  GenerateEnclosedExpr (Init)
	  Writeln (";")
			    
     'rule' GenerateLocalVarInit (nil (_))
	  
-- GenerateStatement --------------------------------------------------------

'action' GenerateStatements( STMT )

    'rule' GenerateStatements( seq( _, Left, Right ) )
        GenerateStatements( Left )
        GenerateStatements( Right )
    
    -- Replace substing in destination String1[lwb..upb] := String2 or ".."

     'rule' GenerateStatements (assign (Pos, _,
					substring (_, String, 
						   range (_, Lwb, Upb)), 
					Source))
	  GenerateLineInfo (Pos)
	  Write ("C3IC3IReplaceSubString (&")
	  GenerateEnclosedExpr (String)
	  Write (", ")
	  GenerateEnclosedExpr (Lwb)
	  Write (", ")
	  GenerateEnclosedExpr (Upb)
	  Write (", ")
	  GenerateEnclosedExpr (Source)
	  Writeln (");")

    -- Replace Character in destination String1[Index] := Character

     'rule' GenerateStatements (assign (Pos, _, 
					stringsubscr (_, String, Index),
					Source))
	  GenerateLineInfo (Pos)
	  Write ("C3IC3IReplaceChar (&")
	  GenerateEnclosedExpr (String)
	  Write (", ")
	  GenerateEnclosedExpr (Index)
	  Write (", ")
	  GenerateEnclosedExpr (Source)
	  Writeln (");")

    -- Assignment of a string literal to a array of char
	  
     'rule' GenerateStatements (assign (Pos, TypeI,
					Dest, stringliteral (_, Value)))
	  FollowNameChainIndex (TypeI -> composite (array (_, _)))
	  GenerateLineInfo (Pos)
	  Write ("C3IC3IStrCpy (")
	  GenerateEnclosedExpr (Dest)
	  Write (", ")
	  WriteString (Value)
	  Writeln (");")

    -- Assignment of a string literal to a ref array of char
	  
     'rule' GenerateStatements (assign (Pos, TypeI,
					Dest, stringliteral (_, Value)))
	  FollowNameChainIndex (TypeI -> composite (ref (_)))
	  GenerateLineInfo (Pos)
	  GenerateEnclosedExpr (Dest)
	  Write ("= (char (*) [])")
	  WriteString (Value)
	  Writeln (";")

    -- Assigment of a string or stringliteral to a string

    'rule' GenerateStatements (assign (Pos, TypeIndex, Dest, Source))
	 FollowNameChainIndex (TypeIndex -> simple (string))
	 GenerateLineInfo (Pos)
	 Write ("C3IC3ICopyString (&")
	 GenerateEnclosedExpr (Dest)
	 Write (", ")
	 GenerateEnclosedExpr (Source)
	 Writeln (");")

    -- NIL-assignment to a method pointer

     'rule' GenerateStatements (assign (Pos, TypeIndex, Dest, expr_nil (_)))
	  FollowNameChainIndex (TypeIndex -> composite (method (_, _)))
	  GenerateLineInfo (Pos)
	  GenerateEnclosedExpr (Dest)
	  Write (" = ")
	  GenerateHiddenName ("NIL")
	  Writeln (";")
			  
    -- record or union result
	      
     'rule' GenerateStatements (assign (Pos, TypeIndex, Dest,
					Source:call( _, _, _, _, _ )))
	  FollowNameChainIndex (TypeIndex -> Type:composite (CompositeType))
	  (|
	       where (CompositeType -> record (_))
	  ||
	       where (CompositeType -> union (_))
	  |)
	  Writeln ("{")
	  TransformTypeIndex (TypeIndex -> ActualType)
	  GenerateBaseType (ActualType)
	  GenerateHiddenName ("RESULT")
	  GenerateBaseTypeExtension (ActualType)
	  Writeln (";")
	  GenerateLineInfo (Pos)
	  GenerateHiddenName ("RESULT")
	  Write (" = ")
	  GenerateEnclosedExpr (Source)
	  Writeln (";")
	  Write ("C3IC3IMemCpy (&")
	  GenerateEnclosedExpr (Dest)
	  Write( ", &")
	  GenerateHiddenName ("RESULT")
	  Write (", sizeof (")
	  GenerateBaseType (ActualType)
	  GenerateBaseTypeExtension (ActualType)
	  Writeln ("));")
	  Writeln ("}")

    -- array assignment

     'rule' GenerateStatements (assign (Pos, TypeIndex, Dest, Source))
	  FollowNameChainIndex (TypeIndex -> composite (array( _, _ )))
	  TypeIndex'Type -> Type
	  GenerateLineInfo (Pos)
	  Write ("C3IC3IMemCpy (")
	  GenerateEnclosedExpr (Dest)
	  Write (", ")
	  GenerateEnclosedExpr (Source)
	  Write (", sizeof (")
	  GenerateBaseType (Type)
	  GenerateBaseTypeExtension (Type)
	  Writeln ("));")

    -- record or union assignment
	      
     'rule' GenerateStatements (assign (Pos, TypeIndex, Dest, Source))
	  FollowNameChainIndex (TypeIndex -> composite (CompositeType))
	  (|
	       where (CompositeType -> record (_))
	  ||
	       where (CompositeType -> union (_))
	  |)
	  TypeIndex'Type -> Type
	  GenerateLineInfo (Pos)
	  Write ("C3IC3IMemCpy (&")
	  GenerateEnclosedExpr (Dest)
	  Write (", &")
	  GenerateEnclosedExpr (Source)
	  Write (", sizeof (")
	  GenerateBaseType (Type)
	  GenerateBaseTypeExtension (Type)
	  Writeln ("));")

     -- other assignment
	  
     'rule' GenerateStatements (assign (Pos, TypeIndex, Dest, Source))
	  GenerateLineInfo (Pos)
	  GetExpressionSpecType (Dest -> DestType)
	  GetExpressionSpecType (Source -> SourceType)
	  GenerateExpr (Dest)
	  Write (" = ")
	  GenerateCastIfNecessary (SourceType, DestType, in)
	  GenerateEnclosedExpr (Source)
	  Writeln (";")

     'rule' GenerateStatements (stmtcall (Pos, Call))
	  GenerateLineInfo (Pos)
	  GenerateEnclosedExpr (Call)
	  Writeln (";")

     'rule' GenerateStatements (return (Pos))
	  GenerateLineInfo (Pos)
	  GenerateProcPostlude
	  Writeln ("return;")

     'rule' GenerateStatements (returnvalue (Pos, Value))
	  UnchangedResultType -> Type
	  FollowNameChain (Type -> composite (array (_, _)))
	  ReturnId -> RetId
	  Write ("C3IC3IMemCpy (")
	  GenerateCooLName (RetId)		 
	  Write	(", ")
	  GenerateEnclosedExpr (Value)
	  Write (", sizeof (")
	  GenerateBaseType (Type)
	  GenerateBaseTypeExtension (Type)
	  GenerateLineInfo (Pos)
	  Writeln ("));")
	  GenerateProcPostlude
	  Write ("return ")
	  GenerateCooLName (RetId)		 
	  Writeln (";")
     
     'rule' GenerateStatements (returnvalue (Pos, Value))
	  UnchangedResultType -> Type
	  TransformResultType (Type -> ResultType1)
	  Writeln ("{")
	  GenerateBaseType (ResultType1)
	  GenerateHiddenName ("RETURN")
	  GenerateBaseTypeExtension (ResultType1)
	  Writeln (";")
	  GenerateLineInfo (Pos)
	  GenerateHiddenName ("RETURN")
	  Write (" = ")
	  GenerateObjectCast
	  GenerateEnclosedExpr (Value)
	  Writeln (";")
	  GenerateProcPostlude
	  Write ("return ")
	  GenerateObjectCast
	  GenerateHiddenName ("RETURN")
	  Writeln (";")
	  Writeln ("}")

     'rule' GenerateStatements (ifelse (Pos, Cond, Then, Else))
	  GenerateLineInfo (Pos)
	  Write ("if ")
	  GenerateEnclosedExpr (Cond)
	  Writeln (" {")
	  GenerateStatements (Then)
	  Writeln ("}")
	  (|
	       where (Else -> nil (_))
	  ||
	       Writeln ("else {")
	       GenerateStatements (Else)
	       Writeln ("}")
	  |)

     'rule' GenerateStatements (select (Pos, Cond, Cases, Otherwise))
	  GenerateLineInfo (Pos)
	  Write ("switch ")
	  GenerateEnclosedExpr (Cond)
	  Writeln ("{")
	  GenerateCases (Cases)
	  Writeln ("default:")
	  Writeln ("{")
	  GenerateStatements (Otherwise)
	  Writeln ("}")
	  Writeln ("}")

     'rule' GenerateStatements (typeselect (Pos, implicitvar (_, Id), Init,
					    Typecases, Otherwise))
	  Writeln ("{")
	  GetIdMeaning (Id -> implicitvar (TypeIndex))
	  GenerateLineInfo (Pos)
	  TransformTypeIndex (TypeIndex -> ActualType)
	  GenerateBaseType (ActualType)
	  GenerateCooLName (Id)
	  GenerateBaseTypeExtension (ActualType)
	  Write (" = ")
	  GenerateEnclosedExpr (Init)
	  Writeln (";")
	  GenerateTypeCases (Typecases, Id)
	  GenerateStatements (Otherwise)
	  Writeln ("}")
	  Write ("typeselectend")
	  TypeSelects -> N
	  WriteInt (N)
	  Writeln (":")
	  TypeSelects <- N + 1

     'rule' GenerateStatements (loop (Pos, block (_, EndPos, Body)))
	  EnterLoop (-> OldExitLabel)
	  GenerateLineInfo (Pos)
	  Writeln ("for (;;)")
	  Writeln ("{")
	  Writeln ("int C3IC3I;")
	  GenerateLoopPrelude (Body)
	  GenerateStatements (Body)
	  GenerateLineInfo (EndPos)
	  Write ("}" )
	  LeaveLoop (OldExitLabel)

     'rule' GenerateStatements (while (Pos, Cond, block (_, EndPos, Body)))
	  EnterLoop (-> OldExitLabel)
	  GenerateLineInfo (Pos) 
	  Write ("while (")
	  GenerateEnclosedExpr (Cond)
	  Writeln (")")
	  Writeln ("{")
	  Writeln ("int C3IC3I;")
	  GenerateLoopPrelude (Body)
	  GenerateStatements (Body)
	  GenerateLineInfo (Pos)
	  Write ("} ")
	  LeaveLoop (OldExitLabel)

     'rule' GenerateStatements (for (Pos, implicitvar (_, Id), 
				     range (_, From, To), Step, 
				     block (_, EndPos, Body)))
	  EnterLoop (-> OldExitLabel)
	  Writeln ("{")
	  Write ("int ")
	  GenerateCooLName (Id)
	  Writeln (";")
	  Writeln ("int C3IC3IFOR;")
	  Writeln ("int C3IC3ISTEP;")
	  GenerateLineInfo (Pos)
	  Write ("for ( C3IC3IFOR = ")
	  GenerateEnclosedExpr (To)
	  Write (", C3IC3ISTEP = ")
	  GenerateForStep (Step)
	  Write (", ")
	  GenerateCooLName (Id)
	  Write (" = ")
	  GenerateEnclosedExpr (From)
	  Write ("; ")
	  GenerateForCheckAndStep (Step, Id)
	  Writeln (" )")
	  Writeln ("{")
	  GenerateLoopPrelude (Body)
	  GenerateStatements (Body)
	  GenerateLineInfo (Pos)
	  Writeln ("}")
	  Write ("} ")
	  LeaveLoop (OldExitLabel)

     'rule' GenerateStatements (exit (Pos))
	  GenerateLineInfo (Pos)
	  GenerateLoopPostlude
	  Write ("goto ")
	  ActExitLabel -> ExitLabel
	  GenerateHiddenName ("EXIT")
	  WriteInt (ExitLabel)
	  Writeln (";")

     'rule' GenerateStatements (raise (Pos, Exception, Params))
	  GenerateLineInfo (Pos)
	  GetIdMeaning (Exception -> exception (FParams))
	  Write ("C3IC3ICurrExcept = &")
	  GenerateQualifiedCooLName (Exception)
	  Writeln (";")
	  GenerateExceptionInit (Exception, FParams, Params)
	  Writeln ("C3IC3IRAISE();")

     'rule' GenerateStatements (try (Pos, Body, Handlers, Otherwise))
	  GenerateLineInfo (Pos)
	  ActualTry -> OldTryNumber
	  NextLabel (-> TryLabel)
	  ActualTry <- TryLabel
	  Writeln ("{")
	  Writeln ("jmp_buf C3IC3IPrevExceptBuf;")
	  Write ("C3IC3ITryLabel")
	  WriteInt (TryLabel)
	  Writeln (":")
	  Writeln ("C3IC3ISetCurrentExceptionHandler (C3IC3IPrevExceptBuf);")
	  Writeln ("if (setjmp (C3IC3ICurrExceptBuf) == 0)")
	  Writeln ("{")
	  GenerateStatements (Body)
	  Writeln ("C3IC3IRestorePrevExceptionHandler (C3IC3IPrevExceptBuf);")
	  Write ("goto C3IC3IHandled")
	  WriteInt (TryLabel)
	  Writeln (";")
	  Writeln ("}")
	  Writeln ("else")
	  Writeln ("{")
	  Writeln ("C3IC3IRestorePrevExceptionHandler (C3IC3IPrevExceptBuf);")
	  GenerateHandler (Handlers)
	  GenerateOtherwiseHandler (Otherwise)
	  Writeln ("}")
	  Write ("C3IC3IHandled")
	  WriteInt (TryLabel)
	  Writeln (":")
	  Writeln ("C3IC3ICurrExcept = 0;")
	  Writeln ("}")
	  ActualTry <- OldTryNumber

     'rule' GenerateStatements (retry (Pos))
	  GenerateLineInfo (Pos)
	  ActualTry -> TryNumber
	  Write ("goto C3IC3ITryLabel")
	  WriteInt (TryNumber)
	  Writeln (";")

     'rule' GenerateStatements (reraise (Pos))
	  GenerateLineInfo (Pos)
	  Writeln ("C3IC3IRAISE ();")

     'rule' GenerateStatements (delete( Pos, Object))
	  GetExpressionRealType (Object -> RealType)
	  (|
	       FollowNameChain (RealType -> composite (classtype (Id, _, _ )))
	  ||
	       FollowNameChain (RealType -> generic (genericinst (Id, _)))
	  |)
	  GenerateLineInfo (Pos)
	  GenerateQualifiedCooLName (Id)
	  Write ("C3IDELETE (")
	  GetExpressionSpecType (Object -> SpecType)
	  GenerateCastIfNecessary (SpecType, composite (typename (Id)), in)
	  GenerateEnclosedExpr (Object)
	  Writeln (");")

     'rule' GenerateStatements (nil (_))
	  Writeln (";")
     
-- GenerateExceptionInit ---------------------------------------------------

'action' GenerateExceptionInit (ID, FPARAMLIST, APARAMLIST)

     'rule' GenerateExceptionInit (_, nil, _)

     'rule' GenerateExceptionInit (Exception, 
				   fparamlist (fparam (_, Id, _, TypeIndex),
					       List1),
				   aparamlist (in (Expression), List2))
	  GenerateQualifiedCooLName (Exception)
	  Write (".")
	  GenerateCooLName (Id)
	  Write (" = ")
	  GenerateEnclosedExpr (Expression)
	  Writeln (";")
	  GenerateExceptionInit (Exception, List1, List2)

-- GenerateOtherwiseHandler ------------------------------------------------

'action' GenerateOtherwiseHandler (STMT)

     'rule' GenerateOtherwiseHandler (nil (_))
	  Writeln ("C3IC3IRAISE ();")

     'rule' GenerateOtherwiseHandler (Stmts)
	  GenerateStatements (Stmts)

-- GenerateHandler ---------------------------------------------------------

'action' GenerateHandler (HANDLER)

     'rule' GenerateHandler (seq (Left, Right))
	  GenerateHandler (Left)
	  GenerateHandler (Right)

     'rule' GenerateHandler (handler (Pos, Id, Params, Body))
	  GenerateLineInfo (Pos) -- handler position
	  ActualTry -> TryNo
	  Write ("if (C3IC3ICurrExcept == &")
	  GenerateQualifiedCooLName (Id)
	  Write (") {")
	  GetIdMeaning (Id -> exception (FParams))
	  GenerateExceptionParamsDecl (Params)
	  GenerateExceptionParamsInit (Id, FParams, Params)
	  GenerateStatements (Body)
	  Write ("goto C3IC3IHandled")
	  WriteInt (TryNo)
	  Writeln (";")
	  Writeln ("}")

     'rule' GenerateHandler (_)

-- GenerateExceptionParamsDecl ---------------------------------------------

'action' GenerateExceptionParamsDecl (FPARAMLIST)

     'rule' GenerateExceptionParamsDecl (fparamlist (fparam (_, Id, _, TypeI),
						     List))
	  TransformTypeIndex (TypeI -> ActualType)
	  GenerateBaseType (ActualType)
	  GenerateCooLName (Id)
	  GenerateBaseTypeExtension (ActualType)
	  Writeln (";")
	  GenerateExceptionParamsDecl (List)

     'rule' GenerateExceptionParamsDecl (_)

-- GenerateExceptionParamsInit ---------------------------------------------

'action' GenerateExceptionParamsInit( ID, FPARAMLIST, FPARAMLIST )

    'rule' GenerateExceptionParamsInit( _, nil, _ )

    'rule' GenerateExceptionParamsInit( Id, 
				    fparamlist( fparam( _, ExceptP1, _, _ ),
					        List1 ),
				    fparamlist( fparam( _, AFParam, _, TI ),
					        List2 ) )
        FollowNameChainIndex( TI -> composite( array( _, _ ) ) )
        Write( "C3IC3IMemCpy ((" )
        GenerateCooLName( AFParam )
        Write( "), " )
        GenerateModuleName( ExceptP1 )
        GenerateCooLName( Id )
        Write( "." )
        GenerateCooLName( ExceptP1 )
        Write( ", sizeof (" )
        GenerateTypeIndex (TI)
        Writeln( "));" )
        GenerateExceptionParamsInit( Id, List1, List2 )

    'rule' GenerateExceptionParamsInit( Id, 
				    fparamlist( fparam( _, ExceptP1, _, _ ),
					        List1 ),
				    fparamlist( fparam( _, AFParam, _, TI ),
					        List2 ) )
        FollowNameChainIndex( TI -> simple( string ) )
        Write( "C3IC3ICopyString (" )
        GenerateCooLName( AFParam )
        Write( ", " )
        GenerateModuleName( ExceptP1 )
        GenerateCooLName( Id )
        Write( "." )
        GenerateCooLName( ExceptP1 )
        Writeln( " );" )
        GenerateExceptionParamsInit( Id, List1, List2 )

    'rule' GenerateExceptionParamsInit( Id, 
				    fparamlist( fparam( _, ExceptP1, _, _ ),
					        List1 ),
				    fparamlist( fparam( _, AFParam, _, TI ),
					        List2 ) )
        GenerateCooLName( AFParam )
        Write( "=" )
        GenerateModuleName( ExceptP1 )
        GenerateCooLName( Id )
        Write( "." )
        GenerateCooLName( ExceptP1 )
        Writeln( ";" )
        GenerateExceptionParamsInit( Id, List1, List2 )

-- NextLabel ---------------------------------------------------------------

'action' NextLabel (-> Next : INT)
     
     'rule' NextLabel (-> Next) :
	  ActLabel -> Next
	  ActLabel <- Next + 1
	  
-- EnterLoop ---------------------------------------------------------------

'action' EnterLoop (-> OldExitLabel : INT)
     
     'rule' EnterLoop (-> OldExitLabel) :
	  ActExitLabel -> OldExitLabel
	  NextLabel (-> Next)
	  ActExitLabel <- Next
	  
-- LeaveLoop ---------------------------------------------------------------

'action' LeaveLoop (OldExitLabel : INT)
     
     'rule' LeaveLoop (OldExitLabel) :
	  ActExitLabel -> ExitLabel
	  GenerateHiddenName ("EXIT")
	  WriteInt (ExitLabel)
	  Writeln (":")
	  ActExitLabel <- OldExitLabel
	  
-- GenerateForStep ---------------------------------------------------------

'action' GenerateForStep (STEP)

     'rule' GenerateForStep (incr (Expr))
	  GenerateEnclosedExpr (Expr)

     'rule' GenerateForStep (decr (Expr))
	  GenerateEnclosedExpr (Expr)

-- GenerateForCheckAndStep -------------------------------------------------

'action' GenerateForCheckAndStep (STEP, ID)

     'rule' GenerateForCheckAndStep (incr (Value), Id)
	  GenerateCooLName (Id)
	  Write (" <= C3IC3IFOR; ")
	  GenerateCooLName (Id)
	  Write (" = ")
	  GenerateCooLName (Id)
	  Write (" + C3IC3ISTEP")

     'rule' GenerateForCheckAndStep (decr (Value), Id)
	  GenerateCooLName (Id)
	  Write (" >= C3IC3IFOR; ")
	  GenerateCooLName (Id)
	  Write (" = ")
	  GenerateCooLName (Id)
	  Write (" - C3IC3ISTEP")

-- GenerateCases -----------------------------------------------------------

'action' GenerateCases (CASE)

     'rule' GenerateCases (seq (Left, Right))
	  GenerateCases (Left)
	  GenerateCases (Right)

     'rule' GenerateCases (case (Pos, Labels, Body))
	  GenerateCaseLabels (Labels)
	  GenerateLineInfo (Pos)
	  Writeln ("{")
	  GenerateStatements (Body)
	  Writeln ("}") 
	  Writeln ("break;")

    'rule' GenerateCases (_)

-- GenerateTypeCases -------------------------------------------------------

'action' GenerateTypeCases (TYPECASE, ID)

     'rule' GenerateTypeCases (seq (Left, Right), Id)
	  GenerateTypeCases (Left, Id)
	  GenerateTypeCases (Right, Id)

     'rule' GenerateTypeCases (typecase (Pos, TypeName, Body), Id)
	  Write ("if (C3IC3IIsDynamicSubtypeOf (")
	  GenerateCooLName (Id)
	  Write( "->C3IMTABR, &") 
	  GenerateMTabVarName (TypeName)
	  Writeln ("))")
	  GenerateLineInfo (Pos)
	  Writeln ("{")
	  GetDefiningId (Id -> Id2)
	  GetIdMeaning (TypeName -> type (TypeNameIndex))
	  Id2'Meaning -> OldMeaning
	  Id2'Meaning <- implicitvar (TypeNameIndex)
	  Temporaries -> Temp
	  AllocTemporary (Body, Temp -> Number)
	  GenerateStatements (Body)
	  Temporaries <- Temp
	  Id2'Meaning <- OldMeaning
	  Write ("goto typeselectend")
	  TypeSelects -> N 
	  WriteInt (N)
	  Writeln (";")
	  Writeln ("}") 

     'rule' GenerateTypeCases (nil, _)

-- GenerateCaseLabels ------------------------------------------------------

'var' FirstCaseLabel : INT

'action' GenerateCaseLabels (EXPRLIST)

     'rule' GenerateCaseLabels (exprlist (range (_, From, To), List))
	  GetRangeValue (From -> FromValue)
	  GetRangeValue (To -> ToValue)
	  FirstCaseLabel <- FromValue
	  GenerateRangeCases (ToValue)

     'rule' GenerateCaseLabels (exprlist (Expr, List))
	  Write ("case ")
	  GenerateEnclosedExpr (Expr)
	  Writeln (":")
	  GenerateCaseLabels (List)

     'rule' GenerateCaseLabels (_)

-- GenerateRangeCases ------------------------------------------------------

'action' GenerateRangeCases (INT)

     'rule' GenerateRangeCases (ToValue)
	  FirstCaseLabel -> NewLabel
	  Write ("case ")
	  WriteInt (NewLabel)
	  Writeln (":")
	  Incr (NewLabel -> IncrLabel)
	  FirstCaseLabel <- IncrLabel
	  le (IncrLabel, ToValue)
	  GenerateRangeCases (ToValue)

     'rule' GenerateRangeCases (_)

-- GetRangeValue -----------------------------------------------------------

'action' GetRangeValue (EXPR -> INT)

     'rule' GetRangeValue (posintliteral (_, Value) -> Value)

     'rule' GetRangeValue (negintliteral (_, Value) -> -Value)

     'rule' GetRangeValue (charliteral (_, Value) -> CharValue)
	  GetIntegerValue (Value -> CharValue)

     'rule' GetRangeValue (enumsel (_, _, _, Number) -> Number)

-- GenerateObjectCast ------------------------------------------------------

'action' GenerateObjectCast

     'rule' GenerateObjectCast
	  UnchangedResultType -> Type
	  (|
	       FollowNameChain (Type -> 
				composite (classtype (ClassName, _, _)))
	  ||	
	       FollowNameChain (Type -> 
				generic (genericinst (ClassName, _)))
	  ||
	       FollowNameChain (Type -> 
				generic (constrained (_, ClassName)))
	  |)
	  Write ("(")
	  GenerateClassName (ClassName)
	  Write( ")" )
        
    'rule' GenerateObjectCast

-- GenerateLineInfo --------------------------------------------------------

'action' GenerateLineInfo (POS)

     'rule' GenerateLineInfo (Pos)
	  PrintMAXLineInfo (Pos)


