-----------------------------------------------------------------------------
--                  CooL-V2.0 - destination code interface                 --
-----------------------------------------------------------------------------
--                        codegeneration interface                         --
--                            Version 1.0, 1993                            --
-----------------------------------------------------------------------------

'module' coder

'export' GenerateSpecification
         GenerateImplementation
         InitCoder
         IsImportedName
         IsExportedProcedure
         IsForeignExportProc
         CurrentModule

'use' ast
      extspecs
      misc
      mapping
      codetype
      codedecl
      codestmt

-----------------------------------------------------------------------------

'var' CurrentModule : ID
'var' ImportList    : IMPORT
'var' SpecList      : DECL

'var' CompileSpec   : BOOL

'type' BOOL
    true
    false

-- InitCoder ----------------------------------------------------------------

'action' InitCoder

     'rule' InitCoder
	  ActModuleList <- nil
	  InitCodeType
	  InitCodeStmt

-- GenerateSpecification ----------------------------------------------------

'action' GenerateSpecification( MODULE )

    'rule' GenerateSpecification( _ )
	IsAnalyseMode  

    'rule' GenerateSpecification( specification( ModuleName,
						 Imports,
						 Specifications) )
        GetIDString( ModuleName -> ModuleNameString )
        CurrentModule <- ModuleName
        ImportList <- Imports
        SpecList <- Specifications
        OpenSpecificationFile
        CompileSpec <- true
	 GenerateSpecificationPrelude (ModuleNameString)
        GenerateImports( Imports )
        GenerateSpecifications( Specifications )
        GenerateSpecificationPostlude( ModuleNameString )
        CloseSpecificationFile

-- GenerateImplementation ---------------------------------------------------

'action' GenerateImplementation( Spec : MODULE, Impl : MODULE ) 

    'rule' GenerateImplementation( _, _ )
	IsAnalyseMode

    'rule' GenerateImplementation( specification( _, _, Specifications ), 
				   implementation( ModuleName, 
						   Imports, 
						   Implementations ) )
        GetIDString( ModuleName -> ModuleNameString )
        CurrentModule <- ModuleName
        ImportList <- Imports
        SpecList <- Specifications
        OpenImplementationFile
        CompileSpec <- false
        GenerateImplementationPrelude( ModuleName )
        GenerateImports( Imports )
        GenerateSpecificationImplementation( Specifications )
        GenerateVarProcSpecExceptions( Implementations )
        GenerateImplementations( Implementations )
        CloseImplementationFile

-- GenerateImports ----------------------------------------------------------

'action' GenerateImports (IMPORT)
     
     'rule' GenerateImports (seq (Left, Right))
	  GenerateImports (Left)
	  GenerateImports (Right)

     'rule' GenerateImports (importmodule (Module))
	  ImportModule (Module)
     
     'rule' GenerateImports (importitem (Module, Item))
	  ImportModule (Module)
	  MapImportedItem (Item) -- problem : superflous ???
     
     'rule' GenerateImports (importforeign (File)) :
	  Write ("# include \"")
	  Write (File)
	  Writeln ("\"")
	  
     'rule' GenerateImports (_) :
	  
-- ImportModule -------------------------------------------------------------

'var' ActModuleList : IDLIST

'action' ImportModule (ID)
     
     'rule' ImportModule (Module)
	  ActModuleList -> ModuleList
	  IsIdInList (Module, ModuleList -> _)
	  
     'rule' ImportModule (Module)
	  ActModuleList -> ModuleList
	  ActModuleList <- idlist (Module, ModuleList)
	  GetIDString (Module -> ModuleNameString)
	  Write ("# include \"")
	  Write (ModuleNameString)
	  Writeln (".h\"")

-- GenerateSpecificationPrelude ---------------------------------------------

'action' GenerateSpecificationPrelude (STRING)

     'rule' GenerateSpecificationPrelude (ModuleString)
	  Writeln ("/* CooLV2.0 - C-code interface Version 1.0 */")
	  Write ("# ifndef ")
	  GenerateIfdefPrelude
	  Write (ModuleString)
	  Writeln ("")
	  Write ("# define ")
	  GenerateIfdefPrelude
	  Write (ModuleString)
	  Writeln (" ")
	  Writeln ("# include \"C3Irts.h\"")

-- GenerateSpecificationPostlude --------------------------------------------

'action' GenerateSpecificationPostlude (STRING)

     'rule' GenerateSpecificationPostlude (ModuleString)
	  Write ("# endif /* ")
	  GenerateIfdefPrelude
	  Write (ModuleString)
	  Writeln (" */")

-- GenerateImplementationPrelude --------------------------------------------

'action' GenerateImplementationPrelude( ID )

    'rule' GenerateImplementationPrelude( ModuleName )
        Writeln( "/* CooLV2.0 - C-code interface Version 1.0 */" )
        ImportModule( ModuleName )

-- GenerateSpecificationImplementation --------------------------------------

'action' GenerateSpecificationImplementation( DECL )

     'rule' GenerateSpecificationImplementation (seq (_, Left, Right))
	  GenerateSpecificationImplementation (Left)
	  GenerateSpecificationImplementation (Right)

     'rule' GenerateSpecificationImplementation(Decl:globalvar (_, _, _, 
								_, _ ))
	  GenerateGlobalVarImplementation (Decl)

     'rule' GenerateSpecificationImplementation( Decl:exception( _, _, _ ) )
	  GenerateExceptionSpecImpl( Decl )

     'rule' GenerateSpecificationImplementation( Decl:type( _, _, _ ) )
        -- copy and equal operator in the case of dynamic strings
	 
     'rule' GenerateSpecificationImplementation( _ )

-- GenerateSpecifications ---------------------------------------------------

'action' GenerateSpecifications( DECL )

    'rule' GenerateSpecifications( seq( Pos, Left, Right ) )
        GenerateSpecifications( Left )
        GenerateSpecifications( Right )

    'rule' GenerateSpecifications( nil( Pos ) )

    'rule' GenerateSpecifications( Decl:type( Pos, TypeId, TypeIndex ) )
        GenerateTypeDeclaration( Decl )

    'rule' GenerateSpecifications( Decl:classspec( _, _, _, _ ) )
        GenerateClassSpecification( Decl )

    'rule' GenerateSpecifications( Decl:const( _, _, _, _ ) )
        GenerateConstant( Decl )

     'rule' GenerateSpecifications (Decl:globalvar (_, _, _, _, _))
	  GenerateGlobalVarSpecification (Decl) 

     'rule' GenerateSpecifications (Decl:exception( _, _, _ ))
	  GenerateExceptionSpecification (Decl)

     'rule' GenerateSpecifications (Decl:procspec (_, _, _, _, _, _ ))
	  GenerateProcedureSpecification (Decl)

    'rule' GenerateSpecifications( Decl:foreignproc( _, _, _, _, _ ) )
        GenerateForeignProcSpecification( Decl )

    'rule' GenerateSpecifications( Decl:foreignvar( _, _, _ ) )
        GenerateForeignVarSpecification( Decl )
     
     'rule' GenerateSpecifications (Decl:foreigntype (_, _, _)) :
	-- no code generation needed for foreigntypes
	  
-- GenerateVarProcSpecExceptions --------------------------------------------

'action' GenerateVarProcSpecExceptions( DECL )

    'rule' GenerateVarProcSpecExceptions( seq( Pos, Left, Right ) )
        GenerateVarProcSpecExceptions( Left )
        GenerateVarProcSpecExceptions( Right )

    'rule' GenerateVarProcSpecExceptions( Decl:globalvar( _, _, _, _, _ ) )
        GenerateStaticGlobalVar( Decl )

    'rule' GenerateVarProcSpecExceptions( Decl:exception( _, _, _ ) )
        GenerateStaticException( Decl )

    'rule' GenerateVarProcSpecExceptions( procimpl( Pos, Id, Params,
						    Result, _, _ )   )
        IsExportedProcedure( Id )

    'rule' GenerateVarProcSpecExceptions( procimpl( Pos, Id, Params,
						    Result, _, _ )   )
        GenerateProcedureSpecification( procspec( Pos, Id, cool, c,
						  Params, Result ) )
     
     'rule' GenerateVarProcSpecExceptions (Decl:foreignproc (_, _, _, _, _))
	  GenerateForeignProcSpecification (Decl)
	  
     'rule' GenerateVarProcSpecExceptions (Decl:foreignvar (_, _, _)) :
	  GenerateForeignVarSpecification (Decl)
					    
    'rule' GenerateVarProcSpecExceptions( _ )

-- GenerateImplementations --------------------------------------------------

'action' GenerateImplementations (DECL)

     'rule' GenerateImplementations (seq (_, Left, Right))
	  GenerateImplementations (Left)
	  GenerateImplementations (Right)

     'rule' GenerateImplementations (Decl:type (_, _, _))
	  GenerateTypeDeclaration (Decl)

     'rule' GenerateImplementations (Decl:class (_, _, _, _, _))
	  GenerateClass (Decl)

     'rule' GenerateImplementations (Decl:classimpl (_, _, _))
	  GenerateClassImpl (Decl)

     'rule' GenerateImplementations (Decl:const (_, _, _, _))
	  GenerateConstant (Decl)

     'rule' GenerateImplementations (Decl:procimpl (_, _, _, _, _, _))
	  GenerateProcedureImplementation (Decl)

     'rule' GenerateImplementations (_)
     -- exceptions, globalvars, foreignproc, foreignvar, foreigntype handled
     -- in GenerateVarProcSpecExceptions
	  
-- IsImportedName -----------------------------------------------------------

'condition' IsImportedName( ID )

    -- Name is defined in specification

    'rule' IsImportedName( Name )
        Name'Module -> module( Module )
        CurrentModule -> CurrentModuleId
        NeId( Module, CurrentModuleId  )

    'rule' IsImportedName( Name )
        Name'Module -> module( Module )
        ImportList -> Imports
        IsImportedModule( Imports, Module )

    'rule' IsImportedName( Name )
        ImportList -> Imports
        IsImportedItem( Imports, Name )

    'rule' IsImportedName( Name )
        CompileSpec -> false
        SpecList -> Specs
        IsExportedName( Specs, Name )

-- IsExportedName -------------------------------------------------------------

'condition' IsExportedName( DECL, ID )

    'rule' IsExportedName( seq( Pos, Left, Right ), Name )
        IsExportedName( Left, Name )

    'rule' IsExportedName( seq( Pos, Left, Right ), Name )
        IsExportedName( Right, Name )

    'rule' IsExportedName( Decl:type( Pos, TypeId, TypeIndex ), Name )
         EqId( Name, TypeId )

    'rule' IsExportedName( Decl:classspec( _, Id, _, _ ), Name )
         EqId( Name, Id )

-- IsImportedModule -----------------------------------------------------------

'condition' IsImportedModule( IMPORT, ID )

    'rule' IsImportedModule( seq( Left, Right ), Module )
        IsImportedModule( Left, Module )

    'rule' IsImportedModule( seq( Left, Right ), Module )
        IsImportedModule( Right, Module )

    'rule' IsImportedModule( importmodule( Module1 ), Module2 )
        EqId( Module1, Module2 )

-- IsImportedItem -------------------------------------------------------------

'condition' IsImportedItem( IMPORT, ID )

    'rule' IsImportedItem( seq( Left, Right ), Name )
        IsImportedItem( Left, Name )

    'rule' IsImportedItem( seq( Left, Right ), Name )
        IsImportedItem( Right, Name )

    'rule' IsImportedItem( importitem( _, Name1 ), Name2 )
        EqId( Name1, Name2 )

-- IsExportedProcedure -------------------------------------------------------

'condition' IsExportedProcedure( ID )

    'rule' IsExportedProcedure( ProcId )
        SpecList -> Specifications
        IsExportedProcedureLoc( Specifications, ProcId )

-- IsExportedProcedureLoc ----------------------------------------------------

'condition' IsExportedProcedureLoc (DECL, ID)

     'rule' IsExportedProcedureLoc (seq (_, Left, _), ProcId)
	  IsExportedProcedureLoc (Left, ProcId)

     'rule' IsExportedProcedureLoc (seq (_, _, Right), ProcId)
	  IsExportedProcedureLoc (Right, ProcId)

     'rule' IsExportedProcedureLoc (procspec (_, ProcId1, _,  _, _, _), 
				    ProcId2) :
	  EqId (ProcId1, ProcId2)

-- IsForeignExportProc -------------------------------------------------------

'condition' IsForeignExportProc( ID )

    'rule' IsForeignExportProc( ProcId )
        SpecList -> Specifications
        IsForeignExportProcLoc( Specifications, ProcId )

-- IsForeignExportProcLoc ----------------------------------------------------

'condition' IsForeignExportProcLoc( DECL, ID )

    'rule' IsForeignExportProcLoc( seq( _, Left, _ ), ProcId )
        IsForeignExportProcLoc( Left, ProcId )

    'rule' IsForeignExportProcLoc( seq( _, _, Right ), ProcId )
        IsForeignExportProcLoc( Right, ProcId )

    'rule' IsForeignExportProcLoc( procspec( _, ProcId1, foreign, _, _, _ ),
				   ProcId2 )
        EqId( ProcId1, ProcId2 )


