/* HEADER */
/* @(#) bcd_def.h 4.1.1.2 */
/* @(#)Description: C-Programme und Include-Dateien */
/* @(#)Author: xsde */
/* @(#)Location: PB01 */
/* @(#)Type: cprog */
/* @(#)Created with X/SDE-REL:  */
/* @(#)Date, time modify: 93/03/19, 11:03:16 */
/* @(#)Date, time return: 92/08/25, 08:13:57 */
/* Copyright: @(#) X/SDE-BCD V3.1A90 19930319 */
/* Copyright: @(#) Siemens Nixdorf Informationssysteme AG, 1993 */
/* END HEADER */
/****************************************************************************/
/**                                                                        **/
/**     BCD-Arithmetic for X/SDE     copyright (C) by SIEMENS/NIXDORF      **/
/**                                                                        **/
/****************************************************************************/
/**                                                                        **/
/**     File name: bcd_def.h                                               **/
/**                                                                        **/
/**     Date     : 05.04.1991                                              **/
/**                                                                        **/
/**     Release  : 1.0.0                                                   **/
/**                                                                        **/
/**                                                                        **/
/****************************************************************************/
/**                                                                        **/
/**     Changes: 0.0 1st version                                           **/
/**              0.1 Lint/House-Standard nits                              **/
/**              0.2 Fix for Intel                                         **/
/**              0.3 bug in b_ldint fixed                                  **/
/**                                                                        **/
/**                                                                        **/
/****************************************************************************/

#include "bcd_xsde.h"


typedef unsigned short USHORT ;
typedef unsigned char UCHAR ;


#define PREC 16           /* precision of binary floating point (double)    */
#define HPREC 7           /* precision of binary floating point (float)     */
#define NBCD 20           /* number of digits held in internal format       */
#define MIN_CHART -64     /* Minimum Internal Characteristic representation */
#define FRACT_CHART 0     /* Greatest characteristic of a fractional value  */
#define MAX_CHART 63      /* Maximum Internal Characteristic representation */
#define POSITIV 0x00              /* Positiv indicator */
#define NEGATIV 0x80              /* Negative indicator */
#define B_D4_POS_EXP   192        /* max. positive exponent Database DDB/4  */
#define B_D4_NULL_EXP  128        /* exponent for number value 0 from DDB/4 */

#ifdef m_i386
#define HIGHBYTE 1
#define LOWBYTE 0
#define I(x)          ( (x) & 1 ? (x) - 1 : (x) + 1 ) /* Byte swap */
#define GETDIG(x,i)   ((x).mant.word[i>>2] >> (12-((i&3)<<2)) & 0x000F)
#define PUTDIG(d,x,i) ( (x).mant.word[i>>2] =   \
			 (x).mant.word[i>>2] &  \
			 (0xFFFF - (0xF000 >> ((i&3)<<2))) | \
			 (d << (12-((i&3)<<2)))          );

#define GETADR(x,i) (&(x).mant.word[(i)>>2])
#define BAPUTDIG(d,x,i) ( *((USHORT *)x) = *((USHORT *)x) | ((d) << (((~i)&3)<<2)) );

#define DIG0 dig[1]
#define DIG1 dig[0]
#define DIG2 dig[3]
#define DIG3 dig[2]
#define DIG4 dig[5]
#define DIG5 dig[4]
#define DIG6 dig[7]
#define DIG7 dig[6]
#define DIG8 dig[9]
#define DIG9 dig[8]
#else /* m_mips */
#define HIGHBYTE 0
#define LOWBYTE 1
#define I(x) (x)
#define GETDIG(x,i) ((x).b_byte.dig[(i)>>1] >> (4-(((i)&1)<<2)) & 0X000F)
#define PUTDIG(d,x,i) ( (x).b_byte.dig[(i)>>1] =   \
			 (x).b_byte.dig[(i)>>1] &  \
			 ((i)&1 ? 0xF0 : 0x0F) | \
			 ((d) << (4-(((i)&1)<<2))) );

#define GETADR(x,i) (&(x).b_byte.dig[(i)>>1])
#define BAPUTDIG(d,x,i) ( *(x) = *(x) | ((d) << (((~i)&1)<<2)) );

#define DIG0 dig[0]
#define DIG1 dig[1]
#define DIG2 dig[2]
#define DIG3 dig[3]
#define DIG4 dig[4]
#define DIG5 dig[5]
#define DIG6 dig[6]
#define DIG7 dig[7]
#define DIG8 dig[8]
#define DIG9 dig[9]

#endif

#define GETSIGN(x) ((UCHAR)(x).mant.sign)
#define SETSIGN(x,s) ((x).mant.sign = (s))
/*  #define GETSIGN(x) ((x).mant.sign ? 1 : 0)               */
/*  #define SETSIGN(x,s) ((x).mant.sign = (s) ? 0x80 : 0x00) */
#define ZERO(x) (!(x).mant.word[0])
#define NORMALIZED(x) ((x).b_byte.DIG0 & 0xF0)
#define ZEROMANT(x) (x).mant.word[0]=(x).mant.word[1]=(x).mant.word[2]= \
		    (x).mant.word[3]=(x).mant.word[4]=0

