(*
-------------------------------------------------------------------------------
-- Name of the source		: TimeRepr.t
-- Author(s)			: SNI
-- Date of creation		: 3 Feb 1992
-- Defined Objects		: TimeRepr 
-- Description of the contents	: 
-- Document reference		: 
-- Copyright 1993, TAO S.A., Barcelona, Spain
-- This software was produced as part of the ESPRIT project ITHACA-IT.
-------------------------------------------------------------------------------
-- Modification log	:
-- Version	Date	Author	Description
-- ------------ ------- ------- -----------------------------------------------
-------------------------------------------------------------------------------
*)

SPECIFICATION TimeRepr 

IMPORT Time FROM Time;     ---Time object

TYPE TimeRepr = Time OBJECT (IN inHours : INT, IN inMinutes : INT,
                             IN inSeconds : INT, IN inFormat : STRING)

PUBLIC
  METHOD GetFormat () : STRING;
    -- Returns the actual format string of this time. The format is  
    -- like the format of the strftime () C-Lib call. 
  METHOD SetFormat (IN inFormat : STRING);
    -- Sets the format of this time.
  METHOD Present () : STRING;
    -- Returns the current time formatted with its representation.

PROTECTED
STATE -- TimeRepr
  format : STRING;

END OBJECT; -- TimeRepr

END SPECIFICATION;
