(*
-------------------------------------------------------------------------------
-- Name of the source		: Time.t
-- Author(s)			: SNI
-- Date of creation		: 5 Feb 1992
-- Defined Objects		: Time
-- Description of the contents	: 
-- Document reference		: 
-- Copyright 1993, TAO S.A., Barcelona, Spain
-- This software was produced as part of the ESPRIT project ITHACA-IT.
-------------------------------------------------------------------------------
-- Modification log	:
-- Version	Date	Author	Description
-- ------------ ------- ------- -----------------------------------------------
--             20/04/93 JLA     All Methods that have to do with Duration object
--                              have been modified (i.e. Add, Subtract and
--                              Distance).
-------------------------------------------------------------------------------
*)

SPECIFICATION Time 

IMPORT Duration FROM Duration; --Duration object
IMPORT Stream FROM Stream;     --Stream object
IMPORT NDuration FROM NDuration;

TYPE Time = OBJECT (IN inHours : INT, IN inMinutes : INT, IN inSeconds : INT)

PUBLIC
  METHOD SetToActualTime ();
    -- Sets the current object to the actual time.
  METHOD Copy () : Time;
    -- Returns a copy of the current Time.
  METHOD GetHours () : INT;
  METHOD GetMinutes () : INT;
  METHOD GetSeconds () : INT;
    -- Return the specific information of the current Time.
  METHOD SetTime (IN inHours : INT, IN inMinutes : INT, IN inSeconds : INT);
    -- Sets the values of the current Time.
  METHOD Add (IN inExtent : NDuration);
  METHOD Subtract (IN inExtent : NDuration);
    -- Add or subtract inExtent to or from the current Time.  
  METHOD Distance (IN inEndTime : Time) : NDuration;
    -- Returns the time between the current Time and inEndTime.
  METHOD IsPassed () : BOOL;
  METHOD IsActual () : BOOL;
  METHOD IsInFuture () : BOOL;
    -- Test the current Time against the actual time.
  METHOD IsEqual (IN inOperand : Time) : BOOL;
  METHOD IsEarlier (IN inOperand : Time) : BOOL;
  METHOD IsLater (IN inOperand : Time) : BOOL;
    -- Compare the current Time with inOperand.
  METHOD Serialize (INOUT ioStream : Stream);
    -- Time state value is stored into ioStream.
  METHOD Deserialize (IN inStream : Stream);
    -- Time state value is loaded from inStream.
  METHOD GetType () : STRING ;
    -- Returns a String containing type name. To be redefined by each subtype.

PROTECTED
STATE -- Time
  hours : INT;
  minutes : INT;
  seconds : INT;

END OBJECT; -- Time

EXCEPTION InvalidTime;

END SPECIFICATION;
