(*
-------------------------------------------------------------------------------
-- Name of the source		: NDuration.t
-- Author(s)			: SNI
-- Date of creation		: 5 Feb 1992
-- Defined Objects		: NDuration 
-- Description of the contents	: Natural Duration object
-- Document reference		: 
-- Copyright 1993, TAO S.A., Barcelona, Spain
-- This software was produced as part of the ESPRIT project ITHACA-IT.
-------------------------------------------------------------------------------
-- Modification log	:
-- Version	Date	Author	Description
-- ----------- -------- ------- -----------------------------------------------
--             13/05/93 JLA     This object is a modification of the Duration
--                              object in CoLibri. Years and months have been
--                              added to the state variables, and so, several
--                              methods to set, get and operate with this va-
--                              riables. Part of the modifications to the Du-
--                              ration object in CoLibri, are specified in the
--                              object Duration, supertype of NDuration object.
-------------------------------------------------------------------------------
*)

SPECIFICATION NDuration 

IMPORT Duration FROM Duration;

TYPE NDuration = Duration OBJECT (IN inYears : INT, IN inMonths : INT,
                                  IN inDays : INT, IN inHours : INT,
                                  IN inMinutes : INT, IN inSeconds : INT)

PUBLIC
  METHOD GetYears () : INT;
  METHOD GetSemesters () : INT;
  METHOD GetQuarters () : INT;
  METHOD GetMonths () : INT;
  METHOD GetWeeks () : INT;
  METHOD GetDays () : INT;
  METHOD GetHours () : INT;
  METHOD GetMinutes () : INT;
  METHOD GetSeconds () : INT;
    -- Return the information of the current NDuration in a given unit.
    -- Conversion between units is not always exact. Approximation is done
    -- sometimes.
  METHOD GetHourPart () : INT;
  METHOD GetMinutePart () : INT;
  METHOD GetSecondPart () : INT;
    -- Return the specific information of the current NDuration.
  METHOD SetNDuration (IN inYears : INT, IN inMonths : INT, IN inDays : INT,
                      IN inHours : INT, IN inMinutes : INT, IN inSeconds : INT);
    -- Sets the values of the current NDuration.

PROTECTED
STATE -- NDuration
  hours : INT;
  minutes : INT;
  seconds : INT;

END OBJECT; -- NDuration

END SPECIFICATION;
