(*
-------------------------------------------------------------------------------
-- Name of the source		: MonthDay.t
-- Author(s)			: Jose Luis Albero
-- Date of creation		: 13 May 1993
-- Defined Objects		: MonthDay
-- Description of the contents	: This object is used only in the calendar
--                                object. It is used to specify the normal
--                                non-working days common to all years. It
--                                is similar to the Date object, but with
--                                less methods than that object and without
--                                the state variable year.
-- Document reference		: 
-- Copyright 1993, TAO S.A., Barcelona, Spain
-- This software was produced as part of the ESPRIT project ITHACA-IT.
-------------------------------------------------------------------------------
-- Modification log	:
-- Version	Date	Author	Description
-- ----------- -------- ------- -----------------------------------------------
-------------------------------------------------------------------------------
*)

SPECIFICATION MonthDay 

IMPORT Date FROM Date;       --Date object
IMPORT Stream FROM Stream;

TYPE MonthDay = OBJECT (inMonth : INT, IN inDay : INT)

PUBLIC
  METHOD SetToActualDate () ;
    -- Sets the current MonthDay to the actual date.
  METHOD Copy () : MonthDay;
    -- Returns a copy of the current MonthDay.
  METHOD GetMonth () : INT;
  METHOD GetDay () : INT;
    -- Return the specific information of the current MonthDay.
  METHOD SetMonthDay (IN inMonth : INT, IN inDay : INT);
    -- Sets the values of the current MonthDay.
  METHOD IsPassed () : BOOL;
  METHOD IsActual () : BOOL;
  METHOD IsInFuture () : BOOL;
    -- Test the current MonthDay against the actual date.
  METHOD IsEqual (IN inOperand : MonthDay) : BOOL;
  METHOD IsEarlier (IN inOperand : MonthDay) : BOOL;
  METHOD IsLater (IN inOperand : MonthDay) : BOOL;
    -- Compare the current MonthDay with the inOperand.
  METHOD IsDateEqual (IN inDate : Date) : BOOL;
    -- Compares the current MonthDay with inDate.
  METHOD Serialize (INOUT ioStream : Stream);
    -- MonthDay state value is stored into ioStream.
  METHOD Deserialize (IN inStream : Stream);
    -- MonthDay state value is loaded from inStream.
  METHOD GetType () : STRING ;
    -- This is an internal method.
    -- Returns a String containing type name. To be redefined by each subtype.

PROTECTED
STATE -- MonthDay
  month : INT;
  day : INT;

END OBJECT; -- MonthDay

END SPECIFICATION;
