(*
-------------------------------------------------------------------------------
-- Name of the source		: Interval.t
-- Author(s)			: SNI
-- Date of creation		: 11 Dec 1991
-- Defined Objects		: Interval
-- Description of the contents	: 
-- Document reference		: 
-- Copyright 1993, TAO S.A., Barcelona, Spain
-- This software was produced as part of the ESPRIT project ITHACA-IT.
-------------------------------------------------------------------------------
-- Modification log	:
-- Version	Date	Author	Description
-- ----------- -------- ------- -----------------------------------------------
--             13/05/93 JLA     Several methods have been added:
--                                - SetInterval, that changes the start
--                                  date and the end date of the interval.
--                                - Methods to get the length of the interval
--                                  in natural days and in working days.
--                                - Methods to compare the length of two
--                                  intervals either in natural days as in
--                                  working days.
-------------------------------------------------------------------------------
*)

SPECIFICATION Interval 

IMPORT Date FROM Date;  --Date object
IMPORT Calendar FROM Calendar;   --Calendar object
IMPORT NDuration FROM NDuration;
IMPORT WDuration FROM WDuration;
IMPORT Duration FROM Duration;
IMPORT Stream FROM Stream;

TYPE Interval = OBJECT (IN inStart : Date, IN inEnd : Date) 

PUBLIC
  METHOD Copy () : Interval;
    -- Return a copy of the current interval.
  METHOD GetStart () : Date;
  METHOD GetEnd () : Date;
    -- Return the specific information of the current interval.
  METHOD GetNLength () : NDuration;
    -- Return the duration in natural days of the current interval.
  METHOD GetWLength (IN inCalen : Calendar) : WDuration;
    -- Return the duration in working days of the current interval.
  METHOD SetStart (IN inStart : Date);
  METHOD SetEnd (IN inEnd : Date);
  METHOD SetInterval (IN inStart : Date, IN inEnd : Date);
    -- Set the values of the current interval.
  METHOD Add (IN inExtent : Duration);
  METHOD Subtract (IN inExtent : Duration);
    -- Add or subtract inExtent to or from both dates of the current interval.
  METHOD AddToStart (IN inExtent : Duration);
  METHOD AddToEnd (IN inExtent : Duration);
  METHOD SubtractFromStart (IN inExtent : Duration);
  METHOD SubtractFromEnd (IN inExtent : Duration);
    -- Add or subtract an extent to or from one date of the current interval.
  METHOD Unite (IN inOperand : Interval);
  METHOD Intersect (IN inOperand : Interval);
    -- Unite or intersect the current interval with inOperand.
  METHOD IsPassed () : BOOL;
  METHOD IsInFuture () : BOOL;
  METHOD IsActual () : BOOL;
    -- Test the current interval against the actual time.
  METHOD IsEqual (IN inOperand : Interval) : BOOL;
  METHOD IsEqualND (IN inOperand : Interval) : BOOL;
  METHOD IsShorterND (IN inOperand : Interval) : BOOL;
  METHOD IsLongerND (IN inOperand : Interval) : BOOL;
    -- Compare the length (in natural days) of the current interval with the
    -- length (in natural days) of inOperand.
  METHOD IsEqualWD (IN inOperand : Interval, IN inCalen : Calendar) : BOOL;
  METHOD IsShorterWD (IN inOperand : Interval, IN inCalen : Calendar) : BOOL;
  METHOD IsLongerWD (IN inOperand : Interval, IN inCalen : Calendar) : BOOL;
    -- Compare the length (in working days) of the current interval with the
    -- length (in working days) of inOperand.
  METHOD IsOverlapping (IN inOperand : Interval) : BOOL;
    -- Test whether the current interval is overlapping with inOperand.
  METHOD Contains (IN inOperand : Interval) : BOOL;
    -- Test whether the current interval contains inOperand. 
  METHOD IsStartInSameYear (IN inOperand : Interval) : BOOL;
  METHOD IsStartInSameMonth (IN inOperand : Interval) : BOOL;
  METHOD IsStartInSameWeek (IN inOperand : Interval) : BOOL;
  METHOD IsStartInSameDay (IN inOperand : Interval) : BOOL;
  METHOD IsEndInSameYear (IN inOperand : Interval) : BOOL;
  METHOD IsEndInSameMonth (IN inOperand : Interval) : BOOL;
  METHOD IsEndInSameWeek (IN inOperand : Interval) : BOOL;
  METHOD IsEndInSameDay	(IN inOperand : Interval) : BOOL;
    -- Test whether the start or end of the current interval and the start or
    -- end of inOperand are laying in the same period.
  METHOD IsEarlier (IN inOperand : Date) : BOOL;
  METHOD ContainsDate (IN inOperand : Date) : BOOL;
  METHOD IsLater (IN inOperand : Date) : BOOL;
    -- Test whether Operand is earlier, in or later than the current interval. 
  METHOD Serialize (INOUT ioStream : Stream);
    -- Interval state value is stored into ioStream.
  METHOD Deserialize (IN inStream : Stream);
    -- Interval state value is loaded from inStream.
  METHOD GetType () : STRING ;
    -- Internal method.
    -- Returns a String containing type name. To be redefined by each subtype.

PROTECTED
STATE -- Interval
  start : Date;
  end : Date;

END OBJECT; -- Interval

EXCEPTION NoOverlap;
EXCEPTION NegativeInterval;

END SPECIFICATION;
