-- ***************************************************************
-- CoLibri
-- ---------------------------------------------------------------
--
-- Map.cs -- 
-- 
--   Copyright (C) sietec Systemtechnik GmbH & Co OHG 1994
--   All rights reserved
-- 
-- Author          : Lutz Hilken
-- 
-- PURPOSE 
--      This module realizes the generic container class Map. It
--      provides the user interface for objects of this collection. 
--
-- REFER
--      see ducoment ITHACA.SNI.CoLibri.91.#4
--
-- ---------------------------------------------------------------
--
-- Created On      : Wed Jan 12 14:57:15 1994
-- Last Modified By: Lutz Hilken
-- Last Modified On: Thu Mar 31 10:41:10 1994
-- Update Count    : 17
-- 
-- ***************************************************************

SPECIFICATION Dictionary

IMPORT Map FROM Map;
IMPORT IdentityBinaryTree FROM BTree;

TYPE Dictionary [KeyType, EntryType] = Map
  OBJECT (less  : PROCEDURE (IN KeyType,
			     IN KeyType) : BOOL,
	  equal : PROCEDURE (IN KeyType,
			     IN KeyType) : BOOL)

-- -----------------------------------------------------------------
-- General
-- -----------------------------------------------------------------
-- 
-- -----------------------------------------------------------------

PUBLIC

PROTECTED

STATE

  Less        : PROCEDURE (IN KeyType, IN KeyType) : BOOL;
  Equal       : PROCEDURE (IN KeyType, IN KeyType) : BOOL;

END OBJECT;

-- ***************************************************************
CONST spec_vid : STRING = 
   "@(#) $__Header$" ;

END SPECIFICATION (* Map *);
