-- ***************************************************************
-- CoLibri
-- ---------------------------------------------------------------
--
-- Conversions.cs -- Conversions between simple CooL types
-- 
--   Copyright (C) sietec Systemtechnik GmbH & Co OHG 1994
--   All rights reserved
-- 
-- Author          : Kalle Koester
-- 
-- PURPOSE 
--      |>Description of modules purpose<|
--
-- REFER
--      |>Documents with client documentation<|
--
-- ---------------------------------------------------------------
--
-- Created On      : Wed Jan 12 14:57:15 1994
-- Last Modified By: Karl-Heinz Koester
-- Last Modified On: Wed Mar  9 13:31:06 1994
-- Update Count    : 10
-- 
-- ***************************************************************

SPECIFICATION Conversions

IMPORT BCD FROM Bcd;

FOREIGN PROCEDURE CharToInt (IN value : CHAR) : INT;
FOREIGN PROCEDURE IntToChar (IN value : INT) : CHAR;

PROCEDURE StringToInt (IN value : STRING) : INT ;
PROCEDURE IntToString (IN value : INT) : STRING ;

PROCEDURE StringToDouble (IN value : STRING) : DOUBLE ;
PROCEDURE DoubleToString (IN value : DOUBLE) : STRING ;

PROCEDURE StringToBcd (IN value : STRING) : BCD;
PROCEDURE BcdToString (IN value : BCD) : STRING;

PROCEDURE StringToCString
  (IN c_string_adr : REF ARRAY OF CHAR,
   IN value        : STRING)
  : REF ARRAY OF CHAR ;

PROCEDURE CStringToString
  (IN value : REF ARRAY OF CHAR)
  : STRING ;

PROCEDURE StringToCStringFixed
  (IN c_string_adr : REF ARRAY OF CHAR,
   IN value        : STRING,
   IN length       : INT) 
  : REF ARRAY OF CHAR ;

PROCEDURE CStringFixedToString
  (IN value  : REF ARRAY OF CHAR,
   IN length : INT)
  : STRING ;

PROCEDURE IntToDouble (IN value : INT) : DOUBLE;
PROCEDURE DoubleToInt (IN value : DOUBLE) : INT;
  
PROCEDURE IntToBcd (IN value : INT) : BCD;
PROCEDURE BcdToInt (IN value : BCD) : INT;

PROCEDURE DoubleToBcd (IN value : DOUBLE) : BCD;
PROCEDURE BcdToDouble (IN value : BCD) : DOUBLE;

EXCEPTION StringContainsNoDigits;
EXCEPTION StringContainsNoBcd;
EXCEPTION IntegerIsOutOfRange;
EXCEPTION DoubleIsOutOfRange;
EXCEPTION BcdIsOutOfRange;
EXCEPTION PositionIsOutOfRange;
  
-- ***************************************************************
CONST spec_vid : STRING = 
   "@(#) $__Header$" ;

END SPECIFICATION (* Conversions *);
