(*
-------------------------------------------------------------------------------
-- Name of the source		: CalendarPR.t
-- Author(s)			: Jose Luis Albero
-- Date of creation		: 13 May 1993
-- Defined Objects		: 
-- Description of the contents	: Definition of auxiliar methods used in
--                                calendar representation.
-- Document reference		: 
-- Copyright 1993, TAO S.A., Barcelona, Spain
-- This software was produced as part of the ESPRIT project ITHACA-IT.
-------------------------------------------------------------------------------
-- Modification log	:
-- Version	Date	Author	Description
-- ------------ ------- ------- -----------------------------------------------
-------------------------------------------------------------------------------
*)

SPECIFICATION CalendarPR

IMPORT Date FROM Date;
IMPORT Calendar FROM Calendar;
IMPORT DateRepr FROM DateRepr; --DateRepr object
IMPORT Time FROM Time;
IMPORT TimeInterval FROM TimeInterval;
IMPORT TimeRepr FROM TimeRepr; --TimeRepr object
IMPORT TimeStamp FROM TimeSt; --TimeStamp object
IMPORT Interval FROM Interval; --Interval object

(*
-------------------------------------------------------------------------------
--     PROCEDUREs defined in this file:
-------------------------------------------------------------------------------

PROCEDURE areTimeTablesEqual (IN inTT1 : timeTable, IN inTT2 : timeTable) : BOOL;
  -- Compares the input timetables. If their components are equal the
  -- procedure returns TRUE; otherwise it returns FALSE.
PROCEDURE areTimeAdjustmentsEqual (IN inTA1 : TimeAdjustment,
                                   IN inTA2 : TimeAdjustment) : BOOL;
  -- Compares the input TimeAdjustments. If their components are equal the
  -- procedure returns TRUE; otherwise it returns FALSE.
PROCEDURE ToWDate (IN inCalendar : Calendar, IN inDate : Date) : Date;
  -- gets the working day that corresponds to the input date. It is
  -- used before adding or subtracting a working duration to a date.
PROCEDURE TimeAfterAdd (IN inCalendar : Calendar, IN inDate : Date) : Time;
  -- gets the end time after adding a working duration to a date. The input
  -- date is the resultant date after addition.
PROCEDURE TimeAfterSubtract (IN inCalendar : Calendar, IN inDate : Date) : Time;
  -- gets the end time after subtracting a working duration to a date. The
  -- input date is the resultant date after addition.
PROCEDURE startOfMonth (IN inDate : Date) : TimeStamp;
  -- returns the start of the month of the input date.
PROCEDURE endOfMonth (IN inDate : Date) : TimeStamp;
  -- returns the end of the month of the input date.
PROCEDURE nextDay (IN inDate : Date) : Date;
  -- returns the next natural day of the input day.
PROCEDURE prevDay (IN inDate : Date) : Date;
  -- returns the previus natural day of the input day.
PROCEDURE ShowCalendar (IN inCalen : Calendar);
  -- Stores all information about input calendar in a file named as the
  -- calendar with the extension .infor.
-------------------------------------------------------------------------------
*)

EXCEPTION DateOutOfCalendar;
EXCEPTION NonWorkingDayDuplic;
EXCEPTION TimeTablesOverlap;
EXCEPTION NonWorkingDay;
EXCEPTION ValidPeriodNotInit;
EXCEPTION TimeTablesNotInit;
EXCEPTION ValidPeriodNotCovered;

-- constant used to define the maximum size of sets
CONST MAX_NB_TIMETABLES : INT = 12;
CONST MAX_NB_NORMAL_NW_DAYS : INT = 10;
CONST MAX_NB_VARIABLE_NW_DAYS : INT = 30;
CONST MAX_NB_LOCAL_NW_DAYS : INT = 15;

-- constants used to determine the time at wich a working day starts or ends.
-- They are the values that may get the field AtTime of TimeAdjustmenting record
-- (see below)
CONST START_TIME_CURRENT_DAY : INT = 1;
CONST END_TIME_PREVIOUS_DAY : INT = 2;
CONST FIXED_TIME_CURRENT_DAY : INT = 3;
CONST FIXED_TIME_PREVIOUS_DAY : INT = 4;
CONST END_TIME_CURRENT_DAY : INT = 5;

-- this type is to define the start and end working hours of every day in a
-- week. It
TYPE timeTable = RECORD
  ValidPeriod : Interval;
  Table : ARRAY [7] OF TimeInterval;
  NWWeekDays : ARRAY [7] OF BOOL; -- 1=Sunday, 2=Monday, ..., 7=Saturday.
END RECORD;

--
TYPE TimeAdjustment = RECORD
  AtTime : INT;
  FixedTime : Time;
END RECORD;

-- -----------------------------------------------------

VAR gvOfficeCalendar : Calendar; -- reference calendar

-- -----------------------------------------------------

PROCEDURE areTimeTablesEqual (IN inTT1 : timeTable, IN inTT2 : timeTable) : BOOL;

PROCEDURE areTimeAdjustmentsEqual (IN inTA1 : TimeAdjustment,
                                   IN inTA2 : TimeAdjustment) : BOOL;

PROCEDURE startOfMonth (IN inDate : Date) : TimeStamp;

PROCEDURE endOfMonth (IN inDate : Date) : TimeStamp;

PROCEDURE nextDay (IN inDate : Date) : Date;

PROCEDURE prevDay (IN inDate : Date) : Date;

PROCEDURE ShowCalendar (IN inCalen : Calendar);

END SPECIFICATION;
