SPECIFICATION BTree

TYPE IdentityBinaryTree [KeyType, EntryType] = 
  OBJECT (IN Key   : KeyType,
	  IN Entry : EntryType)
  -- -----------------------------------------------------------------
  -- 
  -- -----------------------------------------------------------------

PUBLIC
  METHOD GetKey     () : KeyType;
    -- -----------------------------------------------------------------
    -- 
    -- -----------------------------------------------------------------
    
  METHOD GetEntry   () : EntryType;
    -- -----------------------------------------------------------------
    -- 
    -- -----------------------------------------------------------------
    
  METHOD SetEntry   (IN Entry : EntryType);
    -- -----------------------------------------------------------------
    -- 
    -- -----------------------------------------------------------------
    
  METHOD Insert     (IN Key   : KeyType,
		     IN Entry : EntryType);
    -- -----------------------------------------------------------------
    -- 
    -- -----------------------------------------------------------------
    
  METHOD Search     (IN Key : KeyType) : EntryType;
    -- -----------------------------------------------------------------
    -- 
    -- -----------------------------------------------------------------
    
  METHOD Remove     (IN Key : KeyType) 
                     : IdentityBinaryTree [KeyType, EntryType];
    -- -----------------------------------------------------------------
    -- 
    -- -----------------------------------------------------------------
    
  METHOD First      () : IdentityBinaryTree [KeyType, EntryType];
    -- -----------------------------------------------------------------
    -- 
    -- -----------------------------------------------------------------
    
  METHOD Last       () : IdentityBinaryTree [KeyType, EntryType];
    -- -----------------------------------------------------------------
    -- 
    -- -----------------------------------------------------------------
    
  METHOD NextKey    (IN Key : KeyType) 
                     : IdentityBinaryTree [KeyType, EntryType];
    -- -----------------------------------------------------------------
    -- 
    -- -----------------------------------------------------------------
    
  METHOD PrevKey    (IN Key : KeyType) 
                     : IdentityBinaryTree [KeyType, EntryType];
    -- -----------------------------------------------------------------
    -- 
    -- -----------------------------------------------------------------
    
  METHOD SearchKey  (IN Key : KeyType) 
                     : IdentityBinaryTree [KeyType, EntryType];
    -- -----------------------------------------------------------------
    -- 
    -- -----------------------------------------------------------------
    
  METHOD Less (IN k1 : KeyType,
	       IN k2 : KeyType) : BOOL;
    -- -----------------------------------------------------------------
    -- 
    -- -----------------------------------------------------------------
  
  METHOD Equal (IN k1 : KeyType,
		IN k2 : KeyType) : BOOL;
    -- -----------------------------------------------------------------
    -- 
    -- -----------------------------------------------------------------
  
PROTECTED
  
  METHOD InsertLeft (IN smallest : IdentityBinaryTree [KeyType, EntryType]);
    -- -----------------------------------------------------------------
    -- 
    -- -----------------------------------------------------------------
  
STATE
  key   : KeyType;
  entry : EntryType;
  left  : IdentityBinaryTree [KeyType, EntryType];
  right : IdentityBinaryTree [KeyType, EntryType];
  
END OBJECT;

TYPE BinaryTree [KeyType, EntryType] = IdentityBinaryTree 
  OBJECT (IN Key            : KeyType,
	  IN Entry          : EntryType,
	  IN LessPredicate  : PROCEDURE (IN KeyType,
					 IN KeyType) : BOOL,
	  IN EqualPredicate : PROCEDURE (IN KeyType,
					 IN KeyType) : BOOL)
  -- -----------------------------------------------------------------
  -- 
  -- -----------------------------------------------------------------

PUBLIC
  
PROTECTED

STATE
  lesspredicate  : PROCEDURE (IN KeyType, IN KeyType) : BOOL;
  equalpredicate : PROCEDURE (IN KeyType, IN KeyType) : BOOL;

END OBJECT;

EXCEPTION NoPreviousElement;
EXCEPTION NoNextElement;
EXCEPTION KeyNotFound;
EXCEPTION KeyAlreadyExists;

CONST spec_vid : STRING = "@(#) $__Header$";

END SPECIFICATION;
