/*
	Copyright (c) Frank Klemm 1992. All Rights reserved.
	Frank.Klemm@HpUx.Rz.Uni-Jena.De

	Ported to linux 5 Feb 93 
	  Ray Balister - balister@cebaf.gov
*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "set.h"

/*
	An example of an program for DOS. It sets the pixel clock to the given
	value.
*/

#define TRUE      1
#define FALSE     0

void perm_ports(int);

int main(int argc, char **argv)
  { unsigned long freq	 ;
    unsigned long newfreq;
    unsigned	  quarz=2;

    if (argc == 1)
      { fprintf(stderr,"usage: FREQ Pixel_clock_in_kHz [Quartz_#]\n");
	return 1;
      }

    freq=atol(argv[1]);
    if (argc > 2)
      quarz=atoi(argv[2]);

    if (freq<300l || freq>128000l)
      { fprintf(stderr,"Pixel clock must be in the range [300-128000]\n");
	return 1;
      }
    if (freq>86000)
      fprintf(stderr,"Clock generator is running outside the specification\n");
    if (quarz>2)
      { fprintf(stderr,"Quarz must be 0, 1, or 2\n");
	return 1;
      }

    perm_ports( TRUE );  /* set i/o permissions - RLB */
    newfreq=setfreq(freq,quarz);
    printf("[%1X-%1X-%2X-%2X]=[%06lX]\t%5lu kHz instead of%6lu kHz\n",
	    _bin,_gen,_mul,_div,_value,newfreq,freq);
    perm_ports( FALSE ); /* clear i/o permissions - RLB */
    return 0;
  }

inline void outportb( unsigned short port, char value)
{
__asm__ __volatile__ ("outb %%al,%%dx"
		::"a" ((char) value),"d" ((unsigned short) port));
}

inline unsigned int inportb(unsigned short port)
{
	unsigned int _v;
__asm__ __volatile__ ("inb %%dx,%%al"
		:"=a" (_v):"d" ((unsigned short) port),"0" (0));
	return _v;
}

/*
** Routine to set the permissions of i/o
** ports used for clock manipulation.  May not
** be clean, but it works.  --  RLB
*/

void perm_ports(int perm)
{
  ioperm(0x3c2, 1, perm);
  ioperm(0x3cc, 1, perm);
}


/* End of FREQ.C */
