/*
	Copyright (c) Frank Klemm 1992. All Rights reserved.
	Frank.Klemm@HpUx.Rz.Uni-Jena.De

	Ported to linux 5 Feb 93 
	  Ray Balister - balister@cebaf.gov

 *  Changed to run as clock setting program to be used by XServer
 *  Peter Chang 12/9/94
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "set.h"

/*
	An example of an program for DOS. It sets the pixel clock to the given
	value.
*/

#define TRUE      1
#define FALSE     0

void perm_ports(int);

int main(int argc, char **argv)
{
   unsigned long freq;
   unsigned long newfreq;
   unsigned quarz=2;
   int ino;

   if (argc == 2 || argc > 3) {
      fprintf(stderr,"usage: %s freq index\n", argv[0]);
      exit(1);
   }
   if (argc == 3) {
      fprintf(stderr, "freq parameters: %s %s\n", argv[1], argv[2]);
      freq=(long) (atof(argv[1])*1000.0);
      ino = atoi(argv[2]);
   } else {
      fprintf(stderr, "no freq parameters: using clock 1\n");
      freq = 28320; /* primarily for reseting screen */
      ino = 1;
   }
   quarz = (ino < 2) ? ino : 2;

   if (freq<300l || freq>128000l) {
      fprintf(stderr,"Pixel clock must be in the range [300-128000]\n");
      exit(2);
   }
   if (freq>86000)
      fprintf(stderr,"Clock generator is running outside the specification\n");

   perm_ports( TRUE );  /* set i/o permissions - RLB */
   newfreq=setfreq(freq,quarz);
   if (quarz > 1) {
      fprintf(stderr, "%5lu kHz instead of%6lu kHz, index %d, quartz %d\n",
	      newfreq,freq,ino,quarz);
   } else {
      fprintf(stderr, " using index %d quartz %d\n", ino,quarz);
   }
   perm_ports( FALSE ); /* clear i/o permissions - RLB */
   exit(0);
}

inline void outportb( unsigned short port, char value)
{
__asm__ __volatile__ ("outb %%al,%%dx"
		::"a" ((char) value),"d" ((unsigned short) port));
}

inline unsigned int inportb(unsigned short port)
{
	unsigned int _v;
__asm__ __volatile__ ("inb %%dx,%%al"
		:"=a" (_v):"d" ((unsigned short) port),"0" (0));
	return _v;
}

/*
** Routine to set the permissions of i/o
** ports used for clock manipulation.  May not
** be clean, but it works.  --  RLB
*/

void perm_ports(int perm)
{
  ioperm(0x3c2, 1, perm);
  ioperm(0x3cc, 1, perm);
}


/* End of FREQ.C */
