/*
      Copyright (C) 1993,1994 Jon Tombs.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 The entire guts of this program was written by dosemu, modified to
 record reads and writes to the ports in the 0x180-0x188 address space,
 while running the CMS program TAPE.EXE V2.0.5 supplied with the drive.

 Modified to use an array of addresses and generally cleaned up (made
 much shorter) 4 June 94, dosemu isn't that good at writing short code it
 would seem :-). Made independant of 0x180, but I doubt it will work
 at any other address.
 
 Modified for distribution with ftape source. 21 June 94, SJL.

 $Source: /home/bas/distr/ftape-1.14d/RCS/fc-10.c,v $
 $Author: bas $
 *
 $Revision: 1.2 $
 $Date: 1994/06/26 14:10:38 $
 $State: Beta $
 *
 *      This file contains code for the CMS FC-10 card.
 */

static char RCSid[] = "$Id: fc-10.c,v 1.2 1994/06/26 14:10:38 bas Beta $";

#include <asm/io.h>
#include "ftape.h"
#include "fdc-io.h"
#include "fc-10.h"

#ifdef PROBE_FC10

unsigned short inbs_magic[] = {
  0x3, 0x3, 0x0, 0x4, 0x7, 0x2, 0x5, 0x3, 0x1, 0x4,
  0x3, 0x5, 0x2, 0x0, 0x3, 0x7, 0x4, 0x2,
  0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7
};

int fc10_enable( void)
{
   int i;

   /*  Clear state machine ???
    */
   for (i = 0; i < NR_ITEMS( inbs_magic); i++) {
     inb( FDC_BASE + inbs_magic[ i]);
   }
   outb( 0x0, FDC_BASE);

   for (i = 0; i < 8; i++) {
     if (inb( FDC_BASE + i) != 0x13) {
       return 0;
     }
   }
   outb( 0x8, FDC_BASE);

   for (i = 0; i < 8; i++) {
     if (inb( FDC_BASE + i) != 0x0) {
       return 0;
     }
   }
   outb( 0x10, FDC_BASE);

   for (i = 0; i < 8; i++) {
     if (inb( FDC_BASE + i) != 0xff) {
       return 0;
     }
   }

   /*  Okay, we found a FC-10 card ! ???
    */
   outb( 0x0, fdc.ccr);

   /*  Clear state machine again ???
    */
   for (i = 0; i < NR_ITEMS( inbs_magic); i++) {
     inb( FDC_BASE + inbs_magic[ i]);
   }
   outb( 0xd1, FDC_BASE);

   /*  Enable FC-10 ???
    */
   outb( 0, fdc.ccr);
   outb( 0, FDC_BASE + 0x6);
   outb( 8, fdc.dor);
   outb( 8, fdc.dor);   
   outb( 1, FDC_BASE + 0x6);

   /*  Initialize fdc, select drive B:
    */
   outb( 0x08, fdc.dor);        /* assert reset, dma & irq enabled */
   outb( 0x0c, fdc.dor);        /* release reset */
   outb( 0x2d, fdc.dor);        /* select drive 1 */

   return 1;
}

#endif /* CMS_FC10_CONTROLLER*/

