#include "forms.h"

static FL_FORM *fxyplot;
static float x[6][21], y[6][21];

static FL_OBJECT *xyplot[6];
static void create_form_xyplot(void);

typedef struct
{
   int type;
   char *name;
   FL_COLOR color;
} 
XYType;

#define VN(a,c)   {a,#a,c}

static XYType xytype[] =
{
  VN(FL_NORMAL_XYPLOT,FL_BLACK),
  VN(FL_SQUARE_XYPLOT,FL_RED),
  VN(FL_CIRCLE_XYPLOT,FL_GREEN),
  VN(FL_POINTS_XYPLOT,FL_BLUE),
  VN(FL_DASHED_XYPLOT,FL_INDIANRED),
  VN(FL_FILL_XYPLOT,FL_SLATEBLUE),
  VN(-1,0),
};

#define N (sizeof(xytype) / sizeof(xytype[0]) - 1)


static void
done_xyplot(FL_OBJECT *ob, long q)
{
    fl_hide_form(ob->form); 
    exit(0);
}

#include <math.h>
int
main(int argc, char *argv[])
{
     int i, j;

     fl_initialize(argv[0], "FormDemo", 0, 0 ,&argc, argv);
     create_form_xyplot();

     for ( i = 0; i < N; i++)
     {
         for(j = 0; j < 21; j++)
         {
          x[i][j] = (float)j * 3.1415 / 10 ;
          y[i][j] = sin(2*x[i][j]) + cos(x[i][j]);
         }
         fl_set_xyplot_data(xyplot[i], x[i], y[i], 21, "TestTitle", 
         "X-axis", "Y-Axis");
     }

     fl_show_form(fxyplot, FL_PLACE_ASPECT, FL_TRANSIENT, "XYplot");

     while (fl_do_forms())
      ;
      return 0;
}

static
void create_form_xyplot(void)
{
  FL_OBJECT *obj;
  XYType *xy  = xytype;

  if (fxyplot)
     return;

  fxyplot = fl_bgn_form(FL_NO_BOX,570,430);
  obj = fl_add_box(FL_UP_BOX,0,0,570,430,"");

  if(xy->type != -1)
  {
    xyplot[0] = obj = fl_add_xyplot(xy->type,20,230,160,160,xy->name);
    fl_set_object_lsize(obj, FL_TINY_SIZE);
    fl_set_object_color(obj, FL_COL1, xy->color);
    xy++;
  }

  if(xy->type != -1)
  {
    xyplot[1] = obj = fl_add_xyplot(xy->type,200,230,160,160,xy->name);
    fl_set_object_lsize(obj, FL_TINY_SIZE);
    fl_set_object_color(obj, FL_COL1, xy->color);
    xy++;
  }

  if(xy->type != -1)
  {
    xyplot[2] = obj = fl_add_xyplot(xy->type,380,230,160,160,xy->name);
    fl_set_object_lsize(obj, FL_TINY_SIZE);
    fl_set_object_color(obj, FL_COL1, xy->color);
    xy++;
  }

  if(xy->type != -1)
  {
     xyplot[3] = obj = fl_add_xyplot(xy->type,20,60,160,160,xy->name);
     fl_set_object_lsize(obj, FL_TINY_SIZE);
    fl_set_object_color(obj, FL_COL1, xy->color);
     xy++;
  }

  if(xy->type != -1)
  {
    xyplot[4] = obj = fl_add_xyplot(xy->type,200,60,160,160,xy->name);
    fl_set_object_lsize(obj, FL_TINY_SIZE);
    fl_set_object_color(obj, FL_COL1, xy->color);
    xy++;
  }

  if(xy->type != -1)
  {
    xyplot[5] = obj = fl_add_xyplot(xy->type,380,60,160,160,"");
    fl_set_object_lsize(obj, FL_TINY_SIZE);
    fl_set_object_color(obj, FL_COL1, xy->color);
  }

  obj = fl_add_button(FL_NORMAL_BUTTON,230,15,100,30,"Exit");
  fl_set_object_callback(obj, done_xyplot, 0);

  obj = fl_add_text(FL_NORMAL_TEXT,160,390,240,30,"FL_XYPLOT");
  fl_set_object_lcol(obj, FL_SLATEBLUE); 
  fl_set_object_lsize(obj, FL_HUGE_SIZE);
  fl_set_object_lstyle(obj, FL_BOLD_STYLE+FL_EMBOSSED_STYLE);
  fl_set_object_boxtype(obj, FL_FLAT_BOX);

  fl_end_form();
}
