/*
 *  rsrc_mgr.h 1.1 1995/04/20 20:48:45 (David Hinds)
 */

#ifndef _RSRC_MGR_H
#define _RSRC_MGR_H

typedef struct resource_entry_t {
    u_long base, num;
    struct resource_entry_t *next;
} resource_entry_t;

extern resource_entry_t mem_db;
extern resource_entry_t io_db;

int check_mem_region(u_long base, u_long num);
int register_mem_region(u_long base, u_long num, char *name);
int release_mem_region(u_long base, u_long num);

int add_interval(resource_entry_t *map, u_long base, u_long num);
int sub_interval(resource_entry_t *map, u_long base, u_long num);

int find_io_region(ioaddr_t *base, ioaddr_t num, char *name);
int find_mem_region(u_long *base, u_long num, char *name);

#endif	/* _RSRC_MGR_H */
