/* This demo shows the different routines on browsers */

#include "forms.h"

FL_FORM *form;
FL_OBJECT *browserobj, *inputobj, *exitobj;

void addit(FL_OBJECT *obj, long arg)
{
  fl_addto_browser(browserobj,fl_get_input(inputobj));
}

void insertit(FL_OBJECT *obj, long arg)
{
  if (! fl_get_browser(browserobj)) return;
  fl_insert_browser_line(browserobj,fl_get_browser(browserobj),fl_get_input(inputobj));
}

void replaceit(FL_OBJECT *obj, long arg)
{
  if (! fl_get_browser(browserobj)) return;
  fl_replace_browser_line(browserobj,fl_get_browser(browserobj),fl_get_input(inputobj));
}

void deleteit(FL_OBJECT *obj, long arg)
{
  if (! fl_get_browser(browserobj)) return;
  fl_delete_browser_line(browserobj,fl_get_browser(browserobj));
}

void clearit(FL_OBJECT *obj, long arg)
{
  fl_clear_browser(browserobj);
}

/*---------------------------------------*/

void create_form(void)
{
  FL_OBJECT *obj;
  form = fl_bgn_form(FL_UP_BOX,390.0,420.0);
  browserobj = fl_add_browser(FL_HOLD_BROWSER,20.0,70.0,210.0,330.0,"");
  inputobj = obj = fl_add_input(FL_NORMAL_INPUT,20.0,20.0,210.0,30.0,"");
    fl_set_object_callback(obj,addit,0);
  obj = fl_add_button(FL_NORMAL_BUTTON,250.0,370.0,120.0,30.0,"Add");
    fl_set_object_callback(obj,addit,0);
  obj = fl_add_button(FL_NORMAL_BUTTON,250.0,330.0,120.0,30.0,"Insert");
    fl_set_object_callback(obj,insertit,0);
  obj = fl_add_button(FL_NORMAL_BUTTON,250.0,290.0,120.0,30.0,"Replace");
    fl_set_object_callback(obj,replaceit,0);
  obj = fl_add_button(FL_NORMAL_BUTTON,250.0,230.0,120.0,30.0,"Delete");
    fl_set_object_callback(obj,deleteit,0);
  obj = fl_add_button(FL_NORMAL_BUTTON,250.0,190.0,120.0,30.0,"Clear");
    fl_set_object_callback(obj,clearit,0);
  exitobj = fl_add_button(FL_NORMAL_BUTTON,250.0,20.0,120.0,30.0,"Exit");
  fl_end_form();
}

/*---------------------------------------*/

int
main(int argc, char *argv[])
{
  FL_OBJECT *obj;
  fl_initialize(argv[0], "FormDemo", 0, 0 ,&argc, argv);
  create_form();
  fl_show_form(form,FL_PLACE_CENTER,FL_NOBORDER,NULL);
  do obj = fl_do_forms(); while (obj != exitobj);
  fl_hide_form(form);
  return 0;
}
