/* This demo is meant to demonstrate the use of a free
   object in a form.
*/

#include "forms.h"

int on = 1, dcol = 1;
FL_COLOR col = FL_FREE_COL1, cole;

/* The call back routine */
int handle_it(FL_OBJECT *obj, int event, FL_Coord mx, FL_Coord my, 
          int key, void *ev)
{
  switch (event)
  {
    case FL_DRAW:
        fl_rectf(obj->x,obj->y,obj->w,obj->h, col);
        break;
    case FL_RELEASE:
	on = !on;
	break;
    case FL_STEP:
 	if (on)
	{ 
	  if (col == cole) dcol = -1;
	  if (col == FL_FREE_COL1) dcol = 1;
	  col += dcol;
          fl_redraw_object(obj);
	}
	break;
  }
  return 0;
}

int
main(int argc, char *argv[])
{
  FL_FORM *form;
  FL_OBJECT *obj, *but;
  int i, j, depth;

  fl_initialize(argv[0], "FormDemo", 0, 0 ,&argc, argv);
  form = fl_bgn_form(FL_UP_BOX,400.0,400.0);
  obj = fl_add_free(FL_CONTINUOUS_FREE,40.0,80.0,320.0,280.0,"",handle_it);
  but = fl_add_button(FL_NORMAL_BUTTON,320.0,20.0,40.0,30.0,"Exit");
  fl_end_form();

  depth  = fl_get_visual_depth();
  /* can't do it if less than 6 bit deep */
  if(depth < 6)
  {
    fprintf(stderr,"This Demo requires a depth of at least 6 bits\n");
    exit(1);
  }

  cole = ((1 << depth)-1);
  if(cole > 100)
     cole = 100;

  col = FL_FREE_COL1;
  for ( i = col; i <= cole; i++)
  {
     j = 255 * (i - col) /(float)(cole  - col);
     fl_mapcolor(i, j, j, j);
  }

  fl_show_form(form,FL_PLACE_CENTER,FL_NOBORDER,NULL);
  while (obj != but)
     obj = fl_do_forms();
  fl_hide_form(form);
  return 0;
}
