/* Class XYPLOT, type active, demo */

#include "forms.h"

FL_FORM *axy;
FL_OBJECT *xyplot, *xp, *yp;

void create_form_axy(void);
static int border = FL_NOBORDER;

int
main(int argc, char *argv[])
{
    float x[20], y[20];
    int i;

    fl_initialize(argv[0], "FormDemo", 0, 0, &argc, argv);
    create_form_axy();
    for (i = 0; i < 20; i++)
	x[i] = y[i] = i;
    fl_set_xyplot_data(xyplot, x, y, 20, "", "", "");
    fl_show_form(axy, FL_PLACE_ASPECT, border, "FL_ACTIVE_XYPLOT");
    fl_do_forms();
    return 0;
}

static void 
ret_cb(FL_OBJECT * ob, long q)
{
    fl_set_xyplot_return(xyplot, fl_get_button(ob));
}

static void 
tic_cb(FL_OBJECT * ob, long q)
{
    if (fl_get_button(ob))
    {
	fl_set_xyplot_xtics(xyplot, -1, -1);
	fl_set_xyplot_ytics(xyplot, -1, -1);
    }
    else
    {
	fl_set_xyplot_xtics(xyplot, 0, 0);
	fl_set_xyplot_ytics(xyplot, 0, 0);
    }
}

static void 
xyplot_cb(FL_OBJECT * ob, long q)
{
    float xx, yy;
    int i;
    char xc[15], yc[15];

    fl_get_xyplot(ob, &xx, &yy, &i);
    sprintf(xc, "%f", xx);
    sprintf(yc, "%f", yy);
    fl_set_object_label(xp, xc);
    fl_set_object_label(yp, yc);
}

void 
create_form_axy(void)
{
    FL_OBJECT *obj;

    if (axy)
	return;

    axy = fl_bgn_form(FL_NO_BOX, 420, 290);
    obj = fl_add_box(FL_UP_BOX, 0, 0, 420, 290, "");
    xyplot = obj = fl_add_xyplot(FL_ACTIVE_XYPLOT, 10, 10, 280, 270, "");
      fl_set_object_boxtype(obj, FL_UP_BOX);
      fl_set_object_color(obj, FL_COL1, FL_BLUE);
      fl_set_object_callback(obj, xyplot_cb, 0);
    obj = fl_add_box(FL_UP_BOX, 290, 10, 120, 270, "");
    obj = fl_add_button(FL_NORMAL_BUTTON, 305, 20, 95, 30, "Exit");
    obj = fl_add_roundbutton(FL_PUSH_BUTTON, 300, 235, 100, 25, "AlwaysReturn");
      fl_set_object_callback(obj, ret_cb, 0);
    obj = fl_add_roundbutton(FL_PUSH_BUTTON, 300, 215, 100, 25, "NoTics");
      fl_set_object_callback(obj, tic_cb, 0);
    xp = obj = fl_add_text(FL_NORMAL_TEXT, 310, 190, 85, 20, "");
      fl_set_object_boxtype(obj, FL_FRAME_BOX);
    yp = obj = fl_add_text(FL_NORMAL_TEXT, 310, 170, 85, 20, "");
      fl_set_object_boxtype(obj, FL_FRAME_BOX);
    fl_end_form();
}
