/******************************************************************************
 * --- bt_trace.h --- Copyright (C) 1994 by Thomas Weidenfeller
 *
 * File ID:
 *	$Id: bt_trace.h,v 1.2 1994/10/26 18:23:46 root Exp $
 *
 * Purpose:
 *	Trace facility macros
 *
 * Copyright:
 *	Copyright (C) 1994 by T. Weidenfeller. All rights reserved
 *	
 *	You are free to copy, modify and distribute this software as you
 *	see fit, and to use it for any purpose, provided this copyright
 *	notice and the warranty disclaimer are included without any
 *	modification in all copies and modifications. You have to mark all
 *	modifications clearly and you are also commited to give propper
 *	acknowledgment of the original source if you include this software
 *	or parts of it in another software.
 *	
 * Warranty:
 *	The BiTronics device driver and the accompaning material is a free
 *	sample of no commercial value. It comes without any warranty:
 *	
 *	THERE IS NO WARRANTY OF ANY KIND WITH REGARDS TO THIS MATERIAL,
 *	INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *	MECHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. The author
 *	shall not be liable for errors contained in the material or for
 *	incidental or consequental damage in connection with the
 *	furnishing, performance, or use of this material.
 *	
 * Revisions: $Log: bt_trace.h,v $
 *	Revision 1.2  1994/10/26  18:23:46  root
 *	General harmonisation (prep 1. ALPHA release).
 *
 * Revision 1.1  1994/10/23  19:37:43  root
 * Initial revision
 *
 *****************************************************************************/

#ifndef BT_TRACE_H_
#define BT_TRACE_H_

/******************************************************************************
 * Tracing facility
 * NOTE: We use a customized version of TW-SATS with advanced
 *	 gcc macro features.
 *****************************************************************************/
/*
 * Flags
 */
#define BTTF_LOWF	(0x01)	/* Low-level function entry/exit */
#define BTTF_HIGHF	(0x02)	/* High-lvel function entry/exit */
#define BTTF_MEDF	(0x04)	/* Medium */
#define BTTF_FUNC	(BTTF_LOWF | BTTF_MEDF | BTTF_HIGHF)	/* all functions */
#define BTTF_DIR	(0x08)	/* BiTronics direction	*/
#define BTTF_TIME	(0x10)	/* Timing/scheduling	*/
#define BTTF_ALL	(~0)	/* all functions	*/



#ifdef BT_TRACE
#ifndef BTM_IN /* this is a hack! (code generation in headers... brrr... */
static unsigned bt_tflags = BTTF_ALL;	/* tracing management 		*/
static int	bt_tcntr  = 0;
static int	bt_tflayer = 0;		/* Indenting management		*/
static char	bt_tindent[] = "                                              ";
#define BTM_IN	(sizeof(bt_tindent) - 1)
#endif

#define BTPRINT__(m, c, i, f, a...)					\
	do {								\
		if((m) & bt_tflags) {					\
			printk("[%4d] %s" c " " "["__FUNCTION__ "] ",	\
				++bt_tcntr, 				\
				&bt_tindent[BTM_IN - (i)]);		\
			printk(f, ## a);				\
		}							\
	} while(0)

#define BTPRINT(m, f, a...) 	BTPRINT__(m, " ", bt_tflayer,   f, ## a)
#define BTENTER(m, f, a...) 	BTPRINT__(m, "+", bt_tflayer++, f, ## a)
#define BTEXIT(m, f, a...) 	BTPRINT__(m, "-", --bt_tflayer, f, ## a)
#define BTMARK(m, f, a...) 	BTPRINT__(m, "*", bt_tflayer,   f, ## a)

#else

#define BTPRINT(m, f, a...)
#define BTENTER(m, f, a...)
#define BTEXIT(m, f, a...)
#define BTMARK(m, f, a...)

#endif


#endif /* !BT_TRACE_H_	*/
