
/*
 * Copyright 1993, 1994, 1995 by the Regents of the University of California
 * see the file "Copyright" in the distribution for conditions of use.
 */

#include <curses.h>
#include <curses.h>
#include <string.h>

#include "getch7.h"
#include "misc.h"
#include "node.h"

do_node( command_orig )
char *command_orig;
{
	/* may need room to add in base_dir */
	char commands[MAX_CMND_LEN + 100];
	char cmnd_temp[MAX_CMND_LEN + 100];
	char *cmnd_ptr;
	char *ptr;
	char *tmp_ptr;
	char *get_input();
	char *new;
	int option_env = 0;
	int option_gopher = 0;
	int option_telnet = 0;
	int option_control = 0;

	/* have options letters followed by '=' */
	strcpy( commands, command_orig );
	cmnd_ptr = commands;
	while( *cmnd_ptr != '=' ) {
		switch( *cmnd_ptr ) {
		case 'e':
			option_env++; break;
		case 'i':
			option_control++; break;
		case 'g':
			option_gopher++; break;
		case 't':
			option_telnet++; break;
		}
		cmnd_ptr++;
	}
	cmnd_ptr++;
	new = cmnd_temp;
		
	if( (ptr = strstr( cmnd_ptr, "$etc" )) != NULL ) {
		strncpy( new, cmnd_ptr, ptr - cmnd_ptr);
		new[ ptr - cmnd_ptr ] = '\0';
		strcat( new, base_dir );
		strcat( new, "/" );
		strcat( new, ptr+1 );
		strcpy( cmnd_ptr, new );
	}

	if( (ptr = strstr( cmnd_ptr, "$host" )) != NULL ) {
		tmp_ptr = get_input( "Enter remote hostname: " );
		if( tmp_ptr == NULL ) return;
		strncpy( new, cmnd_ptr, ptr - cmnd_ptr);
		new[ ptr - cmnd_ptr ] = '\0';
		strcat( new, tmp_ptr );
		strcat( new, ptr+5 );
		strcpy( cmnd_ptr, new );
	}

	/* special text for gopher and telnet */
	if( option_gopher ) {
		if( gopher_warn( cmnd_ptr ) == 0 ) return;
	} else if( option_telnet ) {
		if( telnet_warn( cmnd_ptr ) == 0 ) return;
	}

	/* special for UNIX shell - restore suspend chars */
	if( option_control ) {
		restore_suspend();
	}

	curses_end();

	system( cmnd_ptr );
	back_to_menu();

	if( strncmp( cmnd_ptr, "do_unix", 7 ) == 0 ) undefine_suspend();

	/* if command may have changed env. vars, must scan and execute
		last line of .cshrc */
	if( option_env ) set_last_env();
}

char *
get_input( prompt )
char *prompt;
{
	char temp_str[100];
	char *ptr;
	int ch;
	char *ptr_first = NULL;
	char *ptr_last = NULL;
	int prompt_len = strlen( prompt );

	/*
	 *	input is prompt - string to prompt with
	 *	return pointer to beginning of static array of input chars
	 *	    chars are all printable, ^H, Del, ^X, ^U processing done
	 *	return NULL if nothing found after deleting white space
	 */
	raw();

	mvaddstr( LINES - 1, 0, prompt );
	clrtoeol();
	refresh();
	
	ptr = temp_str;
	while( 1 ) {
		GETCH7( ch );
		if( ch == '\n' || ch == '\r' ) break;
		if( isprint( ch ) ) {
			addch(ch);
			*ptr++ = ch;
		} else if( ch == 025 || ch == 030 ) {
			/* either ^U or ^X - treat both as kill chars */
			ptr = temp_str;
			*ptr = '\0';
			mvaddstr( LINES -1, prompt_len, "" );
			clrtoeol();
		} else if( (ch == 010 || ch == 0177) && ptr > temp_str ) {
			/* either ^H or delete */
			ptr--;
			*ptr = '\0';
			mvaddstr( LINES -1, prompt_len, temp_str );
			clrtoeol();
		} else {
			ring_bell();
		}
		refresh();
	}
	noraw();

	*ptr = '\0';
	for( ptr = temp_str; *ptr != '\0'; ptr++ ) {
		if( *ptr != ' ' ) {
			if( ptr_first == NULL ) ptr_first = ptr;
			ptr_last = ptr;
		}
	}
	if( ptr_last != NULL ) *(ptr_last + 1 ) = '\0';
	return( ptr_first );
}

static int
telnet_warn( cmnd_ptr, type )
char *cmnd_ptr;
int type;
{
	char *token;
	char *last_token;
	char *host_ptr;
	char cmnd_temp[100];
	char announce[100];

	/*
	 *	Special interface for connecting to Gopher or Telnet
	 *	Give warning & how to escape back to UCLink Menu
	 */

	/* get name of host */

	/* use cmnd_temp as strtok() alters string */
	strcpy( cmnd_temp, cmnd_ptr );
	/* mark don't know */
	host_ptr = "*unknown*";
	/* first token should be telnet */
	token = strtok( cmnd_temp, "\n \t" );
	/* remember last token which begins with a letter */
	while( ( token = strtok( NULL, "\n \t" ) ) != NULL ) {
		last_token = token;
		if( isalpha( *token ) ) host_ptr = token;
	}

	clear();

#define T1   "Warning!!!!!, you are about to leave the UCLink"
#define T2   "menu system and connect to another host."
#define T3   "If you get stuck, press the control key and the \"]\" key,"
#define T4   "and then type quit."

	mvaddstr( 2, 15, T1 );
	mvaddstr( 3, 17, T2 );
	mvaddstr( 4, 11, T3 );
	mvaddstr( 5, 24, T4 );

	strcpy( announce, "Now Connecting to " );
	strcat( announce, host_ptr );
	if( last_token != host_ptr ) {
		strcat( announce, ", port " );
		strcat( announce, last_token );
	}

	return( warn_confirm( announce ) );
}

static int
gopher_warn( cmnd_ptr )
char *cmnd_ptr;
{
	char *token;
	char *last_token;
	char *host_ptr;
	char cmnd_temp[100];
	char announce[100];

	/*
	 *	Special interface for connecting to Gopher or Telnet
	 *	Give warning & how to escape back to UCLink Menu
	 */

	/* get name of host */

	/* use cmnd_temp as strtok() alters string */
	strcpy( cmnd_temp, cmnd_ptr );
	/* mark don't know */
	host_ptr = "*unknown*";
	/* first token should be gopher */
	token = strtok( cmnd_temp, "\n \t" );
	/* remember last token which begins with a letter */
	while( ( token = strtok( NULL, "\n \t" ) ) != NULL ) {
		last_token = token;
		if( isalpha( *token ) ) host_ptr = token;
	}
		
	clear();

#define G1   "You are about to enter the Internet Gopher system"
#define G2   "Type \"q\" to quit Gopher and return to the UCLink Menu System"

	mvaddstr( 2, 14, G1 );
	mvaddstr( 3, 9, G2 );

	strcpy( announce, "Now Connecting to " );
	strcat( announce, host_ptr );
	if( last_token != host_ptr ) {
		strcat( announce, ", port " );
		strcat( announce, last_token );
	}

	return( warn_confirm( announce ) );
}

static int
warn_confirm( announce )
char *announce;
{
	int ch;
		
	/* center the announcement in the middle of screen */
	mvaddstr( LINES/2, (80 - strlen( announce ))/2, announce );
	clrtoeol();

	/* put prompt for quitting or continuing at the botton */
	mvaddstr( LINES-1, 21, "Press return to connect, q to cancel: " );
	clrtoeol();

	refresh();

	/* read - 'q' to quit, return enter telnet or gopher */
	raw();
	GETCH7( ch );
	while( ch != 'q' && ch != '\r' ) {
		ring_bell();
		GETCH7( ch );
	}
	noraw();
	if( ch == 'q' ) {
		return(0);
	} else {
		return(1);
	}
}
	
static
back_to_menu()
{
	int ignore;

	printf("\n\nPress any key to return to the UCLink Menu System: ");
	curses_start();
	raw();
	GETCH7( ignore );
	noraw();
}
