/* 
 * Include file for cipher
 *
 * Copyright (c) 1995 by Thomas J. Moore. All rights reserved.
 *
 */

#ifndef _LINUX_CIPHER_H
#define _LINUX_CIPHER_H

#include <linux/config.h>
#include <linux/mtio.h>


#define M_995	0

#define AT_8	0
#define AT_16	1

/*********** START OF USER CONFIGURABLE SECTION ************/

/* Tape configuration: Select DRIVE, IFC, PORT, IRQ and DMA below.
 * Runtime (re)configuration is not supported yet.
 *
 * Make sure you have the I/O ports/DMA channels 
 * and IRQ stuff configured properly!
 * NOTE: There may be other device drivers using the same major
 *       number. This must be avoided. Check for timer.h conflicts too.
 *
 */

#define CT_MAJOR 13 /* same as XT, but char.. */

#define CIPHER_TAPE_DRIVE	M_995	 /* drive type */

#define CIPHER_TAPE_IFC		AT_16	/* interface card type */
/* #define CIPHER_TAPE_IFC		AT_8 */

#define CIPHER_TAPE_PORT 	0x220	/* controller port address */
#define CIPHER_TAPE_IRQ		11	/* 3, 5, 7, 10, 11, 12, 15 */
#define CIPHER_TAPE_DMA		5	/* 0, 4, 5, 6, 7 */
#define CIPHER_TAPE_ADDR	0	/* 0, 1, 2, 3 */
/* tape drive address on card is minor # */

/************ END OF USER CONFIGURABLE SECTION *************/

#ifdef CONFIG_CIPHER_TAPE
extern int cipher_int(int);
#endif

#define DT_PORT CIPHER_TAPE_PORT

/*
 * DataTrac PCT Standard Symbol Definition
 */
#if CIPHER_TAPE_IFC == AT_16
/*
 * DATATRAC ATC-16 PORT DEFINITIONS
 * (no parens around 'em... so be careful!)
 */
#define DT_COMMAND	DT_PORT		/* COMMAND/SELECT PORT        (OUT) */
#define DT_STATUS	DT_PORT+2	/* STATUS/FLAGS PORT          (IN)  */
#define DT_WDATA	DT_PORT+4	/* WRITE DATA PORT            (OUT) */
#define DT_RDATA	DT_PORT+6	/* READ DATA PORT             (IN)  */
#define DT_CONFIG	DT_PORT+8	/* CONFIGURATION PORT         (OUT) */
#define DT_EXTENDED	DT_PORT+0x0A	/* EXTENDED STATUS PORT       (IN)  */
#define DT_CYCLE	DT_PORT+0x0C	/* FORCE DMA CYCLE STROBE     (OUT) */
#define DT_CLEAR_FIFO	DT_PORT+0x0E	/* CLEAR FIFO AND SEQUENCER   (OUT) */
#define DT_CLEAR_OFFLINE DT_PORT+0x10	/* CLEAR OFFLINE INTERRUPT    (OUT) */
#define DT_COUNTER	DT_PORT+0x12	/* WORD TRANSFER COUNT        (IN)  */
#define DT_CLEAR_TC	DT_PORT+0x14	/* CLEAR T/C INTERRUPT        (OUT) */
#define DT_CLEAR_READY	DT_PORT+0x16	/* CLEAR READY INTERRUPT      (OUT) */
#define DT_CLEAR_CLOCK	DT_PORT+0x18	/* CLEAR CLOCK INTERRUPT      (OUT) */
#define DT_CLEAR_DBUSY	DT_PORT+0x1A	/* CLEAR DBUSY INTERRUPT      (OUT) */
#define DT_CLEAR_FIRST	DT_PORT+0x1C	/* CLEAR FIRST BYTE INTERRUPT (OUT) */
#define DT_CLEARF	DT_PORT+0x1E	/* CLEAR STATUS FLAGS         (OUT) */
/*
 * ATC-16 EXTENDED STATUS PORT SYMBOLS
 */
#define DT_INT_OFFLINE	0x8000		/* TAPE DRIVE HAS GONE OFFLINE */
#define DT_INT_FIRST	0x4000		/* FIRST BYTE TRANSFERRED */
#define DT_INT_READY	0x2000		/* TAPE DRIVE HAS BECOME READY */
#define DT_EX_HER	0x1000		/* IHER (HARD ERROR) AT TAPE DRIVE */
#define DT_INT_CLOCK	0x0800		/* CLOCK COUNT WRAPPED */
#define DT_INT_TC	0x0400		/* TERMINAL COUNT OCCURED */
#define DT_EX_PARITY	0x0200		/* INTERFACE PARITY ERROR */
#define DT_EX_ODD	0x0100		/* LAST BYTE ODD */
#define DT_EX_MEMERR	0x0080		/* MEMORY PARITY ERROR */
#define DT_EX_FBUSY	0x0040		/* FORMATTER BUSY */
#define DT_EX_DMAREQ	0x0020		/* DMA/DATA REQUEST PENDING */
#define DT_EX_DBUSY	0x0010		/* DATA BUSY */
#define DT_INT_DBUSY	0x0008		/* DATA BUSY RELEASED */
#define DT_EX_ONLINE	0x0004		/* DRIVE ONLINE */
#define DT_EX_NOTEMPTY	0x0002		/* FIFO NOT EMPTY */
#define DT_EX_NOTFULL	0x0001		/* FIFO NOT FULL */

#else /* ATC-8 */

/*
 * DATATRAC PC PORT DEFINITIONS
 */
#define DT_COMMAND	DT_PORT		/* COMMAND PORT */
#define DT_SELECT	DT_PORT+1	/* SELECT PORT */
#define DT_FUNCTION	DT_PORT+2	/* BUS FUNCTION CONTROL PORT */
#define DT_STATUS	DT_PORT+3	/* STATUS SAMPLE PORT */
#define DT_CYCLE	DT_PORT+4	/* FORCE DMA CYCLE STROBE */
#define DT_CLEARI	DT_PORT+5	/* CLEAR INTERRUPT STROBE */
#define DT_FLAGS	DT_PORT+6	/* SAMPLE FLAGS PORT */
#define DT_CLEARF	DT_PORT+7	/* CLEAR FLAGS STROBE */
#define DT_EXTENDED	DT_PORT+8	/* EXTENDED STATUS REGISTER (ATC-8 ONLY) */
#define DT_READ_DATA	DT_PORT+9	/* READ DATA PORT (ATC-8 ONLY) */
#define DT_FLAGS_ONLY	DT_PORT+0x0A	/* CLEAR FLAGS ONLY (ATC-8 ONLY) */
#define DT_CLEAR_TC	DT_PORT+0x0B	/* CLEAR T/C INTERRUPT (ATC-8 ONLY) */
#define DT_WRITE_DATA	DT_PORT+0x0C	/* WRITE DATA PORT (ATC-8 ONLY) */
#define DT_CLEAR_FIFO	DT_PORT+0x0D	/* CLEAR FIFO ONLY (ATC-8 ONLY) */
#define DT_AUX_DATA	DT_PORT+0x0E	/* AUXILLIARY READ DATA PORT (ATC-8 ONLY) */
#define DT_AUX_STATUS	DT_PORT+0x0F	/* AUXILLIARY EXTENDED STATUS PORT (") */
/*
 * EXTENDED STATUS PORT BITS (ATC-8 ONLY)
 */
#define DT_PARITY_ERROR	0x080		/* PARITY ERROR */
#define DT_FBUSY_STATUS	0x040		/* FORMATTER BUSY (ACTUAL) */
#define DT_DMA_REQUEST	0x020		/* DMA REQUESTED */
#define DT_DBUSY_STATUS	0x010		/* DATA BUSY (ACTUAL) */
#define DT_DBUSY_INT	0x008		/* END OF DBUSY INTERRUPT */
#define DT_ONLINE_STATUS 0x004		/* ONLINE (ACTUAL) */
#define DT_EMPTY	0x002		/* FIFO EMPTY */
#define DT_FULL		0x001		/* FIFO FULL */

#endif

/*
 * ATC-16 STATUS AND FLAG BITS
 * ATC-8 STATUS IN UPPER 8
 */
#define DT_HER		0x8000		/* HARD ERROR DETECTED */
#define DT_FMK		0x4000		/* FILE MARK DETECTED */
#define DT_IDENT	0x2000		/* PE IDENTIFICATION BURST DETECTED */
#define DT_EOT		0x1000		/* END OF TAPE DETECTED */
#define DT_INTERRUPT	0x0800		/* INTERRUPTING SOURCE */
#define DT_CER		0x0400		/* ERROR CORRECTION IN PROCESS */
#define DT_ONLINE	0x0200		/* TAPE DRIVE ONLINE */
#define DT_OVERFLOW	0x0100		/* DMA UNDERFLOW (1 IF ENABLED) */
/*
 * DATATRAC DRIVE STATUS BITS
 */
#define DT_FBUSY	0x0080		/* FORMATTER BUSY */
#define DT_LOADPT	0x0040		/* LOAD POINT */
#define DT_NRZI		0x0020		/* NRZI TAPE DETECTED */
#define DT_READY	0x0010		/* DRIVE ONLINE AND READY */
#define DT_RWNDG	0x0008		/* DRIVE REWINDING */
#define DT_FPT		0x0004		/* FILE NOT PROTECTED */
#define DT_DBUSY	0x0002		/* DATA TRANSFER BUSY */
#define DT_SPEED	0x0001		/* HIGH SPEED SELECTED */
/*
 * DATATRAC COMMAND PORT FUNCTIONS
 */
#define DT_GO		0x080		/* COMMAND STROBE BIT */
#define DT_TH0		0x040		/* THRESHOLD 0 (NOT USED WITH 1600BPI) */
#define DT_CCG		0x001		/* CHECK CHARACTER GATE */
#define DT_HISPEED	0x020		/* HISPEED BIT */
/*
 * VALID DATATRAC COMMANDS
 */
#define DT_READ		0x000		/* READ */
#define DT_WRITE	0x002		/* WRITE */
#define DT_WFM		0x006		/* WRITE FILE MARK */
#define DT_RECF		0x010		/* SKIP RECORD FORWARD */
#define DT_RECR		0x011		/* SKIP RECORD REVERSE */
#define DT_FILEF	0x004		/* SKIP FILE FORWARD */
#define DT_FILER	0x005		/* SKIP FILE REVERSE */
#define DT_HIDEN	0x01D		/* HIGH DENSITY SELECT */
#define DT_LODEN	0x01C		/* LOW DENSITY SELECT */
#define DT_REWRITE	0x00A		/* REWRITE RECORD */
#define DT_WEG		0x016		/* WRITE ERASE GAP */
/*
 * DATATRAC SELECTION PORT SYMBOLS
 *
 * (HIGH ORDER BYTE OF COMMAND PORT) 
 */
#define DT_ENABLE	0x080		/* FORMATTER ENABLE */
#define DT_FAD		0x040		/* FORMATTER ADDRESS */
#define DT_TAD0		0x020		/* MSB DRIVE ADDRESS */
#define DT_TAD1		0x010		/* LSB DRIVE ADDRESS */
#define DT_GATE		0x008		/* READ DATA GATE (1=INHIBIT READ) */
#define DT_REW		0x004		/* REWIND STROBE */
#define DT_RWU		0x002		/* REWIND AND UNLOAD STROBE */
#define DT_TH1		0x001		/* THRESHOLD 1 (NOT USED WITH 1600BPI) */
/*
 * DATATRAC BUS FUNCTION SELECT SYMBOLS
 */
#define DT_INTMODE	0x008		/* INTERRUPT MODE (ATC-8 ONLY) */
#define DT_LWMODE	0x004		/* LAST WORD MODE (ATC-8 ONLY) */
#define DT_INT		0x002		/* INTERRUPT ENABLE BIT */
#define DT_DMA		0x001		/* DMA ENABLE BIT */

/*
 * RECOMPUTE INTERRUPT SYMBOLS
 */
#if CIPHER_TAPE_IRQ == 3
#define DT_INTMASK	0x20
#endif
#if CIPHER_TAPE_IRQ == 4
#define DT_INTMASK 0x24
#endif
#if CIPHER_TAPE_IRQ == 5
#define DT_INTMASK 0x28
#endif
#if CIPHER_TAPE_IRQ == 7
#define DT_INTMASK 0x2c
#endif
#if CIPHER_TAPE_IRQ == 10
#define DT_INTMASK 0x30
#endif
#if CIPHER_TAPE_IRQ == 11
#define DT_INTMASK 0x34
#endif
#if CIPHER_TAPE_IRQ == 12
#define DT_INTMASK 0x38
#endif
#if CIPHER_TAPE_IRQ == 15
#define DT_INTMASK 0x3c
#endif
#if CIPHER_TAPE_IRQ == 0
#define DT_INTMASK 0
#endif
/*
 * CHANNEL SPECIFIC DMA PORTS
 */
#if CIPHER_TAPE_DMA == 5
#define DT_DMAMASK 1
#endif
#if CIPHER_TAPE_DMA == 6
#define DT_DMAMASK 2
#endif
#if CIPHER_TAPE_DMA == 7
#define DT_DMAMASK 3
#endif
#if CIPHER_TAPE_DMA == 0
#define DT_DMAMASK 0
#endif

struct tape_ctrl_block {
    unsigned long status;		/* generic status */
    int fileno, recno;			/* attempt at storing file & record # */
    unsigned long before, after;	/* pointer location */
    unsigned long blksiz;		/* default: 80 */
    unsigned long bufsiz;		/* write blksize */
    unsigned char *buffer;		/* buffer location */
    unsigned long last;			/* last block size */
    unsigned char drive_select;		/* added to every drive selection */
    unsigned char rwmode;		/* write in process flag */
    unsigned char bus_temp;		/* bus enable temp */
    unsigned char temp_sel;		/* temporary select */
    struct wait_queue *wait_queue;	/* command wait queue */
    int resid;				/* residual from read/write */
    unsigned char error;		/* TERR_XXX */
    unsigned char flags;		/* CF_XXX */
};

#define TERR_OK		0
#define TERR_EOF	1
#define TERR_DMAOVF	2
#define TERR_NOTREADY	3
#define TERR_NCORRERR	4
#define TERR_CORRERR	5
#define TERR_BOT	6
#define TERR_DMAWR	7
#define TERR_ZLR	8
#define TERR_RDOVF	9
#define TERR_POS	10
#define TERR_CMDLOST	11
#define TERR_EOT	12
#define TERR_REVBOT	13
#define TERR_TRIVBLK	14
#define TERR_INVMODE	15
#define TERR_INVOPER	255

#define CF_AUTOSIZE	1

#endif /* _LINUX_CIPHER_H */
