/*	$Header$
	Copyright (c) 1993 by Tycho Softworks.  All rights reserved.

Created by:

	David Sugar, Tycho Softworks
   	E-Mail: dyfet@aol.com, BBS: 201-858-3429

Synopsis:

	Provides interfaces to portable services for creating and managing
	processes.

History:

	$Log$
*/

#ifndef	__TASKS_H__	
#define	__TASKS_H__

#include <stdio.h>
#ifdef	__ANSI__
#ifdef	QNX
#include <process.h>
#endif
#endif

#ifndef	__OS2__
#include <unistd.h>
#endif

#ifndef	__PROTOTYPES_H__
#include <prototypes.h>
#endif

#ifdef	QNX
#define	__PID__
typedef	unsigned	pid_t;
#endif

#ifdef	LINUX
#define	__PID__
#define	PROC_FS	"/proc"
#endif

#ifdef	COHERENT
#include <sys/types.h>
#define	__PID__
#endif

#ifndef	__PID__
#define	__PID__
typedef	int	pid_t;
#endif

typedef	char **	ARGV;

#ifdef	QNX
#include <task_msgs.h>
#include <magic.h>

#define	getgid()	((unsigned char)Group_num)	
#define	getuid()	((getgid() << 8) | (unsigned char)User_num)
IMPORT	int		create_argv PROTO((ARGV task, ARGV stdio, int flags));
#define	wait_argv(argv, stdio)	create_argv(argv, stdio, BEQUEATH_TTY)
#define	fork_argv(argv, stdio)	create_argv(argv, stdio, BEQUEATH_TTY | RUN_CONCURRENT)
#define	exec_argv(argv, stdio)	create_argv(argv, stdio, 0)
#define	attach_argv(argv, stdio)	create_argv(argv, stdio, RUN_BACKGROUND)

#else

IMPORT	int		wait_argv PROTO((ARGV task, ARGV stdio));
IMPORT	pid_t	fork_argv PROTO((ARGV task, ARGV stdio));
IMPORT	void	exec_argv PROTO((ARGV task, ARGV stdio));
IMPORT	int		attach_argv PROTO((ARGV task, ARGV stdio));
#endif

IMPORT	int		get_argv PROTO((ARGV argv, char *cmds));
IMPORT	FILE	*pipe_argv PROTO((ARGV task, char *path, char *mode));
IMPORT	int		pipe_close PROTO((FILE *fp));
IMPORT	pid_t	detach_task PROTO((void));		/*	detach/protect current task	*/
IMPORT	int		stat_task PROTO((char *path));	/* set owner based on fpath	*/
IMPORT	void	lock_task PROTO((void));		/* lock task down			*/
IMPORT	void	ulock_task PROTO((void));		/*	unlock and return state	*/

#ifdef	PROC_FS
#define	get_pidterm(p)	get_pidenv(p, "TERM")
IMPORT	char	*get_pidenv PROTO((pid_t pid, char *sym));
#endif
#endif
