#ifndef	__STREAM_H__
#define	__STREAM_H__

#ifndef	__PROTOTYPES_H__
#include <prototypes.h>
#endif

#ifdef	QNX
#define	__NOSTDIO__
#define	__NOUMASK__
#endif

#ifdef	__ANSI__
#define	__SETVBUF__
#endif

#ifdef	SCO
#define	__SETVBUF__
#endif

#ifdef	COHERENT
#define	__SETVBUF__
#endif

#ifndef	__BUFSIZE
#define	__BUFSIZE	512
#endif

#ifndef	__SREAD
#define	__SREAD	"r+"
#endif

#ifndef	__SWRITE
#define	__SWRITE "w+"
#endif

#ifndef	__SAPPEND
#define	__SAPPEND "a"
#endif

#ifndef	__SRDONLY
#define	__SRDONLY "r"
#endif

#ifndef	__SWRONLY
#define	__SWRONLY "w"
#endif

#ifdef	__NOSTDIO__
#undef	__NOSTDIO__

typedef	struct
{
	long fpos;
	int	fd;
	int	bsize;
	int	rpos;
	int	wpos;
	int	bend;
	int	eof;
	int	err;
	char buf[0];
}	STREAM;

IMPORT	STREAM	*open_stream PROTO((char *fname, char *mode, int size));
IMPORT	int		close_stream PROTO((STREAM *str));
IMPORT	int		flush_stream PROTO((STREAM *str));
IMPORT	STREAM	*attach_stream PROTO((int fd, int size));
IMPORT	int		detach_stream PROTO((STREAM *str));
IMPORT	int		seek_stream PROTO((STREAM *str, long pos));
IMPORT	int		getc_stream PROTO((STREAM *str));
IMPORT	int		gets_stream PROTO((STREAM *str, char *buf, int len));
IMPORT	int		putc_stream PROTO((STREAM *str, char c));
IMPORT	int		puts_stream PROTO((STREAM *str, char *s));
IMPORT	int		print_stream PROTO((STREAM *str, char *format, ...));
IMPORT	int		read_stream PROTO((STREAM *str, PTR buf, int len));
IMPORT	int		write_stream PROTO((STREAM *str, PTR buf, int len));
IMPORT	long	tell_stream PROTO((STREAM *str));
#define	iseof_stream(s)	(s->eof)
#define	iserr_stream(s)	(s->err)
#define	fileno_stream(s) (s->fd)
#define	append_stream(s)	seek_stream(s, -1l)
#define	skip_stream(s, p)	seek_stream(s, tell_stream(s) + p)
#else

#include <stdio.h>

#define	STREAM	FILE
IMPORT	int	detach_stream PROTO((STREAM *str));
#ifdef	__SETVBUF__
IMPORT	STREAM *open_stream PROTO((char *fname, char *mode, int bufsize));
IMPORT	STREAM *attach_stream PROTO((int fd, int size));
#else
#define	open_stream(fname, mode, buf)	fopen(fname, mode)
#define	attach_stream(fd, size)		fdopen(fd)
#endif
IMPORT	int	detach_stream PROTO((STREAM *s));
#define	close_stream(str)			fclose(str)
#define	flush_stream(str)			fflush(str)
#define	seekeof_stream(str)			fseek(str, 0l, SEEK_END)
#define	getc_stream(str)			fgetc(str)
#define	gets_stream(str, buf, len)	fgets(buf, len, str)
#define	putc_stream(str, c)			fputc(c, str)
#define	puts_stream(str, s)			fputs(s, str)
#define	print_stream				fprintf
#define	iseof_stream(s)				feof(s)
#define	iserr_stream(s)				ferror(s)
#define	read_stream(s, b, l)		fread(b, 1, l, s)
#define	write_stream(s, b, l)		fwrite(b, 1, l, s)
#define	fileno_stream(s)			fileno(s)
#define	seek_stream(s,p)			fseek(s, p, SEEK_SET)
#define	tell_stream(s)				ftell(s)
#endif

IMPORT	int	inkey PROTO((int timeout));
IMPORT	int	lock_stream	PROTO((STREAM *s));
IMPORT	int	ulock_stream PROTO((STREAM *s));
#ifdef	__NOUMASK__
IMPORT	int	umask PROTO((int umask));
#endif

#ifdef	__TRUNCATE_STREAM__
IMPORT	int	truncate_stream PROTO((STREAM *s));
#else
#define	truncate_stream(s)	(-1)
#endif

#endif
