/*
   File:   xplay.c
   Author: Ole Gunnar Westgaard 
           root@ogware.oslo.no
           Copyright (c) May 1995.  All Rights Reserved.
*/

#include "otools.h"
#include "macros.h"
#include "protos.h"
#include "colors.h"

#include <unistd.h>
#include <signal.h>
#include <waitflags.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <fcntl.h>

#define PERMS 0666
#define BUFSIZE 32768

char   **e,**a; /* env pointer */
int    n;
pid_t  child;

void Fsave(Button *of,int x,int y)
{
  char fname[20];
  int  t,u,f1,f2;
  char buf[BUFSIZE];
  u=0;
  for (t=strlen(a[n-1]); a[n-1][t] != '/' && t>=0; t--);
  for (t++; t<=strlen(a[n-1]); t++) fname[u++] = a[n-1][t];
  if ((f1 = open(a[n-1],O_RDONLY,0)) == -1) return;
  if ((f2 = creat(fname,PERMS)) == -1) return;
  while ((n=read(f1,buf,BUFSIZE)) > 0) 
    if (write(f2,buf,n) != n) return;
  close(f1);
  close(f2);
}

void Fstop(Button *of,int x,int y)
{
  int stat=1;
  if ( child ) {
    switch ( waitpid(child,&stat,WNOHANG) ) { /* Check status of child */
    case -1:
      printf("%s: Error checking status of child\n",o_name);
      exit(-1);
      break;
    case 0:
      if ( errno == ECHILD ) child = 0;
      else if ( child && kill(child,SIGKILL) )
	printf("%s: could not kill child\n",o_name);
      child = 0;
      break;
    default:
      child = 0;
      break;
    }
  }
}

void Fplay(Button *of,int x,int y)
{
  char *args[20];
  int  t;
  Fstop(of,x,y);
  if (! child ) {
    child = fork();
    switch (child) {
    case 0: /* In child */
      for (t=1; t<=n; t++) args[t-1] = a[t];
      execve(a[1],args,e);
      exit(1);
      break;
    case -1: /* Error */
      printf("%s: could not execute\n",o_name);
      exit(-1);
      break;
    default: /* In parent */
      break;
    }
  }
}

void Fquit(Button *of,int x,int y)
{
  int stat = 1;
  if ( child ) {
    switch ( waitpid(child,&stat,WNOHANG) ) { /* Check status of child */
    case -1:
      printf("%s: Error checking status of child\n",o_name);
      exit(1);
      break;
    case 0:
      if ( errno == ECHILD )
	printf("%s: child nonexistant\n",o_name);
      else if ( child && kill(child,SIGKILL) )
	printf("%s: could not kill child\n",o_name);
      o_running = 0;
      break;
    default:
      o_running = 0;
      break;
    }
  } else o_running = 0;
}

#define C_GREEN2   "#000","#060","#000","#0d0","#0ff","#aa0","#ff0"

int main(int argc,char *argv[],char *envp[])
{
  Color *gr;
  char command[30];
  int t,u;
  if (argc<=2) exit(-1);
  e = envp; a = argv; n = argc;

  o_Init("Xplayer 1.0","xplay","7x13bold",5,5,200,85,0,0,200,85,
	 C_GREEN,argc,argv);
  u=0;
  for (t=strlen(argv[1]); argv[1][t] != '/' && t>=0; t--);
  for (t++; t<=strlen(argv[1]); t++) command[u++] = argv[1][t];
  command[u-1]=' ';
  for (t=strlen(argv[argc-1]); argv[argc-1][t] != '/' && t>=0; t--);
  for (t++; t<=strlen(argv[argc-1]); t++) command[u++] = argv[argc-1][t];
  child = 0;
  gr = new Color(C_GREEN2);
  o_draw = new Chain(new Figlet(5,5,xMax-5,20,IN,gr,0,command));
  o_draw->Add(new Button(5,25,xMax/2-2,50,NONE,&o_color,0,
			 "START",CLICK,OUT,Fplay));
  o_draw->Add(new Button(xMax/2+2,25,xMax-5,50,NONE,&o_color,0,
			 "STOP",CLICK,OUT,Fstop));
  o_draw->Add(new Button(5,55,xMax/2-2,yMax-5,NONE,&o_color,0,
			 "SAVE",CLICK,OUT,Fsave));
  o_draw->Add(new Button(xMax/2+2,55,xMax-5,yMax-5,NONE,&o_color,0,
			 "QUIT",CLICK,OUT,Fquit));
  o_test = o_draw;
  o_EnterLoop();
  o_Quit();
}
