/*
   NAME:     proto
   AUTHOR:   Ole Gunnar Westgaard
   DATE:     Jul 14 1995
             
*/
#ifndef PROTO
#define PROTO

//=============================================================================
// External variables of otools
//=============================================================================

extern Display       *o_dpy;                                 // Display pointer
extern int            o_nr;                                   // Display number
extern char          *o_name;                               // Application name
extern XFontStruct   *o_font;                                 // Font structure
extern uint             xMax,                               // Window width - 1
                        yMax;                              // Window height - 1
extern GC             o_gc;                                 // Graphics context
extern Window         o_win;                                          // Window
extern Colormap       o_cmap;                                // Window colormap
extern unsigned char  o_running;                       // Application running ?
extern Figlet        *o_selected;                            // Selected figlet
extern Chain         *o_draw,                        // Chain to draw at expose
                     *o_test;                         // Figlets with an action
extern void         (*o_DrawFirst) (int,int,int,int);          // Before chains
extern void         (*o_DrawLast)  (int,int,int,int);           // after chains
extern void         (*o_Configure) (int,int,int,int);       // configure window
extern void         (*o_Keyboard)  (char *);   // KeyPress information callback
extern void         (*o_EnterWindow) (int,int);  // Information entering window
extern Color          o_color;                               // Main colortable

//=============================================================================
// Prototyped functions
//=============================================================================
unsigned char ox(char);
unsigned long o_AllocNamedColor(char*);
void o_Context(Window,GC*,XFontStruct*,unsigned long);
void o_Font(XFontStruct**,char*);
void o_Quit(void);
void o_EnterLoop(void);
void o_Init(char*,char*,char*,uint,uint,uint, uint,uint,uint,uint,uint,
            char*,char*,char*,char*,char*,char*,char*,
	    int,char **);

#endif /* PROTO */
